/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.plugin.test.report.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;

public class TestReportQueryPlugin
extends AbstractReportListDataPlugin {
    public DataSet query(ReportQueryParam queryParam, Object paramObject) throws Throwable {
        ORM orm = ORM.create();
        String exceptionType = queryParam.getFilter().getString("exceptiontype");
        String exceptionMessage = queryParam.getFilter().getString("exceptionmessage");
        if (!StringUtils.isEmpty((CharSequence)exceptionType) && !StringUtils.isEmpty((CharSequence)exceptionMessage)) {
            if (StringUtils.endsWithIgnoreCase((CharSequence)"KDBizException", (CharSequence)exceptionType)) {
                throw new KDBizException(exceptionMessage);
            }
            throw new KDException(exceptionMessage);
        }
        HashSet<String> fieldKeys = new HashSet<String>(16);
        String entityNumber = queryParam.getFilter().getString("queryentity");
        if (StringUtils.isEmpty((CharSequence)entityNumber)) {
            entityNumber = "kdtest_report001";
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        for (Map.Entry entry : dataEntityType.getAllEntities().entrySet()) {
            EntityType type = (EntityType)entry.getValue();
            if (type instanceof EntryType) {
                for (Map.Entry entryField : type.getFields().entrySet()) {
                    fieldKeys.add(String.format("%s.%s", entry.getKey(), entryField.getKey()));
                }
                continue;
            }
            if (!(type instanceof BillEntityType)) continue;
            for (Map.Entry field : type.getFields().entrySet()) {
                fieldKeys.add((String)field.getKey());
            }
        }
        return orm.queryDataSet(((Object)((Object)this)).getClass().getName(), entityNumber, StringUtils.join((Object[])fieldKeys.toArray(), (String)","), this.getQfilter(queryParam).toArray(new QFilter[0]), null);
    }

    private List<QFilter> getQfilter(ReportQueryParam queryParam) {
        ArrayList<QFilter> searchFilterList = new ArrayList<QFilter>();
        if (!CollectionUtils.isEmpty((Collection)queryParam.getFilter().getHeadFilters())) {
            searchFilterList.addAll(queryParam.getFilter().getHeadFilters());
        }
        if (!CollectionUtils.isEmpty((Collection)queryParam.getFilter().getQFilters())) {
            searchFilterList.addAll(queryParam.getFilter().getQFilters());
        }
        return searchFilterList;
    }
}

