/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.trace.listener;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceConfig;
import kd.bos.dataentity.trace.EntityTraceListener;
import kd.bos.dataentity.trace.EntityTraceSpanInfo;
import kd.bos.dataentity.trace.EntityTraceWriter;
import kd.bos.dataentity.trace.ListenSchemeParam;
import kd.bos.dataentity.trace.WriterManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.trace.listener.IListenerParamCheck;
import kd.bos.entity.trace.listener.param.CallPluginAuditListenParam;
import kd.bos.orm.util.CollectionUtils;

public class CallPluginAuditListener
implements EntityTraceListener,
IListenerParamCheck {
    private EntityTraceConfig config;
    private WriterManager writerManager;
    private CallPluginAuditListenParam pluginCallCostParam = new CallPluginAuditListenParam();
    private static final String SPAN_TYPE_PLUGIN = "plugin";
    private static final String BOS_ENTITY_TRACE = "bos-entity-trace";
    private String rootKey = "";
    private Map<Long, SpanNode> spanNodeMap = new LinkedHashMap<Long, SpanNode>();
    private Map<Long, Map<String, StatInfo>> statInfoMap = new LinkedHashMap<Long, Map<String, StatInfo>>();

    public void setConfig(EntityTraceConfig config) {
        this.config = config;
    }

    public void setParam(ListenSchemeParam param) {
        String paramStr = param.getParam();
        if (StringUtils.isNotBlank((CharSequence)paramStr)) {
            this.pluginCallCostParam = (CallPluginAuditListenParam)SerializationUtils.fromJsonString((String)paramStr, CallPluginAuditListenParam.class);
        }
    }

    @Override
    public boolean checkListenerParamValid(String paramStr) {
        if (StringUtils.isNotEmpty((CharSequence)paramStr)) {
            CallPluginAuditListenParam param = (CallPluginAuditListenParam)SerializationUtils.fromJsonString((String)paramStr, CallPluginAuditListenParam.class);
            return param != null && param.getWriteReportCost() > 0;
        }
        return true;
    }

    public void setWriterManager(WriterManager writerManager) {
        this.writerManager = writerManager;
    }

    public Set<String> getListenTypes() {
        return new HashSet<String>(0);
    }

    public void create(EntityTraceSpanInfo span) {
        if (this.config.isSkipFormService()) {
            return;
        }
        if (SPAN_TYPE_PLUGIN.equals(span.getType())) {
            this.statInfoMap.put(span.getId(), null);
        }
    }

    public void event(EntityTraceSpanInfo span, String event) {
    }

    public void close(EntityTraceSpanInfo span) {
        SpanNode treeNode;
        if (this.config.isSkipFormService() || CollectionUtils.isEmpty(this.statInfoMap)) {
            return;
        }
        if (!SPAN_TYPE_PLUGIN.equals(span.getType())) {
            this.getPluginMethodStatInfo(span);
        }
        if (span.isRootSpan() && StringUtils.isNotEmpty((CharSequence)this.rootKey) && this.rootKey.equals(this.getRootKey(span)) && span.getCost() > this.pluginCallCostParam.getWriteReportCost() && !CollectionUtils.isEmpty(this.spanNodeMap) && (treeNode = this.getTreeNode(this.spanNodeMap)) != null) {
            this.print(span, treeNode);
        }
        if (!SPAN_TYPE_PLUGIN.equals(span.getType())) {
            return;
        }
        if (span.getCost() > this.pluginCallCostParam.getWriteReportCost()) {
            this.getSpanNodeMap(span);
        }
    }

    private void getPluginMethodStatInfo(EntityTraceSpanInfo span) {
        ArrayList<Long> callStackIds = new ArrayList<Long>(8);
        this.getCallStackIds(callStackIds, span);
        String type = span.getType();
        for (Map.Entry<Long, Map<String, StatInfo>> entry : this.statInfoMap.entrySet()) {
            StatInfo statInfo;
            Long spanId = entry.getKey();
            if (!callStackIds.contains(spanId)) continue;
            Map<String, StatInfo> spanInfoMap = entry.getValue();
            if (spanInfoMap == null) {
                spanInfoMap = new HashMap<String, StatInfo>();
            }
            if ((statInfo = spanInfoMap.get(type)) == null) {
                statInfo = new StatInfo(type);
            }
            statInfo.addCost(span.getCost());
            spanInfoMap.put(type, statInfo);
            this.statInfoMap.put(spanId, spanInfoMap);
        }
    }

    private void getCallStackIds(List<Long> callStackIds, EntityTraceSpanInfo span) {
        callStackIds.add(span.getId());
        if (span.getParent() != null) {
            this.getCallStackIds(callStackIds, span.getParent());
        }
    }

    private void getSpanNodeMap(EntityTraceSpanInfo span) {
        if (span == null) {
            return;
        }
        this.getSpanNodeMap(span.getParent());
        SpanNode spanNode = new SpanNode(span.getType(), span.getName(), span.getId(), span.getPId());
        spanNode.setCost(span.getCost());
        spanNode.setTags(span.getTags());
        spanNode.setOvertime(true);
        this.spanNodeMap.put(span.getId(), spanNode);
        if (span.getParent() == null) {
            this.rootKey = this.getRootKey(span);
        }
    }

    private String getRootKey(EntityTraceSpanInfo span) {
        return span.getType() + "." + span.getName();
    }

    private void print(EntityTraceSpanInfo span, SpanNode spanNode) {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append(ResManager.loadKDString((String)"\u63d2\u4ef6\u4ee3\u7801\u8c03\u7528\u6027\u80fd\u6d88\u8017\u62a5\u544a\uff1a\r\n", (String)"CallPluginAuditListener_0", (String)BOS_ENTITY_TRACE, (Object[])new Object[0]));
        spanNode.setParent(null);
        spanNode.setOvertime(true);
        spanNode.setTags(span.getTags());
        spanNode.print(sBuilder, this.statInfoMap);
        EntityTraceWriter.InfoLevel level = EntityTraceWriter.InfoLevel.DETAIL;
        if (!this.config.isRealtime()) {
            level = EntityTraceWriter.InfoLevel.IMPORTANT;
        }
        this.writerManager.write(span, sBuilder.toString(), level);
    }

    private SpanNode getTreeNode(Map<Long, SpanNode> spanNodeMap) {
        SpanNode root = null;
        Collection<SpanNode> nodeList = spanNodeMap.values();
        for (SpanNode node : nodeList) {
            if (node.getPId() == 0L) {
                root = node;
                continue;
            }
            node.setParent(spanNodeMap.get(node.getPId()));
            node.getParent().getChilds().put(String.valueOf(node.getId()), node);
        }
        return root;
    }

    public static class SpanNode {
        private static final int MAX_TAG_STR_LENGTH = 50;
        private static final int MAX_REPORT_LENGTH = 50000;
        private static final String NEW_LINE = "\r\n";
        private long id;
        private long pid;
        private String type;
        private String name;
        private Map<String, String> tags;
        private String tagString;
        private int count = 1;
        private long cost;
        private boolean writeTags = false;
        private SpanNode parent;
        private Map<String, SpanNode> childs = new LinkedHashMap<String, SpanNode>(4);

        public SpanNode(String type, String name, long id, long pid) {
            this.type = type;
            this.name = name;
            this.id = id;
            this.pid = pid;
        }

        public String getKey() {
            return this.type + "." + this.name;
        }

        public int getLevel() {
            if (this.parent == null) {
                return 1;
            }
            return this.getParent().getLevel() + 1;
        }

        public long getId() {
            return this.id;
        }

        public long getPId() {
            return this.pid;
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public Map<String, String> getTags() {
            return this.tags;
        }

        public void setTags(Map<String, String> tags) {
            this.tags = tags;
        }

        public String getTagString() {
            if (this.tagString != null) {
                return this.tagString;
            }
            if (this.getTags() == null || this.getTags().isEmpty()) {
                this.tagString = "";
            } else {
                StringBuilder sbTag = new StringBuilder();
                for (Map.Entry<String, String> entry : this.getTags().entrySet()) {
                    if (entry.getValue() != null && entry.getValue().length() > 50) {
                        sbTag.append("'").append(entry.getValue().substring(0, 47)).append("...',");
                        continue;
                    }
                    sbTag.append("'").append(entry.getValue()).append("',");
                }
                sbTag.setLength(sbTag.length() - 1);
                this.tagString = sbTag.toString();
            }
            return this.tagString;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public long getCost() {
            return this.cost;
        }

        public void setCost(long cost) {
            this.cost = cost;
        }

        public boolean isOvertime() {
            return this.writeTags;
        }

        public void setOvertime(boolean overtime) {
            this.writeTags = overtime;
        }

        public SpanNode getParent() {
            return this.parent;
        }

        public void setParent(SpanNode parent) {
            this.parent = parent;
        }

        public Map<String, SpanNode> getChilds() {
            return this.childs;
        }

        public void print(StringBuilder sb, Map<Long, Map<String, StatInfo>> statInfoMap) {
            int level = this.getLevel();
            for (int i = 2; i < level; ++i) {
                sb.append("    ");
            }
            if (level > 1) {
                sb.append("|----");
            }
            sb.append(this.getType()).append(".").append(this.getName()).append("(");
            if (this.isOvertime()) {
                sb.append(this.getTagString());
            }
            sb.append("), ");
            if (this.getCount() > 1) {
                sb.append("run ").append(this.getCount()).append(" times, cost ").append(this.getCost()).append(" ms.");
            } else {
                sb.append("cost ").append(this.getCost()).append(" ms.");
            }
            this.printPluginStatInfo(sb, level, statInfoMap);
            sb.append(NEW_LINE);
            if (sb.length() > 50000) {
                return;
            }
            for (Map.Entry<String, SpanNode> entry : this.getChilds().entrySet()) {
                entry.getValue().print(sb, statInfoMap);
                if (sb.length() <= 50000) continue;
                return;
            }
        }

        private void printPluginStatInfo(StringBuilder sb, int level, Map<Long, Map<String, StatInfo>> statInfoMap) {
            if (CollectionUtils.isEmpty(statInfoMap)) {
                return;
            }
            Map<String, StatInfo> map = statInfoMap.get(this.getId());
            if (CollectionUtils.isEmpty(map)) {
                return;
            }
            for (Map.Entry<String, StatInfo> entry : map.entrySet()) {
                sb.append(NEW_LINE);
                for (int i = 2; i < level + 1; ++i) {
                    sb.append("    ");
                }
                if (level > 1) {
                    sb.append("|----");
                }
                StatInfo spanInfo = entry.getValue();
                sb.append(String.format(ResManager.loadKDString((String)"%1$s: \u6267\u884c\u6b21\u6570:%2$d,\u5e73\u5747\u65f6\u95f4:%3$sms,\u603b\u65f6\u95f4:%4$dms", (String)"CallPluginAuditListener_1", (String)CallPluginAuditListener.BOS_ENTITY_TRACE, (Object[])new Object[0]), spanInfo.getType(), spanInfo.getCount(), spanInfo.getAvgCost(), spanInfo.getCost()));
            }
        }
    }

    public static class StatInfo {
        private String type;
        private int count = 0;
        private long cost;

        StatInfo(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public int getCount() {
            return this.count;
        }

        public long getCost() {
            return this.cost;
        }

        public String getAvgCost() {
            Double doubleValue = (double)this.cost / (double)this.count;
            return String.format("%.2f", doubleValue);
        }

        public void addCost(long cost) {
            this.cost += cost;
            ++this.count;
        }
    }
}

