/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.trace.listener;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpanInfo;
import kd.bos.dataentity.trace.EntityTraceWriter;
import kd.bos.dataentity.trace.ListenSchemeParam;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.trace.listener.AbstractEntityTraceListener;
import kd.bos.entity.trace.listener.DynamicObjectSetParam;
import kd.bos.entity.trace.listener.ListenEntity;

public final class DynamicObjectSetListener
extends AbstractEntityTraceListener {
    private static final String TYPE_DATA_STORAGE = "IDataStorage";
    private static final String TYPE_BUSINESS_DATA_READER = "datareader";
    private static final String TYPE_DATA_ENTITY_SERIALIZER = "DataEntitySerializer";
    private static final String TYPE_QUERY_SERVICE_HELPER = "QueryServiceHelper";
    private static final String TYPE_BUSINESS_DATA_SERVICE_HELPER = "BusinessDataServiceHelper";
    private static Set<String> listenTypes;
    private static Set<String> skipTypes;
    private static final int MAX_TAG_LENGTH = 5000;
    private boolean skip = false;
    private DynamicObjectSetParam param;
    private Map<String, ListenEntity> listenEntities;

    public Set<String> getListenTypes() {
        return listenTypes;
    }

    @Override
    public void setParam(ListenSchemeParam param) {
        super.setParam(param);
        this.param = StringUtils.isBlank((CharSequence)param.getParam()) ? new DynamicObjectSetParam() : (DynamicObjectSetParam)SerializationUtils.fromJsonString((String)param.getParam(), DynamicObjectSetParam.class);
        this.listenEntities = new HashMap<String, ListenEntity>(this.param.getListenEntities().size());
        for (ListenEntity listenEntity : this.param.getListenEntities()) {
            this.listenEntities.put(listenEntity.getEntityNumber(), listenEntity);
        }
    }

    @Override
    protected void doEvent(EntityTraceSpanInfo span, String event) {
        if (!this.getConfig().isRealtime()) {
            return;
        }
        if (this.getConfig().isSkipFormService()) {
            return;
        }
        if (StringUtils.equals((CharSequence)span.getType(), (CharSequence)TYPE_DATA_STORAGE)) {
            if (!this.skip) {
                this.doObjSet(span);
            }
        } else {
            this.skip = true;
            if (StringUtils.equals((CharSequence)span.getType(), (CharSequence)TYPE_DATA_ENTITY_SERIALIZER)) {
                this.doSerializerReader(span);
            }
        }
    }

    @Override
    protected void doClose(EntityTraceSpanInfo span) {
        if (StringUtils.equals((CharSequence)span.getType(), (CharSequence)TYPE_DATA_STORAGE)) {
            return;
        }
        this.skip = false;
        List callStacks = span.getCallStack();
        for (int i = callStacks.size() - 2; i >= 0; --i) {
            Map stackItem = (Map)callStacks.get(i);
            if (!this.isSkipType(stackItem)) continue;
            this.skip = true;
            break;
        }
    }

    private void doObjSet(EntityTraceSpanInfo span) {
        String value;
        if (span.isRootSpan()) {
            return;
        }
        Map tags = span.getLocaleTags();
        IDataEntityProperty property = (IDataEntityProperty)tags.get("property");
        if (!this.isListenEntity(property)) {
            return;
        }
        String old = "" + tags.get("old");
        if (old.length() > 5000) {
            old = old.substring(0, 4997) + "...";
        }
        if ((value = "" + tags.get("value")).length() > 5000) {
            value = value.substring(0, 5000) + "...";
        }
        String msg = String.format("key=%s, val=%s, old=%s", this.buildPropFullName(property), value, old);
        this.getWriterManager().write(span, msg, EntityTraceWriter.InfoLevel.DETAIL);
    }

    private void doSerializerReader(EntityTraceSpanInfo span) {
        StringBuilder sb = new StringBuilder();
        Map localeTags = span.getLocaleTags();
        IDataEntityType dt = null;
        for (Map.Entry entry : localeTags.entrySet()) {
            if (!(entry.getValue() instanceof IDataEntityType)) continue;
            dt = (IDataEntityType)entry.getValue();
            break;
        }
        if (!this.isListenEntity(dt)) {
            return;
        }
        for (Map.Entry entry : localeTags.entrySet()) {
            sb.append((String)entry.getKey()).append(" = ");
            if (entry.getValue() instanceof IDataEntityType) {
                dt = (IDataEntityType)entry.getValue();
                sb.append(dt.getName()).append("[");
                for (IDataEntityProperty prop : dt.getProperties()) {
                    sb.append(prop.getOrdinal()).append("-").append(prop.getName()).append(",");
                }
                sb.setLength(sb.length() - 1);
                sb.append("]");
            } else if (entry.getValue() == null) {
                sb.append("null");
            } else {
                String tagValue = SerializationUtils.toJsonString(entry.getValue());
                if (tagValue.length() > 5000) {
                    tagValue = tagValue.substring(0, 4997) + "...";
                }
                sb.append("'").append(tagValue).append("'");
            }
            sb.append(", ");
        }
        if (!localeTags.isEmpty()) {
            sb.setLength(sb.length());
        }
        this.getWriterManager().write(span, sb.toString(), EntityTraceWriter.InfoLevel.INFO);
    }

    private boolean isSkipType(Map<String, Object> spanInfo) {
        String type = (String)spanInfo.get("type");
        return type != null && skipTypes.contains(type);
    }

    private boolean isListenEntity(IDataEntityProperty prop) {
        if (this.listenEntities.isEmpty() || prop == null) {
            return false;
        }
        IDataEntityType parent = prop.getParent();
        if (parent == null) {
            return false;
        }
        while (parent.getParent() != null) {
            parent = parent.getParent();
        }
        ListenEntity listenEntity = this.listenEntities.get(parent.getName());
        if (listenEntity == null) {
            return false;
        }
        if (listenEntity.getFieldKeys().isEmpty()) {
            return true;
        }
        return listenEntity.getFieldKeys().contains(prop.getName()) || listenEntity.getFieldKeys().contains(prop.getParent().getName());
    }

    private boolean isListenEntity(IDataEntityType dt) {
        if (this.listenEntities.isEmpty() || dt == null) {
            return false;
        }
        IDataEntityType parent = dt;
        while (parent.getParent() != null) {
            parent = parent.getParent();
        }
        return this.listenEntities.containsKey(parent.getName());
    }

    private String buildPropFullName(IDataEntityProperty prop) {
        StringBuilder sb = new StringBuilder();
        sb.append(prop.getName());
        for (IDataEntityType parent = prop.getParent(); parent != null; parent = parent.getParent()) {
            sb.insert(0, ".").insert(0, parent.getName());
        }
        return sb.toString();
    }

    static {
        skipTypes = new HashSet<String>(4);
        skipTypes.add(TYPE_DATA_ENTITY_SERIALIZER);
        skipTypes.add(TYPE_BUSINESS_DATA_READER);
        skipTypes.add(TYPE_QUERY_SERVICE_HELPER);
        skipTypes.add(TYPE_BUSINESS_DATA_SERVICE_HELPER);
        listenTypes = new HashSet<String>(8);
        listenTypes.add(TYPE_DATA_STORAGE);
        listenTypes.add(TYPE_DATA_ENTITY_SERIALIZER);
        listenTypes.add(TYPE_BUSINESS_DATA_READER);
        listenTypes.add(TYPE_QUERY_SERVICE_HELPER);
        listenTypes.add(TYPE_BUSINESS_DATA_SERVICE_HELPER);
    }
}

