/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.trace.listener;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpanInfo;
import kd.bos.dataentity.trace.EntityTraceWriter;
import kd.bos.dataentity.trace.ListenSchemeParam;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.trace.listener.AbstractEntityTraceListener;
import kd.bos.entity.trace.listener.IListenerParamCheck;
import kd.bos.entity.trace.listener.param.entryrow.EntryRowChangeListenEntity;
import kd.bos.entity.trace.listener.param.entryrow.EntryRowChangeParam;
import kd.bos.entity.trace.listener.param.entryrow.EntryRowMethodOpType;
import kd.bos.orm.util.CollectionUtils;

public final class EntryRowChangeListener
extends AbstractEntityTraceListener
implements IListenerParamCheck {
    private static final String TYPE_MODEL_CACHE = "ModelCache";
    private static final String TYPE_DYNAMIC_OBJECT_COLLECTION = "DynamicObjectCollection";
    private static final String SPAN_TAG_DT = "dt.name";
    private static final String SPAN_LTAG_ROOTDATAENTITY = "rootDataEntity";
    private static final String SPAN_LTAG_DT = "dt";
    private static final String SPAN_LTAG_ENTRY_ROWS = "entry.rows";
    private static final String BOS_ENTITY_TRACE = "bos-entity-trace";
    private static final String PARAM_ROWINDEX = "rowIndex";
    private static final String PARAM_OBJ = "obj";
    private static final String PARAM_ROWS_SIZE = "rows.size";
    private static final int MAX_CHILD_COUNT = 30;
    private static final String CHILD_COUNT = "child.count";
    private static Set<String> listenTypes = new HashSet<String>(2);
    private EntryRowChangeParam param;
    private Map<String, EntryRowChangeListenEntity> listenEntities;

    public Set<String> getListenTypes() {
        return listenTypes;
    }

    @Override
    public void setParam(ListenSchemeParam param) {
        super.setParam(param);
        this.param = StringUtils.isBlank((CharSequence)param.getParam()) ? new EntryRowChangeParam() : (EntryRowChangeParam)SerializationUtils.fromJsonString((String)param.getParam(), EntryRowChangeParam.class);
        this.listenEntities = new HashMap<String, EntryRowChangeListenEntity>(this.param.getListenEntities().size());
        for (EntryRowChangeListenEntity listenEntity : this.param.getListenEntities()) {
            this.listenEntities.put(listenEntity.getEntityNumber(), listenEntity);
        }
    }

    @Override
    public boolean checkListenerParamValid(String paramStr) {
        if (StringUtils.isNotEmpty((CharSequence)paramStr)) {
            EntryRowChangeParam param = (EntryRowChangeParam)SerializationUtils.fromJsonString((String)paramStr, EntryRowChangeParam.class);
            if (param != null && param.getListenEntities() != null && param.getListenEntities().size() > 0) {
                for (EntryRowChangeListenEntity listenEntity : param.getListenEntities()) {
                    if (!StringUtils.isEmpty((CharSequence)listenEntity.getEntityNumber())) continue;
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    protected void doEvent(EntityTraceSpanInfo span, String event) {
    }

    @Override
    protected void doClose(EntityTraceSpanInfo span) {
        String dtname = (String)span.getTags().get(SPAN_TAG_DT);
        if (StringUtils.isEmpty((CharSequence)dtname)) {
            Set keySet = span.getTags().keySet();
            for (String key : keySet) {
                if (!key.startsWith(SPAN_TAG_DT)) continue;
                dtname = (String)span.getTags().get(key);
                break;
            }
        }
        if (StringUtils.isEmpty((CharSequence)dtname)) {
            return;
        }
        String[] split = dtname.split("\\.");
        String entityNumber = split[0];
        String entrykey = "";
        if (split.length == 2) {
            entrykey = split[1];
        } else if (split.length == 3) {
            entrykey = split[2];
        }
        if (!this.isListenEntity(entityNumber, entrykey, span.getName())) {
            return;
        }
        int childCount = this.getChildCount(span);
        if (childCount > 30) {
            return;
        }
        this.print(span, entityNumber, entrykey);
    }

    private Integer getChildCount(EntityTraceSpanInfo span) {
        int childCount = 0;
        if (span.getParent() == null || span.getParent().getLocaleTags() == null) {
            return childCount;
        }
        Map tag = span.getParent().getLocaleTags();
        childCount = tag.get(CHILD_COUNT) == null ? 1 : (Integer)tag.get(CHILD_COUNT) + 1;
        tag.put(CHILD_COUNT, childCount);
        return childCount;
    }

    private void print(EntityTraceSpanInfo span, String entityNumber, String entrykey) {
        StringBuilder sBuilder = new StringBuilder();
        String methodName = span.getName();
        if (StringUtils.isEmpty((CharSequence)methodName)) {
            return;
        }
        int opType = EntryRowMethodOpType.get(methodName);
        Object entryRows = span.getLocaleTags().get(SPAN_LTAG_ENTRY_ROWS);
        Object rootPkId = this.getRootPkId(span);
        if (StringUtils.isNotEmpty((CharSequence)entrykey)) {
            sBuilder.append(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u3010%s\u3011", (String)"EntryRowChangeListener_0", (String)BOS_ENTITY_TRACE, (Object[])new Object[0]), entrykey));
        }
        if (EntryRowMethodOpType.OpType.DEL.getValue() == opType || EntryRowMethodOpType.OpType.ADD.getValue() == opType) {
            if (EntryRowMethodOpType.OpType.DEL.getValue() == opType) {
                if ("deleteEntryData".equals(methodName) || "clear".equals(methodName) || "release".equals(methodName)) {
                    sBuilder.append(ResManager.loadKDString((String)"\u6574\u4e2a\u5206\u5f55\u884c\u88ab\u6e05\u9664", (String)"EntryRowChangeListener_1", (String)BOS_ENTITY_TRACE, (Object[])new Object[0])).append(System.lineSeparator());
                } else if ("remove".equals(methodName) || "delEntryRow".equals(methodName) || "delEntryRows".equals(methodName)) {
                    this.getDescInfo(sBuilder, ResManager.loadKDString((String)"\u5220\u884c\u7d22\u5f15\uff1a", (String)"EntryRowChangeListener_2", (String)BOS_ENTITY_TRACE, (Object[])new Object[0]), span.getTags().get(PARAM_ROWINDEX));
                    this.getDescInfo(sBuilder, ResManager.loadKDString((String)"\u5220\u884c\u5bf9\u8c61\uff1a", (String)"EntryRowChangeListener_3", (String)BOS_ENTITY_TRACE, (Object[])new Object[0]), span.getLocaleTags().get(PARAM_OBJ));
                }
            } else if (EntryRowMethodOpType.OpType.ADD.getValue() == opType) {
                this.getDescInfo(sBuilder, ResManager.loadKDString((String)"\u589e\u884c\u7d22\u5f15\uff1a", (String)"EntryRowChangeListener_4", (String)BOS_ENTITY_TRACE, (Object[])new Object[0]), span.getTags().get(PARAM_ROWINDEX));
                this.getDescInfo(sBuilder, ResManager.loadKDString((String)"\u589e\u884c\u5bf9\u8c61\uff1a", (String)"EntryRowChangeListener_5", (String)BOS_ENTITY_TRACE, (Object[])new Object[0]), span.getLocaleTags().get(PARAM_OBJ));
                this.getDescInfo(sBuilder, ResManager.loadKDString((String)"\u672c\u6b21\u589e\u52a0\u884c\u6570\uff1a", (String)"EntryRowChangeListener_6", (String)BOS_ENTITY_TRACE, (Object[])new Object[0]), span.getTags().get(PARAM_ROWS_SIZE));
            }
        }
        sBuilder.append(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4e3b\u5b9e\u4f53\u3010%1$s\u3011\u7684\u4e3b\u952eID\u662f\u3010%2$s\u3011%3$s", (String)"EntryRowChangeListener_7", (String)BOS_ENTITY_TRACE, (Object[])new Object[0]), entityNumber, rootPkId, System.lineSeparator()));
        if (EntryRowMethodOpType.OpType.DEL.getValue() == opType || EntryRowMethodOpType.OpType.ADD.getValue() == opType) {
            if (entryRows != null) {
                sBuilder.append(String.format(ResManager.loadKDString((String)"\u603b\u884c\u6570:%1$s%2$s%3$s", (String)"EntryRowChangeListener_8", (String)BOS_ENTITY_TRACE, (Object[])new Object[0]), entryRows, "", System.lineSeparator()));
            } else {
                sBuilder.append(System.lineSeparator());
            }
        }
        sBuilder.append(String.format(ResManager.loadKDString((String)"\u53c2\u6570\uff1a%1$s%2$s", (String)"EntryRowChangeListener_9", (String)BOS_ENTITY_TRACE, (Object[])new Object[0]), span.getTags(), System.lineSeparator()));
        EntityTraceWriter.InfoLevel level = EntityTraceWriter.InfoLevel.DETAIL;
        if (!this.getConfig().isRealtime()) {
            level = EntityTraceWriter.InfoLevel.IMPORTANT;
        }
        boolean printStock = this.getConfig().isPrintStackTrace();
        this.getConfig().setPrintStackTrace(true);
        this.getWriterManager().write(span, sBuilder.toString(), level);
        this.getConfig().setPrintStackTrace(printStock);
    }

    private boolean isListenEntity(String entityNumber, String entrykey, String methodName) {
        boolean result;
        if (this.listenEntities.isEmpty() || entityNumber == null) {
            return false;
        }
        EntryRowChangeListenEntity listenEntity = this.listenEntities.get(entityNumber);
        if (listenEntity == null) {
            return false;
        }
        if (listenEntity.getEntryKeys().isEmpty()) {
            return this.isListenOpType(listenEntity, methodName);
        }
        boolean bl = result = listenEntity.getEntryKeys().contains(entityNumber) || listenEntity.getEntryKeys().contains(entrykey) || StringUtils.isEmpty((CharSequence)entrykey);
        if (result) {
            return this.isListenOpType(listenEntity, methodName);
        }
        return result;
    }

    private boolean isListenOpType(EntryRowChangeListenEntity listenEntity, String methodName) {
        Set<String> entryOps = listenEntity.getEntryOps();
        if (CollectionUtils.isEmpty(entryOps)) {
            return true;
        }
        int optype = EntryRowMethodOpType.get(methodName);
        if (entryOps.contains(String.valueOf(EntryRowMethodOpType.OpType.OTHER.getValue()))) {
            return true;
        }
        return entryOps.contains(String.valueOf(optype));
    }

    private Object getRootPkId(EntityTraceSpanInfo span) {
        Map tags = span.getLocaleTags();
        Object object = tags.get(SPAN_LTAG_ROOTDATAENTITY);
        if (object instanceof DynamicObject) {
            DynamicObjectType rootEntityType;
            ISimpleProperty pkProperty;
            DynamicObject rootEntity = this.getRootEntity((DynamicObject)object);
            Object dt = tags.get(SPAN_LTAG_DT);
            if (dt instanceof DynamicObjectType && (pkProperty = (rootEntityType = this.getRootEntityType((DynamicObjectType)dt)).getPrimaryKey()) != null) {
                return rootEntity.get((IDataEntityProperty)pkProperty);
            }
        }
        return "";
    }

    private DynamicObject getRootEntity(DynamicObject object) {
        DynamicObject parent = (DynamicObject)object.getParent();
        if (parent == null) {
            return object;
        }
        DynamicObject grandpa = (DynamicObject)parent.getParent();
        if (grandpa != null) {
            return grandpa;
        }
        return parent;
    }

    private DynamicObjectType getRootEntityType(DynamicObjectType objectType) {
        DynamicObjectType parent = (DynamicObjectType)objectType.getParent();
        if (parent == null) {
            return objectType;
        }
        DynamicObjectType grandpa = (DynamicObjectType)parent.getParent();
        if (grandpa != null) {
            return grandpa;
        }
        return parent;
    }

    private void getDescInfo(StringBuilder sBuilder, String desc, Object obj) {
        if (obj != null) {
            sBuilder.append(desc).append(obj).append(System.lineSeparator());
        }
    }

    static {
        listenTypes.add(TYPE_MODEL_CACHE);
        listenTypes.add(TYPE_DYNAMIC_OBJECT_COLLECTION);
    }
}

