/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.trace.listener;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpanInfo;
import kd.bos.dataentity.trace.EntityTraceWriter;
import kd.bos.dataentity.trace.ListenSchemeParam;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.interaction.InteractionContext;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.trace.listener.AbstractEntityTraceListener;
import kd.bos.entity.trace.listener.param.OperateMessageParam;

public class OperateMessageListener
extends AbstractEntityTraceListener {
    private static final String TYPE_OPERATE_RESULT = "operationresult";
    private static final String TYPE_INTERACTION_EXCEPTION = "interactionexception";
    private static final String TYPE_DATAENTITY_SERIALIZER = "DataEntitySerializer";
    private static final String METHOD_SETMESSAGE = "setMessage";
    private static final String METHOD_ADDERRORINFO = "addErrorInfo";
    private static final String SPAN_PARAM_MESSAGE = "message";
    private static final String SPAN_PARAM_OPERATE_INFO = "operateInfo";
    private static final String SPAN_PARAM_INTERACTION_CONTEXT = "interactioncontext";
    private static Set<String> listenTypes = new HashSet<String>(1);
    private OperateMessageParam listenerParam = null;

    public Set<String> getListenTypes() {
        return listenTypes;
    }

    @Override
    public void setParam(ListenSchemeParam param) {
        super.setParam(param);
        this.listenerParam = StringUtils.isBlank((CharSequence)param.getParam()) ? new OperateMessageParam() : (OperateMessageParam)SerializationUtils.fromJsonString((String)param.getParam(), OperateMessageParam.class);
    }

    @Override
    protected void doEvent(EntityTraceSpanInfo span, String event) {
    }

    @Override
    protected void doClose(EntityTraceSpanInfo span) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.equalsIgnoreCase((CharSequence)span.getType(), (CharSequence)TYPE_OPERATE_RESULT)) {
            this.doAddErrorInfo(span, sb);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)span.getType(), (CharSequence)TYPE_INTERACTION_EXCEPTION)) {
            this.doThrowInteractionException(span, sb);
        }
        if (sb.length() > 0) {
            boolean printStack = this.getConfig().isPrintStackTrace();
            this.getConfig().setPrintStackTrace(true);
            this.getWriterManager().write(span, sb.toString(), EntityTraceWriter.InfoLevel.DETAIL);
            this.getConfig().setPrintStackTrace(printStack);
        }
    }

    private void doAddErrorInfo(EntityTraceSpanInfo span, StringBuilder sb) {
        String message = null;
        if (StringUtils.equalsIgnoreCase((CharSequence)span.getName(), (CharSequence)METHOD_SETMESSAGE)) {
            message = (String)span.getLocaleTags().get(SPAN_PARAM_MESSAGE);
            if (this.isListenMessage(message) && !this.isFromSerialize(span)) {
                sb.append(message);
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)span.getName(), (CharSequence)METHOD_ADDERRORINFO)) {
            IOperateInfo operateInfo = (IOperateInfo)span.getLocaleTags().get(SPAN_PARAM_OPERATE_INFO);
            message = operateInfo.getMessage();
            if (operateInfo != null && this.isListenMessage(message)) {
                sb.append(message).append(System.lineSeparator());
                sb.append(SerializationUtils.toJsonString((Object)operateInfo));
            }
        }
    }

    private void doThrowInteractionException(EntityTraceSpanInfo span, StringBuilder sb) {
        InteractionContext context = (InteractionContext)span.getLocaleTags().get(SPAN_PARAM_INTERACTION_CONTEXT);
        if (context != null && this.isListenMessage(context.getSimpleMessage())) {
            sb.append(SerializationUtils.toJsonString((Object)context));
        }
    }

    private boolean isListenMessage(String message) {
        if (this.listenerParam == null || StringUtils.isBlank((CharSequence)this.listenerParam.getMessage())) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)message)) {
            return false;
        }
        return message.indexOf(this.listenerParam.getMessage()) >= 0;
    }

    private boolean isFromSerialize(EntityTraceSpanInfo span) {
        for (EntityTraceSpanInfo parent = span.getParent(); parent != null; parent = parent.getParent()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)parent.getType(), (CharSequence)TYPE_DATAENTITY_SERIALIZER)) continue;
            return true;
        }
        return false;
    }

    static {
        listenTypes.add(TYPE_OPERATE_RESULT);
        listenTypes.add(TYPE_INTERACTION_EXCEPTION);
    }
}

