/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.trace.plugin;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.trace.listener.DynamicObjectSetParam;
import kd.bos.entity.trace.listener.ListenEntity;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.treebuilder.FieldTreeShowHelper;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;

public class DynamicObjectSetPlugin
extends AbstractFormPlugin {
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String KEY_ENTITY = "entity";
    private static final String KEY_FIELD = "field";
    private static final String KEY_OK = "btnok";

    public void registerListener(EventObject e) {
        TextEdit fieldEdit;
        super.registerListener(e);
        Button btnOK = (Button)this.getView().getControl(KEY_OK);
        if (btnOK != null) {
            btnOK.addClickListener((ClickListener)this);
        }
        if ((fieldEdit = (TextEdit)this.getView().getControl(KEY_FIELD)) != null) {
            fieldEdit.addButtonClickListener((ClickListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.showParam();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)KEY_OK, (CharSequence)source.getKey())) {
            this.returnParam();
            this.getView().close();
        } else if (StringUtils.equals((CharSequence)KEY_FIELD, (CharSequence)source.getKey())) {
            this.showFieldForm();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)KEY_FIELD) && closedCallBackEvent.getReturnData() != null) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRYENTITY);
            this.getModel().setValue(KEY_FIELD, closedCallBackEvent.getReturnData(), rowIndex);
        }
    }

    private void showFieldForm() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRYENTITY);
        DynamicObject entityObj = (DynamicObject)this.getModel().getValue(KEY_ENTITY, rowIndex);
        if (entityObj == null) {
            return;
        }
        String entityNumber = (String)entityObj.getPkValue();
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        PropTreeBuildOption option = new PropTreeBuildOption();
        option.setIncludeBDRefProp(false);
        option.setOnlyPhysicsField(false);
        option.setIncludePKField(true);
        TreeNode rootNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)mainType, (PropTreeBuildOption)option);
        String selectFields = (String)this.getModel().getValue(KEY_FIELD, rowIndex);
        FieldTreeShowHelper.showMulTreeNode((IFormView)this.getView(), (TreeNode)rootNode, (String)selectFields, (CloseCallBack)new CloseCallBack((IFormPlugin)this, KEY_FIELD));
    }

    private void showParam() {
        DynamicObjectSetParam param = this.getParam();
        if (!param.getListenEntities().isEmpty()) {
            this.getModel().batchCreateNewEntryRow(KEY_ENTRYENTITY, param.getListenEntities().size());
            for (int i = 0; i < param.getListenEntities().size(); ++i) {
                ListenEntity listenEntity = param.getListenEntities().get(i);
                this.getModel().setValue(KEY_ENTITY, (Object)listenEntity.getEntityNumber(), i);
                this.getModel().setValue(KEY_FIELD, (Object)StringUtils.join((Object[])listenEntity.getFieldKeys().toArray(), (String)","), i);
            }
        }
    }

    private boolean returnParam() {
        DynamicObjectSetParam param = new DynamicObjectSetParam();
        DynamicObject obj = this.getModel().getDataEntity(true);
        DynamicObjectCollection rows = obj.getDynamicObjectCollection(KEY_ENTRYENTITY);
        for (DynamicObject row : rows) {
            DynamicObject entityObj = row.getDynamicObject(KEY_ENTITY);
            if (entityObj == null) continue;
            String entityNumber = (String)entityObj.getPkValue();
            String fieldKeys = row.getString(KEY_FIELD);
            param.addListenEntity(entityNumber, fieldKeys);
        }
        this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)param));
        return true;
    }

    private DynamicObjectSetParam getParam() {
        String paramValue = (String)this.getView().getFormShowParameter().getCustomParam("schemeparam");
        if (StringUtils.isBlank((CharSequence)paramValue)) {
            return new DynamicObjectSetParam();
        }
        return (DynamicObjectSetParam)SerializationUtils.fromJsonString((String)paramValue, DynamicObjectSetParam.class);
    }
}

