/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.trace.plugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.trace.config.EntityTraceConfigReader;
import kd.bos.entity.trace.scheme.ListenScheme;
import kd.bos.entity.trace.scheme.ListenSchemeLoader;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;

public class EntityTraceConfigPlugin
extends AbstractBillPlugIn {
    private static final String BOS_ENTITY_TRACE = "bos-entity-trace";
    public static final String CUSTPARAM_REALTIME = "realtime";
    public static final String CUSTPARAM_SCHEMEPARAM = "schemeparam";
    public static final String FORMID_ENTITY_TRACE_CONFIG = "bos_entitytraceconfig";
    private static final String KEY_REALTIME = "realtime";
    private static final String KEY_SCHEME_ENTRY = "schemeentry";
    private static final String KEY_SCHEME_ID = "schemeid";
    private static final String KEY_SCHEME_NEME = "schemename";
    private static final String KEY_SCHEME_DESC = "schemedesc";
    private static final String KEY_SCHEME_ENABLE = "schemeenable";
    private static final String KEY_SCHEME_PARAM = "schemeparam";
    private static final String VECTOR_AP = "vectorap";
    private static final String LABEL_AP = "labelap";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit schemeParam = (TextEdit)this.getView().getControl("schemeparam");
        if (schemeParam != null) {
            schemeParam.addButtonClickListener((ClickListener)this);
        }
        this.addClickListeners(new String[]{VECTOR_AP, LABEL_AP});
    }

    public void createNewData(BizDataEventArgs e) {
        boolean realtime = this.isRealtime();
        DynamicObject configObj = null;
        configObj = realtime ? EntityTraceConfigReader.loadRealtimeConfig() : EntityTraceConfigReader.loadBackGroundConfig();
        e.setDataEntity((Object)configObj);
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("realtime", (Object)this.isRealtime());
        this.initEntryEntity();
    }

    private void initEntryEntity() {
        DynamicObject configObj = this.getModel().getDataEntity(true);
        DynamicObjectCollection rows = configObj.getDynamicObjectCollection(KEY_SCHEME_ENTRY);
        HashMap<String, DynamicObject> configRows = new HashMap<String, DynamicObject>(rows.size());
        for (DynamicObject row : rows) {
            String schemeId = row.getString(KEY_SCHEME_ID);
            if (!StringUtils.isNotBlank((CharSequence)schemeId)) continue;
            configRows.put(schemeId, row);
        }
        rows.clear();
        List<ListenScheme> listenSchemes = ListenSchemeLoader.load();
        for (ListenScheme listenScheme : listenSchemes) {
            String schemeId = listenScheme.getId();
            DynamicObject row = (DynamicObject)configRows.get(schemeId);
            if (row == null) {
                row = new DynamicObject(rows.getDynamicObjectType());
                row.set(KEY_SCHEME_ID, (Object)schemeId);
                row.set(KEY_SCHEME_ENABLE, (Object)listenScheme.isDefSelected());
            }
            String name = listenScheme.getName().getLocaleValue_zh_CN();
            row.set(KEY_SCHEME_NEME, (Object)ResManager.loadKDString((String)name, (String)listenScheme.getName_LangResId(), (String)BOS_ENTITY_TRACE, (Object[])new Object[0]));
            String desc = listenScheme.getDesc().getLocaleValue_zh_CN();
            row.set(KEY_SCHEME_DESC, (Object)ResManager.loadKDString((String)desc, (String)listenScheme.getDesc_LangResId(), (String)BOS_ENTITY_TRACE, (Object[])new Object[0]));
            rows.add((Object)row);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"schemeparam")) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex(KEY_SCHEME_ENTRY);
            String schemeId = (String)this.getModel().getValue(KEY_SCHEME_ID, rowIndex);
            String schemeParam = (String)this.getModel().getValue("schemeparam", rowIndex);
            this.showParamForm(schemeId, schemeParam);
        } else if (VECTOR_AP.equals(source.getKey()) || LABEL_AP.equals(source.getKey())) {
            this.getView().openUrl("https://club.kdcloud.com/article/494819274070829824?productLineId=29&isKnowledge=2");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String paramValue;
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)"schemeparam") && (paramValue = (String)closedCallBackEvent.getReturnData()) != null) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex(KEY_SCHEME_ENTRY);
            this.getModel().setValue("schemeparam", (Object)paramValue, rowIndex);
        }
    }

    private void showParamForm(String schemeId, String paramValue) {
        ListenScheme listenScheme = ListenSchemeLoader.get(schemeId);
        if (listenScheme == null || StringUtils.isBlank((CharSequence)listenScheme.getSettingFormId())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u65b9\u6848\u4e0d\u9700\u8981\u914d\u7f6e\u53c2\u6570\u3002", (String)"EntityTraceConfigPlugin_0", (String)BOS_ENTITY_TRACE, (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(listenScheme.getSettingFormId());
        showParameter.getCustomParams().put("schemeparam", paramValue);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "schemeparam"));
        this.getView().showForm(showParameter);
    }

    private boolean isRealtime() {
        String realtime = (String)this.getView().getFormShowParameter().getCustomParam("realtime");
        if (StringUtils.isBlank((CharSequence)realtime)) {
            return false;
        }
        return Boolean.parseBoolean(realtime);
    }
}

