/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.trace.plugin;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.trace.cache.ConfigCacheWriter;
import kd.bos.entity.trace.cache.MessageCacheReader;
import kd.bos.entity.trace.cache.MessagePackage;
import kd.bos.form.BindingContext;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.service.KDDateUtils;

public class EntityTraceViewPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final String KEY_START = "tbnstart";
    private static final String KEY_PAUSE = "tbnpause";
    private static final String KEY_STOP = "tbnstop";
    private static final String KEY_CLEAR = "tbnclear";
    private static final String KEY_EXPAND = "tbnexpand";
    private static final String KEY_COLLAPSE = "tbncollapse";
    private static final String KEY_CONFIG = "tbnconfig";
    private static final String KEY_FOCUS = "tbnfocus";
    private static final String KEY_PROGRESSBAR = "progressbar";
    public static final String KEY_ENTRY = "entryentity";
    public static final String KEY_ID = "id";
    public static final String KEY_PID = "pid";
    public static final String KEY_CREATETIME = "createtime";
    public static final String KEY_CREATETIME1 = "createtime1";
    public static final String KEY_COST = "cost";
    public static final String KEY_LEVEL = "level";
    public static final String KEY_TYPE = "type";
    public static final String KEY_MESSAGE = "message";
    public static final String KEY_TRACE = "trace";
    private static final String BOS_ENTITY_TRACE = "bos-entity-trace";
    private static final int MAX_ROWS = 10000;
    private DateFormat dataFormat;
    private Map<Long, Integer> rowIndexs;
    private Boolean stop = false;

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setBarStatus(RunStatus.STOP);
    }

    public void registerListener(EventObject e) {
        ProgressBar progressBar;
        super.registerListener(e);
        Toolbar toolbar = (Toolbar)this.getView().getControl("tbmain");
        if (toolbar != null) {
            toolbar.addItemClickListener((ItemClickListener)this);
        }
        if ((progressBar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR)) != null) {
            progressBar.addProgressListener((ProgresssListener)this);
        }
    }

    public void itemClick(ItemClickEvent e) {
        super.itemClick(e);
        switch (e.getItemKey()) {
            case "tbnstart": {
                this.doStart();
                break;
            }
            case "tbnstop": {
                this.doStop();
                break;
            }
            case "tbnpause": {
                this.doPause();
                break;
            }
            case "tbnclear": {
                this.doClear();
                break;
            }
            case "tbnexpand": {
                this.doExpand();
                break;
            }
            case "tbncollapse": {
                this.doCollapse();
                break;
            }
            case "tbnconfig": {
                this.doShowConfig();
                break;
            }
            case "tbnfocus": {
                this.doFocusInfo();
                break;
            }
        }
    }

    public void onProgress(ProgressEvent e) {
        e.setProgress(1);
        this.loadAndShowMessage();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        ConfigCacheWriter.setRealtime(false);
    }

    private void doStart() {
        ProgressBar progressBar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        if (progressBar != null) {
            progressBar.start();
        }
        ConfigCacheWriter.setRealtime(true);
        this.setBarStatus(RunStatus.RUNING);
    }

    private void doStop() {
        ProgressBar progressBar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        if (progressBar != null) {
            progressBar.stop();
        }
        ConfigCacheWriter.setRealtime(false);
        this.stop = true;
        this.setBarStatus(RunStatus.STOP);
        this.loadAndShowMessage();
    }

    private void doPause() {
        ProgressBar progressBar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        if (progressBar != null) {
            progressBar.stop();
        }
        this.setBarStatus(RunStatus.PAUSE);
    }

    private void doClear() {
        this.getModel().deleteEntryData(KEY_ENTRY);
        this.getRowIndexs().clear();
        this.saveRowIndexs();
    }

    private void doExpand() {
        TreeEntryGrid grid = (TreeEntryGrid)this.getView().getControl(KEY_ENTRY);
        grid.setCollapse(false);
    }

    private void doCollapse() {
        TreeEntryGrid grid = (TreeEntryGrid)this.getView().getControl(KEY_ENTRY);
        grid.setCollapse(true);
    }

    private void doShowConfig() {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("bos_entitytraceconfig");
        showParameter.setHasRight(true);
        StyleCss styleCss = new StyleCss();
        styleCss.setHeight("800px");
        styleCss.setWidth("1200px");
        showParameter.getOpenStyle().setInlineStyleCss(styleCss);
        showParameter.getCustomParams().put("realtime", String.valueOf(true));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void doFocusInfo() {
        int selectRow = this.getModel().getEntryCurrentRowIndex(KEY_ENTRY);
        if (selectRow == -1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u805a\u7126\u7684\u4fe1\u606f\u884c\u3002", (String)"EntityTraceViewPlugin_0", (String)BOS_ENTITY_TRACE, (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_entitytracefocus");
        showParameter.setHasRight(true);
        showParameter.getCustomParams().put("selectrow", selectRow);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(showParameter);
    }

    private void setBarStatus(RunStatus runStatus) {
        switch (runStatus) {
            case STOP: {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{KEY_START, KEY_CONFIG});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{KEY_STOP, KEY_PAUSE});
                break;
            }
            case PAUSE: {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{KEY_START, KEY_STOP});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{KEY_PAUSE, KEY_CONFIG});
                break;
            }
            case RUNING: {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{KEY_PAUSE, KEY_STOP});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{KEY_START, KEY_CONFIG});
                break;
            }
        }
    }

    protected void loadAndShowMessage() {
        List<MessagePackage> messagePackages = MessageCacheReader.getAndRemove();
        messagePackages.sort(new SortMessagePackage());
        for (MessagePackage messagePackage : messagePackages) {
            this.showMessage(messagePackage);
        }
        this.saveRowIndexs();
    }

    protected void showMessage(MessagePackage messagePackage) {
        boolean overMaxRows;
        int size = messagePackage.getMessages().size();
        EntryGrid grid = (EntryGrid)this.getView().getControl(KEY_ENTRY);
        IClientViewProxy viewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        int rowCount = this.getModel().getEntryRowCount(KEY_ENTRY);
        boolean bl = overMaxRows = rowCount >= 10000;
        if (overMaxRows) {
            this.doStop();
            return;
        }
        this.getModel().beginInit();
        int[] rows = this.getModel().batchCreateNewEntryRow(KEY_ENTRY, size);
        for (int i = 0; i < size; ++i) {
            int rowIndex = rows[i];
            if (rowIndex >= 10000) {
                overMaxRows = true;
            }
            MessagePackage.Message message = messagePackage.getMessages().get(i);
            DynamicObject rowObj = this.getModel().getEntryRowEntity(KEY_ENTRY, rowIndex);
            rowObj.set(KEY_ID, (Object)message.getId());
            rowObj.set(KEY_PID, (Object)message.getPid());
            rowObj.set(KEY_CREATETIME, (Object)this.getDateFormat().format(new Date(message.getTm())));
            try {
                String date = this.getDateFormat().format(new Date(message.getTm()));
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                dateFormat.setTimeZone(KDDateUtils.getUserTimeZone());
                Date createtime = dateFormat.parse(date);
                rowObj.set(KEY_CREATETIME1, (Object)createtime);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            rowObj.set(KEY_COST, (Object)message.getCt());
            rowObj.set(KEY_LEVEL, (Object)message.getLv());
            rowObj.set(KEY_TYPE, (Object)String.format("%s%s.%s", this.levelToText(message.getLv()), message.getTy(), message.getMt()));
            rowObj.set(KEY_MESSAGE, (Object)message.getMsg());
            rowObj.set(KEY_TRACE, (Object)message.getTc());
            this.getRowIndexs().put(message.getId(), rowIndex);
            this.bindGridView(viewProxy, grid, rowObj, rowIndex);
        }
        this.getModel().endInit();
        for (MessagePackage.Cost cost : messagePackage.getCosts()) {
            Integer rowIndex = this.getRowIndexs().get(cost.getId());
            if (rowIndex == null) continue;
            this.getModel().setValue(KEY_COST, (Object)cost.getCt(), rowIndex.intValue());
        }
        if (overMaxRows && (this.stop == null || !this.stop.booleanValue())) {
            this.doStop();
        }
    }

    private String levelToText(int level) {
        StringBuilder sb = new StringBuilder();
        for (int i = 2; i < level; ++i) {
            sb.append("|   ");
        }
        if (level > 1) {
            sb.append("|---");
        }
        return sb.toString();
    }

    private void bindGridView(IClientViewProxy viewProxy, EntryGrid grid, DynamicObject rowObj, int rowIndex) {
        BindingContext bindCtx = new BindingContext(rowObj.getDataEntityType(), rowObj, rowIndex);
        List rowValues = grid.getRowBindValue(bindCtx);
        viewProxy.appendRow(grid.getKey(), rowValues);
    }

    private DateFormat getDateFormat() {
        if (this.dataFormat == null) {
            TimeZone timeZone = KDDateUtils.getUserTimeZone();
            this.dataFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS");
            this.dataFormat.setTimeZone(timeZone);
        }
        return this.dataFormat;
    }

    private Map<Long, Integer> getRowIndexs() {
        if (this.rowIndexs == null) {
            String cacheVal = this.getPageCache().get("rowindexs");
            this.rowIndexs = cacheVal == null ? new HashMap<Long, Integer>(1000) : (Map)SerializationUtils.fromJsonString((String)cacheVal, Map.class);
        }
        return this.rowIndexs;
    }

    private void saveRowIndexs() {
        if (this.rowIndexs != null) {
            this.getPageCache().put("rowindexs", SerializationUtils.toJsonString(this.rowIndexs));
        }
    }

    static enum RunStatus {
        STOP(0),
        PAUSE(1),
        RUNING(2);

        private int value;

        private RunStatus(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    static class SortMessagePackage
    implements Comparator<MessagePackage> {
        SortMessagePackage() {
        }

        @Override
        public int compare(MessagePackage o1, MessagePackage o2) {
            long diff = o1.getCreateTime() - o2.getCreateTime();
            if (diff <= 0L) {
                return -1;
            }
            return diff > 0L ? 1 : 0;
        }
    }
}

