/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.trace.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.trace.listener.param.MethodListenParam;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;

public class MethodListenPlugin
extends AbstractFormPlugin {
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String KEY_TYPE = "listentype";
    private static final String KEY_NAME = "listenname";
    private static final String KEY_OK = "btnok";
    private static final String KEY_OP_LIST_DATA_PROVIDER = "op_listdataprovider";
    private static final String KEY_OP_OPSERVICE_IMPL = "op_opserviceimpl";
    private static final String KEY_OP_FORMULA = "op_formula";
    private static final String KEY_OP_DATA_READER = "op_datareader";
    private static final String KEY_OP_DATA_WRITER = "op_datawriter";
    private static final String KEY_OP_CLIENT_VIEW = "op_clientview";
    private static final String KEY_OP_PAGE_CACHE = "op_pagecache";
    private static final String KEY_OP_APP_CACHE = "op_appcache";
    private static final String TYPE_LIST = "list";
    private static final String TYPE_OPSERVICE = "opservice";
    private static final String TYPE_FORMULA = "formula";
    private static final String TYPE_DATAREADER = "datareader";
    private static final String TYPE_DATAWRITER = "datawriter";
    private static final String TYPE_CLIENTVIEW = "clientview";
    private static final String TYPE_PAGECACHE = "pagecache";
    private static final String TYPE_APPCACHE = "appcache";
    private static final String METHOD_LIST_DATA_PROVIDER = "ListDataProvider.getData";
    private static final String METHOD_OPSERVICE_IMPL = "OperationService.invokeOperation";
    private static final String METHOD_LOAD_SINGLE = "loadSingle";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button btnOK = (Button)this.getView().getControl(KEY_OK);
        if (btnOK != null) {
            btnOK.addClickListener((ClickListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.showParam();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)KEY_OK, (CharSequence)source.getKey())) {
            this.returnParam();
            this.getView().close();
        }
    }

    private void showParam() {
        MethodListenParam param = this.getParam();
        if (!param.getListenMethods().isEmpty()) {
            this.getModel().batchCreateNewEntryRow(KEY_ENTRYENTITY, param.getListenMethods().size());
            for (int i = 0; i < param.getListenMethods().size(); ++i) {
                MethodListenParam.MethodInfo methodInfo = param.getListenMethods().get(i);
                this.getModel().setValue(KEY_TYPE, (Object)methodInfo.getType(), i);
                this.getModel().setValue(KEY_NAME, (Object)methodInfo.getName(), i);
            }
        }
        if (!param.getCommonMethods().isEmpty()) {
            for (MethodListenParam.MethodInfo methodInfo : param.getCommonMethods()) {
                String opFldKey = this.getOpFieldKey(methodInfo);
                if (!StringUtils.isNotBlank((CharSequence)opFldKey) || this.getModel().getProperty(opFldKey) == null) continue;
                this.getModel().setValue(opFldKey, (Object)true);
            }
        }
    }

    private boolean returnParam() {
        DynamicObject obj = this.getModel().getDataEntity(true);
        DynamicObjectCollection rows = obj.getDynamicObjectCollection(KEY_ENTRYENTITY);
        ArrayList<MethodListenParam.MethodInfo> methodInfos = new ArrayList<MethodListenParam.MethodInfo>(rows.size());
        ArrayList<MethodListenParam.MethodInfo> commonMethods = new ArrayList<MethodListenParam.MethodInfo>(2);
        for (DynamicObject row : rows) {
            String type = row.getString(KEY_TYPE);
            String name = row.getString(KEY_NAME);
            methodInfos.add(new MethodListenParam.MethodInfo(type, name));
        }
        for (IDataEntityProperty prop : this.getModel().getDataEntityType().getProperties()) {
            MethodListenParam.MethodInfo methodInfo;
            Boolean fldValue;
            if (!(prop instanceof BooleanProp) || !(fldValue = (Boolean)this.getModel().getValue(prop.getName())).booleanValue() || (methodInfo = this.getCommonMethod(prop.getName())) == null) continue;
            commonMethods.add(methodInfo);
        }
        MethodListenParam param = new MethodListenParam();
        param.setListenMethods(methodInfos);
        param.setCommonMethods(commonMethods);
        this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)param));
        return true;
    }

    private MethodListenParam getParam() {
        String paramValue = (String)this.getView().getFormShowParameter().getCustomParam("schemeparam");
        if (StringUtils.isBlank((CharSequence)paramValue)) {
            return new MethodListenParam();
        }
        return (MethodListenParam)SerializationUtils.fromJsonString((String)paramValue, MethodListenParam.class);
    }

    private String getOpFieldKey(MethodListenParam.MethodInfo methodInfo) {
        switch (methodInfo.getType()) {
            case "appcache": {
                return KEY_OP_APP_CACHE;
            }
            case "clientview": {
                return KEY_OP_CLIENT_VIEW;
            }
            case "datareader": {
                return KEY_OP_DATA_READER;
            }
            case "datawriter": {
                return KEY_OP_DATA_WRITER;
            }
            case "formula": {
                return KEY_OP_FORMULA;
            }
            case "list": {
                return KEY_OP_LIST_DATA_PROVIDER;
            }
            case "opservice": {
                return KEY_OP_OPSERVICE_IMPL;
            }
            case "pagecache": {
                return KEY_OP_PAGE_CACHE;
            }
        }
        return "";
    }

    private MethodListenParam.MethodInfo getCommonMethod(String opFieldKey) {
        switch (opFieldKey) {
            case "op_appcache": {
                return new MethodListenParam.MethodInfo(TYPE_APPCACHE, "");
            }
            case "op_clientview": {
                return new MethodListenParam.MethodInfo(TYPE_CLIENTVIEW, "");
            }
            case "op_datareader": {
                return new MethodListenParam.MethodInfo(TYPE_DATAREADER, METHOD_LOAD_SINGLE);
            }
            case "op_datawriter": {
                return new MethodListenParam.MethodInfo(TYPE_DATAWRITER, "");
            }
            case "op_formula": {
                return new MethodListenParam.MethodInfo(TYPE_FORMULA, "");
            }
            case "op_listdataprovider": {
                return new MethodListenParam.MethodInfo(TYPE_LIST, METHOD_LIST_DATA_PROVIDER);
            }
            case "op_opserviceimpl": {
                return new MethodListenParam.MethodInfo(TYPE_OPSERVICE, METHOD_OPSERVICE_IMPL);
            }
            case "op_pagecache": {
                return new MethodListenParam.MethodInfo(TYPE_PAGECACHE, "");
            }
        }
        return null;
    }
}

