/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.trace.scheme;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.trace.scheme.ListenScheme;

public class ListenSchemeLoader {
    private static Map<String, ListenScheme> listenSchemeMap;
    private static List<ListenScheme> listenSchemeList;
    private static final String BOS_ENTITY_TRACE = "bos-entity-trace";

    private ListenSchemeLoader() {
    }

    public static List<ListenScheme> load() {
        return new ArrayList<ListenScheme>(ListenSchemeLoader.loadFromXML());
    }

    public static ListenScheme get(String schemeId) {
        if (listenSchemeMap == null) {
            ListenSchemeLoader.loadFromXML();
        }
        return listenSchemeMap.get(schemeId);
    }

    private static synchronized List<ListenScheme> loadFromXML() {
        if (listenSchemeList == null) {
            listenSchemeList = new ArrayList<ListenScheme>(7);
            listenSchemeList.add(ListenSchemeLoader.createDynamicObjectSetScheme());
            listenSchemeList.add(ListenSchemeLoader.createCallStockScheme());
            listenSchemeList.add(ListenSchemeLoader.createMethodRunScheme());
            listenSchemeList.add(ListenSchemeLoader.createExceptionScheme());
            listenSchemeList.add(ListenSchemeLoader.createEntryRowScheme());
            listenSchemeList.add(ListenSchemeLoader.createOpMessageScheme());
            listenSchemeList.add(ListenSchemeLoader.createCallPluginAuditScheme());
            listenSchemeMap = new HashMap<String, ListenScheme>(listenSchemeList.size());
            for (ListenScheme listenScheme : listenSchemeList) {
                listenSchemeMap.put(listenScheme.getId(), listenScheme);
            }
        }
        return listenSchemeList;
    }

    private static ListenScheme createDynamicObjectSetScheme() {
        ListenScheme scheme = new ListenScheme();
        scheme.setId("DynamicObject_Set");
        String name_LangResId = "ListenSchemeLoader_0";
        scheme.setName(ResManager.getLocaleString((String)"\u5b57\u6bb5\u503c\u6539\u52a8", (String)name_LangResId, (String)BOS_ENTITY_TRACE));
        scheme.setName_LangResId(name_LangResId);
        String desc_LangResId = "ListenSchemeLoader_1";
        scheme.setDesc(ResManager.getLocaleString((String)"\u76d1\u542c\u5b57\u6bb5\u503c\u7684\u6539\u52a8\uff0c\u5728\u5b57\u6bb5\u503c\u6539\u52a8\u65f6\u8f93\u51fa\u4fe1\u606f\uff0c\u5217\u51fa\u5b57\u6bb5\u539f\u59cb\u503c\u3001\u6700\u65b0\u503c", (String)desc_LangResId, (String)BOS_ENTITY_TRACE));
        scheme.setDesc_LangResId(desc_LangResId);
        scheme.setListenerClass("kd.bos.entity.trace.listener.DynamicObjectSetListener");
        scheme.setSettingFormId("bos_dynamicobjectsetparam");
        scheme.setRealtime(true);
        scheme.setDefSelected(true);
        scheme.setSeq(1);
        return scheme;
    }

    private static ListenScheme createCallStockScheme() {
        ListenScheme scheme = new ListenScheme();
        scheme.setId("CallStock");
        String name_LangResId = "ListenSchemeLoader_2";
        scheme.setName(ResManager.getLocaleString((String)"\u4ee3\u7801\u8c03\u7528\u6d88\u8017", (String)name_LangResId, (String)BOS_ENTITY_TRACE));
        scheme.setName_LangResId(name_LangResId);
        String desc_LangResId = "ListenSchemeLoader_3";
        scheme.setDesc(ResManager.getLocaleString((String)"\u76d1\u542c\u4ee3\u7801\u8c03\u7528\u7684\u6d88\u8017\uff0c\u5904\u7406\u8d85\u8fc7\u4e00\u5b9a\u65f6\u957f\uff0c\u8f93\u51fa\u62a5\u544a", (String)desc_LangResId, (String)BOS_ENTITY_TRACE));
        scheme.setDesc_LangResId(desc_LangResId);
        scheme.setListenerClass("kd.bos.entity.trace.listener.CallStockListener");
        scheme.setSettingFormId("bos_et_callstocklistener");
        scheme.setRealtime(true);
        scheme.setDefSelected(false);
        scheme.setSeq(1);
        return scheme;
    }

    private static ListenScheme createMethodRunScheme() {
        ListenScheme scheme = new ListenScheme();
        scheme.setId("MethodRun");
        String name_LangResId = "ListenSchemeLoader_4";
        scheme.setName(ResManager.getLocaleString((String)"\u65b9\u6cd5\u6267\u884c\u76d1\u542c", (String)name_LangResId, (String)BOS_ENTITY_TRACE));
        scheme.setName_LangResId(name_LangResId);
        String desc_LangResId = "ListenSchemeLoader_5";
        scheme.setDesc(ResManager.getLocaleString((String)"\u76d1\u542c\u6307\u5b9a\u65b9\u6cd5\u7684\u6267\u884c\uff0c\u8f93\u51fa\u6267\u884c\u53c2\u6570\u548c\u8fc7\u7a0b\u53d8\u91cf\u503c", (String)desc_LangResId, (String)BOS_ENTITY_TRACE));
        scheme.setDesc_LangResId(desc_LangResId);
        scheme.setListenerClass("kd.bos.entity.trace.listener.MethodListener");
        scheme.setSettingFormId("bos_et_methodlistener");
        scheme.setRealtime(true);
        scheme.setDefSelected(false);
        scheme.setSeq(1);
        return scheme;
    }

    private static ListenScheme createExceptionScheme() {
        ListenScheme scheme = new ListenScheme();
        scheme.setId("KDErrorListener");
        String name_LangResId = "ListenSchemeLoader_6";
        scheme.setName(ResManager.getLocaleString((String)"\u5f02\u5e38\u76d1\u542c", (String)name_LangResId, (String)BOS_ENTITY_TRACE));
        scheme.setName_LangResId(name_LangResId);
        String desc_LangResId = "ListenSchemeLoader_7";
        scheme.setDesc(ResManager.getLocaleString((String)"\u76d1\u542c\u8fd0\u884c\u4e2d\u7684\u5f02\u5e38\uff0c\u8f93\u51fa\u6267\u884c\u53c2\u6570\u548c\u8fc7\u7a0b\u53d8\u91cf\u503c", (String)desc_LangResId, (String)BOS_ENTITY_TRACE));
        scheme.setDesc_LangResId(desc_LangResId);
        scheme.setListenerClass("kd.bos.entity.trace.listener.KDErrorListener");
        scheme.setSettingFormId("");
        scheme.setRealtime(false);
        scheme.setDefSelected(true);
        scheme.setSeq(90);
        return scheme;
    }

    private static ListenScheme createEntryRowScheme() {
        ListenScheme scheme = new ListenScheme();
        scheme.setId("EntryRowChange");
        String name_LangResId = "ListenSchemeLoader_8";
        scheme.setName(ResManager.getLocaleString((String)"\u5206\u5f55\u884c\u589e\u5220", (String)name_LangResId, (String)BOS_ENTITY_TRACE));
        scheme.setName_LangResId(name_LangResId);
        String desc_LangResId = "ListenSchemeLoader_9";
        scheme.setDesc(ResManager.getLocaleString((String)"\u76d1\u542c\u5206\u5f55\u884c\u589e\u5220\u6539\u53d8\uff0c\u5728\u5206\u5f55\u884c\u589e\u5220\u65f6\u8f93\u51fa\u4fe1\u606f", (String)desc_LangResId, (String)BOS_ENTITY_TRACE));
        scheme.setDesc_LangResId(desc_LangResId);
        scheme.setListenerClass("kd.bos.entity.trace.listener.EntryRowChangeListener");
        scheme.setSettingFormId("bos_entryrowchangeparam");
        scheme.setRealtime(false);
        scheme.setDefSelected(false);
        scheme.setSeq(10);
        scheme.setListenerParamMcName("bos.entitytrace.entryrowchange.param");
        return scheme;
    }

    private static ListenScheme createOpMessageScheme() {
        ListenScheme scheme = new ListenScheme();
        scheme.setId("OperateMessageListener");
        String name_LangResId = "ListenSchemeLoader_10";
        scheme.setName(ResManager.getLocaleString((String)"\u64cd\u4f5c\u63d0\u793a\u76d1\u542c", (String)name_LangResId, (String)BOS_ENTITY_TRACE));
        scheme.setName_LangResId(name_LangResId);
        String desc_LangResId = "ListenSchemeLoader_11";
        scheme.setDesc(ResManager.getLocaleString((String)"\u76d1\u542c\u64cd\u4f5c\u8fc7\u7a0b\u4e2d\u751f\u6210\u7684\u63d0\u793a\u4fe1\u606f", (String)desc_LangResId, (String)BOS_ENTITY_TRACE));
        scheme.setDesc_LangResId(desc_LangResId);
        scheme.setListenerClass("kd.bos.entity.trace.listener.OperateMessageListener");
        scheme.setSettingFormId("");
        scheme.setRealtime(true);
        scheme.setDefSelected(false);
        scheme.setSeq(11);
        return scheme;
    }

    private static ListenScheme createCallPluginAuditScheme() {
        ListenScheme scheme = new ListenScheme();
        scheme.setId("CallPluginAudit");
        String name_LangResId = "ListenSchemeLoader_12";
        scheme.setName(ResManager.getLocaleString((String)"\u63d2\u4ef6\u6027\u80fd\u5ba1\u8ba1", (String)name_LangResId, (String)BOS_ENTITY_TRACE));
        scheme.setName_LangResId(name_LangResId);
        String desc_LangResId = "ListenSchemeLoader_13";
        scheme.setDesc(ResManager.getLocaleString((String)"\u76d1\u542c\u8c03\u7528\u63d2\u4ef6\u65b9\u6cd5\u7684\u6d88\u8017\uff0c\u5904\u7406\u8d85\u8fc7\u4e00\u5b9a\u65f6\u957f\uff0c\u8f93\u51fa\u62a5\u544a", (String)desc_LangResId, (String)BOS_ENTITY_TRACE));
        scheme.setDesc_LangResId(desc_LangResId);
        scheme.setListenerClass("kd.bos.entity.trace.listener.CallPluginAuditListener");
        scheme.setSettingFormId("bos_callpluginauditparam");
        scheme.setRealtime(false);
        scheme.setDefSelected(false);
        scheme.setSeq(12);
        scheme.setListenerParamMcName("bos.entitytrace.callpluginaudit.param");
        return scheme;
    }
}

