/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.trace.tagval;

import java.util.Arrays;
import kd.bos.entity.trace.tagval.TagToString;
import kd.bos.entity.trace.tagval.TagValue;
import kd.bos.entity.trace.tagval.ToStringOption;

class ArrayToString
implements TagToString {
    ArrayToString() {
    }

    @Override
    public String convToString(Object obj) {
        return this.convToString(obj, new ToStringOption());
    }

    @Override
    public String convToString(Object obj, ToStringOption option) {
        Class<?> eClass = obj.getClass();
        if (eClass.isArray()) {
            if (eClass == byte[].class) {
                return Arrays.toString((byte[])obj);
            }
            if (eClass == short[].class) {
                return Arrays.toString((short[])obj);
            }
            if (eClass == int[].class) {
                return Arrays.toString((int[])obj);
            }
            if (eClass == long[].class) {
                return Arrays.toString((long[])obj);
            }
            if (eClass == char[].class) {
                return Arrays.toString((char[])obj);
            }
            if (eClass == float[].class) {
                return Arrays.toString((float[])obj);
            }
            if (eClass == double[].class) {
                return Arrays.toString((double[])obj);
            }
            if (eClass == boolean[].class) {
                return Arrays.toString((boolean[])obj);
            }
            return this.deepToString((Object[])obj, option);
        }
        return obj.toString();
    }

    private String deepToString(Object[] a, ToStringOption option) {
        if (a == null) {
            return "null";
        }
        int bufLen = 20 * a.length;
        if (a.length != 0 && bufLen <= 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuilder buf = new StringBuilder(bufLen);
        this.deepToString(a, buf, option);
        return buf.toString();
    }

    private void deepToString(Object[] a, StringBuilder buf, ToStringOption option) {
        if (a == null) {
            buf.append("null");
            return;
        }
        int iMax = a.length - 1;
        if (iMax == -1) {
            buf.append("[]");
            return;
        }
        option.addDoingObj(a);
        buf.append('[');
        int i = 0;
        while (true) {
            Object element;
            if ((element = a[i]) == null) {
                buf.append("null");
            } else {
                Class<?> eClass = element.getClass();
                if (eClass.isArray()) {
                    if (eClass == byte[].class) {
                        buf.append(Arrays.toString((byte[])element));
                    } else if (eClass == short[].class) {
                        buf.append(Arrays.toString((short[])element));
                    } else if (eClass == int[].class) {
                        buf.append(Arrays.toString((int[])element));
                    } else if (eClass == long[].class) {
                        buf.append(Arrays.toString((long[])element));
                    } else if (eClass == char[].class) {
                        buf.append(Arrays.toString((char[])element));
                    } else if (eClass == float[].class) {
                        buf.append(Arrays.toString((float[])element));
                    } else if (eClass == double[].class) {
                        buf.append(Arrays.toString((double[])element));
                    } else if (eClass == boolean[].class) {
                        buf.append(Arrays.toString((boolean[])element));
                    } else if (option.containsDoingObj(element)) {
                        buf.append("[...]");
                    } else {
                        this.deepToString((Object[])element, buf, option);
                    }
                } else {
                    buf.append(TagValue.convToString(element, option));
                    if (buf.length() >= option.getMaxLength()) break;
                }
            }
            if (i == iMax) break;
            buf.append(", ");
            ++i;
        }
        buf.append(']');
        option.removeDoingObj(a);
    }
}

