/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.trace.tagval;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.BitSet;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.PkSnapshot;
import kd.bos.dataentity.entity.PkSnapshotSet;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ILocaleProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.PriceProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.entity.trace.tagval.TagToString;
import kd.bos.entity.trace.tagval.ToStringOption;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;

class DynamicObjectToString
implements TagToString {
    private SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final int MAX_FIELD_LENGTH = 50;
    private static final int MAX_CALL_LEVEL = 6;

    DynamicObjectToString() {
    }

    @Override
    public String convToString(Object obj) {
        return this.convToString(obj, new ToStringOption());
    }

    @Override
    public String convToString(Object obj, ToStringOption option) {
        DynamicObject dataEntity = (DynamicObject)obj;
        DynamicObjectType mainType = dataEntity.getDynamicObjectType();
        StringBuilder buf = new StringBuilder();
        this.writeObject(dataEntity, mainType, 0, option, buf);
        return buf.toString();
    }

    private void writeObject(DynamicObject dataEntity, DynamicObjectType mainType, int callLevel, ToStringOption option, StringBuilder buf) {
        if (buf.length() > option.getMaxLength()) {
            return;
        }
        if (callLevel > 6) {
            return;
        }
        if (!option.addDoingObj(dataEntity)) {
            buf.append("{...}");
            return;
        }
        ++callLevel;
        DynamicObjectType entityType = dataEntity.getDynamicObjectType();
        buf.append(entityType.getName()).append("{");
        buf.append("status=");
        this.writeDataEntityState(dataEntity.getDataEntityState(), buf);
        for (IDataEntityProperty p : entityType.getProperties()) {
            buf.append(", ");
            buf.append(p.getName()).append("=");
            Object value = p.getValueFast((Object)dataEntity);
            if (p instanceof ISimpleProperty) {
                this.writeSimpleProperty(p, value, mainType, option, buf);
                continue;
            }
            if (p instanceof IComplexProperty) {
                IComplexProperty cmp = (IComplexProperty)p;
                if (value instanceof DynamicObject) {
                    buf.append(((DynamicObject)value).getPkValue());
                    continue;
                }
                buf.append(String.valueOf(value));
                continue;
            }
            if (!(p instanceof ICollectionProperty)) continue;
            if (value instanceof DynamicObjectCollection) {
                this.writeCollectionProperty((DynamicObjectCollection)value, mainType, callLevel, option, buf);
                continue;
            }
            buf.append(String.valueOf(value));
        }
        option.removeDoingObj(dataEntity);
        buf.append("}");
    }

    private void writeDataEntityState(DataEntityState state, StringBuilder buf) {
        Map entryInfos;
        PkSnapshotSet pksnapshots;
        buf.append("{");
        boolean isfromdb = state.getFromDatabase();
        buf.append("fromdb").append("=").append(String.valueOf(isfromdb)).append(", ");
        buf.append("bizchanged").append("=").append(BitSet.valueOf(state.getBizChangeFlags())).append(", ");
        buf.append("dirty").append("=").append(BitSet.valueOf(state.getDirtyFlags())).append(", ");
        if (state.getRemovedItems().booleanValue()) {
            buf.append("removeitems").append("=").append(String.valueOf(state.getRemovedItems())).append(", ");
        }
        if ((pksnapshots = state.getPkSnapshotSet()) != null && !pksnapshots.Snapshots.isEmpty()) {
            HashMap<String, Object[]> mapPk = new HashMap<String, Object[]>(pksnapshots.Snapshots.size());
            for (PkSnapshot pk : pksnapshots.Snapshots) {
                if (pk.Opids == null) {
                    mapPk.put(pk.TableName, new Object[]{pk.Oids});
                    continue;
                }
                mapPk.put(pk.TableName, new Object[]{pk.Oids, pk.Opids});
            }
            buf.append("pksnapshot").append("=").append(SerializationUtils.toJsonString(mapPk)).append(", ");
        }
        if ((entryInfos = state.getEntryInfos()) != null) {
            buf.append("entryinfos").append("=").append(SerializationUtils.toJsonString((Object)entryInfos)).append(", ");
        }
        buf.setLength(buf.length() - 2);
        buf.append("}");
    }

    private void writeCollectionProperty(DynamicObjectCollection rows, DynamicObjectType mainType, int callLevel, ToStringOption option, StringBuilder buf) {
        ++callLevel;
        buf.append("[");
        if (!rows.isEmpty()) {
            for (DynamicObject row : rows) {
                this.writeObject(row, mainType, callLevel, option, buf);
                buf.append(", ");
            }
            buf.setLength(buf.length() - 2);
        }
        buf.append("]");
    }

    private void writeSimpleProperty(IDataEntityProperty p, Object value, DynamicObjectType mainType, ToStringOption option, StringBuilder buf) {
        String ret = null;
        if (this.isShowField((IDataEntityType)mainType, p, option)) {
            if (p instanceof ILocaleProperty) {
                ret = (String)((ILocaleString)value).getItem("GLang");
            } else if (value instanceof BigDecimal) {
                ret = ((BigDecimal)value).toPlainString();
            } else if (value instanceof Date) {
                ret = this.simpleDateFormat.format((Date)value);
            }
            ret = String.valueOf(value);
        } else {
            ret = "***";
        }
        if (ret != null && ret.length() > 50) {
            buf.append(ret.substring(0, 50));
        } else {
            buf.append(ret);
        }
    }

    private boolean isShowField(IDataEntityType mainType, IDataEntityProperty prop, ToStringOption option) {
        if (option.isShowEncryptField()) {
            return true;
        }
        if (prop instanceof AmountProp || prop instanceof QtyProp || prop instanceof PriceProp) {
            return false;
        }
        if (!(prop instanceof DynamicSimpleProperty)) {
            return true;
        }
        DynamicSimpleProperty simpleProperty = (DynamicSimpleProperty)prop;
        if (simpleProperty.isEncrypt()) {
            return false;
        }
        return !PrivacyCenterServiceHelper.isEncryptField((IDataEntityProperty)prop);
    }
}

