/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.trace.tagval;

import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.entity.trace.tagval.TagToString;

class EntityTypeToString
implements TagToString {
    EntityTypeToString() {
    }

    @Override
    public String convToString(Object obj) {
        IDataEntityType type = (IDataEntityType)obj;
        return this.buildType(type);
    }

    private String buildType(IDataEntityType type) {
        StringBuilder sb = new StringBuilder();
        sb.append(type.getName()).append("[");
        int count = 0;
        for (IDataEntityProperty prop : type.getProperties()) {
            if (count > 0) {
                sb.append(", ");
            }
            if (prop instanceof IComplexProperty) {
                sb.append(this.buildComplexProp((IComplexProperty)prop));
            } else if (prop instanceof ICollectionProperty) {
                sb.append(this.buildCollectionProp((ICollectionProperty)prop));
            } else {
                sb.append(this.buildSimpleProp((ISimpleProperty)prop));
            }
            ++count;
        }
        sb.append("]");
        return sb.toString();
    }

    private String buildSimpleProp(ISimpleProperty prop) {
        return String.format("{%s,%s}", prop.getOrdinal(), prop.getName());
    }

    private String buildComplexProp(IComplexProperty prop) {
        StringBuilder sb = new StringBuilder();
        sb.append("{").append(prop.getOrdinal()).append(",");
        sb.append(prop.getName()).append(",");
        IDataEntityType dType = prop.getComplexType();
        if (dType != null) {
            sb.append(dType.getExtendName());
        }
        sb.append("}");
        return sb.toString();
    }

    private String buildCollectionProp(ICollectionProperty prop) {
        StringBuilder sb = new StringBuilder();
        sb.append("{").append(prop.getOrdinal()).append(", ");
        sb.append(prop.getClass().getSimpleName()).append(", ");
        sb.append(prop.getName()).append(", ");
        IDataEntityType dType = prop.getItemType();
        if (dType != null) {
            sb.append(this.buildType(dType));
        }
        sb.append("}");
        return sb.toString();
    }
}

