/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.trace.writer;

import kd.bos.dataentity.trace.EntityTraceSpanInfo;
import kd.bos.dataentity.trace.EntityTraceWriter;
import kd.bos.entity.trace.writer.AbstractEntityTraceWriter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

class EntityTraceWriteLog
extends AbstractEntityTraceWriter {
    private static Log log = LogFactory.getLog(EntityTraceWriteLog.class);
    private static final int MAX_MESSAGE_LENGTH = 50000;

    EntityTraceWriteLog() {
    }

    public void write(EntityTraceSpanInfo span, String message, EntityTraceWriter.InfoLevel level) {
        if (!this.isWriteLevel(level)) {
            return;
        }
        String msg = message;
        if (message.length() > 50000) {
            msg = message.substring(0, 49997) + "...";
        }
        switch (level) {
            case DETAIL: {
                log.info(msg);
                break;
            }
            case INFO: {
                log.info(msg);
                break;
            }
            case IMPORTANT: {
                log.info(msg);
                break;
            }
            case WARN: {
                log.warn(msg);
                break;
            }
            case ERROR: {
                log.error(msg);
                break;
            }
            default: {
                log.info(msg);
            }
        }
    }

    private boolean isWriteLevel(EntityTraceWriter.InfoLevel level) {
        return level.getValue() >= EntityTraceWriter.InfoLevel.IMPORTANT.getValue();
    }
}

