/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.upgrade.plugin.upgradeservice;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class AppRuntimeUpgradeService
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(AppRuntimeUpgradeService.class);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        List<String> appNumberList = this.getNotRuntimeAppNumbers();
        StringBuilder logMsg = new StringBuilder();
        for (String appNumber : appNumberList) {
            if (!StringUtils.isNotBlank((CharSequence)appNumber)) continue;
            this.addLog(logMsg, "'" + appNumber + "' build: ");
            try {
                MetadataDao.rebuildRuntimeAppMetaByNumber((String)appNumber);
                this.addLog(logMsg, "success.");
            }
            catch (Exception e) {
                log.error(appNumber + " build error:" + e.getMessage());
                this.addLog(logMsg, "failed.");
            }
        }
        result.setLog(logMsg.toString());
        return result;
    }

    private List<String> getNotRuntimeAppNumbers() {
        return (List)DB.query((DBRoute)DBRoute.meta, (String)"select FNUMBER from T_META_BIZAPP WHERE FVISIBLE <> '1' OR FDEPLOYSTATUS <> '2'", rs -> {
            ArrayList<String> appNumbers = new ArrayList<String>(16);
            while (rs.next()) {
                appNumbers.add(rs.getString(1));
            }
            return appNumbers;
        });
    }

    private void addLog(StringBuilder logMsg, String msg) {
        if (logMsg.length() < 500) {
            logMsg.append(msg);
        }
    }
}

