/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cloudmetric.alarm;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.cloudmetric_plugin.meta.AlarmState;
import kd.bos.cloudmetric_plugin.meta.ComparisonOperator;
import kd.bos.cloudmetric_plugin.meta.Statistic;
import kd.bos.cloudmetric_plugin.meta.Unit;
import kd.bos.cloudmetric_plugin.utils.GetUrl;
import kd.bos.cloudmetric_plugin.utils.SeparateStringUtil;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.util.HttpUtils;

public class CloudAlarmAdd
extends AbstractFormPlugin {
    private static final Object LocaleString = null;

    public void initialize() {
        this.addClickListeners(new String[]{"btnaddalarm", "btnback"});
        TextEdit edt = (TextEdit)this.getView().getControl("category");
        edt.addButtonClickListener((ClickListener)this);
        TextEdit edt1 = (TextEdit)this.getView().getControl("groupbydimensions");
        edt1.addButtonClickListener((ClickListener)this);
        TextEdit edt2 = (TextEdit)this.getView().getControl("metricname");
        edt2.addButtonClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        if ("btnaddalarm".equalsIgnoreCase(c.getKey())) {
            this.addAlarm();
        } else if ("btnback".equalsIgnoreCase(c.getKey())) {
            this.cancelAddAction();
        } else if ("category".equalsIgnoreCase(c.getKey())) {
            this.selectCategory();
        } else if ("groupbydimensions".equalsIgnoreCase(c.getKey())) {
            this.selectDimensions();
        } else if ("metricname".equalsIgnoreCase(c.getKey())) {
            this.selectMetric();
        }
    }

    private void addAlarm() {
        if (this.getModel().getValue("name").equals(" ") || this.getModel().getValue("category").equals(" ") || this.getModel().getValue("metricname").equals(" ")) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"CloudAlarmAdd_0", (String)"bos-cloudmetric-plugin", (Object[])new Object[0]));
        } else {
            String name = this.getModel().getValue("name").toString();
            String category = this.getModel().getValue("category").toString();
            String metricName = this.getModel().getValue("metricname").toString();
            String description = this.getModel().getValue("description").toString();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Timestamp now = new Timestamp(System.currentTimeMillis());
            String stateUpdatedTimestamp = df.format(now);
            String groupbydimensionStr = this.getModel().getValue("groupbydimensions").toString();
            String groupByDimensions = SeparateStringUtil.separateToJsonString(groupbydimensionStr);
            String dimensionfilterStr = this.getModel().getValue("dimensionfilters").toString();
            String dimensionFilters = SeparateStringUtil.separateJsonStringMap(dimensionfilterStr);
            String statisticStr = this.getModel().getValue("statistic").toString();
            Statistic statistic = Statistic.Count;
            if (statisticStr.equals("Count")) {
                statistic = Statistic.Count;
            } else if (statisticStr.equals("Average")) {
                statistic = Statistic.Average;
            } else if (statisticStr.equals("Max")) {
                statistic = Statistic.Max;
            } else if (statisticStr.equals("Min")) {
                statistic = Statistic.Min;
            } else if (statisticStr.equals("Sum")) {
                statistic = Statistic.Sum;
            }
            AlarmState state = AlarmState.INSUFFICIENT_DATA;
            String comparisonoperatorStr = this.getModel().getValue("comparisonoperator").toString();
            ComparisonOperator comparisonOperator = ComparisonOperator.GE;
            if (comparisonoperatorStr.equals("GE")) {
                comparisonOperator = ComparisonOperator.GE;
            } else if (comparisonoperatorStr.equals("GT")) {
                comparisonOperator = ComparisonOperator.GT;
            } else if (comparisonoperatorStr.equals("LE")) {
                comparisonOperator = ComparisonOperator.LE;
            } else if (comparisonoperatorStr.equals("LT")) {
                comparisonOperator = ComparisonOperator.LT;
            }
            String unitStr = this.getModel().getValue("unit").toString();
            Unit unit = Unit.Percent;
            if (unitStr.equals("Percent")) {
                unit = Unit.Percent;
            } else if (unitStr.equals("Count")) {
                unit = Unit.Count;
            } else if (unitStr.equals("Megabytes")) {
                unit = Unit.Megabytes;
            } else if (unitStr.equals("Seconds")) {
                unit = Unit.Seconds;
            }
            String actionenabledStr = this.getModel().getValue("actionenabled").toString();
            boolean actionEnabled = true;
            if (actionenabledStr.equals("true")) {
                actionEnabled = true;
            } else if (actionenabledStr.equals("false")) {
                actionEnabled = false;
            }
            String periodStr = this.getModel().getValue("period").toString();
            int period = Integer.parseInt(periodStr);
            String evaluationPeriodsStr = this.getModel().getValue("evaluationperiods").toString();
            int evaluationPeriods = Integer.parseInt(evaluationPeriodsStr);
            String thresholdStr = this.getModel().getValue("threshold").toString();
            double threshold = Double.parseDouble(thresholdStr);
            HashMap<String, String> date = new HashMap<String, String>();
            date.put("name", name);
            date.put("description", description);
            date.put("category", category);
            date.put("metricName", metricName);
            date.put("stateUpdatedTimestamp", stateUpdatedTimestamp);
            date.put("groupByDimensions", groupbydimensionStr);
            date.put("dimensionFilters", dimensionfilterStr);
            date.put("statistic", statisticStr);
            date.put("state", "INSUFFICIENT_DATA");
            date.put("comparisonOperator", comparisonoperatorStr);
            date.put("unit", unitStr);
            date.put("actionEnabled", actionenabledStr);
            date.put("period", periodStr);
            date.put("evaluationPeriods", evaluationPeriodsStr);
            date.put("threshold", thresholdStr);
            String url = GetUrl.getUrl() + "/api/addAlarm";
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("content-type", "application/json");
            String argument = "{\"name\":\"" + name + "\",\"category\":\"" + category + "\",\"metricName\":\"" + metricName + "\",\"state\":\"" + (Object)((Object)state) + "\",\"description\":\"" + description + "\",\"dimensionFilters\":{" + dimensionFilters + "},\"groupByDimensions\":[" + groupByDimensions + "],\"period\":" + period + ",\"evaluationPeriods\":" + evaluationPeriods + ",\"statistic\":\"" + (Object)((Object)statistic) + "\",\"comparisonOperator\":\"" + (Object)((Object)comparisonOperator) + "\",\"threshold\":" + threshold + ",\"unit\":\"" + (Object)((Object)unit) + "\",\"actionEnabled\":\"" + actionEnabled + "\",\"stateUpdatedTimestamp\":\"" + stateUpdatedTimestamp + "\"}";
            String jsonResult = HttpUtils.post((String)url, header, (String)argument);
            Map result = (Map)SerializationUtils.fromJsonString((String)jsonResult, Map.class);
            if (result.get("state").toString().equals("success")) {
                this.getView().returnDataToParent(date);
                this.getView().showMessage(ResManager.loadKDString((String)"\u6dfb\u52a0\u6570\u636e\u6210\u529f\uff01", (String)"CloudAlarmAdd_1", (String)"bos-cloudmetric-plugin", (Object[])new Object[0]));
                this.getView().close();
            } else if (result.get("state").toString().equals("error")) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8be5\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u6dfb\u52a0", (String)"CloudAlarmAdd_2", (String)"bos-cloudmetric-plugin", (Object[])new Object[0]));
            } else {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6dfb\u52a0\u5931\u8d25", (String)"CloudAlarmAdd_3", (String)"bos-cloudmetric-plugin", (Object[])new Object[0]));
            }
        }
    }

    public void cancelAddAction() {
        this.getView().close();
    }

    private void selectCategory() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cloud_category_choose");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "selectCategory");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void selectDimensions() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cloud_dimension_select");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "selectDimensions");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void selectMetric() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cloud_metric_select");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "selectMetric");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Map date;
        if ("selectCategory".equals(e.getActionId())) {
            Map date2 = (Map)e.getReturnData();
            if (date2 != null) {
                IDataModel model = this.getModel();
                model.setValue("category", date2.get("categoryname"));
            }
        } else if ("selectDimensions".equals(e.getActionId())) {
            Map date3 = (Map)e.getReturnData();
            if (date3 != null) {
                IDataModel model = this.getModel();
                model.setValue("groupbydimensions", date3.get("dimensions"));
            }
        } else if ("selectMetric".equals(e.getActionId()) && (date = (Map)e.getReturnData()) != null) {
            IDataModel model = this.getModel();
            model.setValue("metricname", date.get("metricname"));
        }
    }
}

