/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cloudmetric_plugin.meta;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.cloudmetric_plugin.meta.Action;
import kd.bos.cloudmetric_plugin.meta.AlarmState;
import kd.bos.cloudmetric_plugin.meta.ComparisonOperator;
import kd.bos.cloudmetric_plugin.meta.Statistic;
import kd.bos.cloudmetric_plugin.meta.Unit;

public class Alarm {
    private String name;
    private String description;
    private String category;
    private String metricName;
    private Map<String, String> dimensionFilters;
    private String[] groupByDimensions;
    private int period;
    private int evaluationPeriods;
    private Statistic statistic;
    private ComparisonOperator comparisonOperator;
    private double threshold;
    private Unit unit;
    private boolean actionEnabled = true;
    private AlarmState state;
    private String stateUpdatedTimestamp;
    private List<Action> alarmActions = new ArrayList<Action>();
    private List<Action> okActions = new ArrayList<Action>();
    private List<Action> insufficentDataActions = new ArrayList<Action>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public int getEvaluationPeriods() {
        return this.evaluationPeriods;
    }

    public void setEvaluationPeriods(int evaluationPeriods) {
        this.evaluationPeriods = evaluationPeriods;
    }

    public Statistic getStatistic() {
        return this.statistic;
    }

    public void setStatistic(Statistic statistic) {
        this.statistic = statistic;
    }

    public ComparisonOperator getComparisonOperator() {
        return this.comparisonOperator;
    }

    public void setComparisonOperator(ComparisonOperator comparisonOperator) {
        this.comparisonOperator = comparisonOperator;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public boolean isActionEnabled() {
        return this.actionEnabled;
    }

    public void setActionEnabled(boolean actionEnabled) {
        this.actionEnabled = actionEnabled;
    }

    public AlarmState getState() {
        return this.state;
    }

    public void setState(AlarmState state) {
        this.state = state;
    }

    public String getStateUpdatedTimestamp() {
        return this.stateUpdatedTimestamp;
    }

    public void setStateUpdatedTimestamp(String stateUpdatedTimestamp) {
        this.stateUpdatedTimestamp = stateUpdatedTimestamp;
    }

    public List<Action> getAlarmActions() {
        return this.alarmActions;
    }

    public void setAlarmActions(List<Action> alarmActions) {
        this.alarmActions = alarmActions;
    }

    public List<Action> getOkActions() {
        return this.okActions;
    }

    public void setOkActions(List<Action> okActions) {
        this.okActions = okActions;
    }

    public List<Action> getInsufficentDataActions() {
        return this.insufficentDataActions;
    }

    public void setInsufficentDataActions(List<Action> insufficentDataActions) {
        this.insufficentDataActions = insufficentDataActions;
    }

    public Map<String, String> getDimensionFilters() {
        return this.dimensionFilters;
    }

    public void setDimensionFilters(Map<String, String> dimensionFilters) {
        this.dimensionFilters = dimensionFilters;
    }

    public String[] getGroupByDimensions() {
        return this.groupByDimensions;
    }

    public void setGroupByDimensions(String[] groupByDimensions) {
        this.groupByDimensions = groupByDimensions;
    }

    public static List<Action> getActions(Alarm alarm, AlarmState newState) {
        List<Action> actions = null;
        switch (newState) {
            case OK: {
                actions = alarm.getOkActions();
                break;
            }
            case ALARM: {
                actions = alarm.getAlarmActions();
                break;
            }
            default: {
                actions = alarm.getInsufficentDataActions();
            }
        }
        return actions;
    }
}

