/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.privacy.plugin;

import kd.bos.bill.OperationStatus;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.privacy.plugin.PrivacyPluginUtil;

public class DataSecurityLabelListPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(DataSecurityLabelListPlugin.class);

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        Object pkId;
        LicenseCheckResult checkResult = PrivacyPluginUtil.getLicenseCheckResult();
        if (checkResult != null && !checkResult.getHasLicense().booleanValue()) {
            e.getParameter().setStatus(OperationStatus.VIEW);
            logger.debug("no license, only can view");
        }
        if ((pkId = e.getParameter().getPkId()) != null) {
            // empty if block
        }
    }

    public void createNewData(BizDataEventArgs e) {
        LicenseCheckResult checkResult = PrivacyPluginUtil.getLicenseCheckResult();
        if (checkResult != null && !checkResult.getHasLicense().booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btnaddlabel", "btndellabel"});
            logger.debug("no license, button [add,delete] setVisible false ");
        }
    }
}

