/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.privacy.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.jetbrains.annotations.NotNull;

public class DataSecurityLabelPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(DataSecurityLabelPlugin.class);
    private static final String FFEILDS_ENTRY = "ffeildsentry";
    private static final String SCHEME_ENTRY = "t_privacy_scheme_config";
    private static final String BTN_ADD_FIELD = "btnaddfield";
    private static final String BTN_ADD_FIELD_DATA = "btnaddfieldbydata";
    private static final String ADD_FIELD = "addfield";
    private static final String FFIELD_IDENT = "ffield_ident";
    private static final String FENTITY_NUMBER = "fentity_number";
    private static final String FFIELD_DESC = "ffield_desc";
    private static final String BOS_PRIVACY_PLUGIN = "bos-privacy-plugin";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap", "advcontoolbarap"});
        super.registerListener(e);
    }

    public void itemClick(ItemClickEvent evt) {
        switch (evt.getItemKey()) {
            case "btnaddfield": {
                ListShowParameter showParameter = new ListShowParameter();
                showParameter.setBillFormId("privacy_label_fieldselect");
                showParameter.setFormId("privacy_treelistf7");
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ADD_FIELD));
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                StyleCss css = new StyleCss();
                css.setWidth("960px");
                css.setHeight("580px");
                showParameter.getOpenStyle().setInlineStyleCss(css);
                showParameter.setF7Style(0);
                showParameter.setMultiSelect(true);
                showParameter.setShowTitle(false);
                showParameter.setLookUp(true);
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
            case "btnaddfieldbydata": {
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("privacy_cloud_select");
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(formShowParameter);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        StringBuilder errorMsg;
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if ("deleteentry".equals(operate.getOperateKey())) {
            DynamicObject templateid;
            boolean references = this.checkDeleteReferences();
            if (references) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b57\u6bb5\u5df2\u7ecf\u5728\u9690\u79c1\u65b9\u6848\u542f\u7528\u8131\u654f\u6216\u8005\u52a0\u5bc6\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"DataSecurityLabelPlugin_0", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]));
                args.setCancel(true);
            }
            if (!args.isCancel() && (templateid = this.getModel().getDataEntity().getDynamicObject("templateid")) != null) {
                int[] rows;
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)templateid.getPkValue(), (String)"privacy_data_tags_temp");
                ILocaleString fanme = dynamicObject.getLocaleString("fname");
                DynamicObjectCollection dynamicObjects = dynamicObject.getDynamicObjectCollection("t_privacy_data_field_temp");
                HashSet<String> fields = new HashSet<String>(dynamicObjects.size());
                for (DynamicObject dObj : dynamicObjects) {
                    String key = this.getFieldKey(dObj.getString(FFIELD_IDENT), dObj.getString(FENTITY_NUMBER), dObj.getString("fapp_number"));
                    fields.add(key);
                }
                EntryGrid g = (EntryGrid)this.getControl(FFEILDS_ENTRY);
                for (int row : rows = g.getSelectRows()) {
                    String key = this.getFieldKey(String.valueOf(this.getModel().getValue(FFIELD_IDENT, row)), String.valueOf(this.getModel().getValue(FENTITY_NUMBER, row)), String.valueOf(this.getModel().getValue("fapp_number", row)));
                    if (!fields.contains(key)) continue;
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u3010%s\u3011\u4e3a\u6a21\u677f\u9884\u7f6e\u5b57\u6bb5\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"DataSecurityLabelPlugin_3", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]), this.getModel().getValue(FFIELD_DESC, row)));
                    args.setCancel(true);
                    break;
                }
            }
        } else if ("save".equals(operate.getOperateKey()) && StringUtils.isNotBlank((CharSequence)(errorMsg = this.checkRepeatedReference()).toString())) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u91cd\u590d\u5f15\u7528\uff0c\u8bf7\u5220\u9664\u91cd\u590d\u5f15\u7528\u5b57\u6bb5\u3002", (String)"DataSecurityLabelPlugin_1", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]), errorMsg.toString()));
            args.setCancel(true);
        }
    }

    @NotNull
    private String getFieldKey(String ffield_ident, String fentity_number, String fapp_number) {
        return ffield_ident + "&&" + fentity_number + "&&" + fapp_number;
    }

    private StringBuilder checkRepeatedReference() {
        HashSet<String> fieldKeySet = new HashSet<String>();
        HashSet<String> entityNumberSet = new HashSet<String>();
        HashSet<String> fieldSet = new HashSet<String>();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(FFEILDS_ENTRY);
        for (DynamicObject row : entryEntity) {
            String entityNumber = row.getString(FENTITY_NUMBER);
            String fieldKey = row.getString(FFIELD_IDENT);
            fieldKeySet.add(fieldKey);
            entityNumberSet.add(entityNumber);
            fieldSet.add(String.format("%s$%s", entityNumber, fieldKey));
        }
        Object pkId = this.getModel().getDataEntity().getPkValue();
        StringBuilder errorMsg = new StringBuilder();
        QFilter idFilter = new QFilter("id", "!=", pkId);
        idFilter.and(new QFilter("ffeildsentry.ffield_ident", "in", fieldKeySet));
        idFilter.and(new QFilter("ffeildsentry.fentity_number", "in", entityNumberSet));
        QFilter[] filters = new QFilter[]{idFilter};
        HashMap<String, ArrayList<String>> repeatKeys = new HashMap<String, ArrayList<String>>(16);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"DataSecurityLabelPlugin.checkRepeatedReference", (String)"privacy_data_tags", (String)"fnumber,fname,ffeildsentry.fentity_number,ffeildsentry.ffield_ident,ffeildsentry.ffield_desc", (QFilter[])filters, null);){
            while (ds.hasNext()) {
                Row row = ds.next();
                String key = String.format("%s$%s", row.getString("ffeildsentry.fentity_number"), row.getString("ffeildsentry.ffield_ident"));
                if (!fieldSet.contains(key)) continue;
                String number = row.getString("fnumber");
                ArrayList<String> keys = (ArrayList<String>)repeatKeys.get(number);
                if (keys == null) {
                    keys = new ArrayList<String>(10);
                    repeatKeys.put(number, keys);
                }
                keys.add(String.format("[%s %s]", row.get("ffeildsentry.ffield_ident"), row.get("ffeildsentry.ffield_desc")));
            }
        }
        if (!CollectionUtils.isEmpty(repeatKeys)) {
            for (Map.Entry entry : repeatKeys.entrySet()) {
                errorMsg.append(String.format(ResManager.loadKDString((String)"%1$s\u5df2\u7ecf\u88ab\u6807\u7b7e%2$s\u5f15\u7528\uff0c", (String)"DataSecurityLabelPlugin_4", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]), StringUtils.join((Object[])((List)entry.getValue()).toArray(), (String)"/"), entry.getKey()));
            }
        }
        return errorMsg;
    }

    private boolean checkDeleteReferences() {
        Object pkId = this.getModel().getDataEntity().getPkValue();
        if (ObjectUtils.isEmpty((Object)pkId)) {
            return false;
        }
        EntryGrid g = (EntryGrid)this.getControl(FFEILDS_ENTRY);
        int[] rows = g.getSelectRows();
        HashSet<Object> idSet = new HashSet<Object>(rows.length);
        for (int row : rows) {
            idSet.add(this.getModel().getValue("ffeildsentry.id", row));
        }
        String noRuleId = this.loadNoDesensitizationRules();
        QFilter filter = new QFilter("fdatalabelid", "=", pkId);
        QFilter encryptFilter = new QFilter("t_privacy_scheme_encrypt.encryptlabelid", "in", idSet).and(new QFilter("t_privacy_scheme_encrypt.fencrypt_algorithm", "!=", (Object)"NO"));
        QFilter decryptFilter = new QFilter("t_privacy_scheme_desen.denselabelid", "in", idSet).and(new QFilter("t_privacy_scheme_desen.fdesen_rule_basedata", "not in", (Object)new String[]{"NO", "FOLLOW", noRuleId}));
        encryptFilter.or(decryptFilter);
        QFilter[] filters = new QFilter[]{filter, encryptFilter};
        return QueryServiceHelper.exists((String)SCHEME_ENTRY, (QFilter[])filters);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (ADD_FIELD.equalsIgnoreCase(actionId)) {
            List rows = (List)closedCallBackEvent.getReturnData();
            if (rows == null) {
                return;
            }
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(FFEILDS_ENTRY);
            HashSet<String> keySet = new HashSet<String>(10);
            for (DynamicObject dynamicObject : entryEntity) {
                String key = String.format("%s$%s", dynamicObject.get(FENTITY_NUMBER), dynamicObject.get(FFIELD_IDENT));
                keySet.add(key);
            }
            StringBuilder errorMsg = new StringBuilder();
            for (Map row : rows) {
                String key = String.format("%s$%s", row.get(FENTITY_NUMBER), row.get(FFIELD_IDENT));
                if (keySet.contains(key)) {
                    errorMsg.append(String.format("[%s %s]/", row.get(FFIELD_IDENT), row.get(FFIELD_DESC)));
                    continue;
                }
                IDataModel model = this.getModel();
                int rowIndex = this.getModel().createNewEntryRow(FFEILDS_ENTRY);
                model.setValue(FFIELD_IDENT, row.get(FFIELD_IDENT), rowIndex);
                model.setValue("ffield_name", row.get("ffield_name"), rowIndex);
                model.setValue(FFIELD_DESC, row.get(FFIELD_DESC), rowIndex);
                model.setValue("ftable_name", row.get("ftable_name"), rowIndex);
                model.setValue("ffield_type", (Object)DataSecurityLabelPlugin.convertFieldType(row.get("ffield_type").toString()), rowIndex);
                model.setValue("fentity_name", row.get("fentity_name"), rowIndex);
                model.setValue("fapp_name", row.get("fapp_name"), rowIndex);
                model.setValue("fapp_number", row.get("fapp_number"), rowIndex);
                model.setValue("fcloud_name", row.get("fcloud_name"), rowIndex);
                model.setValue("fcloud_number", row.get("fcloud_number"), rowIndex);
                model.setValue(FENTITY_NUMBER, row.get(FENTITY_NUMBER), rowIndex);
                model.setValue("approute", row.get("approute"), rowIndex);
            }
            if (StringUtils.isNotBlank((CharSequence)errorMsg.toString())) {
                errorMsg = errorMsg.deleteCharAt(errorMsg.length() - 1);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u5df2\u7ecf\u88ab\u5f15\u7528\uff0c\u5df2\u5f15\u7528\u5b57\u6bb5\u5c06\u4e0d\u4f1a\u88ab\u91cd\u590d\u5f15\u7528\u3002", (String)"DataSecurityLabelPlugin_2", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]), errorMsg.toString()));
            }
        }
    }

    static Integer convertFieldType(String fieldType) {
        switch (fieldType) {
            case "Date": {
                return 91;
            }
            case "BigDecimal": {
                return 3;
            }
            case "Integer": {
                return 4;
            }
            case "String": {
                return 12;
            }
            case "ILocaleString": {
                return 1112;
            }
            case "DynamicObject": {
                return 1111;
            }
            case "Long": {
                return -5;
            }
        }
        return 12;
    }

    private String loadNoDesensitizationRules() {
        String sql = "SELECT fid,fnumber FROM T_PRIVACY_DESEN_RULES where fnumber = 'NO'";
        try (DataSet dataSet = DB.queryDataSet((String)"DataSecurityLabelPlugin.loadDesensitizationRules", (DBRoute)DBRoute.of((String)"sys"), (String)sql);){
            if (dataSet.hasNext()) {
                Row data = dataSet.next();
                String string = data.getString("fid");
                return string;
            }
            String string = "NO";
            return string;
        }
    }
}

