/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.privacy.plugin;

import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.privacy.DesensitizeStrategyFactory;
import kd.bos.servicehelper.ISVServiceHelper;

public class PrivacyDesensitizationRulesPlugin
extends AbstractBillPlugIn {
    private static final Log log = LogFactory.getLog((String)"PrivacyDesensitizationRulesPlugin");
    private static final String BOS_PRIVACY_PLUGIN = "bos-privacy-plugin";

    public void registerListener(EventObject e) {
        Label quick = (Label)this.getControl("configuration");
        quick.addClickListener((ClickListener)this);
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        if ("save".equals(operate.getOperateKey())) {
            String isv = ISVServiceHelper.getISVInfo().getId();
            this.getModel().setValue("isv", (Object)isv);
        } else if (StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"simulated")) {
            Object matchRules = this.getModel().getValue("matchrules");
            Object replacement = this.getModel().getValue("replacement");
            if (matchRules == null || replacement == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5339\u914d\u89c4\u5219\u4e0e\u66ff\u6362\u89c4\u5219\u5b57\u6bb5\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u7ef4\u62a4\u3002", (String)"PrivacyDesensitizationRulesPlugin_2", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("priavcy_simulated_operate");
            showParameter.setCustomParam("matchrules", matchRules);
            showParameter.setCustomParam("replacement", replacement);
            showParameter.setCustomParam("strategy", this.getModel().getDataEntity().getPkValue());
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        if ("save".equals(afterDoOperationEventArgs.getOperateKey())) {
            DesensitizeStrategyFactory.reload();
        }
    }

    public void afterBindData(EventObject e) {
        Object isv;
        String currentIsv;
        Object preset = this.getModel().getValue("preset");
        if (((Boolean)preset).booleanValue() && !(currentIsv = ISVServiceHelper.getISVInfo().getId()).equals(isv = this.getModel().getValue("isv"))) {
            ((IBillView)this.getView()).setBillStatus(BillOperationStatus.VIEW);
            this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
            log.info("kd.bos.privacy.plugin.PrivacyDesensitizationRulesPlugin.afterBindData, isv:{}, currentIsv:{}", isv, (Object)currentIsv);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u5f53\u524d\u5f00\u53d1\u5546\u9884\u7f6e\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u7f16\u8f91\u3002", (String)"PrivacyDesensitizationRulesPlugin_1", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]));
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)"configuration", (CharSequence)key)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("privacy_quick_config");
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "quickConfig"));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId = event.getActionId();
        if (StringUtils.equals((CharSequence)"quickConfig", (CharSequence)actionId)) {
            Map rows = (Map)event.getReturnData();
            if (CollectionUtils.isEmpty((Map)rows)) {
                return;
            }
            this.getModel().setValue("matchrules", rows.get("matchrules"));
            this.getModel().setValue("replacement", rows.get("replacement"));
        }
    }
}

