/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.privacy.plugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.plugin.logbill.ESDataProvider;
import kd.bos.form.plugin.logbill.LogBillListPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.time.DateUtils;

public class PrivacyDesensitizeLogListPlugin
extends LogBillListPlugin {
    private static final String ENTITY_NUMBER = "entitynumber";
    private static final String FIELD_IDENT = "fieldident";
    private static final String OPERATOR_DATE = "opdate";
    private static Map<String, Object> totalLimitMap = new HashMap<String, Object>();

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new PrivacySchemeListDataProvider(this.getView()));
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        if (e.getOperateKey().equals("showdetaillog")) {
            ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"privacy_desen_detaillog", (boolean)false);
            BillList billList = (BillList)this.getControl("billlistap");
            Object focusRowPkId = billList.getFocusRowPkId();
            DynamicObject row = BusinessDataServiceHelper.loadSingleFromCache((Object)focusRowPkId, (String)billList.getEntityId());
            ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
            filters.add(new QFilter(ENTITY_NUMBER, "=", (Object)row.getString(ENTITY_NUMBER)));
            filters.add(new QFilter(FIELD_IDENT, "=", (Object)row.getString(FIELD_IDENT)));
            filters.add(new QFilter(OPERATOR_DATE, ">=", (Object)row.getDate(OPERATOR_DATE)));
            filters.add(new QFilter(OPERATOR_DATE, "<", (Object)DateUtils.addDays((Date)row.getDate(OPERATOR_DATE), (int)1)));
            showParameter.getListFilterParameter().getQFilters().addAll(filters);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void packageData(PackageDataEvent e) {
        DynamicObject row = e.getRowData();
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        if ("limitcount".equalsIgnoreCase(columnDesc.getFieldKey())) {
            String key = String.format("%s:%s", row.getString(ENTITY_NUMBER), row.getString(FIELD_IDENT));
            e.setFormatValue(totalLimitMap.getOrDefault(key, Character.valueOf('-')));
        }
        super.packageData(e);
    }

    static class PrivacySchemeListDataProvider
    extends ESDataProvider {
        public PrivacySchemeListDataProvider(IFormView formView) {
            super(formView);
        }

        public DynamicObjectCollection getData(int start, int end) {
            DynamicObjectCollection rows = super.getData(start, end);
            if (rows.isEmpty()) {
                return rows;
            }
            HashSet<Long> schemeIdSet = new HashSet<Long>(rows.size());
            for (DynamicObject row : rows) {
                schemeIdSet.add(row.getLong("schemeid"));
            }
            if (CollectionUtils.isEmpty(schemeIdSet)) {
                return rows;
            }
            QFilter[] filters = new QFilter[]{new QFilter("id", "in", schemeIdSet)};
            DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"t_privacy_scheme_config", (String)"id,decryptioncontrol.decryptionentitynumber,decryptioncontrol.decryptionfieldident,decryptioncontrol.dailylimit", (QFilter[])filters);
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                String entityNumber = dynamicObject.getString("decryptioncontrol.decryptionentitynumber");
                String fieldIdent = dynamicObject.getString("decryptioncontrol.decryptionfieldident");
                String key = String.format("%s:%s", entityNumber, fieldIdent);
                totalLimitMap.put(key, dynamicObject.get("decryptioncontrol.dailylimit"));
            }
            return rows;
        }
    }
}

