/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.privacy.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlParameter;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueTextItem;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.list.F7SelectedList;
import kd.bos.list.events.F7SelectedListRemoveEvent;
import kd.bos.list.events.F7SelectedListRemoveListener;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.AddressField;
import kd.bos.metadata.entity.businessfield.AmountField;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.CityField;
import kd.bos.metadata.entity.businessfield.CurrencyField;
import kd.bos.metadata.entity.businessfield.MaterielField;
import kd.bos.metadata.entity.businessfield.NameField;
import kd.bos.metadata.entity.businessfield.OrgField;
import kd.bos.metadata.entity.businessfield.QtyField;
import kd.bos.metadata.entity.businessfield.UnitField;
import kd.bos.metadata.entity.businessfield.UserField;
import kd.bos.metadata.entity.commonfield.BigIntField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.DateTimeField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.EmailField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IntegerField;
import kd.bos.metadata.entity.commonfield.TelephoneField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.entity.commonfield.TimeField;
import kd.bos.mservice.svc.picture.IPictureField;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.privacy.plugin.SelectItemInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;

public class PrivacyFieldSelectorPlugin
extends AbstractTreeListPlugin
implements TreeNodeClickListener,
ClickListener,
RowClickEventListener,
F7SelectedListRemoveListener {
    private static final String KEY_APP_TREE = "treeview";
    private static final String FORM_NODE = "formNode";
    private static final String ENTRYENTITY_MAIN = "entryentity_main";
    private static final String TREE_CACHE = "fieldselect_tree_cache";
    private static final String BOS_PRIVACY_PLUGIN = "bos-privacy-plugin";
    private static final String F7_SELECTED_LIST_AP = "f7selectedlistap";

    public void initialize() {
        AbstractGrid grid;
        super.initialize();
        this.addClickListeners(new String[]{"btnok"});
        TreeView treeView = (TreeView)this.getView().getControl(KEY_APP_TREE);
        if (null != treeView) {
            treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        }
        if (null != (grid = (AbstractGrid)this.getView().getControl(ENTRYENTITY_MAIN))) {
            grid.addRowClickListener((RowClickEventListener)this);
        }
        F7SelectedList f7SelectedList = (F7SelectedList)this.getView().getControl(F7_SELECTED_LIST_AP);
        f7SelectedList.addF7SelectedListRemoveListener((F7SelectedListRemoveListener)this);
        f7SelectedList.addF7SelectedListRemoveAllListener((F7SelectedListRemoveListener)this);
    }

    public void click(EventObject evt) {
        String key;
        Control contrl = (Control)evt.getSource();
        switch (key = contrl.getKey()) {
            case "btnok": {
                this.returnData();
            }
        }
    }

    public void RemoveClick(F7SelectedListRemoveEvent event) {
        Object param = event.getParam();
        if (event.getParam() == null) {
            this.getPageCache().put(F7_SELECTED_LIST_AP, null);
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY_MAIN);
            entryGrid.selectRows(-1);
        } else {
            this.removeF7SelectListRow(param);
        }
    }

    private void returnData() {
        String selStr = this.getPageCache().get(F7_SELECTED_LIST_AP);
        if (StringUtils.isEmpty((CharSequence)selStr) || selStr.equals("{}")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b57\u6bb5!", (String)"PrivacyFieldSelectorPlugin_0", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]));
        } else {
            Map listValue = (Map)SerializationUtils.fromJsonString((String)selStr, Map.class);
            this.getView().returnDataToParent((Object)listValue);
            this.getView().close();
        }
    }

    private Integer convertFieldType(String fieldType) {
        switch (fieldType) {
            case "Date": {
                return 91;
            }
            case "BigDecimal": {
                return 3;
            }
            case "Integer": {
                return 4;
            }
            case "String": {
                return 12;
            }
            case "ILocaleString": {
                return 1112;
            }
            case "DynamicObject": {
                return 1111;
            }
            case "Long": {
                return -5;
            }
        }
        return 12;
    }

    public void entryRowClick(RowClickEvent evt) {
        Map<String, Object> subList;
        String treeStr = this.getPageCache().get(TREE_CACHE);
        TreeView treeView = (TreeView)this.getView().getControl(KEY_APP_TREE);
        Map focusNode = treeView.getTreeState().getFocusNode();
        if (StringUtils.isEmpty((CharSequence)treeStr) || treeStr.equals("{}") || focusNode == null) {
            return;
        }
        String focusNodeId = focusNode.get("id").toString();
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)treeStr, TreeNode.class);
        TreeNode entityNode = root.getTreeNode(focusNodeId);
        String entityNumber = entityNode.getId();
        String selStr = this.getPageCache().get(F7_SELECTED_LIST_AP);
        this.getModel().getDataEntity(true);
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRYENTITY_MAIN);
        int[] selRows = grid.getEntryState().getSelectedRows();
        HashMap<String, SelectItemInfo> entryList = new HashMap<String, SelectItemInfo>(selRows.length);
        for (int i : selRows) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY_MAIN);
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
            String field_type = ((DynamicObject)entryEntity.get(i)).getString("field_type");
            String appNumber = dynamicObject.getString("app_number");
            SelectItemInfo itemInfo = new SelectItemInfo();
            itemInfo.setCloudName(dynamicObject.getString("cloud_name"));
            itemInfo.setCloudNumber(dynamicObject.getString("cloud_number"));
            itemInfo.setAppName(dynamicObject.getString("field_app"));
            itemInfo.setAppNumber(appNumber);
            itemInfo.setEntityName(dynamicObject.getString("field_entity"));
            itemInfo.setEntityNumber(entityNumber);
            itemInfo.setFieldName(dynamicObject.getString("field_name"));
            itemInfo.setTableName(dynamicObject.getString("table_name"));
            itemInfo.setFieldNumber(dynamicObject.getString("field_ident"));
            itemInfo.setFieldDesc(dynamicObject.getString("field_desc"));
            itemInfo.setFieldType(this.convertFieldType(field_type));
            itemInfo.setAppRoute(this.getDBRouteById(appNumber));
            entryList.put(itemInfo.getKey(), itemInfo);
        }
        Map<String, Map<String, Object>> listValue = new HashMap<String, Map<String, Object>>(10);
        F7SelectedList f7SelectedList = (F7SelectedList)this.getControl(F7_SELECTED_LIST_AP);
        if (!StringUtils.isEmpty((CharSequence)selStr) && !selStr.equals("{}") && (subList = (listValue = (Map)SerializationUtils.fromJsonString((String)selStr, Map.class)).get(entityNumber)) != null) {
            subList.clear();
        }
        listValue.put(entityNumber, entryList);
        f7SelectedList.addItems(this.buildF7Items(listValue));
        this.getPageCache().put(F7_SELECTED_LIST_AP, SerializationUtils.toJsonString(listValue));
        this.getView().updateView(F7_SELECTED_LIST_AP);
    }

    private List<ValueTextItem> buildF7Items(Map<String, Map<String, Object>> listValue) {
        ArrayList<ValueTextItem> result = new ArrayList<ValueTextItem>();
        for (Map.Entry<String, Map<String, Object>> entry : listValue.entrySet()) {
            for (Map.Entry<String, Object> subEntry : entry.getValue().entrySet()) {
                ValueTextItem vt;
                if (subEntry.getValue() instanceof SelectItemInfo) {
                    SelectItemInfo item = (SelectItemInfo)subEntry.getValue();
                    vt = new ValueTextItem(subEntry.getKey(), item.getShowKey());
                    result.add(vt);
                    continue;
                }
                if (!(subEntry.getValue() instanceof Map)) continue;
                Map sub = (Map)subEntry.getValue();
                vt = new ValueTextItem(subEntry.getKey(), (String)sub.get("showKey"));
                result.add(vt);
            }
        }
        return result;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initAppTree();
    }

    private void initAppTree() {
        TreeView treeView = (TreeView)this.getView().getControl(KEY_APP_TREE);
        TreeNode root = this.buildRootNode();
        treeView.addNode(root);
        treeView.setRootVisible(true);
        this.getPageCache().put(TREE_CACHE, SerializationUtils.toJsonString((Object)root));
    }

    private TreeNode buildRootNode() {
        TreeNode root = this.getCloudAndAppTree();
        if (root != null) {
            root.setId("8609760E-EF83-4775-A9FF-CCDEC7C0B689");
            root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"PrivacyFieldSelectorPlugin_1", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]));
            root.setParentid("");
            root.setIsOpened(true);
            List<TreeNode> formNodes = this.getFormData();
            this.buildNode(root, formNodes);
        }
        return root;
    }

    private TreeNode getCloudAndAppTree() {
        TreeNode treeRoot = (TreeNode)BizAppServiceHelp.getSubsysTree(null, null, null, (String)"app", (boolean)true, (boolean)false, (boolean)false);
        return treeRoot;
    }

    private void getLeafNodes(Map<String, TreeNode> map, TreeNode node) {
        if (node.getChildren() != null) {
            for (TreeNode childNode : node.getChildren()) {
                this.getLeafNodes(map, childNode);
            }
        } else {
            map.put(node.getId(), node);
        }
    }

    private TreeNode buildNode(TreeNode pnode, List<TreeNode> childNode) {
        HashMap<String, TreeNode> leafNodeMap = new HashMap<String, TreeNode>();
        this.getLeafNodes(leafNodeMap, pnode);
        for (int i = 0; i < childNode.size(); ++i) {
            TreeNode cnode = childNode.get(i);
            String parentID = cnode.getParentid();
            TreeNode parNode = (TreeNode)leafNodeMap.get(parentID);
            if (parNode == null) continue;
            int seq = 0;
            if (parNode.getChildren() != null) {
                seq = parNode.getChildren().size();
            }
            parNode.addChild(seq, cnode);
        }
        this.clearNoParamNode(pnode, null);
        this.clearNoParamNode(pnode, null);
        return pnode;
    }

    private void clearNoParamNode(TreeNode curNode, TreeNode parentNode) {
        if (curNode.getChildren() != null && !curNode.getChildren().isEmpty()) {
            ArrayList lstNodes = new ArrayList();
            lstNodes.addAll(curNode.getChildren());
            for (TreeNode childNode : lstNodes) {
                this.clearNoParamNode(childNode, curNode);
            }
        } else {
            String stype;
            if (parentNode == null) {
                return;
            }
            Object type = curNode.getData();
            if (type != null && ((stype = (String)type).equalsIgnoreCase("cloud") || stype.equalsIgnoreCase("app"))) {
                parentNode.deleteChildNode(curNode.getId());
            }
        }
    }

    private List<TreeNode> getFormData() {
        String sql = "select t.FID, t.FBIZAPPID, tl.FNAME, tp.fmasterid from T_META_MAINENTITYINFO as t left join T_META_MAINENTITYINFO_L as tl on t.FID=tl.FID left join t_meta_bizapp as tp on t.fbizappid = tp.fid left join t_meta_entity as te on t.fid = te.fnumber where t.FISTEMPLATE = '0' and tl.FLOCALEID=? and (t.FMODELTYPE=? or t.FMODELTYPE=?)";
        String sqlStrEntityId = RunModeServiceHelper.getEntityNumFromBlacklist();
        if (StringUtils.isNotEmpty((CharSequence)sqlStrEntityId)) {
            sql = sql + " and t.FID not in (" + sqlStrEntityId + ")";
        }
        sql = sql + " and te.ftype = 20";
        Object[] sqlParams = new SqlParameter[]{new SqlParameter(12, (Object)RequestContext.get().getLang().name()), new SqlParameter(12, (Object)"BaseFormModel"), new SqlParameter(12, (Object)"BillFormModel")};
        ResultSetHandler action = rs -> {
            ArrayList<TreeNode> formNodes = new ArrayList<TreeNode>(10);
            while (rs.next()) {
                String fid = rs.getString(1);
                if (StringUtils.isBlank((CharSequence)fid)) continue;
                TreeNode node = new TreeNode();
                node.setText(rs.getString(3));
                String fmasterid = rs.getString(4);
                if (StringUtils.isBlank((CharSequence)fmasterid)) {
                    node.setParentid(rs.getString(2));
                } else {
                    node.setParentid(fmasterid);
                }
                node.setId(fid);
                node.setType(FORM_NODE);
                formNodes.add(node);
            }
            return formNodes;
        };
        List formNodes = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])sqlParams, (ResultSetHandler)action);
        return formNodes;
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String cache = this.getPageCache().get(TREE_CACHE);
        if (StringUtils.isBlank((CharSequence)cache)) {
            return;
        }
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)cache, TreeNode.class);
        if (root == null) {
            return;
        }
        TreeNode entityNode = root.getTreeNode(e.getNodeId().toString());
        if (entityNode == null) {
            return;
        }
        TreeNode appNode = root.getTreeNode(entityNode.getParentid());
        if (appNode == null) {
            return;
        }
        TreeNode cloudNode = root.getTreeNode(appNode.getParentid());
        if (cloudNode == null) {
            return;
        }
        if (entityNode.getChildren() == null || entityNode.getChildren().size() <= 0) {
            this.showFields(cloudNode.getId(), cloudNode.getText(), appNode.getId(), appNode.getText(), entityNode.getId(), entityNode.getText());
        }
    }

    private void showFields(String cloudNumber, String cloudName, String appNumber, String appName, String entityNumber, String entityName) {
        this.getModel().deleteEntryData(ENTRYENTITY_MAIN);
        Set<String> filteredFields = this.getFilteredFields(entityNumber);
        if (CollectionUtils.isEmpty(filteredFields)) {
            return;
        }
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRYENTITY_MAIN);
        String selStr = this.getPageCache().get(F7_SELECTED_LIST_AP);
        Map listValue = null;
        if (!StringUtils.isEmpty((CharSequence)selStr) && !selStr.equals("{}")) {
            listValue = (Map)SerializationUtils.fromJsonString((String)selStr, Map.class);
        }
        this.getModel().beginInit();
        HashMap allFields = new HashMap(mainType.getAllFields());
        this.getModel().batchCreateNewEntryRow(ENTRYENTITY_MAIN, filteredFields.size());
        ArrayList<Integer> checkList = new ArrayList<Integer>();
        int rowIndex = 0;
        for (String filteredField : filteredFields) {
            Map subList;
            IDataEntityProperty field = (IDataEntityProperty)allFields.get(filteredField);
            this.getModel().setValue("field_type", (Object)field.getPropertyType().getSimpleName(), rowIndex);
            this.getModel().setValue("table_name", (Object)field.getParent().getAlias(), rowIndex);
            this.getModel().setValue("field_name", (Object)field.getAlias(), rowIndex);
            this.getModel().setValue("field_desc", (Object)field.getDisplayName().toString(), rowIndex);
            this.getModel().setValue("field_ident", (Object)field.getName(), rowIndex);
            this.getModel().setValue("field_entity", (Object)entityName, rowIndex);
            this.getModel().setValue("entity_number", (Object)entityNumber, rowIndex);
            this.getModel().setValue("field_app", (Object)appName, rowIndex);
            this.getModel().setValue("app_number", (Object)appNumber, rowIndex);
            this.getModel().setValue("cloud_number", (Object)cloudNumber, rowIndex);
            this.getModel().setValue("cloud_name", (Object)cloudName, rowIndex);
            String key = cloudNumber + "$" + appNumber + "$" + entityNumber + "$" + field.getName();
            if (listValue != null && (subList = (Map)listValue.get(entityNumber)) != null && subList.containsKey(key)) {
                checkList.add(rowIndex);
            }
            ++rowIndex;
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRYENTITY_MAIN);
        this.removeEntryGridSelectRow(checkList, grid);
    }

    public void search(SearchEnterEvent evt) {
        List treeNodes;
        super.search(evt);
        String searchText = evt.getText();
        String cache = this.getPageCache().get(TREE_CACHE);
        if (StringUtils.isBlank((CharSequence)cache)) {
            return;
        }
        TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)cache, TreeNode.class);
        if (rootNode == null) {
            return;
        }
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        String searchNodesCacheKey = this.getView().getPageId() + "_searchNodes";
        String matchNodesCacheKey = this.getView().getPageId() + "_matchNodes";
        String oldSearchTextCacheKey = this.getView().getPageId() + "_oldSearchText";
        String searchIndexCacheKey = this.getView().getPageId() + "_searchIndex";
        String oldSearchText = pageCache.get(oldSearchTextCacheKey);
        pageCache.put(oldSearchTextCacheKey, searchText);
        String matchNodesCache = pageCache.get(matchNodesCacheKey);
        if (oldSearchText != null && !oldSearchText.equals(searchText) || StringUtils.isBlank((CharSequence)matchNodesCache)) {
            treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, node -> this.loadChildNodes((TreeNode)node), 100);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
        } else {
            String searchNodesCache = pageCache.get(searchNodesCacheKey);
            treeNodes = StringUtils.isBlank((CharSequence)searchNodesCache) ? SerializationUtils.fromJsonStringToList((String)matchNodesCache, TreeNode.class) : SerializationUtils.fromJsonStringToList((String)searchNodesCache, TreeNode.class);
        }
        if (treeNodes.isEmpty()) {
            treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, node -> this.loadChildNodes((TreeNode)node), 100);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22\uff0c\u6ca1\u6709\u627e\u5230\u641c\u7d22\u9879\u3002", (String)"PrivacyFieldSelectorPlugin_2", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]));
        } else {
            TreeView treeView = (TreeView)this.getView().getControl(KEY_APP_TREE);
            if (StringUtils.isNotEmpty((CharSequence)pageCache.get(searchIndexCacheKey))) {
                int indexCache = Integer.parseInt(pageCache.get(searchIndexCacheKey));
                if (indexCache == treeNodes.size()) {
                    indexCache = 0;
                }
                this.focusNode(treeView, rootNode, (TreeNode)treeNodes.get(indexCache));
                pageCache.put(searchIndexCacheKey, String.valueOf(++indexCache));
            } else {
                this.focusNode(treeView, rootNode, (TreeNode)treeNodes.get(0));
                pageCache.put(searchIndexCacheKey, String.valueOf(0));
            }
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
        }
    }

    private void focusNode(TreeView treeView, TreeNode rootNode, TreeNode treeNode) {
        this.expandParents(treeView, rootNode, treeNode);
        treeView.showNode(treeNode.getParentid());
        treeView.focusNode(treeNode);
        treeView.treeNodeClick(treeNode.getParentid(), treeNode.getId());
    }

    private void expandParents(TreeView treeView, TreeNode rootNode, TreeNode node) {
        String parentid = node.getParentid();
        if (StringUtils.isNotBlank((CharSequence)parentid)) {
            TreeNode p = rootNode.getTreeNode(parentid);
            if (p != null) {
                this.expandParents(treeView, rootNode, p);
                treeView.expand(parentid);
                if (p == rootNode) {
                    treeView.updateNode(node);
                }
            } else {
                treeView.updateNode(node);
            }
        } else {
            treeView.updateNode(node);
        }
    }

    protected void loadChildNodes(TreeNode node) {
    }

    private String getDBRouteById(String appId) {
        DynamicObject cloud = BusinessDataServiceHelper.loadSingleFromCache((Object)appId, (String)"bos_devportal_bizapp", (String)"dbroute");
        String bizCloudNumber = cloud == null ? "" : cloud.getString("dbroute");
        return bizCloudNumber;
    }

    private Set<String> getFilteredFields(String entityNumber) {
        HashSet<String> filteredFields = new HashSet<String>(10);
        String entityId = MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Entity);
        if (StringUtils.isBlank((CharSequence)entityId)) {
            return filteredFields;
        }
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        List items = entityMetadata.getItems();
        for (EntityItem item : items) {
            if (!(item instanceof Field) || this.isFilterFieldType(item)) continue;
            filteredFields.add(item.getKey());
        }
        return filteredFields;
    }

    private boolean isFilterFieldType(EntityItem<?> item) {
        return !(item instanceof TextField) && !item.getClass().equals(IntegerField.class) && !item.getClass().equals(DecimalField.class) && !item.getClass().equals(BigIntField.class) && !(item instanceof DateTimeField) && !(item instanceof TimeField) && !item.getClass().equals(ComboField.class) && !(item instanceof IPictureField) && !item.getClass().equals(BasedataField.class) && !item.getClass().equals(OrgField.class) && !item.getClass().equals(MaterielField.class) && !item.getClass().equals(CurrencyField.class) && !item.getClass().equals(CityField.class) && !item.getClass().equals(UnitField.class) && !(item instanceof UserField) && !item.getClass().equals(AddressField.class) && !item.getClass().equals(NameField.class) && !(item instanceof AmountField) && !item.getClass().equals(QtyField.class) && !item.getClass().equals(EmailField.class) && !item.getClass().equals(TelephoneField.class);
    }

    private void removeF7SelectListRow(Object param) {
        String selStr = this.getPageCache().get(F7_SELECTED_LIST_AP);
        if (StringUtils.isBlank((CharSequence)selStr) || selStr.equals("{}")) {
            return;
        }
        boolean remove = false;
        Map listValue = (Map)SerializationUtils.fromJsonString((String)selStr, Map.class);
        for (Map value : listValue.values()) {
            Object data = value.remove(param);
            if (data == null) continue;
            remove = true;
            break;
        }
        if (!remove) {
            return;
        }
        this.getPageCache().put(F7_SELECTED_LIST_AP, SerializationUtils.toJsonString((Object)listValue));
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY_MAIN);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY_MAIN);
        int[] selectRows = entryGrid.getSelectRows();
        ArrayList<Integer> newSelectRowsList = new ArrayList<Integer>(10);
        for (int selectRow : selectRows) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(selectRow);
            String cloudNumber = dynamicObject.getString("cloud_number");
            String appNumber = dynamicObject.getString("app_number");
            String entityNumber = dynamicObject.getString("entity_number");
            String fieldName = dynamicObject.getString("field_ident");
            String key = cloudNumber + "$" + appNumber + "$" + entityNumber + "$" + fieldName;
            if (!key.startsWith(param.toString().substring(0, param.toString().lastIndexOf("$")))) {
                return;
            }
            if (key.equals(param)) continue;
            newSelectRowsList.add(selectRow);
        }
        this.removeEntryGridSelectRow(newSelectRowsList, (AbstractGrid)entryGrid);
    }

    private void removeEntryGridSelectRow(List<Integer> newSelectRowsList, AbstractGrid grid) {
        if (newSelectRowsList.size() > 0) {
            Integer[] t = new Integer[newSelectRowsList.size()];
            int[] a = new int[t.length];
            newSelectRowsList.toArray(t);
            for (int i = 0; i < t.length; ++i) {
                a[i] = t[i];
            }
            grid.selectRows(a, 1);
        }
    }
}

