/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.privacy.plugin;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.privacy.PrivacyDataCenterManager;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class PrivacyGlobalControlPlugin
extends AbstractFormPlugin {
    private static final String TEMPLATE = "template";
    private static final String PRIVACY_DECRYPT_MESSAGE = "privacy_decrypt_message";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"tbmain"});
        super.registerListener(e);
    }

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{TEMPLATE});
    }

    public void createNewData(BizDataEventArgs e) {
        String entityName = this.getModel().getDataEntityType().getName();
        DynamicObject dataEntity = BusinessDataServiceHelper.loadSingleFromCache((String)entityName, (QFilter[])new QFilter[0]);
        if (dataEntity != null) {
            e.setDataEntity((Object)dataEntity);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (source.getKey()) {
            case "template": {
                this.showForm(PRIVACY_DECRYPT_MESSAGE);
                break;
            }
        }
    }

    private void showForm(String formId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        String content = (String)this.getView().getModel().getValue(TEMPLATE);
        parameter.setFormId(formId);
        parameter.setCustomParam("entityNumber", (Object)this.getModel().getDataEntityType().getName());
        parameter.setCustomParam("value", (Object)content);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "templateCallBack"));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("templateCallBack".equals(actionId)) {
            this.getModel().setValue(TEMPLATE, closedCallBackEvent.getReturnData());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        if (e.getOperationResult() == null) {
            return;
        }
        if ("save".equals(e.getOperateKey())) {
            PrivacyDataCenterManager.clearCache();
        }
    }
}

