/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.privacy.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.privacy.plugin.PrivacyLabelFieldUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;

public class PrivacyLabelFieldSelectorPlugin
extends AbstractTreeListPlugin
implements TreeNodeClickListener,
ClickListener,
ListRowClickListener {
    private static final String FORM_NODE = "formNode";
    private static final String TREE_CACHE = "fieldselect_tree_cache";
    private static final String BOS_FORM_CORE = "bos-form-core";
    private static final String F7_SELECTED_LIST_AP = "f7selectedlistap";
    private static final String SEARCH_TREE = "searchap";
    private static final String KEY_APP_TREE = "treeview";
    private static final String ENTITY_NUMBER = "privacy_label_fieldselect";
    public static final String NOCODE_CLOUD_ID = "2HGKCE94QELW";
    public static final String NOCODE_SYS_APP_ID = "2HGKTA7HH43C";
    private static final Log log = LogFactory.getLog(PrivacyLabelFieldSelectorPlugin.class);
    private List<Map<String, List<Object>>> fastFilterValues = null;
    private IBizAppServiceHelp bizAppServiceHelp = new IBizAppServiceHelp(){

        @Override
        public Object getSubsysTree(String[] bizCloudIds, String[] bizAppIds, String industryId, String leafType, boolean isRuntime, boolean onlyVisible, boolean onlyDeployed) {
            return BizAppServiceHelp.getSubsysTree((String[])bizCloudIds, (String[])bizAppIds, (String)industryId, (String)leafType, (boolean)isRuntime, (boolean)onlyVisible, (boolean)onlyDeployed);
        }

        @Override
        public DynamicObjectCollection getAllBizApps() {
            return BizAppServiceHelp.getAllBizApps();
        }
    };
    private IBusinessDataServiceHelper businessDataServiceHelper = new IBusinessDataServiceHelper(){

        @Override
        public DynamicObject loadSingleFromCache(Object pk, String entityName, String selectProperties) {
            return BusinessDataServiceHelper.loadSingleFromCache((Object)pk, (String)entityName, (String)selectProperties);
        }

        @Override
        public Map<Object, DynamicObject> loadFromCache(String entityName, String selectProperties, QFilter[] filters) {
            return BusinessDataServiceHelper.loadFromCache((String)entityName, (String)selectProperties, (QFilter[])filters);
        }

        @Override
        public DynamicObject[] load(String entityName, String selectProperties, QFilter[] filters) {
            return BusinessDataServiceHelper.load((String)entityName, (String)selectProperties, (QFilter[])filters);
        }
    };

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btnok"});
        TreeView treeView = (TreeView)this.getView().getControl(KEY_APP_TREE);
        if (null != treeView) {
            treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        }
    }

    public void initializeTree(EventObject e) {
        this.initAppTree();
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new PrivacyLabelFieldListDataProvider(this.getView(), this.getTreeModel()));
    }

    public void click(EventObject evt) {
        String key;
        Control contrl = (Control)evt.getSource();
        switch (key = contrl.getKey()) {
            case "btnok": {
                this.returnData();
            }
        }
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        evt.setCancel(true);
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        this.fastFilterValues = args.getFastFilterValues();
        TreeListModel treeListModel = (TreeListModel)this.getTreeModel();
        treeListModel.setGobackToRoot(false);
    }

    private void returnData() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectedRows)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b57\u6bb5!", (String)"PrivacyLabelFieldSelectorPlugin_0", (String)"bos-privacy-plugin", (Object[])new Object[0]));
        } else {
            ArrayList<Map> dataList = new ArrayList<Map>();
            String listData = this.getView().getPageCache().get("listData");
            if (StringUtils.isNotBlank((CharSequence)listData)) {
                Map allDataMap = (Map)SerializationUtils.fromJsonString((String)listData, Map.class);
                for (ListSelectedRow row : selectedRows) {
                    String primaryKeyValue = row.getPrimaryKeyValue().toString();
                    String rowDataStr = (String)allDataMap.get(primaryKeyValue);
                    if (!StringUtils.isNotBlank((CharSequence)rowDataStr)) continue;
                    Map rowData = (Map)SerializationUtils.fromJsonString((String)rowDataStr, Map.class);
                    dataList.add(rowData);
                }
            }
            this.getView().returnDataToParent(dataList);
            this.getView().close();
        }
    }

    private void initAppTree() {
        TreeView treeView = (TreeView)this.getView().getControl(KEY_APP_TREE);
        TreeNode root = this.buildRootNode();
        if (root != null) {
            treeView.addNode(root);
            treeView.setRootVisible(true);
            this.getTreeModel().setRoot(root);
            this.getTreeModel().setCurrentNodeId((Object)root.getId());
            this.getPageCache().put(TREE_CACHE, SerializationUtils.toJsonString((Object)root));
        }
    }

    private TreeNode buildRootNode() {
        TreeNode root = this.getCloudTree();
        if (root != null) {
            root.setId("8609760E-EF83-4775-A9FF-CCDEC7C0B689");
            root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"PrivacyLabelFieldSelectorPlugin_1", (String)"bos-privacy-plugin", (Object[])new Object[0]));
            root.setParentid("");
            root.setIsOpened(true);
            Map<String, String> appIdMap = this.getAppTree(root);
            List<TreeNode> formNodes = this.getFormData();
            this.buildNode(root, formNodes, appIdMap);
        }
        return root;
    }

    private TreeNode getCloudTree() {
        TreeNode treeRoot = (TreeNode)this.bizAppServiceHelp.getSubsysTree(null, null, null, "cloud", true, false, false);
        return treeRoot;
    }

    private Map<String, String> getAppTree(TreeNode treeRoot) {
        HashMap<String, TreeNode> leafNodeMap = new HashMap<String, TreeNode>();
        this.getLeafNodes(leafNodeMap, treeRoot);
        DynamicObjectCollection allBizApps = this.bizAppServiceHelp.getAllBizApps();
        HashMap<String, String> appMap = new HashMap<String, String>(allBizApps.size());
        for (DynamicObject app : allBizApps) {
            String bizCloudId;
            String id = app.getString("id");
            appMap.put(id, app.getString("masterid"));
            if (!"0".equals(app.getString("type")) || NOCODE_CLOUD_ID.equals(bizCloudId = app.getString("bizcloud"))) continue;
            TreeNode appNode = new TreeNode(bizCloudId, id, app.getString("name"), (Object)"app");
            TreeNode parNode = (TreeNode)leafNodeMap.get(bizCloudId);
            if (parNode == null) continue;
            int seq = 0;
            if (parNode.getChildren() != null) {
                seq = parNode.getChildren().size();
            }
            parNode.addChild(seq, appNode);
        }
        return appMap;
    }

    private void getLeafNodes(Map<String, TreeNode> map, TreeNode node) {
        if (node.getChildren() != null) {
            for (TreeNode childNode : node.getChildren()) {
                this.getLeafNodes(map, childNode);
            }
        } else {
            map.put(node.getId(), node);
        }
    }

    private TreeNode buildNode(TreeNode pnode, List<TreeNode> childNode, Map<String, String> appIdMap) {
        HashMap<String, TreeNode> leafNodeMap = new HashMap<String, TreeNode>();
        this.getLeafNodes(leafNodeMap, pnode);
        for (int i = 0; i < childNode.size(); ++i) {
            TreeNode cnode = childNode.get(i);
            String parentID = cnode.getParentid();
            TreeNode parNode = (TreeNode)leafNodeMap.get(parentID);
            if (parNode == null) {
                String masterId = appIdMap.get(parentID);
                parNode = (TreeNode)leafNodeMap.get(masterId);
                cnode.setParentid(masterId);
            }
            if (parNode == null) continue;
            int seq = 0;
            if (parNode.getChildren() != null) {
                seq = parNode.getChildren().size();
            }
            parNode.addChild(seq, cnode);
        }
        this.clearNoParamNode(pnode, null);
        this.clearNoParamNode(pnode, null);
        return pnode;
    }

    private void clearNoParamNode(TreeNode curNode, TreeNode parentNode) {
        if (curNode.getChildren() != null && !curNode.getChildren().isEmpty()) {
            ArrayList lstNodes = new ArrayList();
            lstNodes.addAll(curNode.getChildren());
            for (TreeNode childNode : lstNodes) {
                this.clearNoParamNode(childNode, curNode);
            }
        } else {
            String stype;
            if (parentNode == null) {
                return;
            }
            Object type = curNode.getData();
            if (type != null && ((stype = (String)type).equalsIgnoreCase("cloud") || stype.equalsIgnoreCase("app"))) {
                parentNode.deleteChildNode(curNode.getId());
            }
        }
    }

    private List<TreeNode> getFormData() {
        QFilter filter = new QFilter("modeltype", "in", (Object)new String[]{"BaseFormModel", "BillFormModel", "DynamicFormModel", "ReportFormModel", "MobileFormModel"});
        filter.and(new QFilter("bizappid", "!=", (Object)NOCODE_SYS_APP_ID));
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject[] data = this.businessDataServiceHelper.load("bos_formmeta", "id,number,name,basedatafield,bizappid,masterid", filters);
        ArrayList<TreeNode> formNodes = new ArrayList<TreeNode>(10);
        for (DynamicObject value : data) {
            String number = value.getString("number");
            if (StringUtils.isBlank((CharSequence)number) || !value.getString("id").equals(value.getString("basedatafield_id"))) continue;
            TreeNode node = new TreeNode();
            node.setText(value.get("name").toString());
            String fmasterid = value.getString("masterid");
            if (StringUtils.isBlank((CharSequence)fmasterid)) {
                node.setParentid(value.getString("bizappid"));
            } else {
                node.setParentid(fmasterid);
            }
            node.setId(number);
            node.setType(FORM_NODE);
            formNodes.add(node);
        }
        return formNodes;
    }

    public void search(SearchEnterEvent evt) {
        super.search(evt);
        Search search = (Search)evt.getSource();
        String key = search.getKey();
        String searchText = evt.getText();
        if (StringUtils.equals((CharSequence)SEARCH_TREE, (CharSequence)key)) {
            this.searchTreeNode(searchText);
        }
    }

    private void searchTreeNode(String searchText) {
        List treeNodes;
        String cache = this.getPageCache().get(TREE_CACHE);
        if (StringUtils.isBlank((CharSequence)cache)) {
            return;
        }
        TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)cache, TreeNode.class);
        if (rootNode == null) {
            return;
        }
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        String searchNodesCacheKey = this.getView().getPageId() + "_searchNodes";
        String matchNodesCacheKey = this.getView().getPageId() + "_matchNodes";
        String oldSearchTextCacheKey = this.getView().getPageId() + "_oldSearchText";
        String searchIndexCacheKey = this.getView().getPageId() + "_searchIndex";
        String oldSearchText = pageCache.get(oldSearchTextCacheKey);
        pageCache.put(oldSearchTextCacheKey, searchText);
        String matchNodesCache = pageCache.get(matchNodesCacheKey);
        if (oldSearchText != null && !oldSearchText.equals(searchText) || StringUtils.isBlank((CharSequence)matchNodesCache)) {
            treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, node -> this.loadChildNodes((TreeNode)node), 100);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
        } else {
            String searchNodesCache = pageCache.get(searchNodesCacheKey);
            treeNodes = StringUtils.isBlank((CharSequence)searchNodesCache) ? SerializationUtils.fromJsonStringToList((String)matchNodesCache, TreeNode.class) : SerializationUtils.fromJsonStringToList((String)searchNodesCache, TreeNode.class);
        }
        if (treeNodes.isEmpty()) {
            treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, node -> this.loadChildNodes((TreeNode)node), 100);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22\uff0c\u6ca1\u6709\u627e\u5230\u641c\u7d22\u9879\u3002", (String)"PrivacyLabelFieldSelectorPlugin_2", (String)BOS_FORM_CORE, (Object[])new Object[0]));
        } else {
            TreeView treeView = (TreeView)this.getView().getControl(KEY_APP_TREE);
            if (StringUtils.isNotEmpty((CharSequence)pageCache.get(searchIndexCacheKey))) {
                int indexCache = Integer.parseInt(pageCache.get(searchIndexCacheKey));
                if (indexCache == treeNodes.size()) {
                    indexCache = 0;
                }
                this.focusNode(treeView, rootNode, (TreeNode)treeNodes.get(indexCache));
                pageCache.put(searchIndexCacheKey, String.valueOf(++indexCache));
            } else {
                this.focusNode(treeView, rootNode, (TreeNode)treeNodes.get(0));
                pageCache.put(searchIndexCacheKey, String.valueOf(0));
            }
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
        }
    }

    private void focusNode(TreeView treeView, TreeNode rootNode, TreeNode treeNode) {
        this.expandParents(treeView, rootNode, treeNode);
        treeView.showNode(treeNode.getParentid());
        treeView.focusNode(treeNode);
        treeView.treeNodeClick(treeNode.getParentid(), treeNode.getId());
    }

    private void expandParents(TreeView treeView, TreeNode rootNode, TreeNode node) {
        String parentid = node.getParentid();
        if (StringUtils.isNotBlank((CharSequence)parentid)) {
            TreeNode p = rootNode.getTreeNode(parentid);
            if (p != null) {
                this.expandParents(treeView, rootNode, p);
                treeView.expand(parentid);
                if (p == rootNode) {
                    treeView.updateNode(node);
                }
            } else {
                treeView.updateNode(node);
            }
        } else {
            treeView.updateNode(node);
        }
    }

    protected void loadChildNodes(TreeNode node) {
    }

    private String getDBRouteById(String appId) {
        DynamicObject cloud = this.businessDataServiceHelper.loadSingleFromCache(appId, "bos_devportal_bizapp", "dbroute");
        String bizCloudNumber = cloud == null ? "" : cloud.getString("dbroute");
        return bizCloudNumber;
    }

    class PrivacyLabelFieldListDataProvider
    extends ListDataProvider {
        private IFormView view;
        private ITreeModel treeModel;
        private IEntityMetadataCache entityMetadataCache = new IEntityMetadataCache(){

            @Override
            public MainEntityType getDataEntityType(String number) {
                return EntityMetadataCache.getDataEntityType((String)number);
            }
        };

        public IFormView getView() {
            return this.view;
        }

        public void setView(IFormView view) {
            this.view = view;
        }

        public ITreeModel getTreeModel() {
            return this.treeModel;
        }

        public void setTreeModel(ITreeModel treeModel) {
            this.treeModel = treeModel;
        }

        public PrivacyLabelFieldListDataProvider(IFormView view, ITreeModel treeModel) {
            this.view = view;
            this.treeModel = treeModel;
        }

        public DynamicObjectCollection getData(int start, int limit) {
            MainEntityType dt = this.entityMetadataCache.getDataEntityType(PrivacyLabelFieldSelectorPlugin.ENTITY_NUMBER);
            DynamicObjectCollection collection = new DynamicObjectCollection((DynamicObjectType)dt, null);
            Object currNodeId = this.getTreeModel().getCurrentNodeId();
            if (currNodeId == null) {
                return collection;
            }
            TreeNode root = this.getTreeModel().getRoot();
            if (root == null) {
                return collection;
            }
            TreeNode entityNode = root.getTreeNode(currNodeId.toString());
            if (entityNode == null) {
                return collection;
            }
            TreeNode appNode = root.getTreeNode(entityNode.getParentid());
            if (appNode == null) {
                return collection;
            }
            TreeNode cloudNode = root.getTreeNode(appNode.getParentid());
            if (cloudNode == null) {
                return collection;
            }
            if (entityNode.getChildren() == null || entityNode.getChildren().size() <= 0) {
                collection = this.getBillListData(dt, cloudNode.getId(), cloudNode.getText(), appNode.getId(), appNode.getText(), entityNode.getId(), entityNode.getText());
            }
            this.getQueryResult().setCollection(collection);
            return collection;
        }

        public int getMaxCount() {
            String dataCount = PrivacyLabelFieldSelectorPlugin.this.getPageCache().get("dataCount");
            if (StringUtils.isNotBlank((CharSequence)dataCount)) {
                return Integer.parseInt(dataCount);
            }
            return 0;
        }

        private DynamicObjectCollection getBillListData(MainEntityType dt, String cloudNumber, String cloudNameStr, String appNumber, String appNameStr, String entityNumber, String entityNameStr) {
            DynamicObjectCollection collection = new DynamicObjectCollection((DynamicObjectType)dt, null);
            Map<String, String> fieldStrategyMap = PrivacyLabelFieldUtils.getFieldStrategyMap(entityNumber);
            Set<String> filteredFields = PrivacyLabelFieldUtils.getFilteredFields(entityNumber, fieldStrategyMap);
            if (CollectionUtils.isEmpty(filteredFields)) {
                return collection;
            }
            PrivacyLabelFieldSelectorPlugin.this.getPageCache().put("dataCount", String.valueOf(filteredFields.size()));
            MainEntityType mainType = this.entityMetadataCache.getDataEntityType(entityNumber);
            HashMap allFields = new HashMap(mainType.getAllFields());
            Map<String, String> allDataMap = new HashMap(16);
            IPageCache pageCache = this.getView().getPageCache();
            String listData = pageCache.get("listData");
            if (StringUtils.isNotBlank((CharSequence)listData)) {
                allDataMap = (Map)SerializationUtils.fromJsonString((String)pageCache.get("listData"), Map.class);
            }
            LocaleString entityName = mainType.getDisplayName();
            AppInfo appInfo = null;
            try {
                appInfo = AppMetadataCache.getAppInfo((String)appNumber);
            }
            catch (Exception e) {
                log.warn((Throwable)e);
            }
            LocaleString appName = null;
            appName = appInfo != null ? appInfo.getName() : new LocaleString(appNameStr);
            Object cloudName = null;
            DynamicObject cloudInfo = BizCloudServiceHelp.getBizCloudByID((String)cloudNumber);
            cloudName = cloudInfo != null ? cloudInfo.getLocaleString("name") : new LocaleString(cloudNameStr);
            for (String filteredField : filteredFields) {
                String tableGroup;
                IDataEntityProperty field = (IDataEntityProperty)allFields.get(filteredField);
                DynamicObject dynamicObject = (DynamicObject)dt.createInstance();
                String tableName = field.getParent().getAlias();
                String fieldName = field.getAlias();
                String fieldIden = field.getName();
                LocaleString fieldDesc = field.getDisplayName();
                if (field instanceof DynamicSimpleProperty && ((DynamicSimpleProperty)field).isEncrypt()) {
                    log.info(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5%1$s(%2$s)\u5df2\u52a0\u5bc6\uff0c\u4e0d\u505a\u5c55\u793a\u3002", (String)"PrivacyLabelFieldSelectorPlugin_3", (String)"bos-privacy-plugin", (Object[])new Object[0]), fieldIden, fieldDesc));
                    continue;
                }
                String string = StringUtils.isEmpty((CharSequence)tableName) ? tableName : (tableGroup = String.format("%s%s", tableName, StringUtils.isBlank((CharSequence)field.getTableGroup()) ? "" : "_" + field.getTableGroup()));
                if (StringUtils.isNotEmpty((CharSequence)tableGroup)) {
                    tableGroup = tableGroup.toLowerCase(Locale.ENGLISH);
                }
                if (StringUtils.isNotEmpty((CharSequence)fieldName)) {
                    fieldName = fieldName.toLowerCase(Locale.ENGLISH);
                }
                dynamicObject.set("ffield_type", (Object)field.getPropertyType().getSimpleName());
                dynamicObject.set("ftable_name", (Object)tableGroup);
                dynamicObject.set("ffield_name", (Object)fieldName);
                dynamicObject.set("ffield_desc", (Object)fieldDesc);
                dynamicObject.set("ffield_ident", (Object)fieldIden);
                dynamicObject.set("fentity_name", (Object)entityName);
                dynamicObject.set("fentity_number", (Object)entityNumber);
                dynamicObject.set("fapp_name", (Object)appName);
                dynamicObject.set("fapp_number", (Object)appNumber);
                dynamicObject.set("fcloud_number", (Object)cloudNumber);
                dynamicObject.set("fcloud_name", cloudName);
                dynamicObject.set("appRoute", (Object)PrivacyLabelFieldSelectorPlugin.this.getDBRouteById(appNumber));
                dynamicObject.set("name", (Object)String.format("%s(%s)", fieldDesc, entityName));
                String key = entityNumber + "$" + fieldIden;
                dynamicObject.set("id", (Object)key);
                if (!this.isEligibleRow(dynamicObject)) continue;
                collection.add((Object)dynamicObject);
                allDataMap.put(key, SerializationUtils.toJsonString((Object)dynamicObject));
            }
            if (!CollectionUtils.isEmpty(allDataMap)) {
                this.getView().getPageCache().put("listData", SerializationUtils.toJsonString(allDataMap));
            }
            return collection;
        }

        private boolean isEligibleRow(DynamicObject dynamicObject) {
            if (CollectionUtils.isEmpty((Collection)PrivacyLabelFieldSelectorPlugin.this.fastFilterValues)) {
                return true;
            }
            boolean eligibleRow = false;
            for (Map fastFilterValue : PrivacyLabelFieldSelectorPlugin.this.fastFilterValues) {
                List value;
                List fieldNames = (List)fastFilterValue.get("FieldName");
                eligibleRow = this.isEligibleRow(fieldNames, value = (List)fastFilterValue.get("Value"), dynamicObject);
                if (eligibleRow) continue;
                return false;
            }
            return eligibleRow;
        }

        private boolean isEligibleRow(List<Object> fieldNames, List<Object> value, DynamicObject dynamicObject) {
            if (fieldNames == null || value == null) {
                return true;
            }
            for (Object fieldName : fieldNames) {
                String field = dynamicObject.getString(fieldName.toString());
                for (Object searchValue : value) {
                    if (!field.contains(searchValue.toString())) continue;
                    return true;
                }
            }
            return false;
        }

        protected MainEntityType getDataEntityType(String number) {
            return EntityMetadataCache.getDataEntityType((String)number);
        }
    }

    static interface IEntityMetadataCache {
        public MainEntityType getDataEntityType(String var1);
    }

    static interface IBusinessDataServiceHelper {
        public DynamicObject loadSingleFromCache(Object var1, String var2, String var3);

        public Map<Object, DynamicObject> loadFromCache(String var1, String var2, QFilter[] var3);

        public DynamicObject[] load(String var1, String var2, QFilter[] var3);
    }

    static interface IBizAppServiceHelp {
        public Object getSubsysTree(String[] var1, String[] var2, String var3, String var4, boolean var5, boolean var6, boolean var7);

        public DynamicObjectCollection getAllBizApps();
    }
}

