/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.privacy.plugin;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.privacy.PrivacyDataCenterManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.privacy.task.BaseTask;
import kd.bos.privacy.utils.PrivacyTaskUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class PrivacySchemeAddByTemplatePlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final Log logger = LogFactory.getLog(PrivacySchemeAddByTemplatePlugin.class);
    private static final String KEY_BTN_BACK = "butto_back";
    private static final String KEY_BTN_SURE = "button_sure";
    private static final String FFIELD_IDENT = "ffield_ident";
    private static final String FENTITY_NUMBER = "fentity_number";
    private static final String FFIELD_DESC = "ffield_desc";
    private static final String FENCRYPT_ALGORITHM = "fencrypt_algorithm";
    private static final String FENCRYPT_TABLE_NAME = "fencrypt_table_name";
    private static final String FENCRYPT_FIELD_NAME = "fencrypt_field_name";
    private static final String FENCRYPT_ENTITY_NUMBER = "fencrypt_entity_number";
    private static final String FENCRYPT_STATUS = "fencrypt_status";
    private static final String NO = "NO";
    private static final String COMBO_ENCRYPT = "combo_encrypt";
    private static final String BOS_PRIVACY_PLUGIN = "bos-privacy-plugin";
    private static final String EN_US = "en_US";
    private static final String ZH_TW = "zh_TW";
    private static Map<String, Object> labIdMap = new HashMap<String, Object>();
    private boolean isTask = true;
    private IDB idb = new IDB(){

        @Override
        public <T> T query(DBRoute dbRoute, String sql, ResultSetHandler<T> rh) {
            return (T)DB.query((DBRoute)dbRoute, (String)sql, rh);
        }

        @Override
        public DataSet queryDataSet(String algoKey, DBRoute dbRoute, String sql) {
            return DB.queryDataSet((String)algoKey, (DBRoute)dbRoute, (String)sql);
        }

        @Override
        public boolean execute(DBRoute dbRoute, String sql, Object[] params) {
            return DB.execute((DBRoute)dbRoute, (String)sql, (Object[])params);
        }

        @Override
        public int[] executeBatch(DBRoute dbRoute, String sql, List<Object[]> paramsList) {
            return DB.executeBatch((DBRoute)dbRoute, (String)sql, paramsList);
        }
    };
    private IBusinessDataServiceHelper businessDataServiceHelper = new IBusinessDataServiceHelper(){

        @Override
        public DynamicObject[] load(Object[] pkArray, DynamicObjectType type) {
            return BusinessDataServiceHelper.load((Object[])pkArray, (DynamicObjectType)type);
        }

        @Override
        public DynamicObject[] load(String entityName, String selectProperties, QFilter[] filters) {
            return BusinessDataServiceHelper.load((String)entityName, (String)selectProperties, (QFilter[])filters);
        }

        @Override
        public Map<Object, DynamicObject> loadFromCache(String entityName, String selectProperties, QFilter[] filters) {
            return BusinessDataServiceHelper.loadFromCache((String)entityName, (String)selectProperties, (QFilter[])filters);
        }
    };
    private IEntityMetadataCache entityMetadataCache = new IEntityMetadataCache(){

        @Override
        public MainEntityType getDataEntityType(String number) {
            return EntityMetadataCache.getDataEntityType((String)number);
        }
    };
    private IQueryServiceHelper queryServiceHelper = new IQueryServiceHelper(){

        @Override
        public boolean exists(String entityName, QFilter[] qFilters) {
            return QueryServiceHelper.exists((String)entityName, (QFilter[])qFilters);
        }
    };
    private IPrivacyTaskUtils privacyTaskUtils = new IPrivacyTaskUtils(){

        @Override
        public Map<String, Map<String, Object>> queryAllEncryptData(Object fid, DynamicObjectCollection entryData) {
            return PrivacyTaskUtils.queryAllEncryptData((Object)fid, (DynamicObjectCollection)entryData);
        }

        @Override
        public SqlParameter[] buildSqlParameter(Long schemeId, DynamicObject newObj, int taskType, String oldEncryptType) {
            return PrivacyTaskUtils.buildSqlParameter((Long)schemeId, (DynamicObject)newObj, (int)taskType, (String)oldEncryptType);
        }

        @Override
        public void printTaskLog(SqlParameter[] sqlParameter, int taskType) {
            PrivacyTaskUtils.printTaskLog((SqlParameter[])sqlParameter, (int)taskType);
        }

        @Override
        public void updateEncryptAlgorithmField(DynamicObjectCollection collection) {
            PrivacyTaskUtils.updateEncryptAlgorithmField((DynamicObjectCollection)collection);
        }

        @Override
        public void buildPrivacyTable(Set<String> entityNumberSet) {
            PrivacyTaskUtils.buildPrivacyTable(entityNumberSet);
        }
    };
    private IBaseTask baseTask = new IBaseTask(){

        @Override
        public void batchSave(List<Object[]> sqlParams) {
            BaseTask.batchSave(sqlParams);
        }
    };

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{KEY_BTN_BACK, KEY_BTN_SURE});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        this.getModel().setValue("fscheme_code", showParameter.getCustomParam("number"));
        this.getModel().setValue("fid", showParameter.getCustomParam("fid"));
        String sql = "select fpkid,fid,flocaleid,fscheme_name from t_privacy_config_tpl_l where fid = " + showParameter.getCustomParam("fid");
        LocaleString localeString = this.idb.query(DBRoute.of((String)"sys"), sql, new ResultSetHandler<LocaleString>(){

            public LocaleString handle(ResultSet rs) throws Exception {
                LocaleString localeString = new LocaleString();
                while (rs.next()) {
                    String localId = rs.getString("flocaleid");
                    localeString.setItem(localId, (Object)rs.getString("fscheme_name"));
                }
                return localeString;
            }
        });
        this.getModel().setValue("fscheme_name", (Object)localeString);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initEncryptAlgorithm();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button button = (Button)evt.getSource();
        switch (button.getKey()) {
            case "butto_back": {
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId("privacy_scheme_add_temp");
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().close();
                this.getView().getParentView().showForm(parameter);
                this.getView().sendFormAction(this.getView().getParentView());
                break;
            }
            case "button_sure": {
                this.addPrivacySchemeAddByTemplate();
                PrivacyDataCenterManager.clearCache();
                this.getView().getParentView().updateView();
                this.getView().sendFormAction(this.getView().getParentView());
                break;
            }
        }
    }

    private void initEncryptAlgorithm() {
        ComboEdit fencrypt_algorithm = (ComboEdit)this.getControl(COMBO_ENCRYPT);
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(6);
        ComboItem defaultItem = new ComboItem();
        defaultItem.setValue(NO);
        defaultItem.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u52a0\u5bc6", (String)"PrivacySchemeAddByTemplatePlugin_0", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0])));
        comboItems.add(defaultItem);
        QFilter filter = new QFilter("number", "!=", (Object)"LICENCE-SIGNATURE");
        Map<Object, DynamicObject> data = this.businessDataServiceHelper.loadFromCache("perm_encryptionscheme", "id, number, name, enable", new QFilter[]{filter});
        ArrayList<DynamicObject> encryptSchemes = new ArrayList<DynamicObject>(data.values());
        for (DynamicObject scheme : encryptSchemes) {
            ComboItem item = new ComboItem();
            item.setValue(scheme.getPkValue().toString());
            item.setCaption(new LocaleString(scheme.getString("name")));
            item.setItemVisible(scheme.getBoolean("enable"));
            comboItems.add(item);
        }
        fencrypt_algorithm.setComboItems(comboItems);
    }

    private void addPrivacySchemeAddByTemplate() {
        Long encryptAlgorithmId;
        String encrtptType = (String)this.getModel().getValue(COMBO_ENCRYPT);
        if (StringUtils.isEmpty((CharSequence)encrtptType)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u52a0\u5bc6\u65b9\u6848\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PrivacySchemeAddByTemplatePlugin_1", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (!NO.equals(encrtptType) && !PermissionServiceHelper.checkSchemeEnable((long)(encryptAlgorithmId = Long.valueOf(Long.parseLong((String)this.getModel().getValue(COMBO_ENCRYPT)))))) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u52a0\u5bc6\u65b9\u6848\u3010%1$s\u3011\u672a\u542f\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PrivacySchemeAddByTemplatePlugin_2", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]), encryptAlgorithmId));
            return;
        }
        DynamicObject[] configTemplates = this.businessDataServiceHelper.load(new Object[]{this.getModel().getValue("fid")}, (DynamicObjectType)this.entityMetadataCache.getDataEntityType("t_privacy_config_temp"));
        if (configTemplates.length <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6a21\u677f\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PrivacySchemeAddByTemplatePlugin_3", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]));
            return;
        }
        DynamicObject configTemplate = configTemplates[0];
        String schemeCode = (String)this.getModel().getValue("fscheme_code");
        QFilter schemeCodeFilter = new QFilter("fscheme_code", "=", (Object)schemeCode);
        if (this.queryServiceHelper.exists("t_privacy_scheme_config", new QFilter[]{schemeCodeFilter})) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65b9\u6848\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u65b0\u589e\u3002", (String)"PrivacySchemeAddByTemplatePlugin_4", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]));
            return;
        }
        OrmLocaleValue schemeName = (OrmLocaleValue)this.getModel().getValue("fscheme_name");
        if (schemeName.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u65b0\u589e\u3002", (String)"PrivacySchemeAddByTemplatePlugin_5", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]));
            return;
        }
        QFilter schemeNameFilter = new QFilter("fscheme_name", "=", (Object)schemeName.getLocaleValue());
        if (this.queryServiceHelper.exists("t_privacy_scheme_config", new QFilter[]{schemeNameFilter})) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u65b0\u589e\u3002", (String)"PrivacySchemeAddByTemplatePlugin_6", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]));
            return;
        }
        DynamicObject[] dataTagTemps = this.businessDataServiceHelper.load(new Object[]{configTemplate.getDynamicObject("fdatalabelid").get("id")}, (DynamicObjectType)this.entityMetadataCache.getDataEntityType("privacy_data_tags_temp"));
        if (dataTagTemps.length <= 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6a21\u677f\u4e2d\u7684\u6570\u636e\u5b89\u5168\u6807\u7b7e\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PrivacySchemeAddByTemplatePlugin_7", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]));
            return;
        }
        DynamicObject dataTagtemp = dataTagTemps[0];
        if (this.existPrivacyDataTag(dataTagtemp.getString("fnumber"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u6807\u7b7e\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u4f7f\u7528\u6b64\u6a21\u677f\u65b0\u589e\u3002", (String)"PrivacySchemeAddByTemplatePlugin_8", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection coll = dataTagtemp.getDynamicObjectCollection("t_privacy_data_field_temp");
        for (Object dObj : coll) {
            String ffield_name;
            String ftable_name = dObj.getString("ftable_name");
            if (StringUtils.isNotEmpty((CharSequence)ftable_name)) {
                dObj.set("ftable_name", (Object)ftable_name.toLowerCase(Locale.ENGLISH));
            }
            if (!StringUtils.isNotEmpty((CharSequence)(ffield_name = dObj.getString("ffield_name")))) continue;
            dObj.set("ffield_name", (Object)ffield_name.toLowerCase(Locale.ENGLISH));
        }
        DynamicObjectCollection desenColl = configTemplate.getDynamicObjectCollection("t_privacy_desen_template");
        for (Object dObj : desenColl) {
            String fdense_field_name;
            String fdense_table_name = dObj.getString("fdense_table_name");
            if (StringUtils.isNotEmpty((CharSequence)fdense_table_name)) {
                dObj.set("fdense_table_name", (Object)fdense_table_name.toLowerCase(Locale.ENGLISH));
            }
            if (!StringUtils.isNotEmpty((CharSequence)(fdense_field_name = dObj.getString("fdense_field_name")))) continue;
            dObj.set("fdense_field_name", (Object)fdense_field_name.toLowerCase(Locale.ENGLISH));
        }
        DynamicObjectCollection encryptColl = configTemplate.getDynamicObjectCollection("t_privacy_encrypt_temp");
        for (DynamicObject dObj : encryptColl) {
            String fencrypt_field_name;
            String fencrypt_table_name = dObj.getString(FENCRYPT_TABLE_NAME);
            if (StringUtils.isNotEmpty((CharSequence)fencrypt_table_name)) {
                dObj.set(FENCRYPT_TABLE_NAME, (Object)fencrypt_table_name.toLowerCase(Locale.ENGLISH));
            }
            if (!StringUtils.isNotEmpty((CharSequence)(fencrypt_field_name = dObj.getString(FENCRYPT_FIELD_NAME)))) continue;
            dObj.set(FENCRYPT_FIELD_NAME, (Object)fencrypt_field_name.toLowerCase(Locale.ENGLISH));
        }
        StringBuilder errorMsg = this.existPrivacyDataTagFields(dataTagtemp);
        if (StringUtils.isNotBlank((CharSequence)errorMsg.toString())) {
            errorMsg = errorMsg.deleteCharAt(errorMsg.length() - 1);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%1$s\u5df2\u7ecf\u88ab\u5176\u4ed6\u6807\u7b7e\u5f15\u7528\uff0c\u65e0\u6cd5\u4f7f\u7528\u6b64\u6a21\u677f\u65b0\u589e\u3002", (String)"PrivacySchemeAddByTemplatePlugin_9", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]), errorMsg.toString()));
            return;
        }
        long tagId = DB.genLongId((String)"t_privacy_data_tag");
        try (TXHandle h = TX.required();){
            DynamicObjectCollection filedsList = dataTagtemp.getDynamicObjectCollection("t_privacy_data_field_temp");
            HashSet<String> fieldList = new HashSet<String>(filedsList.size());
            for (DynamicObject filed : filedsList) {
                String entityNumber = filed.getString(FENTITY_NUMBER);
                QFilter qFilter = new QFilter("number", "=", (Object)entityNumber);
                if (!fieldList.contains(entityNumber) && !this.queryServiceHelper.exists("bos_formmeta", new QFilter[]{qFilter})) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5b9e\u4f53\u7f16\u7801\u662f%1$s\u7684\u5143\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u8fdb\u884c\u65b0\u5efa\u3002", (String)"PrivacySchemeAddByTemplatePlugin_10", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]), entityNumber));
                    return;
                }
                fieldList.add(entityNumber);
            }
            this.addDataTag(dataTagtemp, tagId);
            this.addPrivacyConfig(configTemplate, tagId);
            if (!this.isTask) {
                this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u521b\u5efa\u6210\u529f\u3002", (String)"PrivacySchemeAddByTemplatePlugin_11", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]));
                this.getView().sendFormAction(this.getView().getParentView());
                this.getView().close();
            } else {
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("privacy_temp_confirm");
                OpenStyle openStyle = new OpenStyle();
                openStyle.setShowType(ShowType.Modal);
                formShowParameter.setOpenStyle(openStyle);
                this.getView().close();
                this.getView().getParentView().showForm(formShowParameter);
                this.getView().sendFormAction(this.getView().getParentView());
            }
        }
        catch (Exception e) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6839\u636e\u6a21\u677f\u65b0\u589e\u9690\u79c1\u65b9\u6848\u5931\u8d25\u3002", (String)"PrivacySchemeAddByTemplatePlugin_12", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]));
            logger.error("\u6839\u636e\u6a21\u677f\u65b0\u589e\u9690\u79c1\u65b9\u6848\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    private void addPrivacyConfig(DynamicObject dynamicObject, Long tageId) {
        String mulSql;
        List<Object[]> r3SqlParameterList;
        DynamicObjectCollection encryptObjects = dynamicObject.getDynamicObjectCollection("t_privacy_encrypt_temp");
        ArrayList<Object[]> encryptSqlParams = new ArrayList<Object[]>(encryptObjects.size());
        ArrayList<Object[]> encryptLParamters = new ArrayList<Object[]>(encryptObjects.size() * 3);
        DynamicObjectCollection changeData = new DynamicObjectCollection();
        ArrayList<Object[]> sqlParams = new ArrayList<Object[]>(encryptObjects.size());
        HashSet<String> entityNumberSet = new HashSet<String>(encryptObjects.size());
        long schemeId = DB.genLongId((String)"t_privacy_scheme_config");
        String newEncryptType = (String)this.getModel().getValue(COMBO_ENCRYPT);
        Map<String, Map<String, Object>> allData = this.privacyTaskUtils.queryAllEncryptData(schemeId, encryptObjects);
        for (DynamicObject object : encryptObjects) {
            String key = PrivacyTaskUtils.buildEncryptConstaintKey((String)object.getString(FENCRYPT_TABLE_NAME), (String)object.getString(FENCRYPT_FIELD_NAME));
            Map<String, Object> oldObj = allData.get(key);
            SqlParameter[] parameter = this.buildEncryptSqlParameter(object, newEncryptType, schemeId, oldObj);
            encryptSqlParams.add(parameter);
            Object fentryid = parameter[1].getValue();
            DynamicObjectCollection lDColl = object.getDynamicObjectCollection("multilanguagetext");
            if (lDColl != null) {
                for (DynamicObject lDObj : lDColl) {
                    String pkValue = DB.genStringId((String)"t_privacy_scheme_encrypt_l");
                    String localeid = lDObj.getString("localeid");
                    String fencrypt_field_desc = lDObj.getString("fencrypt_field_desc");
                    String fencrypt_entity_name = lDObj.getString("fencrypt_entity_name");
                    String fencrypt_app_name = lDObj.getString("fencrypt_app_name");
                    String fencrypt_cloud_name = lDObj.getString("fencrypt_cloud_name");
                    Object[] param = new Object[]{pkValue, fentryid, localeid, fencrypt_field_desc, fencrypt_entity_name, fencrypt_app_name, fencrypt_cloud_name};
                    encryptLParamters.add(param);
                }
            }
            if (oldObj == null && newEncryptType.equals(NO) || object.getString(FENCRYPT_ALGORITHM).equals(NO) || oldObj != null && oldObj.get(FENCRYPT_ALGORITHM).toString().equals(newEncryptType)) {
                object.set(FENCRYPT_STATUS, (Object)Character.valueOf('1'));
                continue;
            }
            object.set("FENCRYPT_ALGORITHM", (Object)newEncryptType);
            changeData.add((Object)object);
            object.set(FENCRYPT_STATUS, (Object)Character.valueOf('0'));
            int taskType = 1;
            String oldEncryptType = newEncryptType;
            if (oldObj == null && !newEncryptType.equals(NO) || oldObj != null && oldObj.get(FENCRYPT_ALGORITHM).toString().equals(NO) && !newEncryptType.equals(NO)) {
                entityNumberSet.add(object.getString(FENCRYPT_ENTITY_NUMBER));
                allData.remove(key);
            } else if (oldObj != null && !oldObj.get(FENCRYPT_ALGORITHM).toString().equals(newEncryptType)) {
                if (newEncryptType.equals(NO)) {
                    entityNumberSet.add(object.getString(FENCRYPT_ENTITY_NUMBER));
                    taskType = 2;
                } else {
                    taskType = 3;
                }
                oldEncryptType = oldObj.get(FENCRYPT_ALGORITHM).toString();
            }
            SqlParameter[] taskParameter = this.privacyTaskUtils.buildSqlParameter(schemeId, object, taskType, oldEncryptType);
            sqlParams.add(taskParameter);
            this.privacyTaskUtils.printTaskLog(taskParameter, taskType);
        }
        DynamicObjectCollection desenObjects = dynamicObject.getDynamicObjectCollection("t_privacy_desen_template");
        ArrayList<Object[]> desenSqlParams = new ArrayList<Object[]>(desenObjects.size());
        ArrayList<Object[]> desenLParamters = new ArrayList<Object[]>(desenObjects.size() * 3);
        for (DynamicObject desen : desenObjects) {
            SqlParameter[] sqlParameter = PrivacySchemeAddByTemplatePlugin.buildDesenSqlParameter(desen, schemeId);
            desenSqlParams.add(sqlParameter);
            Object fentryid = sqlParameter[1].getValue();
            DynamicObjectCollection lDColl = desen.getDynamicObjectCollection("multilanguagetext");
            if (lDColl == null) continue;
            for (DynamicObject lDObj : lDColl) {
                String pkValue = DB.genStringId((String)"T_PRIVACY_SCHEME_DESEN_L");
                String localeid = lDObj.getString("localeid");
                String fdense_field_desc = lDObj.getString("fdense_field_desc");
                String fdense_entity_name = lDObj.getString("fdense_entity_name");
                String fdense_app_name = lDObj.getString("fdense_app_name");
                String fdense_cloud_name = lDObj.getString("fdense_cloud_name");
                Object[] param = new Object[]{pkValue, fentryid, localeid, fdense_field_desc, fdense_entity_name, fdense_app_name, fdense_cloud_name};
                desenLParamters.add(param);
            }
        }
        String desc = (String)this.getModel().getValue("fscheme_desc");
        OrmLocaleValue fschemeName = (OrmLocaleValue)this.getModel().getValue("fscheme_name");
        this.idb.execute(DBRoute.of((String)"sys"), this.getConfigInsertSql(), PrivacySchemeAddByTemplatePlugin.buildConfigSqlParameter(dynamicObject, schemeId, tageId, desc, fschemeName.getLocaleValue_zh_CN()));
        List<Object[]> lSqlParameterList = PrivacySchemeAddByTemplatePlugin.buildConfigLSqlParameter(schemeId, fschemeName);
        if (!lSqlParameterList.isEmpty()) {
            this.idb.executeBatch(DBRoute.of((String)"sys"), this.getConfigLSqlInsertSql(), lSqlParameterList);
        }
        if (!(r3SqlParameterList = PrivacySchemeAddByTemplatePlugin.buildConfigR3SqlParameter(dynamicObject, schemeId)).isEmpty()) {
            this.idb.executeBatch(DBRoute.of((String)"sys"), this.getConfigR3SqlInsertSql(), r3SqlParameterList);
        }
        if (!encryptSqlParams.isEmpty()) {
            this.idb.executeBatch(DBRoute.of((String)"sys"), this.getEncryptInsertSql(), encryptSqlParams);
        }
        if (!encryptLParamters.isEmpty()) {
            mulSql = "insert into t_privacy_scheme_encrypt_l (fpkid,fentryid,flocaleid,fencrypt_field_desc,fencrypt_entity_name,fencrypt_app_name,fencrypt_cloud_name) values (?,?,?,?,?,?,?) ";
            DB.executeBatch((DBRoute)DBRoute.of((String)"sys"), (String)mulSql, encryptLParamters);
        }
        if (!desenSqlParams.isEmpty()) {
            this.idb.executeBatch(DBRoute.of((String)"sys"), this.getDesenInsertSql(), desenSqlParams);
        }
        if (!desenLParamters.isEmpty()) {
            mulSql = "insert into t_privacy_scheme_desen_l (fpkid,fentryid,flocaleid,fdense_field_desc,fdense_entity_name,fdense_app_name,fdense_cloud_name) values (?,?,?,?,?,?,?) ";
            DB.executeBatch((DBRoute)DBRoute.of((String)"sys"), (String)mulSql, desenLParamters);
        }
        this.privacyTaskUtils.updateEncryptAlgorithmField(changeData);
        this.privacyTaskUtils.buildPrivacyTable(entityNumberSet);
        if (CollectionUtils.isEmpty(sqlParams)) {
            this.isTask = false;
        }
        this.baseTask.batchSave(sqlParams);
    }

    private void addDataTag(DynamicObject dynamicObject, Long tagId) {
        List<Object[]> r3SqlParameterlist;
        DynamicObjectCollection filedsList = dynamicObject.getDynamicObjectCollection("t_privacy_data_field_temp");
        ArrayList<Object[]> filedsParamters = new ArrayList<Object[]>(filedsList.size());
        ArrayList<Object[]> filedsLParamters = new ArrayList<Object[]>(filedsList.size() * 3);
        for (DynamicObject filed : filedsList) {
            SqlParameter[] parameter = PrivacySchemeAddByTemplatePlugin.buildTagFieldsSqlParameter(filed, tagId);
            filedsParamters.add(parameter);
            Object fentryid = parameter[7].getValue();
            DynamicObjectCollection lDColl = filed.getDynamicObjectCollection("multilanguagetext");
            if (lDColl == null) continue;
            for (DynamicObject lDObj : lDColl) {
                String pkValue = DB.genStringId((String)"T_PRIVACY_DATA_TAG_FIELDS_L");
                String localeid = lDObj.getString("localeid");
                String ffield_desc = lDObj.getString(FFIELD_DESC);
                String fentity_name = lDObj.getString("fentity_name");
                String fapp_name = lDObj.getString("fapp_name");
                String fcloud_name = lDObj.getString("fcloud_name");
                Object[] param = new Object[]{pkValue, fentryid, localeid, ffield_desc, fentity_name, fapp_name, fcloud_name};
                filedsLParamters.add(param);
            }
        }
        this.idb.execute(DBRoute.of((String)"sys"), this.getDataTagInsertSql(), PrivacySchemeAddByTemplatePlugin.buildDataTagSqlParameter(dynamicObject, tagId));
        List<Object[]> lsqlList = PrivacySchemeAddByTemplatePlugin.buildTagLSqlParameter(dynamicObject, tagId);
        if (!lsqlList.isEmpty()) {
            this.idb.executeBatch(DBRoute.of((String)"sys"), this.getTagLSqlInsertSql(), lsqlList);
        }
        if (!(r3SqlParameterlist = PrivacySchemeAddByTemplatePlugin.buildTagR3SqlParameter(dynamicObject, tagId)).isEmpty()) {
            this.idb.executeBatch(DBRoute.of((String)"sys"), this.getTagR3SqlInsertSql(), r3SqlParameterlist);
        }
        if (!filedsParamters.isEmpty()) {
            this.idb.executeBatch(DBRoute.of((String)"sys"), this.getTagFieldsInsertSql(), filedsParamters);
        }
        if (!filedsLParamters.isEmpty()) {
            String mulSql = "insert into T_PRIVACY_DATA_TAG_FIELDS_L (fpkid,fentryid,flocaleid,ffield_desc,fentity_name,fapp_name,fcloud_name) values (?,?,?,?,?,?,?) ";
            DB.executeBatch((DBRoute)DBRoute.of((String)"sys"), (String)mulSql, filedsLParamters);
        }
    }

    private static SqlParameter[] buildConfigSqlParameter(DynamicObject dynamicObject, Long configId, Long tagId, String desc, String fschemeName) {
        SqlParameter[] sqlParas = new SqlParameter[12];
        try {
            sqlParas[0] = new SqlParameter(":fid", -5, (Object)configId);
            sqlParas[1] = new SqlParameter(":fmasterid", -5, dynamicObject.get("masterid"));
            sqlParas[2] = new SqlParameter(":fdatalabelid", -5, (Object)tagId);
            sqlParas[3] = new SqlParameter(":fscheme_status", 12, (Object)dynamicObject.getString("fscheme_status"));
            sqlParas[4] = new SqlParameter(":fscheme_code", 12, (Object)dynamicObject.getString("fscheme_code"));
            sqlParas[5] = new SqlParameter(":fscheme_desc", 12, (Object)desc);
            sqlParas[6] = new SqlParameter(":fscheme_name", 12, (Object)fschemeName);
            sqlParas[7] = new SqlParameter(":fmessagechannel", 12, (Object)(dynamicObject.getString("messagechannel") == null ? "" : dynamicObject.getString("messagechannel")));
            sqlParas[8] = new SqlParameter(":ftemplate", 12, (Object)dynamicObject.getString("template"));
            sqlParas[9] = new SqlParameter(":fcreater", -5, (Object)RequestContext.get().getCurrUserId());
            sqlParas[10] = new SqlParameter(":fcreatedate", 93, (Object)new Date());
            sqlParas[11] = new SqlParameter(":ftemplateid", -5, dynamicObject.getPkValue());
        }
        catch (Exception exception) {
            logger.error("\u751f\u6210sql\u53c2\u6570\u62a5\u9519\uff0ctablename\uff1at_privacy_scheme_config");
            throw new RuntimeException(exception);
        }
        return sqlParas;
    }

    private String getConfigInsertSql() {
        String sql = "INSERT INTO t_privacy_scheme_config(fid, fmasterid, fdatalabelid, fscheme_status, fscheme_code, fscheme_desc, fscheme_name, fmessagechannel, ftemplate, fcreater, fcreatedate,ftemplateid)VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
        return sql;
    }

    private SqlParameter[] buildEncryptSqlParameter(DynamicObject dynamicObject, String encryptType, Long schemeId, Map<String, Object> oldObj) {
        SqlParameter[] sqlParas = new SqlParameter[19];
        String oldEncryptType = "";
        try {
            if (oldObj != null && !ObjectUtils.isEmpty((Object)oldObj.get(FENCRYPT_ALGORITHM))) {
                oldEncryptType = oldObj.get(FENCRYPT_ALGORITHM).toString();
            }
            long id = DB.genLongId((String)"t_privacy_scheme_encrypt");
            String status = dynamicObject.getString(FENCRYPT_STATUS);
            String encryptAlgorithm = dynamicObject.getString(FENCRYPT_ALGORITHM);
            if (oldObj != null && (NO.equals(encryptAlgorithm) && !NO.equals(oldEncryptType) || encryptType.equals(oldEncryptType))) {
                encryptType = oldEncryptType;
                status = (String)oldObj.get(FENCRYPT_STATUS);
            } else if (NO.equals(encryptAlgorithm)) {
                encryptType = encryptAlgorithm;
                status = "1";
            } else {
                status = NO.equals(encryptType) ? "1" : "0";
            }
            sqlParas[0] = new SqlParameter(":fid", -5, (Object)schemeId);
            sqlParas[1] = new SqlParameter(":fentryid", -5, (Object)id);
            sqlParas[2] = new SqlParameter(":fseq", -5, dynamicObject.get("seq"));
            sqlParas[3] = new SqlParameter(":fencrypt_field_ident", 12, (Object)dynamicObject.getString("fencrypt_field_ident"));
            sqlParas[4] = new SqlParameter(":fencrypt_field_type", 12, (Object)dynamicObject.getString("fencrypt_field_type"));
            sqlParas[5] = new SqlParameter(":fencrypt_cloud_number", 12, (Object)dynamicObject.getString("fencrypt_cloud_number"));
            sqlParas[6] = new SqlParameter(":fencrypt_field_name", 12, (Object)dynamicObject.getString(FENCRYPT_FIELD_NAME));
            sqlParas[7] = new SqlParameter(":fencrypt_algorithm", 12, (Object)encryptType);
            sqlParas[8] = new SqlParameter(":fencrypt_entity_number", 12, (Object)dynamicObject.getString(FENCRYPT_ENTITY_NUMBER));
            sqlParas[9] = new SqlParameter(":fencrypt_app_number", 12, (Object)dynamicObject.getString("fencrypt_app_number"));
            sqlParas[10] = new SqlParameter(":fversion", -5, dynamicObject.get("fencrypt_version"));
            sqlParas[11] = new SqlParameter(":fencrypt_table_name", 12, (Object)dynamicObject.getString(FENCRYPT_TABLE_NAME));
            sqlParas[12] = new SqlParameter(":fencrypt_field_desc", 12, (Object)dynamicObject.getString("fencrypt_field_desc"));
            sqlParas[13] = new SqlParameter(":fencrypt_entity_name", 12, (Object)dynamicObject.getString("fencrypt_entity_name"));
            sqlParas[14] = new SqlParameter(":fencrypt_app_name", 12, (Object)dynamicObject.getString("fencrypt_app_name"));
            sqlParas[15] = new SqlParameter(":fencrypt_cloud_name", 12, (Object)dynamicObject.getString("fencrypt_cloud_name"));
            sqlParas[16] = new SqlParameter(":fencrypt_status", 12, (Object)status);
            sqlParas[17] = new SqlParameter(":fapp_route", 12, (Object)dynamicObject.getString("approute"));
            sqlParas[18] = new SqlParameter(":flabelid", -5, labIdMap.get(String.format("%s$%s", dynamicObject.getString(FENCRYPT_ENTITY_NUMBER), dynamicObject.getString("fencrypt_field_ident"))));
        }
        catch (Exception exception) {
            logger.error("\u751f\u6210\u52a0\u5bc6\u89c4\u5219sql\u62a5\u9519,tablename\uff1at_privacy_scheme_encrypt", (Throwable)exception);
            throw new RuntimeException(exception);
        }
        return sqlParas;
    }

    private String getEncryptInsertSql() {
        String sql = "INSERT INTO t_privacy_scheme_encrypt(fid, fentryid, fseq, fencrypt_field_ident, fencrypt_field_type, fencrypt_cloud_number, fencrypt_field_name, fencrypt_algorithm, fencrypt_entity_number, fencrypt_app_number, fversion, fencrypt_table_name, fencrypt_field_desc, fencrypt_entity_name, fencrypt_app_name, fencrypt_cloud_name, fencrypt_status, fapp_route, flabelid)VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
        return sql;
    }

    private static SqlParameter[] buildDesenSqlParameter(DynamicObject dynamicObject, Long schemeId) {
        SqlParameter[] sqlParas = new SqlParameter[21];
        try {
            long id = DB.genLongId((String)"t_privacy_scheme_desen");
            sqlParas[0] = new SqlParameter(":fid", -5, (Object)schemeId);
            sqlParas[1] = new SqlParameter(":fentryid", -5, (Object)id);
            sqlParas[2] = new SqlParameter(":fseq", -5, dynamicObject.get("seq"));
            sqlParas[3] = new SqlParameter(":fdense_field_ident", 12, (Object)dynamicObject.getString("fdense_field_ident"));
            sqlParas[4] = new SqlParameter(":fdense_field_name", 12, (Object)dynamicObject.getString("fdense_field_name"));
            sqlParas[5] = new SqlParameter(":fdense_field_type", 12, (Object)dynamicObject.getString("fdense_field_type"));
            sqlParas[6] = new SqlParameter(":fdesensitize_rule", 12, (Object)dynamicObject.getString("fdesensitize_rule"));
            sqlParas[7] = new SqlParameter(":fdense_entity_number", 12, (Object)dynamicObject.getString("fdense_entity_number"));
            sqlParas[8] = new SqlParameter(":fdense_app_number", 12, (Object)dynamicObject.getString("fdense_app_number"));
            sqlParas[9] = new SqlParameter(":fdense_cloud_number", 12, (Object)dynamicObject.getString("fdense_cloud_number"));
            sqlParas[10] = new SqlParameter(":fdense_field_locale", 12, (Object)"");
            sqlParas[11] = new SqlParameter(":fdesensitize_type", 12, (Object)dynamicObject.getString("fdesensitize_type"));
            sqlParas[12] = new SqlParameter(":fplugin", 12, (Object)dynamicObject.getString("fplugin"));
            sqlParas[13] = new SqlParameter(":fdense_table_name", 12, (Object)dynamicObject.getString("fdense_table_name"));
            sqlParas[14] = new SqlParameter(":fdense_field_desc", 12, (Object)dynamicObject.getString("fdense_field_desc"));
            sqlParas[15] = new SqlParameter(":fdense_entity_name", 12, (Object)dynamicObject.getString("fdense_entity_name"));
            sqlParas[16] = new SqlParameter(":fdense_app_name", 12, (Object)dynamicObject.getString("fdense_app_name"));
            sqlParas[17] = new SqlParameter(":fdense_cloud_name", 12, (Object)dynamicObject.getString("fdense_cloud_name"));
            sqlParas[18] = new SqlParameter(":fdesensitiz_status", 12, (Object)dynamicObject.getString("fdesensitiz_status"));
            sqlParas[19] = new SqlParameter(":fdensefieldlocale", 12, (Object)dynamicObject.getString("fdensefieldlocale"));
            sqlParas[20] = new SqlParameter(":flabelid", -5, labIdMap.get(String.format("%s$%s", dynamicObject.getString("fdense_entity_number"), dynamicObject.getString("fdense_field_ident"))));
        }
        catch (Exception exception) {
            logger.error("\u751f\u6210\u8131\u654f\u89c4\u5219sql\u53c2\u6570\u62a5\u9519,tablename\uff1at_privacy_scheme_desen");
            throw new RuntimeException(exception);
        }
        return sqlParas;
    }

    private String getDesenInsertSql() {
        String sql = "INSERT INTO t_privacy_scheme_desen(fid, fentryid, fseq, fdense_field_ident, fdense_field_name, fdense_field_type, fdesensitize_rule, fdense_entity_number, fdense_app_number, fdense_cloud_number, fdense_field_locale, fdesensitize_type, fplugin, fdense_table_name, fdense_field_desc, fdense_entity_name, fdense_app_name, fdense_cloud_name, fdesensitiz_status, fdensefieldlocale, flabelid)VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
        return sql;
    }

    private static SqlParameter[] buildDataTagSqlParameter(DynamicObject dynamicObject, Long tagId) {
        SqlParameter[] sqlParas = new SqlParameter[9];
        try {
            sqlParas[0] = new SqlParameter(":fid", -5, (Object)tagId);
            sqlParas[1] = new SqlParameter(":fnumber", 12, (Object)dynamicObject.getString("fnumber"));
            sqlParas[2] = new SqlParameter(":fname", 12, (Object)dynamicObject.getString("fname"));
            sqlParas[3] = new SqlParameter(":fcreater", -5, (Object)RequestContext.get().getCurrUserId());
            sqlParas[4] = new SqlParameter(":fcreatedate", 93, (Object)new Date());
            sqlParas[5] = new SqlParameter(":fstatus", 12, (Object)dynamicObject.getString("status"));
            sqlParas[6] = new SqlParameter(":ftemplateid", -5, dynamicObject.getPkValue());
        }
        catch (Exception exception) {
            logger.error("\u751f\u6210\u6570\u636e\u5b89\u5168\u6807\u7b7esql\u53c2\u6570\u62a5\u9519\uff0ctablename\uff1at_privacy_data_tag");
            throw new RuntimeException(exception);
        }
        return sqlParas;
    }

    private String getDataTagInsertSql() {
        String sql = "INSERT INTO t_privacy_data_tag(fid, fnumber, fname, fcreater, fcreatedate, fstatus,ftemplateid, fmodifier, fmodifydate)VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?);";
        return sql;
    }

    private static SqlParameter[] buildTagFieldsSqlParameter(DynamicObject dynamicObject, Long tagId) {
        SqlParameter[] sqlParas = new SqlParameter[16];
        try {
            long id = DB.genLongId((String)"t_privacy_data_tag_fields");
            labIdMap.put(String.format("%s$%s", dynamicObject.getString(FENTITY_NUMBER), dynamicObject.getString(FFIELD_IDENT)), id);
            sqlParas[0] = new SqlParameter(":fid", -5, (Object)tagId);
            sqlParas[1] = new SqlParameter(":fentity_number", 12, (Object)dynamicObject.getString(FENTITY_NUMBER));
            sqlParas[2] = new SqlParameter(":ffield_ident", 12, (Object)dynamicObject.getString(FFIELD_IDENT));
            sqlParas[3] = new SqlParameter(":fdatatagid", -5, (Object)0);
            sqlParas[4] = new SqlParameter(":ffield_type", 12, (Object)dynamicObject.getString("ffield_type"));
            sqlParas[5] = new SqlParameter(":fapp_number", 12, (Object)dynamicObject.getString("fapp_number"));
            sqlParas[6] = new SqlParameter(":fcloud_number", 12, (Object)dynamicObject.getString("fcloud_number"));
            sqlParas[7] = new SqlParameter(":fentryid", -5, (Object)id);
            sqlParas[8] = new SqlParameter(":fseq", -5, dynamicObject.get("seq"));
            sqlParas[9] = new SqlParameter(":ffield_name", 12, (Object)dynamicObject.getString("ffield_name"));
            sqlParas[10] = new SqlParameter(":fentity_name", 12, (Object)dynamicObject.getString("fentity_name"));
            sqlParas[11] = new SqlParameter(":fapp_name", 12, (Object)dynamicObject.getString("fapp_name"));
            sqlParas[12] = new SqlParameter(":fcloud_name", 12, (Object)dynamicObject.getString("fcloud_name"));
            sqlParas[13] = new SqlParameter(":ffield_desc", 12, (Object)dynamicObject.getString(FFIELD_DESC));
            sqlParas[14] = new SqlParameter(":ftable_name", 12, (Object)dynamicObject.getString("ftable_name"));
            sqlParas[15] = new SqlParameter(":fapp_route", 12, (Object)dynamicObject.getString("approute"));
        }
        catch (Exception exception) {
            logger.error("\u751f\u6210\u6570\u636e\u5b89\u5168\u6807\u7b7e\u5b57\u6bb5sql\u53c2\u6570\u62a5\u9519,tablename\uff1at_privacy_data_tag_fields");
            throw new RuntimeException(exception);
        }
        return sqlParas;
    }

    private String getTagFieldsInsertSql() {
        String sql = "INSERT INTO t_privacy_data_tag_fields(fid, fentity_number, ffield_ident, fdatatagid, ffield_type, fapp_number, fcloud_number, fentryid, fseq, ffield_name, fentity_name, fapp_name, fcloud_name, ffield_desc, ftable_name, fapp_route)VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
        return sql;
    }

    private boolean existPrivacyDataTag(String number) {
        QFilter[] qFilters = new QFilter[5];
        qFilters[0] = new QFilter("fnumber", "=", (Object)number);
        DynamicObject[] dynamicObjects = this.businessDataServiceHelper.load("privacy_data_tags", "id,fnumber,fname", qFilters);
        return dynamicObjects.length > 0;
    }

    private StringBuilder existPrivacyDataTagFields(DynamicObject dynamicObject) {
        DynamicObjectCollection encryptObjects = dynamicObject.getDynamicObjectCollection("t_privacy_data_field_temp");
        HashSet<String> entityNumberList = new HashSet<String>(encryptObjects.size());
        HashSet<String> fieldList = new HashSet<String>(encryptObjects.size());
        for (DynamicObject object : encryptObjects) {
            entityNumberList.add(object.getString(FENTITY_NUMBER));
            fieldList.add(object.getString(FFIELD_IDENT));
        }
        String sql = String.format("select fentity_number,ffield_ident,ffield_desc from t_privacy_data_tag_fields where  ffield_ident in ('%s') and fentity_number in ('%s')", StringUtils.join((Object[])fieldList.toArray(), (String)"','"), StringUtils.join((Object[])entityNumberList.toArray(), (String)"','"));
        StringBuilder errorMsg = new StringBuilder();
        try (DataSet ds = this.idb.queryDataSet("", DBRoute.of((String)"sys"), sql);){
            while (ds.hasNext()) {
                Row row = ds.next();
                errorMsg.append(String.format("[%s %s]/", row.get(FFIELD_IDENT), row.get(FFIELD_DESC)));
            }
            StringBuilder stringBuilder = errorMsg;
            return stringBuilder;
        }
    }

    private String getTagLSqlInsertSql() {
        String sql = "INSERT INTO t_privacy_data_tag_l\n(fpkid, fid, flocaleid, fname)\nVALUES(?, ?, ?, ?);\n";
        return sql;
    }

    private static List<Object[]> buildTagLSqlParameter(DynamicObject dynamicObject, final Long tagId) {
        final ArrayList<Object[]> filedsParamters = new ArrayList<Object[]>(4);
        String sql = "select fpkid,fid,flocaleid,fname from t_privacy_data_tag_tpl_l where fid = " + dynamicObject.getString("id");
        DB.query((DBRoute)DBRoute.of((String)"sys"), (String)sql, (ResultSetHandler)new ResultSetHandler<Object>(){

            public Object handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    SqlParameter[] sqlParas = new SqlParameter[]{new SqlParameter(":fpkid", 12, (Object)rs.getString("fpkid")), new SqlParameter(":fid", -5, (Object)tagId), new SqlParameter(":flocaleid", 12, (Object)rs.getString("flocaleid")), new SqlParameter(":fname", 12, (Object)rs.getString("fname"))};
                    filedsParamters.add(sqlParas);
                }
                return filedsParamters;
            }
        });
        return filedsParamters;
    }

    private String getTagR3SqlInsertSql() {
        String sql = "INSERT INTO t_privacy_data_tag_r3\n(fid, frefstatus)\nVALUES(?, ?,);\n";
        return sql;
    }

    private static List<Object[]> buildTagR3SqlParameter(DynamicObject dynamicObject, final Long tagId) {
        final ArrayList<Object[]> filedsParamters = new ArrayList<Object[]>(2);
        String sql = "select fid,frefstatus from t_privacy_data_tag_tpl_r3 where fid = " + dynamicObject.getString("id");
        DB.query((DBRoute)DBRoute.of((String)"sys"), (String)sql, (ResultSetHandler)new ResultSetHandler<Object>(){

            public Object handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    SqlParameter[] sqlParas = new SqlParameter[]{new SqlParameter(":fid", -5, (Object)tagId), new SqlParameter(":frefstatus", 12, (Object)rs.getString("frefstatus"))};
                    filedsParamters.add(sqlParas);
                }
                return filedsParamters;
            }
        });
        return filedsParamters;
    }

    private String getConfigLSqlInsertSql() {
        String sql = "INSERT INTO t_privacy_scheme_config_l\n(fpkid, fid, flocaleid, fscheme_name)\nVALUES(?, ?, ?, ?);\n";
        return sql;
    }

    private static List<Object[]> buildConfigLSqlParameter(Long schemeId, OrmLocaleValue fschemeName) {
        ArrayList<Object[]> filedsParamters = new ArrayList<Object[]>(3);
        if (fschemeName == null || fschemeName.entrySet().isEmpty()) {
            return filedsParamters;
        }
        String[] ids = DB.genStringIds((String)"t_privacy_scheme_config_l", (int)fschemeName.entrySet().size());
        int i = 0;
        for (Map.Entry entry : fschemeName.entrySet()) {
            SqlParameter[] sqlParas = new SqlParameter[]{new SqlParameter(":fpkid", 12, (Object)ids[i]), new SqlParameter(":fid", -5, (Object)schemeId), new SqlParameter(":flocaleid", 12, entry.getKey()), new SqlParameter(":fscheme_name", 12, entry.getValue())};
            filedsParamters.add(sqlParas);
            ++i;
        }
        return filedsParamters;
    }

    private String getConfigR3SqlInsertSql() {
        String sql = "INSERT INTO t_privacy_scheme_confi_r3\n(fid, frefstatus)\nVALUES(?, ?,);\n";
        return sql;
    }

    private static List<Object[]> buildConfigR3SqlParameter(DynamicObject dynamicObject, final Long schemeId) {
        final ArrayList<Object[]> filedsParamters = new ArrayList<Object[]>(3);
        String sql = "select fid,frefstatus from t_privacy_config_tpl_r3 where fid = " + dynamicObject.getString("id");
        DB.query((DBRoute)DBRoute.of((String)"sys"), (String)sql, (ResultSetHandler)new ResultSetHandler<Object>(){

            public Object handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    SqlParameter[] sqlParas = new SqlParameter[]{new SqlParameter(":fid", -5, (Object)schemeId), new SqlParameter(":frefstatus", 12, (Object)rs.getString("frefstatus"))};
                    filedsParamters.add(sqlParas);
                }
                return filedsParamters;
            }
        });
        return filedsParamters;
    }

    static interface IBaseTask {
        public void batchSave(List<Object[]> var1);
    }

    static interface IPrivacyTaskUtils {
        public Map<String, Map<String, Object>> queryAllEncryptData(Object var1, DynamicObjectCollection var2);

        public SqlParameter[] buildSqlParameter(Long var1, DynamicObject var2, int var3, String var4);

        public void printTaskLog(SqlParameter[] var1, int var2);

        public void updateEncryptAlgorithmField(DynamicObjectCollection var1);

        public void buildPrivacyTable(Set<String> var1);
    }

    static interface IQueryServiceHelper {
        public boolean exists(String var1, QFilter[] var2);
    }

    static interface IEntityMetadataCache {
        public MainEntityType getDataEntityType(String var1);
    }

    static interface IBusinessDataServiceHelper {
        public DynamicObject[] load(Object[] var1, DynamicObjectType var2);

        public DynamicObject[] load(String var1, String var2, QFilter[] var3);

        public Map<Object, DynamicObject> loadFromCache(String var1, String var2, QFilter[] var3);
    }

    static interface IDB {
        public <T> T query(DBRoute var1, String var2, ResultSetHandler<T> var3);

        public DataSet queryDataSet(String var1, DBRoute var2, String var3);

        public boolean execute(DBRoute var1, String var2, Object[] var3);

        public int[] executeBatch(DBRoute var1, String var2, List<Object[]> var3);
    }
}

