/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.privacy.plugin;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeBindDataEvent;
import kd.bos.form.events.BeforeBindDataListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListGridView;
import kd.bos.list.column.ListOperationColumnDesc;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.privacy.task.BaseTask;
import kd.bos.privacy.task.DecodeTask;
import kd.bos.privacy.task.EncodeTask;
import kd.bos.privacy.task.ExchangeTask;
import kd.bos.privacy.task.TaskExecute;
import kd.bos.privacy.task.WatchTask;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.xdb.mservice.ShardingMetadataService;

public class PrivacyTaskListPlugin
extends AbstractListPlugin
implements BeforeBindDataListener {
    private static final Log logger = LogFactory.getLog(PrivacyTaskListPlugin.class);
    private static final String BOS_PRIVACY_PLUGIN = "bos-privacy-plugin";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap", "advcontoolbarap"});
        super.registerListener(e);
    }

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addBeforeBindDataListener((BeforeBindDataListener)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        if (e.getOperateKey().equals("showerrorinfo")) {
            FormShowParameter showParameter = new FormShowParameter();
            BaseTask bask = null;
            bask = this.getTaskByPrimaryKey((Long)e.getOperationResult().getSuccessPkIds().get(0));
            if (bask == null) {
                return;
            }
            showParameter.setFormId("privacy_error_log");
            showParameter.setCustomParam("errorlogs", (Object)bask.getErrorlogs());
            showParameter.setCustomParam("entity_number", (Object)bask.getEntityNumber());
            showParameter.setCustomParam("field_name", (Object)bask.getFieldName());
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        } else if (e.getOperateKey().equals("btnpublish")) {
            List errorResult = e.getOperationResult().getAllErrorInfo();
            StringBuilder sb = new StringBuilder();
            if (errorResult.size() > 0) {
                e.getOperationResult().setShowMessage(false);
                for (OperateErrorInfo opInfo : errorResult) {
                    sb.append(opInfo.getMessage());
                }
                this.getView().showTipNotification(sb.toString());
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8fc1\u79fb\u4efb\u52a1\u5df2\u7ecf\u542f\u52a8\u3002", (String)"PrivacyTaskListPlugin_0", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]));
            }
        }
    }

    public void packageData(PackageDataEvent pkEvent) {
        if (pkEvent.getSource() instanceof ListOperationColumnDesc && "listoperationcolumnap".equals(((ListOperationColumnDesc)pkEvent.getSource()).getKey())) {
            List opItems = (List)pkEvent.getFormatValue();
            String ftask_status = pkEvent.getRowData().getString("ftask_status");
            for (OperationColItem item : opItems) {
                if (ftask_status.equals("4")) {
                    item.setVisible(true);
                    continue;
                }
                item.setVisible(false);
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if ("btnpublish".equals(evt.getItemKey())) {
            QFilter filter = new QFilter("ftask_status", "in", (Object)new String[]{"1", "2"});
            boolean exists = QueryServiceHelper.exists((String)"t_privacy_task", (QFilter[])new QFilter[]{filter});
            if (exists) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u6709\u4efb\u52a1\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u8bf7\u7b49\u5f85\u4efb\u52a1\u6267\u884c\u5b8c\u6210\u540e\u518d\u64cd\u4f5c\u3002", (String)"PrivacyTaskListPlugin_5", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        Object pkId = null;
        ListGridView grid = null;
        ListSelectedRowCollection collection = null;
        switch (evt.getItemKey()) {
            case "btnchongqi": {
                grid = (ListGridView)this.getView().getControl("gridview");
                collection = ((IListView)this.getView()).getSelectedRows();
                if (collection.size() > 1) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u4e2a\u5931\u8d25\u7684\u4efb\u52a1\u8fdb\u884c\u6062\u590d\u3002", (String)"PrivacyTaskListPlugin_1", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]));
                    return;
                }
                if (collection.size() == 1) {
                    BaseTask base = null;
                    base = this.getTaskByPrimaryKey((Long)collection.get(0).getPrimaryKeyValue());
                    if (base == null) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u91cd\u542f\u4efb\u52a1\u9047\u5230\u95ee\u9898,\u6570\u636e\u9700\u8981\u4fee\u590d\u3002", (String)"PrivacyTaskListPlugin_2", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]));
                        return;
                    }
                    if (base.getTaskStatus() != 4) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u72b6\u6001\u4e3a\u5931\u8d25\u7684\u4efb\u52a1\u8fdb\u884c\u6062\u590d\u3002", (String)"PrivacyTaskListPlugin_3", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]));
                        return;
                    }
                    WatchTask.pushTask((TaskExecute)new TaskExecute(base));
                    ShardingMetadataService.getInstance().syncPrivacyXDBConfig(base.getTableName(), base.getPyTableName());
                    WatchTask.executeTask();
                    break;
                }
                if (collection.size() > 0) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u5931\u8d25\u201d\u4efb\u52a1\u8fdb\u884c\u91cd\u542f\u3002", (String)"PrivacyTaskListPlugin_4", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]));
                return;
            }
        }
        super.itemClick(evt);
    }

    public String buildErrorInfo(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        e.printStackTrace(pw);
        String stackTraceString = sw.getBuffer().toString();
        return stackTraceString;
    }

    private Map<String, BaseTask> queryMigrateTask(Long schemeId) throws ParseException {
        HashMap<String, BaseTask> result = new HashMap<String, BaseTask>();
        BaseTask baseTask = null;
        String sql = "select ftask_type,ftable_name,fentity_number,fdbrouter,fpytable_name,fstart_date,fislocale,fend_date,fcreate_date,fversion,ftask_status,ffield_name,ffield_type,forderby,fpkname,fpkvalue,forderby_value,foldencrypt_type,fpktype,ffieldIdent,fid from t_privacy_task where fschemeid=? and ftask_status in ('0','1','2','4')";
        Object[] sqlParas = new SqlParameter[]{new SqlParameter(":fschemeid", -5, (Object)schemeId)};
        try (DataSet ds = DB.queryDataSet((String)"PrivacyTaskSplitPlugin.checkTask", (DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])sqlParas);){
            if (ds != null) {
                while (ds.hasNext()) {
                    Row row = ds.next();
                    baseTask = this.buildTask(row);
                    result.put(baseTask.getTaskId() + "", baseTask);
                }
            }
            HashMap<String, BaseTask> hashMap = result;
            return hashMap;
        }
    }

    private BaseTask buildTask(Row row) throws ParseException {
        ExchangeTask baseTask = null;
        Integer taskType = 0;
        taskType = Integer.parseInt(row.get("ftask_type").toString());
        switch (taskType) {
            case 3: {
                baseTask = new ExchangeTask();
                baseTask.setTaskType(3);
                break;
            }
            case 2: {
                baseTask = new DecodeTask();
                baseTask.setTaskType(2);
                break;
            }
            case 1: {
                baseTask = new EncodeTask();
                baseTask.setTaskType(1);
            }
        }
        if (baseTask != null) {
            baseTask.setErrorlogs(row.getString("ferrorlogs"));
            baseTask.setOldEncryptType(row.get("foldencrypt_type") == null ? "" : row.get("foldencrypt_type").toString());
            baseTask.setPkName(row.get("fpkname") == null ? "" : row.get("fpkname").toString());
            baseTask.setEntityNumber(row.get("fentity_number") == null ? "" : row.get("fentity_number").toString());
            baseTask.setOrderBy(row.get("forderby") == null ? "" : row.get("forderby").toString());
            baseTask.setDbRouter(row.get("fdbrouter") == null ? "" : row.get("fdbrouter").toString());
            baseTask.setFieldName(row.get("ffield_name") == null ? "" : row.get("ffield_name").toString());
            baseTask.setTableName(row.get("ftable_name") == null ? "" : row.get("ftable_name").toString());
            baseTask.setFieldType(Integer.valueOf(Integer.parseInt(row.get("ffield_type").toString())));
            baseTask.setPyTableName(row.get("fpytable_name") == null ? "" : row.get("fpytable_name").toString());
            baseTask.setTaskId((Long)row.get("fid"));
            baseTask.setFieldIdent(row.get("ffieldIdent").toString());
            baseTask.setTaskStatus(Integer.valueOf(1));
            baseTask.setIsLocale(row.get("fislocale") == null ? "" : row.get("fislocale").toString());
            baseTask.setIsCommonLang(row.get("fiscommonlang") == null ? "FALSE" : row.get("fiscommonlang").toString());
            baseTask.setPkValue(row.get("fpkvalue"));
            baseTask.setPkType(row.getInteger("fpktype"));
            baseTask.setOrderByValue(row.get("forderby_value") == null ? "" : row.get("forderby_value").toString());
            baseTask.setVersion(row.getInteger("fversion"));
            baseTask.setTaskStatus(Integer.valueOf(Integer.parseInt(row.get("ftask_status").toString())));
            this.buildExistLastUpdateDate((BaseTask)baseTask);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            if (row.get("fstart_date") == null) {
                baseTask.setCreateDate(null);
            } else {
                baseTask.setCreateDate(simpleDateFormat.parse(row.get("fstart_date").toString()));
            }
            if (row.get("fend_date") == null) {
                baseTask.setCreateDate(null);
            } else {
                baseTask.setCreateDate(simpleDateFormat.parse(row.get("fend_date").toString()));
            }
            if (row.get("fcreate_date") == null) {
                baseTask.setCreateDate(null);
            } else {
                baseTask.setCreateDate(simpleDateFormat.parse(row.get("fcreate_date").toString()));
            }
        }
        return baseTask;
    }

    private void buildExistLastUpdateDate(BaseTask task) {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)task.getEntityNumber());
        for (IDataEntityType entryType : entityType.getAllEntities().values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)entryType.getAlias(), (CharSequence)task.getTableName()) || entryType.getModifyTimeProperty() == null) continue;
            task.setExistLastUpdate(Boolean.valueOf(true));
            break;
        }
    }

    private BaseTask getTaskByPrimaryKey(Long id) {
        BaseTask baseTask = null;
        String sql = "select ftask_type,ftable_name,fentity_number,fdbrouter,fpytable_name,fstart_date,fislocale,fend_date,fcreate_date,fversion,ftask_status,ffield_name,ffield_type,forderby,fpkname,fpkvalue,forderby_value,foldencrypt_type,ferrorlogs,fpktype,fiscommonlang,ffieldIdent,fid from t_privacy_task where fid = ?";
        Object[] sqlParas = new SqlParameter[]{new SqlParameter(":fid", -5, (Object)id)};
        try (DataSet ds = DB.queryDataSet((String)"getTaskByPrimaryKey", (DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])sqlParas);){
            if (ds != null && ds.hasNext()) {
                Row row = ds.next();
                try {
                    baseTask = this.buildTask(row);
                }
                catch (ParseException e) {
                    logger.error("getTaskByPrimaryKey:error info :" + this.buildErrorInfo(e));
                    BaseTask baseTask2 = null;
                    if (ds != null) {
                        if (var6_6 != null) {
                            try {
                                ds.close();
                            }
                            catch (Throwable throwable) {
                                var6_6.addSuppressed(throwable);
                            }
                        } else {
                            ds.close();
                        }
                    }
                    return baseTask2;
                }
            }
            BaseTask baseTask3 = baseTask;
            return baseTask3;
        }
    }

    public void setFilter(SetFilterEvent e) {
        e.setOrderBy("fcreate_date DESC,fstart_date DESC,id desc");
    }

    public void beforeBindData(BeforeBindDataEvent evt) {
        QFilter filter = new QFilter("ftask_status", "in", (Object)new String[]{"1", "2"}).and(new QFilter("instanceid", "<>", (Object)""));
        DynamicObjectCollection data = QueryServiceHelper.query((String)"t_privacy_task", (String)"id, instanceid, ftask_status", (QFilter[])new QFilter[]{filter});
        HashMap<String, DynamicObjectCollection> instanceIds = new HashMap<String, DynamicObjectCollection>(data.size());
        for (Object row : data) {
            String string = row.getString("instanceid");
            if (!StringUtils.isNotBlank((CharSequence)string)) continue;
            DynamicObjectCollection collection = (DynamicObjectCollection)instanceIds.get(string);
            if (collection == null) {
                collection = new DynamicObjectCollection();
                instanceIds.put(string, collection);
            }
            collection.add(row);
        }
        DynamicObjectCollection changeTask = new DynamicObjectCollection();
        for (Map.Entry entry : instanceIds.entrySet()) {
            String instanceId = (String)entry.getKey();
            if (DLock.isInstanceAlive((String)instanceId)) continue;
            changeTask.addAll((Collection)entry.getValue());
        }
        if (changeTask.size() > 0) {
            String updSql = "UPDATE t_privacy_task SET ftask_status = ? WHERE fid = ?  AND ftask_status = ? AND finstanceid = ?";
            ArrayList<SqlParameter[]> arrayList = new ArrayList<SqlParameter[]>(changeTask.size());
            for (DynamicObject dynamicObject : changeTask) {
                SqlParameter[] params = new SqlParameter[]{new SqlParameter(":ftask_status", 12, (Object)0), new SqlParameter(":fid", -5, dynamicObject.get("id")), new SqlParameter(":ftask_status", 12, (Object)dynamicObject.getString("ftask_status")), new SqlParameter(":finstanceid", 12, (Object)dynamicObject.getString("instanceid"))};
                arrayList.add(params);
            }
            DB.executeBatch((DBRoute)DBRoute.of((String)"sys"), (String)updSql, arrayList);
        }
    }
}

