/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.privacy.plugin.upgrade;

import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.validate.IValidatorHanlder;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.privacy.plugin.upgrade.PrivacyUpgradeJob;
import kd.bos.privacy.plugin.upgrade.UpgradeUtils;
import kd.bos.privacy.service.PrivacyEncryptService;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.PlanInfo;
import kd.bos.schedule.api.RepeatModeEnum;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;

class AbstractUpgradePlugin
extends AbstractFormPlugin {
    private static final String PROJECTNAME = "bos-privacy-plugin";
    private static final String[] fields = new String[]{"starttime", "algorithm", "notifier", "msgchannels"};
    private static final String[] firstFields = new String[]{"algorithm"};
    private static final Log log = LogFactory.getLog(AbstractUpgradePlugin.class);

    AbstractUpgradePlugin() {
    }

    public void afterCreateNewData(EventObject e) {
        this.initMsgChannelCombo();
        this.initAlgorithm();
        this.initMustInputControl();
    }

    private void initMsgChannelCombo() {
        List<ComboItem> comboItemList = this.getMsgChannelComboItems();
        MulComboEdit combo = (MulComboEdit)this.getView().getControl("msgchannels");
        combo.setComboItems(comboItemList);
        ArrayList<String> msgItems = new ArrayList<String>(comboItemList.size());
        for (ComboItem item : comboItemList) {
            msgItems.add(item.getValue());
        }
        if (msgItems.size() > 0) {
            msgItems.add(0, "");
            msgItems.add("");
            this.getModel().setValue("msgchannels", (Object)String.join((CharSequence)",", msgItems));
        }
    }

    private void initAlgorithm() {
        ComboEdit algorithm = (ComboEdit)this.getControl("algorithm");
        ArrayList<ComboItem> algorithms = new ArrayList<ComboItem>(10);
        QFilter filterLicence = new QFilter("number", "!=", (Object)"LICENCE-SIGNATURE");
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] datas = BusinessDataServiceHelper.load((String)"perm_encryptionscheme", (String)"id, number,algorithm,length,name,is_system", (QFilter[])new QFilter[]{filterLicence, enable});
        HashMap<String, Long> map = new HashMap<String, Long>(6);
        for (DynamicObject data : datas) {
            ILocaleString name = data.getLocaleString("name");
            Long pk = (Long)data.getPkValue();
            JSONObject result = PermissionServiceHelper.encryptData((long)pk, (String)"testdata");
            if (!result.getBoolean("success").booleanValue()) continue;
            algorithms.add(new ComboItem(LocaleString.fromMap((Map)name), pk.toString()));
            map.put(data.getString("number"), pk);
        }
        algorithm.setComboItems(algorithms);
        Long defValue = null;
        if (map.containsKey("STANDARD-AES-256")) {
            defValue = (Long)map.get("STANDARD-AES-256");
        } else if (map.containsKey("STANDARD-SM4-128")) {
            defValue = (Long)map.get("STANDARD-SM4-128");
        }
        if (defValue != null) {
            this.getModel().setValue("algorithm", (Object)defValue);
            this.getView().setVisible(Boolean.FALSE, new String[]{"algorithm"});
        }
    }

    private void initMustInputControl() {
        DateTimeEdit starttime = (DateTimeEdit)this.getView().getControl("starttime");
        starttime.setMustInput(true);
        FieldEdit msgchannels = (FieldEdit)this.getView().getControl("msgchannels");
        msgchannels.setMustInput(true);
        FieldEdit algorithm = (FieldEdit)this.getView().getControl("algorithm");
        algorithm.setMustInput(true);
        FieldEdit notifier = (FieldEdit)this.getView().getControl("notifier");
        notifier.setMustInput(true);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(5, 30);
        starttime.setMaxDate(calendar.getTime());
        starttime.setMinDate(new Date());
    }

    protected boolean valid() {
        for (String field : fields) {
            if (this.requiredValidator(field)) continue;
            return false;
        }
        Date start = (Date)this.getModel().getValue("starttime");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(12, 10);
        Date min = calendar.getTime();
        calendar.add(5, 30);
        Date max = calendar.getTime();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setTimeZone(KDDateUtils.getUserTimeZone());
        if (start.before(min) || start.after(max)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u542f\u52a8\u65f6\u95f4\u9700\u8981\u4e0d\u80fd\u65e9\u4e8e %1$s\uff0c\u4e0d\u80fd\u665a\u4e8e %2$s", (String)"AbstractUpgradePlugin_0", (String)PROJECTNAME, (Object[])new Object[]{df.format(min), df.format(max)}));
            return false;
        }
        return !this.vailAlgorithm();
    }

    protected boolean firstValid() {
        for (String field : firstFields) {
            if (this.requiredValidator(field)) continue;
            return false;
        }
        return !this.vailAlgorithm();
    }

    private boolean vailAlgorithm() {
        try {
            PrivacyEncryptService service = new PrivacyEncryptService();
            Long schemeId = Long.parseLong(String.valueOf(this.getModel().getValue("algorithm")));
            JSONObject result = service.encryptData(schemeId.longValue(), "test");
            boolean supported = result.getBoolean("success");
            if (!supported) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u52a0\u5bc6\u65b9\u6848\u4e0d\u53ef\u7528\uff0c%s", (String)"AbstractUpgradePlugin_5", (String)PROJECTNAME, (Object[])new Object[0]), result.getString("description")));
                return true;
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u52a0\u5bc6\u65b9\u6848\u4e0d\u53ef\u7528\uff0c%s", (String)"AbstractUpgradePlugin_5", (String)PROJECTNAME, (Object[])new Object[0]), e.getMessage()));
            return true;
        }
        return false;
    }

    private boolean requiredValidator(String fieldCtl) {
        DynamicProperty prop;
        IDataEntityProperty fieldProp;
        Control ctl = this.getView().getControl(fieldCtl);
        if (ctl instanceof FieldEdit && (fieldProp = ((FieldEdit)ctl).getProperty()) instanceof IValidatorHanlder && (prop = ((IValidatorHanlder)fieldProp).getCompareProp()) instanceof IValidatorHanlder && ((IValidatorHanlder)prop).getValueComparator().compareValue(this.getModel().getValue(prop.getName()))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201d%s\u201c", (String)"AbstractUpgradePlugin_1", (String)PROJECTNAME, (Object[])new Object[]{((FieldEdit)ctl).getDisplayName()}));
            return false;
        }
        return true;
    }

    protected List<ComboItem> getMsgChannelComboItems() {
        DynamicObject[] channelArray = BusinessDataServiceHelper.load((String)"msg_channel", (String)"id, number, name, enable", null);
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(10);
        if (channelArray != null && channelArray.length > 0) {
            for (DynamicObject channelDo : channelArray) {
                ILocaleString name = channelDo.getLocaleString("name");
                String number = channelDo.getString("number");
                Boolean enable = channelDo.getBoolean("enable");
                if (!enable.booleanValue() || "sysnotice".equalsIgnoreCase(number)) continue;
                ComboItem comboItem = new ComboItem();
                comboItem.setValue(number);
                comboItem.setCaption(new LocaleString(name != null ? name.getLocaleValue() : ""));
                comboItemList.add(comboItem);
            }
        }
        return comboItemList;
    }

    protected void generateScheduleTask(Long notifierId, String msgChannels, Date startTime, String algorithm) {
        ArrayList<String> msgChannelList = new ArrayList<String>(3);
        for (String it : msgChannels.split(",")) {
            if (!StringUtils.isNotBlank((CharSequence)it)) continue;
            msgChannelList.add(it);
        }
        JobInfo jobInfo = this.createJob(notifierId, msgChannelList, algorithm);
        String jobId = ScheduleServiceHelper.createJob((JobInfo)jobInfo);
        PlanInfo scheduleInfo = this.createSchedule(jobInfo, startTime);
        scheduleInfo.setJobId(jobId);
        String schId = ScheduleServiceHelper.createPlan((PlanInfo)scheduleInfo);
        ArrayList<String> schIds = new ArrayList<String>(1);
        schIds.add(schId);
        try {
            ScheduleServiceHelper.enableSchedule(schIds);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        UpgradeUtils.addOpLog(this.getView().getFormShowParameter().getFormId(), "createSchedule", ResManager.loadKDString((String)"\u751f\u6210\u9690\u79c1\u5347\u7ea7\u5b9a\u65f6\u4efb\u52a1", (String)"AbstractUpgradePlugin_4", (String)PROJECTNAME, (Object[])new Object[0]), schId);
    }

    protected JobInfo createJob(Long notifierId, List<String> msgChannels, String algorithm) {
        HashMap<String, Object> params = new HashMap<String, Object>(3);
        params.put("msgChannels", String.join((CharSequence)",", msgChannels));
        params.put("notifierId", notifierId);
        params.put("algorithm", algorithm);
        JobInfo jobInfo = new JobInfo();
        jobInfo.setId(DB.genGlobalLongId() + "");
        jobInfo.setRunConcurrently(false);
        jobInfo.setJobType(JobType.BIZ);
        jobInfo.setTaskDefineId("3QN4T3ZUHZXJ");
        jobInfo.setTaskClassname(PrivacyUpgradeJob.class.getName());
        jobInfo.setParams(params);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        long time = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String dateStr = sdf.format(time);
        jobInfo.setName(this.getPrefixName() + dateStr);
        jobInfo.setNumber(this.getPrefixNumber() + dateStr);
        jobInfo.setAppId("bos");
        return jobInfo;
    }

    private String getPrefixName() {
        return ResManager.loadKDString((String)"\u9690\u79c1\u9884\u7f6e", (String)"AbstractUpgradePlugin_2", (String)PROJECTNAME, (Object[])new Object[0]);
    }

    private String getPrefixNumber() {
        return "PRI_PRESET_";
    }

    private PlanInfo createSchedule(JobInfo jobInfo, Date startTime) {
        PlanInfo scheduleInfo = new PlanInfo();
        scheduleInfo.setId(DB.genGlobalLongId() + "");
        scheduleInfo.setJobId(jobInfo.getId());
        scheduleInfo.setName(jobInfo.getName());
        scheduleInfo.setNumber(jobInfo.getNumber());
        scheduleInfo.setEnable(true);
        scheduleInfo.setRepeatMode(RepeatModeEnum.NONE);
        scheduleInfo.setEnable(true);
        Calendar start = Calendar.getInstance();
        start.setTime(new Date());
        start.add(12, -3);
        scheduleInfo.setStartTime(start);
        Calendar end = Calendar.getInstance();
        end.setTime(startTime);
        end.add(5, 3);
        scheduleInfo.setEndTime(end);
        scheduleInfo.setCronExpression(this.getCron(startTime));
        return scheduleInfo;
    }

    private String getCron(Date date) {
        String dateFormat = "ss mm HH dd MM ? yyyy";
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        String corn = null;
        if (date != null) {
            corn = sdf.format(date);
        }
        return corn;
    }

    protected void showSuccessMsg(String pageId) {
        IFormView view = this.getView().getViewNoPlugin(pageId);
        view.showSuccessNotification(ResManager.loadKDString((String)"\u914d\u7f6e\u5df2\u5b8c\u6210\uff0c\u542f\u7528\u751f\u6548\u540e\u8bf7\u8fdb\u5165\u201c\u57fa\u7840\u670d\u52a1\u4e91\u2014\u5b89\u5168\u7ba1\u7406\u2014\u9690\u79c1\u7ba1\u7406\"\u67e5\u770b\u3002", (String)"AbstractUpgradePlugin_3", (String)PROJECTNAME, (Object[])new Object[0]));
        this.getView().sendFormAction(view);
    }
}

