/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.privacy.plugin.upgrade;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.privacy.PrivacyDataCenterManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.privacy.plugin.PrivacyPluginUtil;
import kd.bos.privacy.service.PrivacyTableBuilderService;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class PrivacyToLowerCaseServiceImpl
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(PrivacyToLowerCaseServiceImpl.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        StringBuilder log = new StringBuilder("PrivacyToLowerCaseServiceImpl begin");
        long startTime = System.currentTimeMillis();
        try {
            this.repairPrivacyTable(log);
        }
        catch (Throwable e) {
            logger.error(e);
            result.setSuccess(false);
            result.setErrorInfo(this.getStackTrace(e));
        }
        long costTime = System.currentTimeMillis() - startTime;
        log.append("PrivacyToLowerCaseServiceImpl end. all cost : ").append(costTime);
        result.setLog(log.toString());
        return result;
    }

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        PrivacyDataCenterManager.clearCache();
        return super.afterExecuteSqlWithResult(ver, iteration, dbKey, sqlFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repairPrivacyTable(StringBuilder log) {
        String sql = "select fencrypt_table_name,fencrypt_field_name,fapp_route from t_privacy_scheme_encrypt";
        List list = (List)DB.query((DBRoute)DBRoute.basedata, (String)sql, resultSet -> {
            ArrayList<Tuple> res = new ArrayList<Tuple>(8);
            HashSet<String> set = new HashSet<String>(8);
            while (resultSet.next()) {
                String Key;
                String tableName = resultSet.getString("fencrypt_table_name");
                String fieldName = resultSet.getString("fencrypt_field_name");
                String approute = resultSet.getString("fapp_route");
                if (!StringUtils.isNotEmpty((CharSequence)tableName) || !StringUtils.isNotEmpty((CharSequence)approute) || PrivacyPluginUtil.isAllLowerCase(tableName) && PrivacyPluginUtil.isAllLowerCase(fieldName) || !set.add(Key = tableName.toLowerCase(Locale.ENGLISH) + "&&" + approute.toLowerCase(Locale.ENGLISH))) continue;
                res.add(new Tuple((Object)tableName.toLowerCase(Locale.ENGLISH), (Object)approute.toLowerCase(Locale.ENGLISH)));
            }
            return res;
        });
        for (Tuple tuple : list) {
            long cost;
            long startTime;
            String appRoute;
            String tableName;
            block5: {
                tableName = (String)tuple.item1;
                appRoute = (String)tuple.item2;
                if (!DB.exitsTable((DBRoute)DBRoute.of((String)appRoute), (String)tableName)) continue;
                startTime = System.currentTimeMillis();
                try {
                    String privacyTableName = PrivacyTableBuilderService.buildPrivacyTableName((String)tableName);
                    if (!DB.exitsTable((DBRoute)DBRoute.of((String)appRoute), (String)privacyTableName)) break block5;
                    String updateSql = String.format("update %s set ffield = lower(ffield)", privacyTableName);
                    DB.execute((DBRoute)DBRoute.of((String)appRoute), (String)updateSql);
                }
                catch (Throwable t) {
                    try {
                        logger.error(String.format("tableName : %s, appRoute : %s", tableName, appRoute), t);
                        log.append(String.format("tableName : %s, appRoute : %s, exception : %s", tableName, appRoute, this.getStackTrace(t)));
                    }
                    catch (Throwable throwable) {
                        long cost2 = System.currentTimeMillis() - startTime;
                        logger.info(String.format("tableName : %s, appRoute : %s, costtime : %d", tableName, appRoute, cost2));
                        log.append(String.format("tableName : %s, appRoute : %s, costtime : %d", tableName, appRoute, cost2));
                        throw throwable;
                    }
                    cost = System.currentTimeMillis() - startTime;
                    logger.info(String.format("tableName : %s, appRoute : %s, costtime : %d", tableName, appRoute, cost));
                    log.append(String.format("tableName : %s, appRoute : %s, costtime : %d", tableName, appRoute, cost));
                    continue;
                }
            }
            cost = System.currentTimeMillis() - startTime;
            logger.info(String.format("tableName : %s, appRoute : %s, costtime : %d", tableName, appRoute, cost));
            log.append(String.format("tableName : %s, appRoute : %s, costtime : %d", tableName, appRoute, cost));
        }
    }

    private String getStackTrace(Throwable e) {
        StringBuilder oSB = new StringBuilder();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        oSB.append(ResManager.loadKDString((String)"\u8c03\u7528\u5806\u6808\uff1a", (String)"ExceptionHandler_1", (String)"bos-mservice-form", (Object[])new Object[0])).append("\r\n");
        oSB.append(sw.getBuffer().toString()).append("\r\n");
        return oSB.toString();
    }
}

