/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.privacy.plugin.upgrade;

import java.sql.Timestamp;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.privacy.PrivacyDataCenterManager;
import kd.bos.log.api.AppLogInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.session.SystemPropertyUtils;

public class UpgradeUtils {
    private static final String PRIVACYCENTER_UPGRADE_ENABLE = "privacycenter.upgrade.enable";
    public static final String UPGRADETASKDEFINEDID = "3QN4T3ZUHZXJ";
    public static final String NOTIFYTASKDEFINEDID = "3RQMCHWP9T2H";

    public static boolean isEnableUpgrade() {
        if (!PrivacyDataCenterManager.isEnable()) {
            return Boolean.FALSE;
        }
        String param = SystemPropertyUtils.getProptyByTenant((String)PRIVACYCENTER_UPGRADE_ENABLE, (String)RequestContext.get().getTenantId());
        if (StringUtils.isNotEmpty((CharSequence)param)) {
            return Boolean.parseBoolean(param);
        }
        return Boolean.FALSE;
    }

    public static boolean existAgreement() {
        int size = (Integer)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)"select count(1) from t_privacy_upgradeprotocol", rs -> {
            if (rs.next()) {
                return rs.getInt(1);
            }
            return 0;
        });
        return size > 0;
    }

    public static boolean existWaitingExecTask() {
        QFilter[] jobFilters = new QFilter[]{new QFilter("job.taskclassname.id", "=", (Object)UPGRADETASKDEFINEDID), new QFilter("status", "=", (Object)"1"), new QFilter("job.status", "=", (Object)"1")};
        List schIds = QueryServiceHelper.queryPrimaryKeys((String)"sch_schedule", (QFilter[])jobFilters, null, (int)-1);
        Map map = ScheduleServiceHelper.queryNextExecuteTime((String[])schIds.toArray(new String[schIds.size()]));
        Timestamp ts = new Timestamp(new Date().getTime());
        ZonedDateTime current = ts.toInstant().atZone(KDDateUtils.getSysTimeZone().toZoneId());
        for (Map.Entry it : map.entrySet()) {
            ZonedDateTime dateTime = (ZonedDateTime)it.getValue();
            if (dateTime == null || !dateTime.isAfter(current)) continue;
            return true;
        }
        return false;
    }

    public static void addOpLog(String formId, String opName, String opDesc, String detail) {
        HashMap<String, Object> content = new HashMap<String, Object>(10);
        content.put("traceId", RequestContext.get().getTraceId());
        content.put("detail", detail);
        content.put("time", new Date());
        AppLogInfo appLogInfo = new AppLogInfo();
        appLogInfo.setUserID(Long.valueOf(RequestContext.get().getUserId()));
        appLogInfo.setBizAppID(BizAppServiceHelp.getAppIdByAppNumber((String)"privacy"));
        appLogInfo.setBizObjID(formId);
        appLogInfo.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
        appLogInfo.setOpTime(new Date());
        appLogInfo.setClientType(RequestContext.get().getClient());
        appLogInfo.setClientIP(RequestContext.get().getLoginIP());
        appLogInfo.setOpName(opName);
        appLogInfo.setOpDescription(opDesc);
        appLogInfo.setModifyContentTag(SerializationUtils.toJsonString(content));
        LogServiceHelper.addLog((AppLogInfo)appLogInfo);
    }
}

