/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.filter.constants;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.ConditionVariableContext;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.FilterRow;
import kd.bos.entity.filter.IConditionVariableAnalysis;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.orm.query.MultiBaseDataFilterValue;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.QFilterHint;
import kd.bos.servicehelper.QueryServiceHelper;
import org.jetbrains.annotations.NotNull;

public class ItemClassEqualsAnalysis
implements IConditionVariableAnalysis {
    private static final String MESS = "%s %s %s";
    private String currentType;

    public String getCurrentType() {
        return this.currentType;
    }

    public void setCurrentType(String currentType) {
        this.currentType = currentType;
    }

    public void getScriptFilter(ConditionVariableContext ctx) {
        List<Object> itemIds = this.loadItemIds(ctx);
        FilterField filterField = ctx.getFilterRow().getFilterField();
        String ormFullFieldName = FilterField.buildPropORMFullName((IDataEntityProperty)filterField.getSrcFieldProp());
        String cp = this.getQCP(itemIds);
        String script = itemIds.isEmpty() ? String.format(MESS, ormFullFieldName, cp, ormFullFieldName) : (itemIds.size() == 1 ? String.format(MESS, ormFullFieldName, cp, itemIds.get(0).toString()) : String.format("%s %s (%s)", ormFullFieldName, cp, StringUtils.join((Object[])itemIds.toArray(), (String)",")));
        ctx.setScript(script);
        ctx.setFilterDesc(this.buildFilterDesc(ctx));
    }

    protected QFilterHint getQFilterHint() {
        return null;
    }

    QFilter decorateFilter(String fieldName, QFilter qFilter, ItemClassTypeProp itemTypeProp) {
        return qFilter;
    }

    public void getVariableFilter(ConditionVariableContext ctx) {
        if (!ctx.getFilterRow().getValue().isEmpty() && StringUtils.isBlank((CharSequence)((CharSequence)ctx.getFilterRow().getValue().get(0)))) {
            return;
        }
        ItemClassProp itemClassProp = (ItemClassProp)ctx.getFilterRow().getFilterField().getSrcFieldProp();
        ItemClassTypeProp itemTypeProp = this.getTypeProp(ctx.getMainType(), itemClassProp);
        if (itemTypeProp == null || itemTypeProp.getItemTypes().size() == 0) {
            return;
        }
        String currentBaseId = this.setCurrentType(ctx, itemTypeProp);
        FilterField filterField = ctx.getFilterRow().getFilterField();
        String ormFullFieldName = FilterField.buildPropORMFullName((IDataEntityProperty)filterField.getSrcFieldProp());
        List value = "IN".equalsIgnoreCase(ctx.getOperater()) || "NOT IN".equalsIgnoreCase(ctx.getOperater()) ? ctx.getFilterRow().getValue() : ctx.getFilterRow().getValue().get(0);
        QFilter qFilter = this.getQFilterHint() != null ? new QFilter(filterField.getFullFieldName(), ctx.getOperater(), (Object)new MultiBaseDataFilterValue(currentBaseId, ormFullFieldName, (Object)value), this.getQFilterHint()) : new QFilter(filterField.getFullFieldName(), ctx.getOperater(), (Object)new MultiBaseDataFilterValue(currentBaseId, ormFullFieldName, (Object)value));
        qFilter = this.decorateFilter(filterField.getFullFieldName(), qFilter, itemTypeProp);
        ctx.setQFilter(qFilter);
        ctx.setFilter(qFilter.toString());
    }

    protected String getQCP(List<Object> itemIds) {
        if (itemIds.isEmpty()) {
            return "!=";
        }
        if (itemIds.size() == 1) {
            return "=";
        }
        return "in";
    }

    public void addItemClassTypeFilter(ConditionVariableContext ctx) {
        QFilter qFilter = ctx.getQFilter();
        ItemClassProp itemClassProp = (ItemClassProp)ctx.getFilterRow().getFilterField().getSrcFieldProp();
        ItemClassTypeProp itemTypeProp = this.getTypeProp(ctx.getMainType(), itemClassProp);
        QFilter q = this.getItemTypeFilter(itemTypeProp);
        FilterField filterField = ctx.getFilterRow().getFilterField();
        String ormFullFieldName = FilterField.buildPropORMFullName((IDataEntityProperty)filterField.getSrcFieldProp());
        q.and(new QFilter(ormFullFieldName, "=", (Object)0));
        qFilter = qFilter.or(q);
        ctx.setQFilter(qFilter);
    }

    @NotNull
    QFilter getItemTypeFilter(ItemClassTypeProp itemTypeProp) {
        String typeFieldName = FilterField.buildPropORMFullName((IDataEntityProperty)itemTypeProp);
        return new QFilter(typeFieldName, "=", (Object)this.getCurrentType());
    }

    protected List<Object> loadItemIds(ConditionVariableContext ctx) {
        ArrayList<Object> itemIds = new ArrayList<Object>();
        if (StringUtils.isBlank((CharSequence)((CharSequence)ctx.getFilterRow().getValue().get(0)))) {
            return itemIds;
        }
        ItemClassProp itemClassProp = (ItemClassProp)ctx.getFilterRow().getFilterField().getSrcFieldProp();
        ItemClassTypeProp itemTypeProp = this.getTypeProp(ctx.getMainType(), itemClassProp);
        if (itemTypeProp == null || itemTypeProp.getItemTypes().size() == 0) {
            return itemIds;
        }
        String currentBaseId = this.setCurrentType(ctx, itemTypeProp);
        for (Map.Entry item : itemTypeProp.getItemTypes().entrySet()) {
            if (!currentBaseId.equals(item.getKey())) continue;
            BasedataEntityType bdType = (BasedataEntityType)item.getValue();
            String pkFldName = bdType.getPrimaryKey().getName();
            IDataEntityProperty fieldProp = ctx.getFilterRow().getFilterField().getFieldProp();
            if (fieldProp instanceof PKFieldProp) {
                this.loadPkIds(itemIds, fieldProp, ctx.getFilterRow().getValue());
                continue;
            }
            QFilter qFilter = this.buildBaseDataQFilter(ctx, bdType);
            String maxRowStr = System.getProperty("bos.billlist.maxRowCount", "100000");
            int maxrowcount = Integer.parseInt(maxRowStr);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)("ItemClassEqualsAnalysis." + bdType.getName()), (String)bdType.getName(), (String)pkFldName, (QFilter[])new QFilter[]{qFilter}, (String)"", (int)maxrowcount);
            Throwable throwable = null;
            try {
                if (dataSet.isEmpty()) continue;
                while (dataSet.hasNext()) {
                    Long id = dataSet.next().getLong(pkFldName);
                    itemIds.add(id);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dataSet == null) continue;
                if (throwable != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dataSet.close();
            }
        }
        return itemIds;
    }

    private String setCurrentType(ConditionVariableContext ctx, ItemClassTypeProp itemTypeProp) {
        List filterRows = ctx.getFilterObject().getFilterRows();
        String currentBaseId = (String)itemTypeProp.getBaseEntityIds().get(0);
        for (FilterRow filterRow : filterRows) {
            IDataEntityProperty controlProp = filterRow.getFilterField().getSrcFieldProp();
            if (!(controlProp instanceof ItemClassTypeProp) || !controlProp.getName().equals(itemTypeProp.getName()) || filterRow.getValue().isEmpty()) continue;
            currentBaseId = (String)filterRow.getValue().get(0);
        }
        this.setCurrentType(currentBaseId);
        return currentBaseId;
    }

    protected boolean isMulti() {
        return false;
    }

    protected void loadPkIds(List<Object> itemIds, IDataEntityProperty fieldProp, List<String> values) {
        if (this.isMulti()) {
            if (fieldProp instanceof LongProp) {
                for (String value : values) {
                    itemIds.add(Long.parseLong(value));
                }
            } else {
                itemIds.addAll(values);
            }
        } else if (fieldProp instanceof LongProp) {
            itemIds.add(Long.parseLong(values.get(0)));
        } else {
            itemIds.add(values.get(0));
        }
    }

    boolean isNameProp(IDataEntityProperty fieldProp) {
        return StringUtils.equalsIgnoreCase((CharSequence)fieldProp.getName(), (CharSequence)"name");
    }

    protected String getQCP() {
        return "=";
    }

    protected Object getValue(List<String> valueList) {
        return valueList.get(0);
    }

    public QFilter buildBaseDataQFilter(ConditionVariableContext ctx, BasedataEntityType bdType) {
        IDataEntityProperty fieldProp = ctx.getFilterRow().getFilterField().getFieldProp();
        return new QFilter(this.isNameProp(fieldProp) ? bdType.getNameProperty() : bdType.getNumberProperty(), this.getQCP(), this.getValue(ctx.getFilterRow().getValue()), this.getQFilterHint());
    }

    private ItemClassTypeProp getTypeProp(MainEntityType mainType, ItemClassProp itemClassProp) {
        if (mainType == null || itemClassProp == null || StringUtils.isBlank((CharSequence)itemClassProp.getTypePropName())) {
            return null;
        }
        IDataEntityProperty prop = mainType.findProperty(itemClassProp.getTypePropName());
        if (prop instanceof ItemClassTypeProp) {
            return (ItemClassTypeProp)prop;
        }
        return null;
    }

    protected String buildFilterDesc(ConditionVariableContext ctx) {
        String fieldCaption = ctx.getFilterRow().getFilterField().getCaption().toString();
        return String.format("%s %s '%s'", fieldCaption, ctx.getFilterRow().getCompareType().getName().toString(), ctx.getFilterRow().getValue().get(0));
    }
}

