/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.filter.constants;

import java.util.List;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.ConditionVariableContext;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.FilterRow;
import kd.bos.entity.filter.constants.IsNotNullAnalysis;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.orm.query.QFilter;

public class ItemClassIsNotNullAnalysis
extends IsNotNullAnalysis {
    public void getVariableFilter(ConditionVariableContext ctx) {
        String fieldName = ctx.getFilterRow().getFilterField().getFullFieldName();
        int lastIndexOf = fieldName.lastIndexOf(46);
        if (lastIndexOf == -1) {
            lastIndexOf = fieldName.length();
        }
        QFilter qFilter = new QFilter(fieldName.substring(0, lastIndexOf), "!=", (Object)0);
        ctx.setQFilter(qFilter);
        this.addItemClassTypeFilter(ctx, "!=", "0");
    }

    private void addItemClassTypeFilter(ConditionVariableContext ctx, String cp, String value) {
        QFilter qFilter = ctx.getQFilter();
        ItemClassProp itemClassProp = (ItemClassProp)ctx.getFilterRow().getFilterField().getSrcFieldProp();
        ItemClassTypeProp itemTypeProp = this.getTypeProp(ctx.getMainType(), itemClassProp);
        if (itemTypeProp == null) {
            return;
        }
        String typeFieldName = FilterField.buildPropORMFullName((IDataEntityProperty)itemTypeProp);
        String currentBaseId = (String)itemTypeProp.getBaseEntityIds().get(0);
        List filterRows = ctx.getFilterObject().getFilterRows();
        for (FilterRow filterRow : filterRows) {
            IDataEntityProperty controlProp = filterRow.getFilterField().getSrcFieldProp();
            if (!(controlProp instanceof ItemClassTypeProp) || !controlProp.getName().equals(itemTypeProp.getName()) || filterRow.getValue().isEmpty()) continue;
            currentBaseId = (String)filterRow.getValue().get(0);
        }
        QFilter q = new QFilter(typeFieldName, "=", (Object)currentBaseId);
        qFilter = qFilter.and(q);
        String filter = null;
        FilterField filterField = ctx.getFilterRow().getFilterField();
        if (ctx.isParam()) {
            ctx.getParam().add(new SqlParameter(ctx.getFieldName(), filterField.getFieldType(), (Object)value));
            filter = String.format("%s %s ?", ctx.getFieldName(), cp);
        } else {
            filter = String.format("%s %s %s", ctx.getFieldName(), cp, value);
        }
        ctx.setFilter(filter);
        ctx.setQFilter(qFilter);
    }

    private ItemClassTypeProp getTypeProp(MainEntityType mainType, ItemClassProp itemClassProp) {
        if (mainType == null || itemClassProp == null || StringUtils.isBlank((CharSequence)itemClassProp.getTypePropName())) {
            return null;
        }
        IDataEntityProperty prop = mainType.findProperty(itemClassProp.getTypePropName());
        if (prop instanceof ItemClassTypeProp) {
            return (ItemClassTypeProp)prop;
        }
        return null;
    }
}

