/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.filter.constants;

import java.util.List;
import kd.bos.entity.filter.ConditionVariableContext;
import kd.bos.entity.filter.constants.ItemClassEqualsAnalysis;

public class ItemClassNotInAnalysis
extends ItemClassEqualsAnalysis {
    @Override
    protected boolean isMulti() {
        return true;
    }

    @Override
    public void getVariableFilter(ConditionVariableContext ctx) {
        super.getVariableFilter(ctx);
        this.addItemClassTypeFilter(ctx);
    }

    @Override
    protected String getQCP() {
        return "in";
    }

    @Override
    protected String getQCP(List<Object> itemIds) {
        if (itemIds.isEmpty()) {
            return "=";
        }
        if (itemIds.size() == 1) {
            return "!=";
        }
        return "not in";
    }

    @Override
    protected Object getValue(List<String> valueList) {
        return valueList;
    }

    @Override
    protected String buildFilterDesc(ConditionVariableContext ctx) {
        String fieldCaption = ctx.getFilterRow().getFilterField().getCaption().toString();
        String join = String.join((CharSequence)"','", ctx.getFilterRow().getValue());
        return String.format("%s %s ('%s')", fieldCaption, ctx.getFilterRow().getCompareType().getName().toString(), join);
    }
}

