/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.filter.constants;

import kd.bos.entity.filter.ConditionVariableContext;
import kd.bos.entity.filter.constants.ItemClassEqualsAnalysis;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.QFilterHint;

public class ItemClassNotLikeAnalysis
extends ItemClassEqualsAnalysis {
    @Override
    protected QFilterHint getQFilterHint() {
        return QFilterHint.NOT_CONTAINS;
    }

    @Override
    protected String getQCP() {
        return "not like";
    }

    @Override
    QFilter decorateFilter(String fieldName, QFilter qFilter, ItemClassTypeProp itemTypeProp) {
        int currentDot = fieldName.indexOf(".");
        QFilter itemTypeFilter = this.getItemTypeFilter(itemTypeProp);
        while (currentDot != -1) {
            qFilter.or(QFilter.notExists((String)fieldName.substring(0, currentDot)).and(itemTypeFilter));
            currentDot = fieldName.indexOf(".", currentDot + 1);
        }
        return qFilter;
    }

    @Override
    public void getScriptFilter(ConditionVariableContext ctx) {
        String script = String.format("%s not like '%s'", ctx.getFieldName(), "%" + this.getValue(ctx.getFilterRow().getValue()) + "%");
        ctx.setScript(script);
        ctx.setFilterDesc(this.buildFilterDesc(ctx));
    }
}

