/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.function;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.function.BatchFuncRunParam;
import kd.bos.entity.function.BatchQueryById;
import kd.bos.entity.function.BatchQueryKey;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;

class BatchQueryByFilter {
    private BatchQueryKey queryKey;
    private Set<BatchFuncRunParam> params;
    private BatchFuncRunParam param0 = null;
    private static final int TOP = 500000;

    public BatchQueryByFilter(BatchQueryKey queryKey, Set<BatchFuncRunParam> params) {
        this.queryKey = queryKey;
        this.params = params;
        if (params != null && !params.isEmpty()) {
            this.param0 = params.iterator().next();
        }
    }

    public static BatchQueryByFilter create(BatchQueryKey queryKey, Set<BatchFuncRunParam> params) {
        if (queryKey.getFilterFieldKeys().length == 0) {
            return new BatchQueryById(queryKey, params);
        }
        return new BatchQueryByFilter(queryKey, params);
    }

    public Map<BatchFuncRunParam, Object> query() {
        this.getQueryKey().buildFullName();
        QFilter[] qFilters = this.createQFilters();
        String selectFields = this.createSelectFields();
        HashMap<BatchFuncRunParam, Object> result = new HashMap<BatchFuncRunParam, Object>(this.getParams().size());
        ORM orm = ORM.create();
        try (DataSet ds = orm.queryDataSet(this.getClass().getName(), this.getQueryKey().getEntityNumber(), selectFields, qFilters, null, 500000);){
            while (ds.hasNext()) {
                Row row = ds.next();
                BatchFuncRunParam param = this.createBatchFuncRunParam(row);
                if (param == null || result.containsKey(param) || !this.params.contains(param)) continue;
                Object value = row.get(this.getQueryKey().getSelectFieldAlias());
                if (value instanceof DynamicObject) {
                    value = ((DynamicObject)value).getPkValue();
                }
                result.put(param, value);
            }
        }
        return result;
    }

    protected QFilter[] createQFilters() {
        ArrayList filterValues = new ArrayList(this.getQueryKey().getFilterFieldKeys().length);
        int filterFieldCount = this.getQueryKey().getFilterFieldKeys().length;
        for (int i = 0; i < filterFieldCount; ++i) {
            filterValues.add(new HashSet(this.params.size()));
        }
        for (BatchFuncRunParam param : this.getParams()) {
            for (int i = 0; i < filterFieldCount; ++i) {
                int filterValueIndex = i * 2 + 3;
                if (filterValueIndex >= param.getFuncParamVals().length) continue;
                ((Set)filterValues.get(i)).add(param.getFuncParamVals()[filterValueIndex]);
            }
        }
        QFilter[] qFilters = new QFilter[filterFieldCount];
        for (int i = 0; i < filterFieldCount; ++i) {
            if (((Set)filterValues.get(i)).isEmpty()) continue;
            qFilters[i] = new QFilter(this.getQueryKey().getFilterFullName()[i], "in", (Object)((Set)filterValues.get(i)).toArray());
        }
        return qFilters;
    }

    protected String createSelectFields() {
        return this.queryKey.createSelectFields();
    }

    protected BatchFuncRunParam createBatchFuncRunParam(Row row) {
        BatchFuncRunParam inParam = this.getParam0();
        Object[] outParams = new Object[inParam.getFuncParamVals().length];
        outParams[0] = inParam.getFuncParamVals()[0];
        outParams[1] = inParam.getFuncParamVals()[1];
        for (int i = 0; i < this.getQueryKey().getFilterFieldKeys().length; ++i) {
            outParams[i * 2 + 2] = this.getQueryKey().getFilterFieldKeys()[i];
            outParams[i * 2 + 3] = row.get("f" + i);
        }
        return new BatchFuncRunParam(inParam.getFuncName(), outParams);
    }

    public BatchQueryKey getQueryKey() {
        return this.queryKey;
    }

    public Set<BatchFuncRunParam> getParams() {
        return this.params;
    }

    public BatchFuncRunParam getParam0() {
        return this.param0;
    }
}

