/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.function;

import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;

class BatchQueryKey {
    private String entityNumber;
    private String selectFieldKey;
    private String[] filterFieldKeys;
    private MainEntityType mainType;
    private String selectFullName;
    private String[] filterFullName;

    public BatchQueryKey(String entityNumber, String selectFieldKey, String[] filterFieldKeys) {
        this.entityNumber = entityNumber;
        this.selectFieldKey = selectFieldKey;
        this.filterFieldKeys = filterFieldKeys;
    }

    public void buildFullName() {
        this.selectFullName = BatchQueryKey.buildFullPropName(this.getMainType(), this.getSelectFieldKey());
        this.filterFullName = new String[this.filterFieldKeys.length];
        for (int i = 0; i < this.filterFieldKeys.length; ++i) {
            this.filterFullName[i] = BatchQueryKey.buildFullPropName(this.getMainType(), this.filterFieldKeys[i]);
        }
    }

    public String createSelectFields() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMainType().getPrimaryKey().getName()).append(" id");
        sb.append(", ").append(this.selectFullName).append(" ").append(this.getSelectFieldAlias());
        for (int i = 0; i < this.filterFullName.length; ++i) {
            sb.append(", ").append(this.filterFullName[i]).append(" ").append(this.getFilterFieldAlias(i));
        }
        return sb.toString();
    }

    public static String buildFullPropName(MainEntityType mainType, String propertyName) {
        String[] keys = propertyName.split("\\.");
        IDataEntityProperty property = mainType.findProperty(keys[0]);
        if (property == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5728\u5355\u636e\u3010%1$s\u3011\u4e0a\uff0c\u6ca1\u6709\u627e\u5230\u5c5e\u6027\u3010%2$s\u3011", (String)"BatchQueryKey_0", (String)"bos-entity-business", (Object[])new Object[0]), mainType.getDisplayName().toString(), keys[0]));
        }
        String fullPropName = propertyName;
        for (IDataEntityType parent = property.getParent(); parent != null && !(parent instanceof MainEntityType); parent = parent.getParent()) {
            fullPropName = parent.getName() + "." + fullPropName;
        }
        return fullPropName;
    }

    public String getEntityNumber() {
        return this.entityNumber;
    }

    public String getSelectFieldKey() {
        return this.selectFieldKey;
    }

    public String[] getFilterFieldKeys() {
        return this.filterFieldKeys;
    }

    public String getSelectFullName() {
        return this.selectFullName;
    }

    public String[] getFilterFullName() {
        return this.filterFullName;
    }

    public MainEntityType getMainType() {
        if (this.mainType == null) {
            this.mainType = EntityMetadataCache.getDataEntityType((String)this.entityNumber);
        }
        return this.mainType;
    }

    public String getSelectFieldAlias() {
        return "s1";
    }

    public String getFilterFieldAlias(int index) {
        return "f" + index;
    }

    public String toString() {
        return "{entity=" + this.entityNumber + ", select=" + this.selectFieldKey + ", filter=[" + StringUtils.join((Object[])this.filterFieldKeys, (String)",") + "]}";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.entityNumber == null ? 0 : this.entityNumber.hashCode());
        result = 31 * result + (this.selectFieldKey == null ? 0 : this.selectFieldKey.hashCode());
        if (this.filterFieldKeys != null && this.filterFieldKeys.length > 0) {
            String str = StringUtils.join((Object[])this.filterFieldKeys, (String)",");
            result = 31 * result + str.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BatchQueryKey other = (BatchQueryKey)obj;
        return this.equalsValue(this.entityNumber, other.entityNumber) && this.equalsValue(this.selectFieldKey, other.selectFieldKey) && this.equalsListValue(this.filterFieldKeys, other.filterFieldKeys);
    }

    private boolean equalsValue(Object v1, Object v2) {
        if (v1 == null) {
            return v2 == null;
        }
        return v1.equals(v2);
    }

    private boolean equalsListValue(Object[] l1, Object[] l2) {
        if (l1 == null) {
            return l2 == null;
        }
        if (l2 == null) {
            return false;
        }
        if (l1.length != l2.length) {
            return false;
        }
        for (int i = 0; i < l1.length; ++i) {
            if (this.equalsValue(l1[i], l2[i])) continue;
            return false;
        }
        return true;
    }
}

