/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.function;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.function.BOSUDFunction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class ExchangeRateQuery
implements BOSUDFunction {
    private static final Log log = LogFactory.getLog(ExchangeRateQuery.class);
    private static final String ORIGINAL_CURRENCY = "originalcurrency";
    private static final String TARGET_CURRENCY = "targetcurrency";
    private static final String EXCHANGE_RATE_TYPE = "exchangeratetype";
    private static final String CONVERSION_DATE = "conversiondate";
    private static final String QUOTE_TYPE = "quotetype";
    private ExpressionContext expContext;
    private String lastQuoteType;

    public String getLastQuoteType() {
        return this.lastQuoteType;
    }

    public void setLastQuoteType(String lastQuoteType) {
        this.lastQuoteType = lastQuoteType;
    }

    public ExchangeRateQuery() {
    }

    public ExchangeRateQuery(ExpressionContext expContext) {
        this.expContext = expContext;
    }

    public String getName() {
        return "EXCHANGERATEQUERY";
    }

    public Object call(Object ... params) {
        Map<String, Object> paramsMap = this.paramsToMap(params);
        boolean isRequired = this.requiredCheck(paramsMap);
        if (isRequired) {
            if (params.length == 4) {
                return this.loadQuoteType(paramsMap);
            }
            if (params.length == 5) {
                if (paramsMap.get(QUOTE_TYPE) == null || "".equals(paramsMap.get(QUOTE_TYPE))) {
                    return "";
                }
                return this.loadExchangeRate(paramsMap);
            }
        }
        return "";
    }

    private int loadQuoteType(Map<String, Object> paramsMap) {
        Map exchangeRateByRules = BaseDataServiceHelper.getExchangeRateMap((Long)Long.valueOf(paramsMap.get(ORIGINAL_CURRENCY).toString()), (Long)Long.valueOf(paramsMap.get(TARGET_CURRENCY).toString()), (Long)Long.valueOf(paramsMap.get(EXCHANGE_RATE_TYPE).toString()), (Date)((Date)paramsMap.get(CONVERSION_DATE)));
        if (Boolean.parseBoolean(exchangeRateByRules.get("quoteType").toString())) {
            return 1;
        }
        return 0;
    }

    private BigDecimal loadExchangeRate(Map<String, Object> paramsMap) {
        BigDecimal rate = BaseDataServiceHelper.getExchangeRateByQuoteType((Long)Long.valueOf(paramsMap.get(ORIGINAL_CURRENCY).toString()), (Long)Long.valueOf(paramsMap.get(TARGET_CURRENCY).toString()), (Long)Long.valueOf(paramsMap.get(EXCHANGE_RATE_TYPE).toString()), (Date)((Date)paramsMap.get(CONVERSION_DATE)), (Integer.parseInt(paramsMap.get(QUOTE_TYPE).toString()) == 1 ? 1 : 0) != 0);
        return rate;
    }

    private Map<String, Object> paramsToMap(Object ... params) {
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        if (params != null && params.length >= 4) {
            map.put(ORIGINAL_CURRENCY, params[0]);
            map.put(TARGET_CURRENCY, params[1]);
            map.put(EXCHANGE_RATE_TYPE, params[2]);
            map.put(CONVERSION_DATE, params[3]);
            if (params.length > 4) {
                map.put(QUOTE_TYPE, params[4]);
            }
        }
        return map;
    }

    private boolean requiredCheck(Map<String, Object> paramsMap) {
        return paramsMap.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals(QUOTE_TYPE)).noneMatch(entry -> entry.getValue() == null || entry.getValue() instanceof String && StringUtils.isBlank((CharSequence)((String)entry.getValue())));
    }

    public BOSUDFunction getInstance(ExpressionContext expContext) {
        return new ExchangeRateQuery(expContext);
    }
}

