/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.operate;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.session.EncreptSessionUtils;
import kd.bos.url.UrlService;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class AttachmentView
extends FormOperate {
    private static Log log = LogFactory.getLog(AttachmentView.class);

    protected int hasRight(OperationResult result) {
        return 1;
    }

    public OperationResult invokeOperation() {
        Object[] pkIds = ((IListView)this.getView()).getSelectedRows().getPrimaryKeyValues();
        if (pkIds == null || pkIds.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"AttachmentView_0", (String)"bos-entity-business", (Object[])new Object[0]));
            return null;
        }
        if ("attachmentview".equals(this.getOperateKey()) && pkIds.length > 10) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u89c8\u6700\u591a\u652f\u6301\u9009\u62e910\u4e2a\u9644\u4ef6\u3002", (String)"AttachmentView_1", (String)"bos-entity-business", (Object[])new Object[0]));
            return null;
        }
        ORM orm = ORM.create();
        QFilter filter = new QFilter("id", "in", (Object)pkIds);
        DynamicObjectCollection dataset = orm.query("bos_attachment", "id,ffileid,fbilltype", new QFilter[]{filter});
        for (DynamicObject data : dataset) {
            this.doPackUrl(data.getString("ffileid"), data.getString("fbilltype"));
        }
        return null;
    }

    protected void doPackUrl(String url, String fId) {
        String attachmentFullUrl = AttachmentView.getEncreptURL(UrlService.getAttachmentFullUrl((String)URLEncoder.encode(url)));
        if (!(attachmentFullUrl = attachmentFullUrl.replace("download.do", "preview.do")).contains("&kdedcba=")) {
            attachmentFullUrl = EncreptSessionUtils.encryptSession((String)attachmentFullUrl);
        }
        attachmentFullUrl = attachmentFullUrl + "&fId=" + fId;
        String resutlt = AttachmentView.sendGet(attachmentFullUrl, null);
        try {
            JSONObject resultMap = (JSONObject)JSON.parse((String)resutlt);
            if (resultMap != null && "error".equals(resultMap.get((Object)"status"))) {
                this.getView().showTipNotification(resultMap.get((Object)"description").toString());
                return;
            }
            if (resultMap != null && "success".equals(resultMap.get((Object)"status"))) {
                attachmentFullUrl = resultMap.get((Object)"url").toString();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        this.getView().openUrl(attachmentFullUrl);
    }

    private static String getEncreptURL(String url) {
        return EncreptSessionUtils.encryptSession((String)url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendGet(String url, String param) {
        StringBuilder result = new StringBuilder();
        BufferedReader in = null;
        InputStreamReader inputStreamReader = null;
        try {
            String line;
            String urlNameString = url;
            if (!StringUtils.isEmpty((Object)param)) {
                urlNameString = urlNameString + "?" + param;
            }
            URL realUrl = new URL(urlNameString);
            URLConnection connection = realUrl.openConnection();
            connection.setRequestProperty("accept", "*/*");
            connection.setRequestProperty("connection", "Keep-Alive");
            connection.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            connection.connect();
            Map<String, List<String>> map = connection.getHeaderFields();
            inputStreamReader = new InputStreamReader(connection.getInputStream());
            in = new BufferedReader(inputStreamReader);
            while ((line = in.readLine()) != null) {
                result.append(line);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e2) {
                log.warn((Throwable)e2);
            }
            try {
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
            }
            catch (Exception e3) {
                log.warn((Throwable)e3);
            }
        }
        return result.toString();
    }
}

