/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.operate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.data.ParameterHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.DefaultEntityOperate;
import kd.bos.entity.operate.SaveValidatorCloseCallBack;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.FormRoot;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.operate.OperateUtils;
import kd.bos.list.IListView;
import kd.bos.service.operation.OperationServiceImpl;

public class Audit
extends DefaultEntityOperate
implements IConfirmCallBack {
    private static final String AUDITOP = "auditop";

    @Override
    protected boolean needCheckDBDataVersion() {
        Boolean enable = this.getParameter().getOrDefault("checkFormDataVersion", false);
        return enable instanceof Boolean ? enable : Boolean.parseBoolean(((Object)enable).toString());
    }

    @Override
    protected OperationResult callBillOperationService() {
        this.setTempAttachmentOption();
        this.setModelTableOption();
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        OperationServiceImpl operationService = new OperationServiceImpl();
        OperationResult opResult = operationService.localInvokeOperation(this.getOperateKey(), new DynamicObject[]{dataEntity}, this.getOption());
        if (opResult != null && !opResult.getSuccessPkIds().isEmpty()) {
            this.clearAttsCache();
            this.updateOperationFields(opResult);
            this.notifyListViewChanged();
        }
        return opResult;
    }

    protected void afterInvokeOperation(OperationResult opResult) {
        if (opResult != null && !opResult.getSuccessPkIds().isEmpty()) {
            FormRoot rootControl;
            IClientViewProxy service = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            if (MutexHelper.allFieldWithRequiredLock((IClientViewProxy)service, (List)(rootControl = (FormRoot)this.getView().getRootControl()).getItems(), (BillOperationStatus)BillOperationStatus.AUDIT, (MainEntityType)this.getView().getModel().getDataEntityType())) {
                MutexHelper.release((IFormView)this.getView());
            } else {
                IPageCache pageCache = this.getView().getPageCache();
                String mutexEntityKey = pageCache.get("MUTEX_ENTITY_KEY");
                String mutexOperationKey = pageCache.get("MUTEX_OPER_KEY");
                String mutexObjId = pageCache.get("MUTEX_OBJ_ID");
                if (StringUtils.isBlank((CharSequence)mutexObjId) || StringUtils.isBlank((CharSequence)mutexEntityKey) || !StringUtils.equals((CharSequence)"modify", (CharSequence)mutexOperationKey)) {
                    this.requestMutex("modify");
                }
            }
        }
        super.afterInvokeOperation(opResult);
    }

    @Override
    protected void afterOperationClose(OperationResult result) {
        super.afterOperationClose(result);
        if (MutexHelper.isOpenIntentLocks()) {
            MutexHelper.releaseAndApplyIntent((IFormView)this.getView(), (StringBuilder)new StringBuilder());
        }
    }

    @Override
    protected boolean beforeInvokeOperation(OperationResult result) {
        if (MutexHelper.isOpenIntentLocks() && !this.checkIntentExist(AUDITOP)) {
            return false;
        }
        if (!super.beforeInvokeOperation(result)) {
            this.getOperateLog().info("Audit.beforeInvokeOperation\uff1asuper.beforeInvokeOperation return false");
            return false;
        }
        return true;
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        if (StringUtils.equals((CharSequence)e.getCallBackId(), (CharSequence)AUDITOP)) {
            if (e.getResult() == MessageBoxResult.Yes) {
                this.getView().invokeOperation("refresh");
            }
        } else if (StringUtils.equals((CharSequence)e.getCallBackId(), (CharSequence)"savevalidator_refreshactionid")) {
            SaveValidatorCloseCallBack cb = new SaveValidatorCloseCallBack();
            HashMap<String, String> data = new HashMap<String, String>(1);
            data.put("opType", "refresh");
            ClosedCallBackEvent event = new ClosedCallBackEvent((Object)this.getView(), "savevalidator_refreshactionid", data);
            event.setView(this.getView());
            cb.closedCallBack(event);
        }
    }

    @Override
    protected void invokeNextOperation(OperationResult opResult) {
        DynamicObject opDyObj;
        String nextOp = "";
        if (!(this.getView() instanceof IListView) && (opDyObj = ParameterHelper.getUserOption((long)RequestContext.get().getCurrUserId(), (String)this.getEntityId())) != null) {
            boolean submitAndAudit = (Boolean)opDyObj.get("submitandaudit");
            boolean submitAndNew = (Boolean)opDyObj.get("submitandnew");
            boolean saveAndSubmit = (Boolean)opDyObj.get("saveandsubmit");
            boolean saveAndNew = (Boolean)opDyObj.get("saveandnew");
            Map allOperates = OperateUtils.getAllOperate((String)this.getEntityId());
            List newOperate = (List)allOperates.get("new");
            Object sourceOperateType = this.getView().getFormShowParameter().getCustomParam("source_operate_type");
            if ((saveAndSubmit && submitAndNew && submitAndAudit && "save".equals(sourceOperateType) || submitAndAudit && submitAndNew && "submit".equals(sourceOperateType) || submitAndAudit && saveAndSubmit && saveAndNew && "save".equals(sourceOperateType)) && newOperate != null && newOperate.size() == 1) {
                nextOp = (String)newOperate.get(0);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)nextOp)) {
            this.getView().invokeOperation(nextOp);
        } else {
            super.invokeNextOperation(opResult);
        }
        this.getView().getFormShowParameter().setCustomParam("source_operate_type", null);
    }
}

