/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.operate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.RuntimeMetaType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.cache.TableModelCache;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RaiseEventType;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.flex.FlexEntireData;
import kd.bos.entity.operate.OpBatchExecutePlugin;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.SaveValidatorCloseCallBack;
import kd.bos.entity.operate.interaction.IInteractionRequest;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.entity.rule.RaiseEventSource;
import kd.bos.entity.rule.RuleContainer;
import kd.bos.entity.rule.RuleExecuteContext;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.GroupFieldsUniqueValidateResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.entity.wf.WfAssignNextPersonCloseCallBack;
import kd.bos.entity.wf.WfSensitiveCloseCallBack;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.flex.FlexService;
import kd.bos.form.AbstractFormView;
import kd.bos.form.BinderMap;
import kd.bos.form.BindingContext;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.ControlTypes;
import kd.bos.form.FieldTip;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoCheckDataPermissionArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.FlexEdit;
import kd.bos.form.fieldtip.DeleteRule;
import kd.bos.form.flex.FlexEditData;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.DuplicateSubmitHelper;
import kd.bos.form.operate.EntityOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.ICombinOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.operate.interaction.InteractionHandler;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.rule.FormRuleExecuteContext;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.svc.attach.IAttachmentFieldModelProxy;
import kd.bos.mservice.svc.attach.IAttachmentPanel;
import kd.bos.mservice.svc.attach.IAttachmentProp;
import kd.bos.mutex.impl.MutexLockInfo;
import kd.bos.mvc.bill.BillView;
import kd.bos.param.ParameterReader;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.service.operation.validate.DataVersionChangeValidator;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.workflow.api.IWorkflowService;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class DefaultEntityOperate
extends EntityOperate {
    protected static final String BOS_ENTITY_BUSINESS = "bos-entity-business";
    private static final String SPAN_TYPE_OPERATE = "operate";
    private static final String BILLPARAM_OPBATCHCOUNT = "opbatchcount";
    private LocaleString successMsg;
    private List<Map<String, Object>> refreshFields = new ArrayList<Map<String, Object>>();
    private Set<String> opFields = null;
    private Map<IDataEntityType, Set<String>> opEntityFields = null;
    private Boolean allUserApp = null;
    private static Log logger = LogFactory.getLog(DefaultEntityOperate.class);

    public void initialize(Map<String, Object> opMeta) {
        super.initialize(opMeta);
        Object object = opMeta.get("refreshFields");
        if (object != null) {
            List fields = (List)object;
            this.refreshFields.addAll(fields);
        }
        this.successMsg = this.LocaleFromOpMeta(opMeta, "successMsg");
    }

    public LocaleString getSuccessMsg() {
        return this.successMsg;
    }

    public List<Map<String, Object>> getRefreshFields() {
        return this.refreshFields;
    }

    protected Set<String> getOperationFields() {
        if (this.opFields != null) {
            return this.opFields;
        }
        this.opFields = new HashSet<String>();
        for (Map<String, Object> field : this.refreshFields) {
            if (this.getView().getControl((String)field.get("id")) == null) continue;
            this.opFields.add((String)field.get("id"));
        }
        String statusPropName = (String)this.getParameter().get("statusProp");
        String statusValue = (String)this.getParameter().get("value");
        if (StringUtils.isNotBlank((CharSequence)statusPropName)) {
            this.opFields.add(statusPropName);
            MainEntityType mainEntityType = this.getView().getModel().getDataEntityType();
            IDataEntityProperty prop = mainEntityType.findProperty(statusPropName);
            if (prop instanceof BillStatusProp) {
                BillStatusProp.StatusItemPro statusItem;
                BillStatusProp statusProp = (BillStatusProp)prop;
                if (StringUtils.isNotBlank((CharSequence)statusValue) && (statusItem = statusProp.getStatusItem(statusValue)) != null) {
                    if (StringUtils.isNotBlank((CharSequence)statusItem.getOperationerKey())) {
                        this.opFields.add(statusItem.getOperationerKey());
                    }
                    if (StringUtils.isNotBlank((CharSequence)statusItem.getOperationDateKey())) {
                        this.opFields.add(statusItem.getOperationDateKey());
                    }
                }
            }
            if (mainEntityType.getModifyTimeProperty() != null) {
                this.opFields.add(mainEntityType.getModifyTimeProperty().getName());
            }
        }
        if (this.getOperateLog().isWriteLog()) {
            this.getOperateLog().info(String.format("getOperationFields: %s", StringUtils.join((Object[])this.opFields.toArray(), (String)",")));
        }
        return this.opFields;
    }

    protected Map<IDataEntityType, Set<String>> getOperationEntityFields() {
        if (this.opEntityFields != null) {
            return this.opEntityFields;
        }
        this.opEntityFields = new HashMap<IDataEntityType, Set<String>>();
        Set<String> refreshFldKeys = this.getOperationFields();
        if (refreshFldKeys.isEmpty()) {
            return this.opEntityFields;
        }
        if (this instanceof Save && this.getView().getModel() instanceof IBillModel) {
            IBillModel model = (IBillModel)this.getView().getModel();
            model.getDataEntity().beginInit();
            model.syncDataFromDB(refreshFldKeys);
            model.getDataEntity().endInit();
            this.getView().getModel().setDataChanged(false);
        }
        MainEntityType mainType = this.getView().getModel().getDataEntityType();
        for (String key : refreshFldKeys) {
            Control control;
            IDataEntityProperty property = mainType.findProperty(key);
            if (property == null && (!((control = this.getView().getControl(key)) instanceof FieldEdit) || (property = ((FieldEdit)control).getProperty()) == null)) continue;
            if (!this.opEntityFields.containsKey(property.getParent())) {
                this.opEntityFields.put(property.getParent(), new HashSet());
            }
            this.opEntityFields.get(property.getParent()).add(key);
        }
        return this.opEntityFields;
    }

    protected Set<Object> getOperateIds() {
        LinkedHashSet<Object> ids = new LinkedHashSet<Object>();
        ListSelectedRowCollection listSelectedRowCollection = this.getListSelectedData();
        if (listSelectedRowCollection == null || listSelectedRowCollection.isEmpty()) {
            return ids;
        }
        for (ListSelectedRow listSelectedRowValue : listSelectedRowCollection) {
            ids.add(listSelectedRowValue.getPrimaryKeyValue());
        }
        return ids;
    }

    @Deprecated
    protected boolean isNeedCheckChanged() {
        return false;
    }

    protected Boolean isAllUserApp() {
        if (this.allUserApp == null) {
            AppInfo app;
            String appId = this.getView().getFormShowParameter().getAppId();
            this.allUserApp = StringUtils.isBlank((CharSequence)appId) ? Boolean.valueOf(false) : ((app = AppMetadataCache.getAppInfo((String)appId)) != null ? Boolean.valueOf(app.isAllUserApp()) : Boolean.FALSE);
        }
        return this.allUserApp;
    }

    protected boolean beforeInvokeOperation(OperationResult result) {
        if (!super.beforeInvokeOperation(result)) {
            this.getOperateLog().info("DefaultEntityOperate.beforeInvokeOperation\uff1asuper.beforeInvokeOperation return false");
            return Boolean.FALSE;
        }
        if (this.needCheckDBDataVersion() && !this.checkDBDataVersion()) {
            this.getOperateLog().info("DefaultEntityOperate.beforeInvokeOperation\uff1asuper.beforeInvokeOperation return false");
            return false;
        }
        this.getOption().setVariableValue("appnumber", this.getView().getFormShowParameter().getAppId());
        boolean batchFinish = this.isBatchFinish();
        if (!batchFinish && this.needSplitBatch()) {
            this.getOperateLog().info("DefaultEntityOperate.beforeInvokeOperation: needSplitBatch");
            OpBatchExecutePlugin.showOpBatchForm(this);
            return Boolean.FALSE;
        }
        long maxLockTime = Long.getLong("mutex.maxsessiontimeout_s", 600L);
        this.getOption().setVariableValue("autoclearlostlock", "true");
        this.getOption().setVariableValue("maxlocktime_s", Long.toString(maxLockTime));
        this.getOperateLog().info("DefaultEntityOperate.beforeInvokeOperation\uff1areturn true");
        return true;
    }

    protected int checkRightInListForm(MainEntityType mainEntityType, OperationResult result) {
        if (!this.needSelectData()) {
            this.getOperateLog().info("DefaultEntityOperate.checkRightInListForm: needSelectData");
            return super.checkRightInListForm(mainEntityType, result);
        }
        this.doPermission(result, this.getPermissionItemId(), 0L);
        if (!result.isSuccess()) {
            this.getOperateLog().info("DefaultEntityOperate.checkRightInListForm: no right, return");
            return 0;
        }
        this.doDataRuleCheckInList(result);
        if (!result.isSuccess()) {
            this.getOperateLog().info("DefaultEntityOperate.checkRightInListForm: no right, return");
            return 0;
        }
        this.getOption().removeVariable("ishasright");
        this.getOption().setVariableValue("currbizappid", ShowFormHelper.getBizAppId((FormShowParameter)this.getView().getFormShowParameter()));
        this.getOperateLog().info("DefaultEntityOperate.checkRightInListForm: need check data right in operation mservice, pass");
        return 1;
    }

    private void doDataRuleCheckInList(OperationResult result) {
        if (!DefaultEntityOperate.hasEnableOldDataRule() && !this.getListSelectedData().isEmpty()) {
            FormViewPluginProxy formViewPluginProxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
            BeforeDoCheckDataPermissionArgs checkArgs = new BeforeDoCheckDataPermissionArgs((FormOperate)this);
            checkArgs.setListSelectedData(this.getListSelectedData());
            formViewPluginProxy.fireBeforeCheckDataPermission(checkArgs);
            if (checkArgs.isCancel()) {
                ValidateResult validateResult = new ValidateResult();
                ValidationErrorInfo info = new ValidationErrorInfo("", (Object)"", 0, 0, "001", "", checkArgs.getCancelMessage(), ErrorLevel.Error);
                validateResult.addErrorInfo((OperateErrorInfo)info);
                result.setSuccess(false);
                result.getValidateResult().addValidateError("permission", validateResult);
            }
            if (checkArgs.isSkipCheckDataPermission()) {
                this.getOption().getVariables().put("skipCheckDataPermission", "true");
            }
        }
    }

    private static boolean hasEnableOldDataRule() {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"perm_olddataruleenable");
        Map rets = BusinessDataReader.loadFromCache((Object[])new Object[]{1L}, (DynamicObjectType)type);
        DynamicObject dObj = (DynamicObject)rets.get(1L);
        if (dObj == null) {
            return true;
        }
        return dObj.getBoolean("enable_olddatarule");
    }

    public OperationResult callEntityOperate() {
        String val;
        OperationResult operationResult;
        boolean batchFinish;
        this.getOperateLog().info("DefaultEntityOperate.callEntityOperate: begin");
        Map customParams = new HashMap();
        String customParamStr = this.getView().getPageCache().get("datarule_customparams");
        if (StringUtils.isNotBlank((CharSequence)customParamStr)) {
            customParams = (Map)SerializationUtils.fromJsonString((String)customParamStr, Map.class);
        }
        if (!customParams.isEmpty()) {
            for (Map.Entry entry : customParams.entrySet()) {
                this.getOption().setVariableValue((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (batchFinish = this.isBatchFinish()) {
            this.getOperateLog().info("DefaultEntityOperate.callEntityOperate: batchFinish");
            String resultString = this.getOption().getVariableValue("batchop_result", "");
            operationResult = (OperationResult)DataEntitySerializer.deSerializerFromString((String)resultString, (IDataEntityType)OrmUtils.getDataEntityType(OperationResult.class));
            return operationResult;
        }
        if (StringUtils.isNotBlank((CharSequence)this.getPermissionEntityId())) {
            this.getOption().setVariableValue("permissionentityid", this.getPermissionEntityId());
        }
        String modelTypeForWf = this.getView().getFormShowParameter().getFormConfig().getModelType();
        this.getOption().setVariableValue("modeltypeforwf", modelTypeForWf);
        String modelType = this.getView().getFormShowParameter().getFormConfig().getModelType();
        String scene = this.getScene(this.getView());
        this.getOption().setVariableValue("showscene", scene);
        IWorkflowService workFlowService = (IWorkflowService)ServiceFactory.getService(IWorkflowService.class);
        if (this.isRemoteInvoke()) {
            Object[] ids = this.getOperateIds().toArray();
            if (this.getOperateLog().isWriteLog()) {
                String info = String.format("DefaultEntityOperate.callEntityOperate: call OperationServiceHelper.executeOperate(%s, %s, [%s], option)", this.getOperateKey(), this.getEntityId(), ids.length < 3 ? StringUtils.join((Object[])ids, (String)",") : ids[0] + "," + ids[1] + "," + ids[2] + "... total " + String.valueOf(ids.length));
                this.getOperateLog().info(info);
            }
            operationResult = this.remoteInvokeOperation(ids);
            this.getOperateLog().info("DefaultEntityOperate.callEntityOperate: OperationServiceHelper.executeOperate() return");
        } else {
            this.getOperateLog().info("DefaultEntityOperate.callEntityOperate: call invokeBillOperation()");
            operationResult = this.invokeBillOperation();
        }
        Map opResultMap = operationResult.getCustomData();
        logger.info("callEntityOperate operationResult.getCustomData():" + opResultMap);
        if (null != opResultMap && !opResultMap.isEmpty()) {
            for (Map.Entry entry : opResultMap.entrySet()) {
                this.getOption().setVariableValue((String)entry.getKey(), (String)entry.getValue());
            }
        }
        logger.info("callEntityOperate getOption().getVariables():" + this.getOption().getVariables());
        Object callBackFlag = this.getOption().getVariables().get("WfSensitiveCallBackFlag");
        Boolean bl = Boolean.valueOf(callBackFlag == null ? "false" : callBackFlag.toString());
        if (!bl.booleanValue() && "true".equals(this.getOption().getVariables().get("openSensitiveFieldPage"))) {
            this.openSensitiveFieldPage(scene);
            OperationResult result = new OperationResult();
            result.setSuccess(false);
            result.setNeedWfAssignPersons(true);
            return result;
        }
        if (operationResult != null && !operationResult.isSuccess() && operationResult.isNeedWfAssignPersons() && !Boolean.parseBoolean((String)this.getOption().getVariables().get("wfAssignCallbackFlag")) && (val = (String)this.getOption().getVariables().get("procdefid")) != null && val.length() > 0) {
            DynamicObject dataEntity = this.getView().getModel().getDataEntity();
            if (("mobileform".equalsIgnoreCase(modelType) || "list".equalsIgnoreCase(modelType)) && this.getListSelectedData() != null && this.getListSelectedData().size() > 0 && this.getListSelectedData().get(0) != null) {
                Object pk = this.getListSelectedData().get(0).getPrimaryKeyValue();
                MainEntityType type = EntityMetadataCache.getDataEntityType((String)this.getEntityId());
                dataEntity = BusinessDataReader.loadSingle((Object)pk, (DynamicObjectType)type);
            }
            this.getOption().setVariableValue("parentPageId", this.getPageId());
            FormShowParameter para = workFlowService.getAllowPersonParameter(this.getOption().getVariables(), dataEntity, new CloseCallBack(WfAssignNextPersonCloseCallBack.class.getName(), "wfAssignNextAllowPerson"), scene);
            if (para != null) {
                Object taskdefinitionkey;
                this.getView().showForm(para);
                String opKey = this instanceof ICombinOperate ? ((ICombinOperate)this).getOriOperateKey() : this.getOperateKey();
                IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
                cache.put("operateKey", opKey);
                Map optionVariables = this.getOption().getVariables();
                if (optionVariables != null) {
                    cache.put("optionVariables", SerializationUtils.toJsonString((Object)optionVariables));
                }
                cache.put("taskdefinitionkey", null != (taskdefinitionkey = para.getCustomParam("taskdefinitionkey")) ? taskdefinitionkey.toString() : "");
            }
        }
        this.getOperateLog().info("DefaultEntityOperate.callEntityOperate: retrun");
        return operationResult;
    }

    protected OperationResult remoteInvokeOperation(Object[] ids) {
        return OperationServiceHelper.executeOperate((String)this.getOperateKey(), (String)this.getEntityId(), (Object[])ids, (OperateOption)this.getOption());
    }

    protected OperationResult localInvokeOperation(Set<Object> ids) {
        OperationServiceImpl operationService = new OperationServiceImpl();
        return operationService.localInvokeOperation(this.getOperateKey(), this.getView().getModel().getDataEntityType().getName(), ids.toArray(), this.getOption());
    }

    private void openSensitiveFieldPage(String scene) {
        String sensitiveFieldInfosStr = (String)this.getOption().getVariables().get("sensitiveFieldInfos");
        IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
        cache.put("operateKey", this.getOperateKey());
        cache.put("optionVariables", SerializationUtils.toJsonString((Object)this.getOption().getVariables()));
        CloseCallBack closeCallback = new CloseCallBack(WfSensitiveCloseCallBack.class.getName(), "wfSensitiveCloseCallBack");
        if ("pc".equals(scene)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("wf_sensitivfiledchange");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCloseCallBack(closeCallback);
            formShowParameter.setCustomParam("sensitivefieldinfo", (Object)sensitiveFieldInfosStr);
            this.getView().showForm(formShowParameter);
        } else {
            MobileFormShowParameter mFormShowParameter = new MobileFormShowParameter();
            mFormShowParameter.setFormId("wf_sensitivfiledmobile");
            mFormShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            StyleCss sc = new StyleCss();
            sc.setHeight("180px");
            sc.setWidth("260px");
            mFormShowParameter.getOpenStyle().setInlineStyleCss(sc);
            HashMap<String, String> m = new HashMap<String, String>(1);
            m.put("position", "center");
            mFormShowParameter.getOpenStyle().setCustParam(m);
            mFormShowParameter.setCloseCallBack(closeCallback);
            mFormShowParameter.setCustomParam("sensitivefieldinfo", (Object)sensitiveFieldInfosStr);
            this.getView().showForm((FormShowParameter)mFormShowParameter);
        }
    }

    protected OperationResult invokeBillOperation() {
        OperationResult opResult = this.callBillOperationService();
        return opResult;
    }

    protected OperationResult callBillOperationService() {
        this.getOperateLog().info("DefaultEntityOperate.callBillOperationService: begin");
        Set<Object> ids = this.getOperateIds();
        if (ids.isEmpty()) {
            Object pkValue = this.getView().getModel().getDataEntity().getPkValue();
            PKFieldProp pkProp = (PKFieldProp)this.getView().getModel().getDataEntityType().getPrimaryKey();
            if (pkProp.getValueComparator().compareValue(pkValue)) {
                OperationResult errResult = new OperationResult();
                errResult.setSuccess(false);
                errResult.setShowMessage(false);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002", (String)"DefaultEntityOperate_0", (String)BOS_ENTITY_BUSINESS, (Object[])new Object[0]));
                return errResult;
            }
            ids.add(pkValue);
        }
        if (this.getOperateLog().isWriteLog()) {
            String info = String.format("DefaultEntityOperate.callBillOperationService: operationService.localInvokeOperation(%s, %s, [%s], option)", this.getOperateKey(), this.getEntityId(), StringUtils.join((Object[])ids.toArray(), (String)","));
            this.getOperateLog().info(info);
        }
        OperationResult opResult = this.localInvokeOperation(ids);
        this.getOperateLog().info("DefaultEntityOperate.callBillOperationService: operationService.localInvokeOperation return");
        if (opResult != null && !opResult.getSuccessPkIds().isEmpty()) {
            this.syncDataFromDB(opResult);
            this.notifyListViewChanged();
        }
        return opResult;
    }

    protected void notifyListViewChanged() {
        IFormView pView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (pView instanceof IListView) {
            IPageCache pageCache = (IPageCache)pView.getService(IPageCache.class);
            pageCache.put("listdatachanged", "1");
        }
    }

    protected void syncDataFromDB(OperationResult opResult) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_OPERATE, (String)"DefaultEntityOperate.syncDataFromDB");){
            this.getOperateLog().info("DefaultEntityOperate.syncDataFromDB: begin");
            Set<String> loadKeys = this.getOperationFields();
            if (loadKeys.isEmpty()) {
                return;
            }
            IBillModel model = (IBillModel)this.getView().getModel();
            model.beginInit();
            model.syncDataFromDB(loadKeys);
            model.endInit();
            this.getView().getModel().setDataChanged(false);
            this.getOperateLog().info("DefaultEntityOperate.syncDataFromDB: end");
            this.updateOperationFields(opResult);
        }
    }

    protected void updateOperationFields(OperationResult opResult) {
        this.getOperateLog().info("DefaultEntityOperate.updateOperationFields: begin");
        Map<IDataEntityType, Set<String>> updateFields = this.getOperationEntityFields();
        HashSet<String> entryKeys = new HashSet<String>();
        HashSet<String> subEntryKeys = new HashSet<String>();
        MainEntityType mainType = this.getView().getModel().getDataEntityType();
        for (Map.Entry<IDataEntityType, Set<String>> entityItem : updateFields.entrySet()) {
            if (entityItem.getKey() instanceof SubEntryType) {
                subEntryKeys.add(entityItem.getKey().getName());
                continue;
            }
            if (entityItem.getKey() instanceof EntryType) {
                entryKeys.add(entityItem.getKey().getName());
                EntryType entity = (EntryType)entityItem.getKey();
                for (IDataEntityProperty property : entity.getProperties()) {
                    if (!(property instanceof SubEntryProp)) continue;
                    subEntryKeys.add(property.getName());
                }
                continue;
            }
            if (!(entityItem.getKey() instanceof MainEntityType)) continue;
            for (String key : entityItem.getValue()) {
                if (this.getView().getControl(key) == null) continue;
                this.getView().updateView(key);
            }
            RuleContainer ruleContaiber = (RuleContainer)this.getView().getService(RuleContainer.class);
            ArrayList list = new ArrayList();
            list.add(new RowDataEntity(0, this.getView().getModel().getDataEntity()));
            RaiseEventSource s = new RaiseEventSource(RaiseEventType.Initialized, (List)list, (IDataEntityType)mainType);
            ruleContaiber.raise(s, (RuleExecuteContext)new FormRuleExecuteContext(this.getView()));
        }
        for (String entryKey : entryKeys) {
            if (this.getView().getControl(entryKey) == null) continue;
            int rowIndex = this.getView().getModel().getEntryCurrentRowIndex(entryKey);
            this.getView().updateView(entryKey);
            this.getView().getModel().setEntryCurrentRowIndex(entryKey, rowIndex);
        }
        for (String subEntryKey : subEntryKeys) {
            if (this.getView().getControl(subEntryKey) == null) continue;
            int rowIndex = this.getView().getModel().getEntryCurrentRowIndex(subEntryKey);
            this.getView().updateView(subEntryKey);
            this.getView().getModel().setEntryCurrentRowIndex(subEntryKey, rowIndex);
        }
        String formId = this.getView().getFormShowParameter().getFormId();
        List controls = FormMetadataCache.getRootControl((String)formId).getItems();
        ArrayList<String> AttachmentPanelKeys = new ArrayList<String>();
        this.getAttachmentPanelKeys(controls, AttachmentPanelKeys);
        for (String AttachmentPanelKey : AttachmentPanelKeys) {
            this.getView().updateView(AttachmentPanelKey);
        }
        ArrayList<String> flexEditKeys = new ArrayList<String>();
        this.getFlexEdits(controls, flexEditKeys);
        BindingContext bindingContext = new BindingContext(null, -1);
        for (String flexEditKey : flexEditKeys) {
            FlexEdit flexEdit = (FlexEdit)this.getView().getControl(flexEditKey);
            flexEdit.splitUnlock(bindingContext);
        }
        this.getOperateLog().info("DefaultEntityOperate.updateOperationFields: end");
    }

    private void getAttachmentPanelKeys(List<Control> controls, List<String> panelKeys) {
        for (Control control : controls) {
            if (control instanceof IAttachmentPanel) {
                panelKeys.add(control.getKey());
                continue;
            }
            if (!(control instanceof Container)) continue;
            controls = ((Container)control).getItems();
            this.getAttachmentPanelKeys(controls, panelKeys);
        }
    }

    private void getFlexEdits(List<Control> controls, List<String> flexEditKeys) {
        for (Control control : controls) {
            if (control instanceof FlexEdit) {
                flexEditKeys.add(control.getKey());
                continue;
            }
            if (!(control instanceof Container)) continue;
            controls = ((Container)control).getItems();
            this.getFlexEdits(controls, flexEditKeys);
        }
    }

    protected void updateAttachment() {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_OPERATE, (String)"DefaultEntityOperate.updateAttachment");){
            Map propCollections = this.getView().getModel().getDataEntityType().getAllFields();
            for (Map.Entry propMap : propCollections.entrySet()) {
                if (!(propMap.getValue() instanceof IAttachmentProp)) continue;
                String attachmentKey = ((IDataEntityProperty)propMap.getValue()).getName();
                this.updateAttachmentProp(attachmentKey);
            }
        }
    }

    private void updateAttachmentProp(String attachmentKey) {
        block11: {
            IDataEntityProperty property;
            block10: {
                DynamicObject row;
                int j;
                MainEntityType mainType = this.getView().getModel().getDataEntityType();
                property = mainType.findProperty(attachmentKey);
                if (!(property.getParent() instanceof MainEntityType)) break block10;
                DynamicObjectCollection attEntryRows = (DynamicObjectCollection)this.getView().getModel().getValue(attachmentKey);
                ArrayList<Long> attPKIds = new ArrayList<Long>();
                ArrayList<Boolean> bizChangeBak = new ArrayList<Boolean>(attEntryRows.size());
                boolean parentBizChanged = false;
                DynamicObject parentDynamicObject = null;
                for (j = 0; j < attEntryRows.size(); ++j) {
                    row = (DynamicObject)attEntryRows.get(j);
                    boolean bizChanged = row.getDataEntityState().isBizChanged();
                    bizChangeBak.add(bizChanged);
                    Long attPKId = row.getLong("fbasedataid_id");
                    if (attPKId != null && Long.compare(0L, attPKId) != 0) {
                        attPKIds.add(attPKId);
                    }
                    if (j != 0 || !(row.getParent() instanceof DynamicObject)) continue;
                    parentDynamicObject = (DynamicObject)row.getParent();
                    parentBizChanged = parentDynamicObject.getDataEntityState().isBizChanged();
                }
                this.getView().getModel().setValue(attachmentKey, (Object)attPKIds.toArray(new Long[attPKIds.size()]));
                for (j = 0; j < attEntryRows.size(); ++j) {
                    row = (DynamicObject)attEntryRows.get(j);
                    row.getDataEntityState().setBizChanged(((Boolean)bizChangeBak.get(j)).booleanValue());
                }
                if (parentDynamicObject != null) {
                    parentDynamicObject.getDataEntityState().setBizChanged(parentBizChanged);
                }
                for (String attCtlKey : this.getAttCtlKeys(attachmentKey)) {
                    this.getView().updateView(attCtlKey);
                }
                break block11;
            }
            if (!(property.getParent() instanceof EntryType)) break block11;
            ArrayList<Long> attPKIds = new ArrayList<Long>();
            DynamicObjectCollection entryEntityCollection = this.getView().getModel().getEntryEntity(property.getParent().getName());
            if (entryEntityCollection == null) {
                return;
            }
            for (int i = 0; i < entryEntityCollection.size(); ++i) {
                DynamicObjectCollection attEntryRows;
                DynamicObject entryrow = (DynamicObject)entryEntityCollection.get(i);
                DynamicObjectCollection dynamicObjectCollection = attEntryRows = entryrow.get(attachmentKey) == null ? null : (DynamicObjectCollection)entryrow.get(attachmentKey);
                if (attEntryRows == null) continue;
                attPKIds.clear();
                ArrayList<Boolean> bizChangeBak = new ArrayList<Boolean>(attEntryRows.size());
                for (DynamicObject row : attEntryRows) {
                    boolean bizChanged = row.getDataEntityState().isBizChanged();
                    bizChangeBak.add(bizChanged);
                    Long attPKId = row.getLong("fbasedataid_id");
                    if (attPKId == null || Long.compare(0L, attPKId) == 0) continue;
                    attPKIds.add(attPKId);
                }
                this.getView().getModel().setValue(attachmentKey, (Object)attPKIds.toArray(new Long[attPKIds.size()]), i);
                for (int j = 0; j < attEntryRows.size(); ++j) {
                    DynamicObject row;
                    row = (DynamicObject)attEntryRows.get(j);
                    row.getDataEntityState().setBizChanged(((Boolean)bizChangeBak.get(j)).booleanValue());
                }
                for (String attCtlKey : this.getAttCtlKeys(attachmentKey)) {
                    this.getView().updateView(attCtlKey, i);
                }
            }
        }
    }

    protected void afterOperationClose(OperationResult result) {
        this.getOperateLog().info("DefaultEntityOperate.afterOperationClose: begin");
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("validationwarn", (AbstractOperate)this);
        InteractionHandler.doInteraction((IFormView)this.getView(), (IInteractionRequest)result, (OperateOption)this.getOption(), (ConfirmCallBackListener)confirmCallBacks);
        if (this.isShowMessage(result)) {
            if (result.isSuccess() && result.getAllErrorOrValidateInfo().isEmpty() && StringUtils.isBlank((CharSequence)result.getMessage())) {
                this.showSuccessMessage();
            } else if (!this.uniqueValidatorResult(result)) {
                this.getView().showOperationResult(result, this.getOperateName().toString());
            }
        }
        if (result.isSuccess()) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_OPERATE, (String)(((Object)((Object)this)).getClass().getSimpleName() + ".invokeNextOperation"));){
                this.invokeNextOperation(result);
            }
        }
    }

    private boolean containsEntryType(List<String> fieldKeys, Set<String> entryTypeKeys, Set<String> otherTypeKeys) {
        Objects.requireNonNull(entryTypeKeys);
        Objects.requireNonNull(otherTypeKeys);
        Objects.requireNonNull(fieldKeys);
        boolean result = false;
        for (String key : fieldKeys) {
            if (otherTypeKeys.contains(key)) continue;
            if (entryTypeKeys.contains(key)) {
                result = true;
                continue;
            }
            IDataEntityProperty prop = this.getView().getModel().getProperty(key);
            if (prop.getParent() instanceof EntryType || prop.getParent() instanceof SubEntryType) {
                result = true;
                entryTypeKeys.add(key);
                continue;
            }
            otherTypeKeys.add(key);
        }
        return result;
    }

    private List<String> getAttCtlKeys(String attPropKey) {
        MetadataService metadataService = (MetadataService)ServiceFactory.getService(MetadataService.class);
        String ctlStr = metadataService.loadFormRuntimeMeta(this.getView().getFormShowParameter().getFormId(), RuntimeMetaType.Control.getValue(), "_bindermap_");
        BinderMap binderMap = StringUtils.isBlank((CharSequence)ctlStr) ? null : (BinderMap)ControlTypes.fromJsonString((String)ctlStr);
        ArrayList<String> relatedKeys = new ArrayList<String>();
        ArrayList<String> sf = null;
        if (binderMap != null) {
            sf = (List)binderMap.getMap().get(attPropKey.toLowerCase());
        }
        if (sf == null) {
            sf = new ArrayList<String>(10);
        }
        sf.add(attPropKey);
        for (String key : sf) {
            Control ctl = this.getView().getControl(key);
            if (!(ctl instanceof FieldEdit) || !StringUtils.equalsIgnoreCase((CharSequence)((FieldEdit)ctl).getFieldKey(), (CharSequence)attPropKey)) continue;
            relatedKeys.add(key);
        }
        return relatedKeys;
    }

    private boolean uniqueValidatorResult(OperationResult result) {
        List resultErrors = result.getValidateResult().getValidateErrors();
        if (!(this.getView() instanceof IMobileView)) {
            HashSet<String> entryTypeKeys = new HashSet<String>();
            HashSet<String> otherTypeKeys = new HashSet<String>();
            HashMap map = new HashMap();
            for (ValidateResult res : resultErrors) {
                GroupFieldsUniqueValidateResult validateResult;
                Object fieldKeys;
                if (!(res instanceof GroupFieldsUniqueValidateResult) || !((GroupFieldsUniqueValidateResult)res).isShowUniqueResult() || this.containsEntryType((List<String>)(fieldKeys = (validateResult = (GroupFieldsUniqueValidateResult)res).getFieldKeys()), entryTypeKeys, otherTypeKeys)) continue;
                fieldKeys.forEach(arg_0 -> DefaultEntityOperate.lambda$uniqueValidatorResult$0(map, (List)fieldKeys, arg_0));
            }
            List fieldTips = map.entrySet().stream().map(mapper -> {
                IDataEntityProperty prop = this.getView().getModel().getProperty((String)mapper.getKey());
                if (prop.getParent() instanceof EntryType || prop.getParent() instanceof SubEntryType) {
                    return null;
                }
                FieldTip fieldTip = new FieldTip();
                fieldTip.setFieldKey((String)mapper.getKey());
                fieldTip.setLevel(FieldTip.FieldTipsLevel.Info);
                fieldTip.setSuccess(false);
                fieldTip.setTipsType(FieldTip.FieldTipsTypes.others);
                fieldTip.setTip(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u5b58\u5728", (String)"DefaultEntityOperate_6", (String)BOS_ENTITY_BUSINESS, (Object[])new Object[0]));
                DeleteRule deleteRule = new DeleteRule();
                deleteRule.setAction("isChange");
                deleteRule.setFields(((List)mapper.getValue()).stream().distinct().collect(Collectors.toList()));
                fieldTip.setDeleteRule(deleteRule);
                return fieldTip;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            this.getView().showFieldTips(fieldTips);
        }
        if (this.getOperateIds().size() > 1 || resultErrors.size() < 2) {
            return false;
        }
        ArrayList<GroupFieldsUniqueValidateResult> uniqueResults = new ArrayList<GroupFieldsUniqueValidateResult>();
        ArrayList<GroupFieldsUniqueValidateResult> singleUniqueResults = new ArrayList<GroupFieldsUniqueValidateResult>();
        boolean hasErrorLevel = false;
        for (ValidateResult res : resultErrors) {
            List errorInfos;
            if (res instanceof GroupFieldsUniqueValidateResult) {
                if (((GroupFieldsUniqueValidateResult)res).getFieldCaptions().size() > 1) {
                    uniqueResults.add((GroupFieldsUniqueValidateResult)res);
                } else {
                    singleUniqueResults.add((GroupFieldsUniqueValidateResult)res);
                }
            }
            if ((errorInfos = res.getAllErrorInfo()) == null) continue;
            for (OperateErrorInfo info : errorInfos) {
                if (info.getLevel() != ErrorLevel.FatalError) continue;
                hasErrorLevel = true;
            }
        }
        if (uniqueResults.size() + singleUniqueResults.size() < 2 || uniqueResults.size() == 1 && singleUniqueResults.size() == 1) {
            return false;
        }
        StringBuilder validteMsg = new StringBuilder();
        if (uniqueResults.size() > 1) {
            String msg = String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u5b57\u6bb5\u5df2\u5b58\u5728%2$s", (String)"DefaultEntityOperate_1", (String)BOS_ENTITY_BUSINESS, (Object[])new Object[0]), uniqueResults.size(), "\uff08");
            validteMsg.append(msg);
            for (int i = 0; i < uniqueResults.size(); ++i) {
                if (i != uniqueResults.size() - 1) {
                    validteMsg.append(((GroupFieldsUniqueValidateResult)uniqueResults.get(i)).getFieldCaptions().stream().map(name -> "\u201c" + name + "\u201d").collect(Collectors.joining("\u3001")));
                    validteMsg.append(ResManager.loadKDString((String)"\u4e3a\u4e00\u7ec4\uff1b", (String)"DefaultEntityOperate_2", (String)BOS_ENTITY_BUSINESS, (Object[])new Object[0]));
                    continue;
                }
                validteMsg.append(((GroupFieldsUniqueValidateResult)uniqueResults.get(i)).getFieldCaptions().stream().map(name -> "\u201c" + name + "\u201d").collect(Collectors.joining("\u3001")));
                validteMsg.append(ResManager.loadKDString((String)"\u4e3a\u4e00\u7ec4\uff09\uff0c\u8bf7\u6bcf\u7ec4\u81f3\u5c11\u4fee\u6539\u4e00\u9879\u3002", (String)"DefaultEntityOperate_3", (String)BOS_ENTITY_BUSINESS, (Object[])new Object[0]));
            }
        } else if (uniqueResults.size() == 1) {
            String message = ((OperateErrorInfo)((GroupFieldsUniqueValidateResult)uniqueResults.get(0)).getAllErrorInfo().get(0)).getMessage();
            if (message.contains(":")) {
                message = message.substring(message.indexOf(58) + 1);
            }
            validteMsg = new StringBuilder(message);
        }
        StringBuilder singlValidteMsg = new StringBuilder();
        if (singleUniqueResults.size() > 1) {
            for (int i = 0; i < singleUniqueResults.size(); ++i) {
                if (i != singleUniqueResults.size() - 1) {
                    singlValidteMsg.append('\u201c').append((String)((GroupFieldsUniqueValidateResult)singleUniqueResults.get(i)).getFieldCaptions().get(0)).append('\u201d').append('\u3001');
                    continue;
                }
                singlValidteMsg.append('\u201c').append((String)((GroupFieldsUniqueValidateResult)singleUniqueResults.get(i)).getFieldCaptions().get(0)).append('\u201d');
            }
            String message = String.format(ResManager.loadKDString((String)"%s\u5747\u5df2\u5b58\u5728\u3002", (String)"DefaultEntityOperate_4", (String)BOS_ENTITY_BUSINESS, (Object[])new Object[0]), singlValidteMsg.toString());
            singlValidteMsg = new StringBuilder(message);
        } else if (singleUniqueResults.size() == 1) {
            String message = ((OperateErrorInfo)((GroupFieldsUniqueValidateResult)singleUniqueResults.get(0)).getAllErrorInfo().get(0)).getMessage();
            if (message.contains(":")) {
                message = message.substring(message.indexOf(58) + 1);
            }
            singlValidteMsg = new StringBuilder(message);
        }
        String msg = singlValidteMsg.append('\n').append((CharSequence)validteMsg).toString();
        if ((msg.startsWith("\n") || msg.endsWith("\n")) && msg.length() < 40) {
            if (hasErrorLevel) {
                this.getView().showErrorNotification(msg);
            } else {
                this.getView().showTipNotification(msg);
            }
        } else {
            boolean isWeb = !"mobile".equals(RequestContext.get().getClient()) && !(this.getView() instanceof IMobileView);
            FormShowParameter parameters = new FormShowParameter();
            parameters.getOpenStyle().setShowType(isWeb ? ShowType.Modal : ShowType.Floating);
            parameters.setFormId(isWeb ? "bos_uniquevalidaresult" : "bos_mobuniquevalidaresult");
            parameters.setCustomParam("validteMsg", (Object)msg);
            this.getView().showForm(parameters);
        }
        if (this.getView() instanceof AbstractFormView) {
            ((AbstractFormView)this.getView()).showOperationAllFieldLoc(result);
        }
        return true;
    }

    protected void invokeNextOperation(OperationResult opResult) {
        if (this.needInvokeNextCloseOperation()) {
            this.getView().close();
        }
    }

    private boolean needInvokeNextCloseOperation() {
        String nextOperationKey = (String)this.getParameter().get("afterOperation");
        this.getOperateLog().info(String.format("invokeNextOperation: %s", nextOperationKey));
        return !(this.getView() instanceof IListView) && StringUtils.equalsIgnoreCase((CharSequence)"close", (CharSequence)nextOperationKey);
    }

    protected boolean isShowMessage(OperationResult operationResult) {
        if (operationResult != null && !operationResult.isShowMessage()) {
            return false;
        }
        RefObject opValue = new RefObject();
        if (this.getOption().tryGetVariableValue("isshowmessage", opValue)) {
            return Boolean.parseBoolean((String)opValue.getValue());
        }
        return true;
    }

    protected void showSuccessMessage() {
        IFormView view = this.getView();
        boolean showInParentView = false;
        if (this.needInvokeNextCloseOperation() && StringUtils.isNotBlank((CharSequence)this.getView().getFormShowParameter().getParentPageId())) {
            view = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
            showInParentView = true;
            if (view == null) {
                view = this.getView();
                showInParentView = false;
            }
        }
        String msg = this.getShowSuccessMsg();
        view.showSuccessNotification(msg);
        if (showInParentView) {
            this.getView().sendFormAction(view);
        }
    }

    protected String getShowSuccessMsg() {
        if (this.getSuccessMsg() == null || StringUtils.isBlank((CharSequence)this.getSuccessMsg().toString())) {
            return String.format(ResManager.loadKDString((String)"%s\u6210\u529f\u3002", (String)"DefaultEntityOperate_5", (String)BOS_ENTITY_BUSINESS, (Object[])new Object[0]), this.getOperateName().toString());
        }
        return this.getSuccessMsg().toString();
    }

    protected void requestMutex(String operationKey) {
        Object pkValue = this.getView().getModel().getDataEntity().getPkValue();
        if (pkValue == null || "0".equals(String.valueOf(pkValue))) {
            return;
        }
        String objId = String.valueOf(pkValue);
        boolean isStrict = true;
        if (this.getOption() != null && this.getOption().containsVariable("isStrict")) {
            isStrict = Boolean.parseBoolean(this.getOption().getVariableValue("isStrict"));
        }
        StringBuilder errMsg = new StringBuilder();
        MainEntityType dataEntityType = this.getView().getModel().getDataEntityType();
        String billNo = null;
        if (dataEntityType instanceof BillEntityType && StringUtils.isNotBlank((CharSequence)((BillEntityType)dataEntityType).getBillNo())) {
            billNo = this.getView().getModel().getDataEntity().getString(((BillEntityType)dataEntityType).getBillNo());
        }
        if (StringUtils.isBlank(billNo)) {
            billNo = objId;
        }
        MutexLockInfo lockInfo = new MutexLockInfo(objId, billNo, null, this.getEntityId(), operationKey, isStrict, "default");
        boolean isMutexLocked = MutexHelper.require((IFormView)this.getView(), (MutexLockInfo)lockInfo, (StringBuilder)errMsg);
        this.getOperateLog().info(String.format("requestMutex: %s", isMutexLocked));
        if (!isMutexLocked) {
            this.getView().showErrorNotification(errMsg.toString());
        }
    }

    @Deprecated
    protected int getBatchCount() {
        return this.getBatchSize();
    }

    protected int getBatchSize() {
        String variableValue = this.getOption().getVariableValue("batchop_batchsize", null);
        if (StringUtils.isNotBlank((CharSequence)variableValue)) {
            return Integer.parseInt(variableValue);
        }
        DynamicObject billParamObj = ParameterReader.getBillParameter((String)this.getEntityId());
        if (billParamObj != null && billParamObj.getDataEntityType().getProperties().containsKey((Object)BILLPARAM_OPBATCHCOUNT) && billParamObj.get(BILLPARAM_OPBATCHCOUNT) != null) {
            return (Integer)billParamObj.get(BILLPARAM_OPBATCHCOUNT);
        }
        return 100;
    }

    protected boolean needSplitBatch() {
        GroupProp prop;
        if (!this.isRemoteInvoke()) {
            return false;
        }
        int batchCount = this.getBatchCount();
        if (batchCount <= 0 || batchCount >= this.getOperateIds().size()) {
            return false;
        }
        boolean opSkipBatch = Boolean.parseBoolean(this.getOption().getVariableValue("bos_skip_op_batch", "false"));
        if (opSkipBatch) {
            return false;
        }
        IFormView view = this.getView();
        return !(view instanceof IListView) || ((IListView)view).getTreeListView() == null || ((IListView)view).getTreeListView().getTreeModel() == null || ((IListView)view).getTreeListView().getTreeModel().getGroupProp() == null || !((prop = ((IListView)view).getTreeListView().getTreeModel().getGroupProp()) instanceof ParentBasedataProp);
    }

    protected boolean isBatchFinish() {
        return Boolean.parseBoolean(this.getOption().getVariableValue("batchop_completed", String.valueOf(false)));
    }

    protected void clearAttsCache() {
        IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
        cache.remove("TampAttCache" + this.getView().getPageId());
    }

    protected void setTempAttachmentOption() {
        IAttachmentFieldModelProxy attachmentFieldModel;
        Object pkId;
        IPageCache cache;
        String cacheJsonString;
        MainEntityType dataEntityType = this.getView().getModel().getDataEntityType();
        String formId = dataEntityType.getName();
        String pageId = this.getView().getPageId();
        String billno = "";
        if (dataEntityType instanceof BillEntityType && StringUtils.isNotBlank((CharSequence)((BillEntityType)dataEntityType).getBillNo())) {
            billno = this.getView().getModel().getDataEntity().getString(((BillEntityType)dataEntityType).getBillNo());
        }
        if (!StringUtils.isEmpty((CharSequence)(cacheJsonString = (cache = (IPageCache)this.getView().getService(IPageCache.class)).get("TampAttCache" + this.getView().getPageId())))) {
            HashMap<String, Object> attachmentPanel = new HashMap<String, Object>();
            String appId = this.getView().getFormShowParameter().getFormConfig().getAppId();
            pkId = this.getView().getModel().getDataEntity().getPkValue();
            Map attachmentInfo = (Map)SerializationUtils.fromJsonString((String)cacheJsonString, Map.class);
            attachmentPanel.put("AppId", appId);
            attachmentPanel.put("PkId", pkId);
            attachmentPanel.put("FormId", formId);
            attachmentPanel.put("BillNo", billno);
            attachmentPanel.put("AttachmentInfo", attachmentInfo);
            Map<String, Object> shareAttsMsg = this.getShareAttsMsg(cache, attachmentInfo);
            if (shareAttsMsg.size() > 0) {
                attachmentPanel.put("ShareAttsMsg", shareAttsMsg);
            }
            this.getOption().setVariableValue("AttachmentPanel", SerializationUtils.toJsonString(attachmentPanel));
        }
        if ((attachmentFieldModel = (IAttachmentFieldModelProxy)ServiceFactory.getService(IAttachmentFieldModelProxy.class)).checkIfHasAttProp(formId)) {
            HashMap<String, Object> attachmentField = new HashMap<String, Object>();
            pkId = this.getView().getModel().getDataEntity().getPkValue();
            attachmentField.put("PkId", pkId);
            attachmentField.put("PageId", pageId);
            attachmentField.put("BillNo", billno);
            this.getOption().setVariableValue("AttachmentField", SerializationUtils.toJsonString(attachmentField));
        }
    }

    protected void setRemoveImageOption() {
        String formId = this.getView().getModel().getDataEntityType().getName();
        String appId = this.getView().getFormShowParameter().getFormConfig().getAppId();
        Object pkId = this.getView().getModel().getDataEntity().getPkValue();
        HashMap<String, Object> imageOption = new HashMap<String, Object>();
        imageOption.put("AppId", appId);
        imageOption.put("PkId", pkId);
        imageOption.put("FormId", formId);
        boolean isWeb = !"mobile".equals(RequestContext.get().getClient()) && !(this.getView() instanceof IMobileView);
        imageOption.put("isWeb", isWeb);
        String billno = "";
        MainEntityType dataEntityType = this.getView().getModel().getDataEntityType();
        if (dataEntityType instanceof BillEntityType && StringUtils.isNotBlank((CharSequence)((BillEntityType)dataEntityType).getBillNo())) {
            billno = this.getView().getModel().getDataEntity().getString(((BillEntityType)dataEntityType).getBillNo());
        }
        imageOption.put("billno", billno);
        IPageCache pageCache = this.getView().getPageCache();
        String removeKey = "TempRemoveCache" + this.getView().getPageId();
        String removeStr = pageCache.get(removeKey);
        if (StringUtils.isNotBlank((CharSequence)removeStr)) {
            List cacheList = (List)SerializationUtils.fromJsonString((String)removeStr, List.class);
            Iterator iterator = cacheList.iterator();
            while (iterator.hasNext()) {
                HashMap next = (HashMap)iterator.next();
                String url = String.valueOf(next.get("url"));
                if (FileServiceFactory.getImageFileService().exists(url)) continue;
                iterator.remove();
            }
            if (!CollectionUtils.isEmpty((Collection)cacheList)) {
                imageOption.put("remove", cacheList);
                this.getOption().setVariableValue("RemoveImage", SerializationUtils.toJsonString(imageOption));
            }
        }
    }

    protected Map<String, Object> getShareAttsMsg(IPageCache cache, Map<String, Object> attachmentInfo) {
        HashMap<String, Object> shareAttsMsg = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : attachmentInfo.entrySet()) {
            String attPanelKey = entry.getKey();
            String entityId = cache.get("AttEntityId" + attPanelKey);
            if (StringUtils.isEmpty((CharSequence)entityId)) continue;
            shareAttsMsg.put(attPanelKey, entityId);
        }
        return shareAttsMsg;
    }

    protected boolean hasAttachmentUploading() {
        IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
        String uploadingAttJson = cache.get("UploadingAtt" + this.getView().getPageId());
        return StringUtils.isNotBlank((CharSequence)uploadingAttJson);
    }

    protected boolean hasImgUploading() {
        IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
        String uploadingAttJson = cache.get("UploadingImg:" + this.getView().getPageId());
        return StringUtils.isNotBlank((CharSequence)uploadingAttJson);
    }

    protected boolean hasImgListUploading() {
        IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
        String uploadingAttJson = cache.get("ImageList_UploadingImg:" + this.getView().getPageId());
        return StringUtils.isNotBlank((CharSequence)uploadingAttJson);
    }

    protected boolean checkIntentExist(String callBackId) {
        if (this.getView() instanceof IListView) {
            return true;
        }
        boolean isFromDB = this.getView().getModel().getDataEntity().getDataEntityState().getFromDatabase();
        if (!isFromDB) {
            return true;
        }
        boolean intent = MutexHelper.checkIntent((IFormView)this.getView());
        if (!intent) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(callBackId, (AbstractOperate)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u88ab\u4fee\u6539\uff0c\u8bf7\u5237\u65b0\u540e\u518d\u64cd\u4f5c\u3002", (String)"DefaultEntityOperate_7", (String)BOS_ENTITY_BUSINESS, (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
            return false;
        }
        return true;
    }

    protected boolean requestIntentLock(Object pkId, StringBuilder errMsg) {
        boolean isSuccess = true;
        String entityId = this.getView().getEntityId();
        if (StringUtils.isNotBlank((CharSequence)entityId) && StringUtils.isNotBlank((Object)pkId)) {
            String intentKey = MutexHelper.requireIntent((IFormView)this.getView(), (String)entityId, (Object)String.valueOf(pkId), (StringBuilder)errMsg);
            if (StringUtils.isBlank((CharSequence)intentKey)) {
                return false;
            }
        } else {
            errMsg.append("apply intent lock for ").append(pkId).append(" failed");
            isSuccess = false;
        }
        return isSuccess;
    }

    protected boolean applyILockAfterOperate() {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (!(this.getView() instanceof IListView) && status == OperationStatus.ADDNEW) {
            StringBuilder errMsg = new StringBuilder();
            Object pkValue = this.getView().getModel().getDataEntity().getPkValue();
            return this.requestIntentLock(String.valueOf(pkValue), errMsg);
        }
        return MutexHelper.releaseAndApplyIntent((IFormView)this.getView(), (StringBuilder)new StringBuilder());
    }

    protected boolean isOpenIntentLocks() {
        return MutexHelper.isOpenIntentLocks();
    }

    protected void flexSave(DynamicObject dataEntity) {
        String modelType = this.getView().getFormShowParameter().getFormConfig().getModelType();
        if ("mobilebase".equalsIgnoreCase(modelType) || "mobilebill".equalsIgnoreCase(modelType) || "mobileform".equalsIgnoreCase(modelType)) {
            MainEntityType met = this.getView().getModel().getDataEntityType();
            HashMap<String, List<FlexEdit>> entryFlexEdits = new HashMap<String, List<FlexEdit>>();
            for (IDataEntityProperty prop : met.getAllFields().values()) {
                ArrayList<FlexEdit> flexEditList;
                FlexEdit fe;
                if (!(prop instanceof FlexProp) || (fe = (FlexEdit)this.getView().getControl(prop.getName())) == null) continue;
                Object entryKey = fe.getEntryKey();
                if (StringUtils.isBlank((CharSequence)entryKey)) {
                    entryKey = "head";
                }
                if ((flexEditList = (ArrayList<FlexEdit>)entryFlexEdits.get(entryKey)) == null) {
                    flexEditList = new ArrayList<FlexEdit>();
                    entryFlexEdits.put((String)entryKey, (List<FlexEdit>)flexEditList);
                }
                flexEditList.add(fe);
            }
            HashMap<Integer, List<FlexEditData>> flexEditDataMap = new HashMap<Integer, List<FlexEditData>>(16);
            for (Map.Entry entry : entryFlexEdits.entrySet()) {
                if ("head".equals(entry.getKey())) {
                    for (FlexEdit fe : (List)entry.getValue()) {
                        this.extractFlexData(entryFlexEdits, flexEditDataMap, (String)entry.getKey(), -1);
                    }
                    continue;
                }
                DynamicObjectCollection entries = (DynamicObjectCollection)dataEntity.get((String)entry.getKey());
                for (int i = 0; i < entries.size(); ++i) {
                    this.extractFlexData(entryFlexEdits, flexEditDataMap, (String)entry.getKey(), i);
                }
            }
            for (Map.Entry entry : flexEditDataMap.entrySet()) {
                ArrayList<FlexEntireData> list = new ArrayList<FlexEntireData>(10);
                for (FlexEditData fed : (List)entry.getValue()) {
                    list.add(fed.getFlexEntireData());
                }
                FlexService.batchSaveFlexData((int)((Integer)entry.getKey()), list);
            }
            for (List list : flexEditDataMap.values()) {
                for (FlexEditData fed : list) {
                    if ("head".equals(fed.getEntryKey())) {
                        dataEntity.set(fed.getFlexEdit().getKey() + "_id", (Object)fed.getFlexEntireData().getId());
                        continue;
                    }
                    DynamicObjectCollection entries = (DynamicObjectCollection)dataEntity.get(fed.getEntryKey());
                    if (StringUtils.isNotBlank((CharSequence)fed.getFlexEntireData().concatFlexData())) {
                        DynamicObjectType dt = ((FlexProp)fed.getFlexEdit().getProperty()).getFlexDataType();
                        DynamicObject flexData = new DynamicObject(dt);
                        flexData.set("value", (Object)fed.getFlexEntireData().concatFlexData());
                        ((DynamicObject)entries.get(fed.getRow())).set(fed.getFlexEdit().getKey(), (Object)flexData);
                    }
                    ((DynamicObject)entries.get(fed.getRow())).set(fed.getFlexEdit().getKey() + "_id", (Object)fed.getFlexEntireData().getId());
                }
            }
        }
    }

    protected boolean checkDuplicateSubmit() {
        return DuplicateSubmitHelper.check((IFormView)this.getView());
    }

    protected void clearDuplicateSubmit() {
        DuplicateSubmitHelper.clean((IFormView)this.getView());
    }

    protected void setModelTableOption() {
        TableModelCache cache = new TableModelCache((IRefrencedataProvider)this.getView().getModel(), this.getView().getModel().getDataEntityType(), this.getView().getPageId());
        cache.setSaveOption(this.getOption());
    }

    private void extractFlexData(Map<String, List<FlexEdit>> entryFlexEdits, Map<Integer, List<FlexEditData>> flexEditDataMap, String entryKey, int i) {
        for (FlexEdit fe : entryFlexEdits.get(entryKey)) {
            IDataModel fm = fe.getFlexModel(i);
            FlexEntireData fed = new FlexEntireData();
            fed.setFlexData(fm.getDataEntityType(), fm.getDataEntity());
            Integer flexTypeId = fe.getFlexTypeId();
            FlexEditData flexEditData = new FlexEditData(fe, fed, entryKey, i);
            List<FlexEditData> flexEditDataList = flexEditDataMap.get(flexTypeId);
            if (flexEditDataList == null) {
                flexEditDataList = new ArrayList<FlexEditData>();
                flexEditDataMap.put(flexTypeId, flexEditDataList);
            }
            flexEditDataList.add(flexEditData);
        }
    }

    protected boolean needCheckDBDataVersion() {
        return false;
    }

    protected boolean checkDBDataVersion() {
        if (!(this.getView() instanceof BillView) || !Boolean.parseBoolean(this.getOption().getVariableValue("bos_checkFormDataVersion", "true"))) {
            return true;
        }
        boolean result = (Boolean)DataVersionChangeValidator.getBillStatusValidator().apply(this.getView().getModel().getDataEntity(true));
        if (!result) {
            this.showBillChangeValidationPage();
        }
        return result;
    }

    private void showBillChangeValidationPage() {
        String title = String.format(ResManager.loadKDString((String)"%s\u5931\u8d25", (String)"DefaultEntityOperate_8", (String)BOS_ENTITY_BUSINESS, (Object[])new Object[0]), this.getOperateName());
        String detail = ResManager.loadKDString((String)"\u5f53\u524d\u9875\u9762\u6709\u6570\u636e\u66f4\u65b0\uff0c\u8bf7\u70b9\u51fb\u4e0b\u65b9\u6309\u94ae\u52a0\u8f7d\u6700\u65b0\u6570\u636e", (String)"DefaultEntityOperate_10", (String)BOS_ENTITY_BUSINESS, (Object[])new Object[0]);
        if (this.getView() instanceof IMobileView) {
            HashMap<Integer, String> btnNames = new HashMap<Integer, String>();
            btnNames.put(2, ResManager.loadKDString((String)"\u5237\u65b0", (String)"DefaultEntityOperate_11", (String)BOS_ENTITY_BUSINESS, (Object[])new Object[0]));
            ConfirmCallBackListener confirmListener = new ConfirmCallBackListener("savevalidator_refreshactionid", (AbstractOperate)this);
            this.getView().showConfirm(title, detail, MessageBoxOptions.OK, ConfirmTypes.Default, confirmListener, btnNames);
            return;
        }
        CloseCallBack closeCallback = new CloseCallBack(SaveValidatorCloseCallBack.class.getName(), "savevalidator_refreshactionid");
        FormShowParameter formShowParameter = new FormShowParameter();
        if (this.getView() instanceof IMobileView) {
            formShowParameter = new MobileFormShowParameter();
        }
        formShowParameter.setFormId("bos_savefailedfeedback");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(closeCallback);
        formShowParameter.setShowTitle(false);
        String appId = this.getView().getFormShowParameter().getAppId();
        if (StringUtils.isNotBlank((CharSequence)appId) && !"bos".equals(appId)) {
            formShowParameter.setAppId(this.getView().getFormShowParameter().getAppId());
        }
        formShowParameter.setCustomParam("title", (Object)title);
        formShowParameter.setCustomParam("detail", (Object)detail);
        this.getView().showForm(formShowParameter);
    }

    private static /* synthetic */ void lambda$uniqueValidatorResult$0(Map map, List fieldKeys, String key) {
        map.putIfAbsent(key, new ArrayList());
        ((List)map.get(key)).addAll(fieldKeys);
    }
}

