/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.operate;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.DefaultEntityOperate;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.operate.NavigationCache;
import kd.bos.list.IListView;
import kd.bos.mservice.attachment.AttachmentRemoveSource;
import kd.bos.mservice.svc.attach.IAttachmentFieldModelProxy;
import kd.bos.mservice.svc.attach.IAttachmentModelProxy;
import kd.bos.mservice.svc.attach.IAttachmentProp;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.param.ParameterReader;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.SoftDeleteHandler;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class Delete
extends DefaultEntityOperate {
    @Override
    public void initialize(Map<String, Object> opMeta) {
        super.initialize(opMeta);
        this.setConfirmTypes(ConfirmTypes.Delete);
    }

    @Override
    protected Set<Object> getOperateIds() {
        Set<Object> ids = super.getOperateIds();
        if ("focus".equals(this.getParameter().get("listDelScope"))) {
            ids = new HashSet<Object>();
            Object pkId = this.getListFocusRow().getPrimaryKeyValue();
            if (StringUtils.isBlank((Object)pkId)) {
                return ids;
            }
            ids.add(pkId);
        }
        return ids;
    }

    @Override
    protected boolean beforeInvokeOperation(OperationResult result) {
        boolean res = super.beforeInvokeOperation(result);
        if (res) {
            Map<Object, Map<String, List<Long>>> oldMap;
            OperateOption option = this.getOption();
            Map<Object, List<Map<String, Object>>> map = this.getDeleteAttachmentFieldIds();
            if (map.size() > 0) {
                option.setVariableValue("deleteAttFieldIdsMap", JSON.toJSONString(map));
            }
            if ((oldMap = this.getDelAttachmentFieldIds()).size() > 0) {
                option.setVariableValue("delteAttFieldIdsMap", JSON.toJSONString(oldMap));
            }
        }
        return res;
    }

    private Map<Object, List<Map<String, Object>>> getDeleteAttachmentFieldIds() {
        String entityId = this.getEntityId();
        HashMap<Object, List<Map<String, Object>>> res = new HashMap<Object, List<Map<String, Object>>>();
        Map propCollections = EntityMetadataCache.getDataEntityType((String)entityId).getAllFields();
        for (Map.Entry propMap : propCollections.entrySet()) {
            IDataEntityProperty property = (IDataEntityProperty)propMap.getValue();
            String tableName = property.getAlias();
            if (!(property instanceof IAttachmentProp)) continue;
            String attachmentKey = property.getName();
            List<Object> delPkIds = this.getDelPKIds();
            for (Object delPkId : delPkIds) {
                DynamicObject dynamicObject;
                List list = res.computeIfAbsent(delPkId, k -> new ArrayList());
                IDataEntityType parent = property.getParent();
                if (parent instanceof MainEntityType) {
                    DynamicObjectCollection attCollection;
                    dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)delPkId, (String)entityId);
                    if (dynamicObject == null || CollectionUtils.isEmpty((Collection)(attCollection = dynamicObject.getDynamicObjectCollection(attachmentKey)))) continue;
                    HashMap<String, Object> delMap = new HashMap<String, Object>();
                    delMap.put("isHead", true);
                    delMap.put("isSubEntry", false);
                    delMap.put("tableName", tableName);
                    delMap.put("fid", delPkId);
                    List pIds = attCollection.stream().map(entry -> entry.getLong("fbasedataid_id")).collect(Collectors.toList());
                    delMap.put("attPkIds", pIds);
                    list.add(delMap);
                }
                if (!(parent instanceof EntryType) || (dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)delPkId, (String)entityId)) == null) continue;
                if (parent instanceof SubEntryType) {
                    IDataEntityType entity = parent.getParent();
                    DynamicObjectCollection entityParent = dynamicObject.getDynamicObjectCollection(entity.getName());
                    if (entityParent.isEmpty()) continue;
                    for (DynamicObject object : entityParent) {
                        this.setDeleteMap(tableName, attachmentKey, list, parent, object, true);
                    }
                    continue;
                }
                this.setDeleteMap(tableName, attachmentKey, list, parent, dynamicObject, false);
            }
        }
        return res;
    }

    private void setDeleteMap(String tableName, String attachmentKey, List<Map<String, Object>> list, IDataEntityType parent, DynamicObject preParentDynamicObject, boolean isSubEntry) {
        DynamicObjectCollection entryEntity = preParentDynamicObject.getDynamicObjectCollection(parent.getName());
        for (DynamicObject entry : entryEntity) {
            DynamicObjectCollection attCollection = entry.getDynamicObjectCollection(attachmentKey);
            if (CollectionUtils.isEmpty((Collection)attCollection)) continue;
            HashMap<String, Object> delMap = new HashMap<String, Object>();
            delMap.put("isHead", false);
            delMap.put("tableName", tableName);
            delMap.put("isSubEntry", isSubEntry);
            if (isSubEntry) {
                delMap.put("fdetailid", entry.getPkValue());
            } else {
                delMap.put("fentryid", entry.getPkValue());
            }
            List pIds = attCollection.stream().map(att -> att.getLong("fbasedataid_id")).collect(Collectors.toList());
            delMap.put("attPkIds", pIds);
            list.add(delMap);
        }
    }

    private List<Object> getDelPKIds() {
        ArrayList<Object> res = new ArrayList<Object>();
        if (this.getView() instanceof IBillView) {
            res.add(this.getView().getModel().getDataEntity().getPkValue());
            return res;
        }
        if (this.getView() instanceof IListView) {
            for (ListSelectedRow selectedRow : this.getListSelectedData()) {
                res.add(selectedRow.getPrimaryKeyValue());
            }
            return res;
        }
        return res;
    }

    protected void afterInvokeOperation(OperationResult opResult) {
        super.afterInvokeOperation(opResult);
        if (opResult != null && opResult.isSuccess() && !opResult.getSuccessPkIds().isEmpty()) {
            this.delAttments(opResult);
        }
        if (this.getView() instanceof IListView && opResult != null && !opResult.getSuccessPkIds().isEmpty()) {
            ((IListView)this.getView()).clearSelection();
        }
    }

    private void delAttments(OperationResult opResult) {
        List successPkIds = opResult.getSuccessPkIds();
        String entityId = this.getEntityId();
        IAttachmentModelProxy attachmentModel = (IAttachmentModelProxy)ServiceFactory.getService(IAttachmentModelProxy.class);
        IAttachmentFieldModelProxy attachmentFieldModel = (IAttachmentFieldModelProxy)ServiceFactory.getService(IAttachmentFieldModelProxy.class);
        attachmentModel.batchRemove(entityId, successPkIds);
        String deleteAttFieldIdsMap = "";
        HashMap<String, Set<Object>> attIdDelMap = new HashMap<String, Set<Object>>();
        HashMap<String, Set<Object>> fIdDelMap = new HashMap<String, Set<Object>>();
        HashMap<String, Set<Object>> entryIdDelMap = new HashMap<String, Set<Object>>();
        HashMap<String, Set<Object>> datailIdDelMap = new HashMap<String, Set<Object>>();
        OperateOption option = this.getOption();
        if (option.containsVariable("deleteAttFieldIdsMap")) {
            deleteAttFieldIdsMap = option.getVariableValue("deleteAttFieldIdsMap");
        }
        if (StringUtils.isNotBlank((CharSequence)deleteAttFieldIdsMap)) {
            Set attPkIdsDel;
            String tableName;
            Map map = (Map)JSON.parseObject((String)deleteAttFieldIdsMap, Map.class);
            for (Object e : successPkIds) {
                List delList = (List)map.get(e);
                if (CollectionUtils.isEmpty((Collection)delList)) continue;
                for (Map delMap : delList) {
                    boolean isHead = (Boolean)delMap.get("isHead");
                    boolean isSubEntry = (Boolean)delMap.get("isSubEntry");
                    String tableName2 = String.valueOf(delMap.get("tableName"));
                    List attPkIds = (List)delMap.get("attPkIds");
                    this.genDelIdMap(tableName2, attPkIds, attIdDelMap);
                    if (isHead) {
                        Object fid = delMap.get("fid");
                        this.genDelIdMap(tableName2, fid, fIdDelMap);
                        continue;
                    }
                    if (!isSubEntry) {
                        Object fentryid = delMap.get("fentryid");
                        this.genDelIdMap(tableName2, fentryid, entryIdDelMap);
                        continue;
                    }
                    Object fdetailid = delMap.get("fdetailid");
                    this.genDelIdMap(tableName2, fdetailid, datailIdDelMap);
                }
            }
            for (Map.Entry entry : fIdDelMap.entrySet()) {
                tableName = (String)entry.getKey();
                Set billPkIds = (Set)entry.getValue();
                attPkIdsDel = (Set)attIdDelMap.get(tableName);
                attachmentFieldModel.batchRemoveAtt(entityId, tableName, attPkIdsDel.toArray(), billPkIds.toArray(), AttachmentRemoveSource.HEAD, true);
            }
            for (Map.Entry entry : entryIdDelMap.entrySet()) {
                tableName = (String)entry.getKey();
                Set entryIds = (Set)entry.getValue();
                attPkIdsDel = (Set)attIdDelMap.get(tableName);
                attachmentFieldModel.batchRemoveAtt(entityId, tableName, attPkIdsDel.toArray(), entryIds.toArray(), AttachmentRemoveSource.ENTRY, true);
            }
            for (Map.Entry entry : datailIdDelMap.entrySet()) {
                tableName = (String)entry.getKey();
                Set datailIds = (Set)entry.getValue();
                attPkIdsDel = (Set)attIdDelMap.get(tableName);
                attachmentFieldModel.batchRemoveAtt(entityId, tableName, attPkIdsDel.toArray(), datailIds.toArray(), AttachmentRemoveSource.SUB_ENTRY, true);
            }
        }
    }

    private void genDelIdMap(String tableName, Object ids, Map<String, Set<Object>> delMap) {
        ArrayList<Object> idList = new ArrayList<Object>();
        if (ids instanceof List) {
            idList.addAll((List)ids);
        } else {
            idList.add(ids);
        }
        delMap.computeIfAbsent(tableName, key -> new HashSet()).addAll(idList);
    }

    @Override
    protected void invokeNextOperation(OperationResult opResult) {
        if (this.getView() instanceof IBillView) {
            Object pkValue = this.getView().getModel().getDataEntity().getPkValue();
            DynamicObject blankObj = new DynamicObject((DynamicObjectType)this.getView().getModel().getDataEntityType());
            if (blankObj.containsProperty("id")) {
                blankObj.set("id", pkValue);
            }
            ((IBillModel)this.getView().getModel()).push((Object)blankObj);
            String nextOperationKey = (String)this.getParameter().get("afterOperation");
            if (StringUtils.equalsIgnoreCase((CharSequence)"close", (CharSequence)nextOperationKey)) {
                this.getView().close();
            } else if (StringUtils.equalsIgnoreCase((CharSequence)"new", (CharSequence)nextOperationKey)) {
                this.getView().invokeOperation("new");
            } else {
                this.doNext();
            }
            NavigationCache.delPKValue((IFormView)this.getView(), (Object)pkValue);
        }
    }

    private void doNext() {
        OperateOption nextOption = OperateOption.create();
        nextOption.setVariableValue("invokeAfterDelete", String.valueOf(true));
        OperationResult toNextResult = this.getView().invokeOperation("next", nextOption);
        if (toNextResult.isSuccess()) {
            return;
        }
        OperateOption previousOption = OperateOption.create();
        previousOption.setVariableValue("invokeAfterDelete", String.valueOf(true));
        OperationResult toPreviousOptionResult = this.getView().invokeOperation("previous", nextOption);
        if (toPreviousOptionResult.isSuccess()) {
            return;
        }
        this.getView().close();
    }

    @Override
    protected OperationResult remoteInvokeOperation(Object[] ids) {
        if (this.hasOpenSoftDelete()) {
            SoftDeleteHandler handler = new SoftDeleteHandler(this.getEntityId(), this.getOperateKey());
            return handler.process(this.getEntityId(), ids);
        }
        return super.remoteInvokeOperation(ids);
    }

    @Override
    protected OperationResult localInvokeOperation(Set<Object> ids) {
        if (this.hasOpenSoftDelete()) {
            SoftDeleteHandler handler = new SoftDeleteHandler(this.getEntityId(), this.getOperateKey());
            return handler.process(this.getEntityId(), ids.toArray());
        }
        return super.localInvokeOperation(ids);
    }

    private boolean hasOpenSoftDelete() {
        Optional softDelete = Optional.empty();
        DynamicObject obj = ParameterReader.getBillParameter((String)this.getEntityId());
        if (obj != null && obj.getDataEntityType() != null) {
            boolean haveCodeRuleBillParams = obj.getDataEntityType().getProperties().containsKey((Object)"softdelete");
            Optional<Object> optional = softDelete = haveCodeRuleBillParams ? Optional.of(obj.get("softdelete")) : Optional.empty();
        }
        if (!softDelete.isPresent() || !((Boolean)softDelete.get()).booleanValue()) {
            return false;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)this.getEntityId());
        return entityType instanceof BasedataEntityType && entityType.findProperty("enable") instanceof BillStatusProp;
    }

    @Override
    protected String getShowSuccessMsg() {
        if (this.getSuccessMsg() == null || StringUtils.isBlank((CharSequence)this.getSuccessMsg().toString())) {
            if (this.hasOpenSoftDelete()) {
                return ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"Delete_0", (String)"bos-entity-business", (Object[])new Object[0]);
            }
            return String.format(ResManager.loadKDString((String)"%s\u6210\u529f\u3002", (String)"Delete_1", (String)"bos-entity-business", (Object[])new Object[0]), this.getOperateName().toString());
        }
        return this.getSuccessMsg().toString();
    }

    private Map<Object, Map<String, List<Long>>> getDelAttachmentFieldIds() {
        String entityId = this.getEntityId();
        HashMap<Object, Map<String, List<Long>>> res = new HashMap<Object, Map<String, List<Long>>>();
        Map propCollections = EntityMetadataCache.getDataEntityType((String)entityId).getAllFields();
        for (Map.Entry propMap : propCollections.entrySet()) {
            IDataEntityProperty property = (IDataEntityProperty)propMap.getValue();
            String tableName = property.getAlias();
            if (!(property instanceof IAttachmentProp)) continue;
            String attachmentKey = property.getName();
            List<Object> delPkIds = this.getDelPKIds();
            for (Object delPkId : delPkIds) {
                DynamicObject dynamicObject;
                Map map = res.computeIfAbsent(delPkId, k -> new HashMap());
                IDataEntityType parent = property.getParent();
                if (parent instanceof MainEntityType) {
                    DynamicObjectCollection attCollection;
                    dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)delPkId, (String)entityId);
                    if (dynamicObject == null || CollectionUtils.isEmpty((Collection)(attCollection = dynamicObject.getDynamicObjectCollection(attachmentKey)))) continue;
                    List pIds = attCollection.stream().map(entry -> entry.getLong("fbasedataid_id")).collect(Collectors.toList());
                    map.put(tableName, pIds);
                }
                if (!(parent instanceof EntryType) || (dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)delPkId, (String)entityId)) == null) continue;
                if (parent instanceof SubEntryType) {
                    IDataEntityType entity = parent.getParent();
                    DynamicObjectCollection entityParent = dynamicObject.getDynamicObjectCollection(entity.getName());
                    if (entityParent.isEmpty()) continue;
                    for (DynamicObject object : entityParent) {
                        this.setDelMap(tableName, attachmentKey, map, parent, object);
                    }
                    continue;
                }
                this.setDelMap(tableName, attachmentKey, map, parent, dynamicObject);
            }
        }
        return res;
    }

    private void setDelMap(String tableName, String attachmentKey, Map<String, List<Long>> map, IDataEntityType parent, DynamicObject preParentDynamicObject) {
        DynamicObjectCollection entryEntity = preParentDynamicObject.getDynamicObjectCollection(parent.getName());
        for (DynamicObject entry : entryEntity) {
            DynamicObjectCollection attCollection = entry.getDynamicObjectCollection(attachmentKey);
            if (CollectionUtils.isEmpty((Collection)attCollection)) continue;
            List pIds = attCollection.stream().map(att -> att.getLong("fbasedataid_id")).collect(Collectors.toList());
            List<Long> pkIds = map.get(tableName);
            if (CollectionUtils.isEmpty(pkIds)) {
                map.put(tableName, pIds);
                continue;
            }
            pkIds.addAll(pIds);
        }
    }
}

