/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.operate;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.OpBatchExecuter;
import kd.bos.entity.operate.OpBigDataExecuter;
import kd.bos.entity.operate.OperateProgressCache;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class OpBigDataExecutePlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final String FORMID_OPBIGDATAEXECUTER = "bos_bigdataopexecuter";
    private static final String CUSTPARAM_ENTITYNUMBER = "entitynumber";
    private static final String CUSTPARAM_OPKEY = "opkey";
    private static final String CUSTPARAM_OPERATEOPTION = "operateoption";
    private static final String KEY_PROGRESSBAR = "progressbarap";
    private static final String KEY_LBLPROGRESS = "lblprogress";
    private static final String CACHEKEY_TASKID = "taskid";
    private static final String CACHEKEY_PROGRESS = "progress";
    private static ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"OpBigDataExecuter", (int)1);
    private IThreadExecuer threadExecuer = new ThreadExecuerImpl();
    private ITaskProgress taskProgress = new TaskProgressImpl();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        bar.addProgressListener((ProgresssListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.start();
    }

    public void onProgress(ProgressEvent e) {
        String taskId = this.getTaskId();
        if (StringUtils.isBlank((CharSequence)taskId)) {
            taskId = DBServiceHelper.genStringId();
            String parentPageId = this.getView().getFormShowParameter().getParentPageId();
            String appId = this.getView().getViewNoPlugin(parentPageId).getFormShowParameter().getServiceAppId();
            this.taskProgress.setFinished(taskId, false);
            OpBigDataExecuter executer = new OpBigDataExecuter(taskId, appId, parentPageId, this.getOpKey(), this.getOption());
            this.threadExecuer.executeThreadPool(executer);
            this.setTaskId(taskId);
            return;
        }
        boolean finished = this.taskProgress.isFinished(taskId);
        ProgressBar bar = (ProgressBar)this.getControl(KEY_PROGRESSBAR);
        if (finished) {
            this.complete();
            bar.stop();
        } else {
            int progress = this.getProgress();
            if (++progress >= 100) {
                progress = 1;
            }
            this.setProgress(progress);
            String tip = this.taskProgress.getProgressTip(taskId);
            e.setProgress(progress);
            if (StringUtils.isNotBlank((CharSequence)tip)) {
                this.setProgressTip(tip);
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String taskId = this.getTaskId();
        if (StringUtils.isBlank((CharSequence)taskId)) {
            return;
        }
        boolean finished = this.taskProgress.isFinished(taskId);
        if (finished) {
            OpBatchExecuter.clearCache(taskId);
        } else {
            e.setCancel(true);
        }
    }

    private void start() {
        String entityNumber = this.getEntityNumber();
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            return;
        }
        ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        bar.start();
        this.setProgressTip(ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u53ef\u80fd\u4f1a\u6bd4\u8f83\u8017\u65f6\uff0c\u8bf7\u8010\u5fc3\u7b49\u5019...", (String)"OpBigDataExecutePlugin_3", (String)"bos-entity-business", (Object[])new Object[0]));
    }

    private void complete() {
        String taskId = this.getTaskId();
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        boolean error = this.taskProgress.isError(taskId);
        if (error) {
            String errMsg = this.taskProgress.getErrorMsg(taskId);
            if (StringUtils.isBlank((CharSequence)errMsg)) {
                errMsg = ResManager.loadKDString((String)"\u64cd\u4f5c\u9047\u5230\u4e86\u672a\u77e5\u9519\u8bef\uff0c\u4e2d\u65ad\u6267\u884c\uff01", (String)"OpBigDataExecutePlugin_2", (String)"bos-entity-business", (Object[])new Object[0]);
            }
            IFormView parentView = this.getView().getViewNoPlugin(parentPageId);
            parentView.showErrorNotification(errMsg);
            this.getView().sendFormAction(parentView);
            this.getView().close();
        } else {
            List<Object> opFormActions = this.taskProgress.getFormActions(taskId);
            if (!opFormActions.isEmpty()) {
                HashMap<String, Object> arg = new HashMap<String, Object>();
                arg.put("pageId", parentPageId);
                arg.put("actions", opFormActions);
                ArrayList<HashMap<String, Object>> paras = new ArrayList<HashMap<String, Object>>();
                paras.add(arg);
                IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                clientViewProxy.addAction("sendDynamicFormAction", paras);
            }
            this.getView().close();
        }
    }

    private String getTaskId() {
        return this.getPageCache().get(CACHEKEY_TASKID);
    }

    private void setTaskId(String taskId) {
        this.getPageCache().put(CACHEKEY_TASKID, taskId);
    }

    private int getProgress() {
        String str = this.getPageCache().get(CACHEKEY_PROGRESS);
        if (StringUtils.isBlank((CharSequence)str)) {
            return 1;
        }
        return Integer.parseInt(str);
    }

    private void setProgress(int progress) {
        this.getPageCache().put(CACHEKEY_PROGRESS, String.valueOf(progress));
    }

    private String getEntityNumber() {
        return (String)this.getView().getFormShowParameter().getCustomParam(CUSTPARAM_ENTITYNUMBER);
    }

    private String getOpKey() {
        return (String)this.getView().getFormShowParameter().getCustomParam(CUSTPARAM_OPKEY);
    }

    private OperateOption getOption() {
        Map vars;
        OperateOption option = OperateOption.create();
        String str = (String)this.getView().getFormShowParameter().getCustomParam(CUSTPARAM_OPERATEOPTION);
        Map map = vars = StringUtils.isBlank((CharSequence)str) ? new HashMap() : (Map)SerializationUtils.fromJsonString((String)str, Map.class);
        if (vars != null) {
            for (Map.Entry entry : vars.entrySet()) {
                option.setVariableValue((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return option;
    }

    private void setProgressTip(String tip) {
        Label lblTip = (Label)this.getControl(KEY_LBLPROGRESS);
        lblTip.setText(tip);
    }

    private static class TaskProgressImpl
    implements ITaskProgress {
        private TaskProgressImpl() {
        }

        @Override
        public boolean isFinished(String taskId) {
            return OperateProgressCache.isFinished((String)taskId);
        }

        @Override
        public void setFinished(String taskId, boolean finisih) {
            OperateProgressCache.setFinished((String)taskId, (boolean)finisih);
        }

        @Override
        public String getProgressTip(String taskId) {
            return OperateProgressCache.getProgressTip((String)taskId);
        }

        @Override
        public boolean isError(String taskId) {
            return OperateProgressCache.isError((String)taskId);
        }

        @Override
        public String getErrorMsg(String taskId) {
            return OperateProgressCache.getErrorMsg((String)taskId);
        }

        @Override
        public List<Object> getFormActions(String taskId) {
            return OperateProgressCache.getFormActions((String)taskId);
        }
    }

    private static class ThreadExecuerImpl
    implements IThreadExecuer {
        private ThreadExecuerImpl() {
        }

        @Override
        public void executeThreadPool(OpBigDataExecuter executer) {
            threadPool.execute((Runnable)executer);
        }
    }

    public static interface ITaskProgress {
        default public boolean isFinished(String taskId) {
            return false;
        }

        default public void setFinished(String taskId, boolean finisih) {
        }

        default public String getProgressTip(String taskId) {
            return null;
        }

        default public boolean isError(String taskId) {
            return false;
        }

        default public String getErrorMsg(String taskId) {
            return null;
        }

        default public List<Object> getFormActions(String taskId) {
            return null;
        }
    }

    public static interface IThreadExecuer {
        default public void executeThreadPool(OpBigDataExecuter executer) {
        }
    }
}

