/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.operate;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.OpBatchExecuter;
import kd.bos.entity.operate.OperateProgressCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;

public class OpBigDataExecuter
implements Runnable {
    private static final Log log = LogFactory.getLog(OpBatchExecuter.class);
    private static final String BOS_MSERVICE_FORM = "bos-mservice-form";
    private static final String SPAN_TYPE_OPERATE = "operate";
    private RequestContext rc;
    private String taskId;
    private String appId;
    private String pageId;
    private String opKey;
    private ListSelectedRowCollection listSelectedRows;
    private OperateOption option;
    private IOpService opService = new OpServiceImpl();
    private ITaskProgress taskProgress = new TaskProgressImpl();

    @Deprecated
    public ListSelectedRowCollection getListSelectedRows() {
        return this.listSelectedRows;
    }

    @Deprecated
    public void setListSelectedRows(ListSelectedRowCollection listSelectedRows) {
        this.listSelectedRows = listSelectedRows;
    }

    @Deprecated
    public OpBigDataExecuter(String taskId, String entityNumber, String opKey, Set<Object> pkIds, OperateOption option) {
        this.rc = RequestContext.get();
        this.taskId = taskId;
        this.option = option;
    }

    public OpBigDataExecuter(String taskId, String appId, String pageId, String opKey, OperateOption option) {
        this.rc = RequestContext.get();
        this.taskId = taskId;
        this.appId = appId;
        this.pageId = pageId;
        this.opKey = opKey;
        this.option = option;
    }

    @Override
    public void run() {
        RequestContext.copyAndSet((RequestContext)this.rc);
        this.doExecute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute() {
        OperationResult opResult = null;
        List<Object> formActions = null;
        try {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_OPERATE, (String)"OpBigDataExecuter.doExecute");){
                this.option.setVariableValue("ignoreinteraction", String.valueOf(true));
                this.option.setVariableValue("ignorewarn", String.valueOf(true));
                if (this.option.containsVariable("bos_support_bigdata_aysn")) {
                    this.option.removeVariable("bos_support_bigdata_aysn");
                }
                this.option.setVariableValue("bos_bigdata_aysn", String.valueOf(true));
                this.option.setVariableValue("bos_op_taskid", this.taskId);
                Date startTime = new Date();
                Map<String, Object> serResult = this.opService.invokeOperationFromService(this.appId, this.pageId, this.opKey, this.option.getVariables());
                String opResultStr = (String)serResult.get("operationResult");
                opResult = this.deSerializerOpResult(opResultStr);
                if (opResult != null) {
                    opResult.setStartTime(startTime);
                    opResult.setFinishedTime(new Date());
                }
                formActions = (List)serResult.get("actionResult");
            }
            this.setOperationResult(this.taskId, opResult);
            this.setFormActions(this.taskId, formActions);
            this.setFinished(this.taskId, true);
        }
        catch (Throwable exp) {
            try {
                if (formActions == null) {
                    formActions = new ArrayList<Object>();
                }
                Map<String, Object> action = this.HandlerErr(exp, this.opKey);
                formActions.add(action);
                log.error(exp);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                this.setOperationResult(this.taskId, opResult);
                this.setFormActions(this.taskId, formActions);
                this.setFinished(this.taskId, true);
            }
        }
    }

    private void setFinished(String taskId, boolean finisih) {
        this.taskProgress.setFinished(taskId, finisih);
    }

    private void setOperationResult(String taskId, OperationResult opResult) {
        this.taskProgress.setOperationResult(taskId, opResult);
    }

    private void setFormActions(String taskId, List<Object> formActions) {
        this.taskProgress.setFormActions(taskId, formActions);
    }

    private void setError(String taskId, boolean error, String errMsg) {
        this.taskProgress.setError(taskId, error, errMsg);
    }

    private OperationResult deSerializerOpResult(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        return (OperationResult)DataEntitySerializer.deSerializerFromString((String)str, (IDataEntityType)OrmUtils.getDataEntityType(OperationResult.class));
    }

    private Map<String, Object> HandlerErr(Throwable Ex, String key) {
        ArrayList<HashMap<String, Object>> paras;
        KDException KDEx;
        HashMap<String, Object> ClientPageAction = null;
        HashMap<String, Object> ClientActionParas = null;
        while (Ex instanceof InvocationTargetException) {
            Ex = ((InvocationTargetException)Ex).getTargetException();
        }
        while (Ex.getCause() != null) {
            String msg = Ex.getMessage();
            if (msg == null) {
                Ex = Ex.getCause();
                continue;
            }
            String superMsg = Ex.getCause().getMessage();
            if (!msg.equals(superMsg)) break;
            Ex = Ex.getCause();
        }
        if (Ex instanceof KDBizException) {
            KDEx = (KDException)Ex;
            ClientPageAction = new HashMap<String, Object>();
            paras = new ArrayList<HashMap<String, Object>>();
            ClientPageAction.put("p", paras);
            ClientActionParas = new HashMap<String, Object>();
            ClientPageAction.put("a", "ShowNotificationMsg");
            ClientActionParas.put("type", 1);
            ClientActionParas.put("content", KDEx.getMessage());
            paras.add(ClientActionParas);
        } else if (Ex instanceof KDException) {
            KDEx = (KDException)Ex;
            ClientPageAction = new HashMap();
            paras = new ArrayList();
            ClientPageAction.put("p", paras);
            ClientActionParas = new HashMap();
            ClientPageAction.put("a", "showErrMsg");
            this.SetExceptionErrorInfo(Ex, key, ClientActionParas);
            paras.add(ClientActionParas);
        } else {
            ClientPageAction = new HashMap();
            ArrayList<HashMap<String, Object>> paras2 = new ArrayList<HashMap<String, Object>>();
            ClientPageAction.put("p", paras2);
            ClientActionParas = new HashMap();
            ClientPageAction.put("a", "showErrMsg");
            this.SetExceptionErrorInfo(Ex, key, ClientActionParas);
            paras2.add(ClientActionParas);
        }
        return ClientPageAction;
    }

    private void SetExceptionErrorInfo(Throwable Ex, String key, Map<String, Object> ClientActionParas) {
        StringBuilder oSB = new StringBuilder();
        oSB.append(key).append("\r\n");
        oSB.append(ResManager.loadKDString((String)"\u53d1\u751f\u65f6\u95f4\uff1a", (String)"OpBigDataExecuter_0", (String)BOS_MSERVICE_FORM, (Object[])new Object[0])).append(new Date().toString()).append("bos-entity-business");
        oSB.append("===================================================\r\n");
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        Ex.printStackTrace(pw);
        oSB.append(ResManager.loadKDString((String)"\u8c03\u7528\u5806\u6808\uff1a", (String)"OpBigDataExecuter_1", (String)BOS_MSERVICE_FORM, (Object[])new Object[0])).append("bos-entity-business");
        oSB.append(sw.getBuffer().toString()).append("\r\n");
        ClientActionParas.put("errorTitle", this.appId + ":" + Ex.getMessage());
        ClientActionParas.put("errorInfo", oSB.toString());
    }

    private static class TaskProgressImpl
    implements ITaskProgress {
        private TaskProgressImpl() {
        }

        @Override
        public void setFinished(String taskId, boolean finisih) {
            OperateProgressCache.setFinished((String)taskId, (boolean)finisih);
        }

        @Override
        public void setOperationResult(String taskId, OperationResult opResult) {
            OperateProgressCache.setOperationResult((String)taskId, (OperationResult)opResult);
        }

        @Override
        public void setFormActions(String taskId, List<Object> formActions) {
            OperateProgressCache.setFormActions((String)taskId, formActions);
        }

        @Override
        public void setError(String taskId, boolean error, String errMsg) {
            OperateProgressCache.setError((String)taskId, (boolean)error, (String)errMsg);
        }
    }

    private static class OpServiceImpl
    implements IOpService {
        private OpServiceImpl() {
        }

        @Override
        public Map<String, Object> invokeOperationFromService(String appid, String pageId, String opKey, Map<String, String> option) {
            return (Map)DispatchServiceHelper.invokeBOSService((String)appid, (String)"FormService", (String)"invokeOperationFromService", (Object[])new Object[]{pageId, opKey, option});
        }
    }

    public static interface ITaskProgress {
        public void setFinished(String var1, boolean var2);

        public void setOperationResult(String var1, OperationResult var2);

        public void setFormActions(String var1, List<Object> var2);

        public void setError(String var1, boolean var2, String var3);
    }

    public static interface IOpService {
        default public Map<String, Object> invokeOperationFromService(String appid, String pageId, String opKey, Map<String, String> option) {
            return null;
        }
    }
}

