/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.operate;

import java.util.Collection;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.DefaultEntityOperate;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.list.IListView;

public class RowStatusConvert
extends DefaultEntityOperate {
    private static final String ROWSTATUSCONVERT0 = "RowStatusConvert_0";
    private static final String BOSENTITYBUSINESS = "bos-entity-business";
    private String statusFldKey;
    private ListSelectedRowCollection rows;

    private String getDescription() {
        return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5904\u7406\u7684\u6570\u636e\u884c\u3002", (String)"RowStatusConvert_4", (String)BOSENTITYBUSINESS, (Object[])new Object[0]);
    }

    @Override
    public void initialize(Map<String, Object> opMeta) {
        super.initialize(opMeta);
        if (this.getParameter().containsKey("statusProp")) {
            this.statusFldKey = (String)this.getParameter().get("statusProp");
        }
    }

    @Override
    protected boolean beforeInvokeOperation(OperationResult result) {
        boolean pass;
        this.rows = new ListSelectedRowCollection();
        boolean bl = pass = this.isBatchFinish() ? true : this.addSelectedRows(this.rows);
        if (pass) {
            if (this.rows != null && !this.rows.isEmpty()) {
                String str = SerializationUtils.toJsonString((Object)this.rows);
                this.getOption().setVariableValue("bos_listselectedrowcollection", str);
            }
            return super.beforeInvokeOperation(result);
        }
        return false;
    }

    @Override
    public OperationResult callEntityOperate() {
        return super.callEntityOperate();
    }

    private boolean addSelectedRows(ListSelectedRowCollection rows) {
        if (StringUtils.isBlank((CharSequence)this.statusFldKey)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u9700\u5207\u6362\u7684\u884c\u72b6\u6001\u5b57\u6bb5", (String)"RowStatusConvert_5", (String)BOSENTITYBUSINESS, (Object[])new Object[0]));
            return false;
        }
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)this.getEntityId());
        IDataEntityProperty statusProp = mainType.findProperty(this.statusFldKey);
        if (statusProp == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u9700\u5207\u6362\u7684\u884c\u72b6\u6001\u5b57\u6bb5", (String)"RowStatusConvert_5", (String)BOSENTITYBUSINESS, (Object[])new Object[0]));
            return false;
        }
        if (statusProp.getParent() instanceof MainEntityType) {
            return true;
        }
        if (this.getView() instanceof IListView) {
            return this.addListViewSelectedRows(statusProp, rows);
        }
        if (this.getView() instanceof IBillView) {
            return this.addBillViewSelectedRows(statusProp, rows);
        }
        return true;
    }

    private boolean addListViewSelectedRows(IDataEntityProperty statusProp, ListSelectedRowCollection rows) {
        ListSelectedRowCollection listViewRows = this.getListSelectedData();
        if (listViewRows == null || listViewRows.isEmpty()) {
            this.getView().showTipNotification(this.getMessage());
            return false;
        }
        rows.addAll((Collection)listViewRows);
        return true;
    }

    private boolean addBillViewSelectedRows(IDataEntityProperty statusProp, ListSelectedRowCollection rows) {
        DynamicObject billObj = this.getView().getModel().getDataEntity();
        if (!billObj.getDataEntityState().getFromDatabase()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002", (String)"RowStatusConvert_6", (String)BOSENTITYBUSINESS, (Object[])new Object[0]));
            return false;
        }
        if (((BillShowParameter)this.getView().getFormShowParameter()).getBillStatus() == BillOperationStatus.EDIT && this.getView().getModel().getDataChanged()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002", (String)"RowStatusConvert_6", (String)BOSENTITYBUSINESS, (Object[])new Object[0]));
            return false;
        }
        if (statusProp.getParent() instanceof MainEntityType) {
            return true;
        }
        if (statusProp.getParent() instanceof SubEntryType) {
            return this.addSubEntrySelectedRows(statusProp, rows);
        }
        return this.addEntrySelectedRows(statusProp, rows);
    }

    private boolean addEntrySelectedRows(IDataEntityProperty statusProp, ListSelectedRowCollection rows) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(statusProp.getParent().getName());
        int[] rowIndexs = entryGrid.getSelectRows();
        if (rowIndexs == null || rowIndexs.length == 0) {
            this.getView().showTipNotification(this.getMessage());
            return false;
        }
        Object pkValue = ((IBillModel)this.getView().getModel()).getPKValue();
        for (int rowIndex : rowIndexs) {
            DynamicObject entryRow = this.getView().getModel().getEntryRowEntity(statusProp.getParent().getName(), rowIndex);
            ListSelectedRow row = new ListSelectedRow(pkValue);
            row.setEntryEntityKey(statusProp.getParent().getName());
            row.setEntryPrimaryKeyValue(entryRow.getPkValue());
            rows.add((Object)row);
        }
        return true;
    }

    private boolean addSubEntrySelectedRows(IDataEntityProperty statusProp, ListSelectedRowCollection rows) {
        int rowIndex = this.getView().getModel().getEntryCurrentRowIndex(statusProp.getParent().getParent().getName());
        if (rowIndex == -1) {
            this.getView().showTipNotification(this.getMessage());
            return false;
        }
        DynamicObject entryRow = this.getView().getModel().getEntryRowEntity(statusProp.getParent().getParent().getName(), rowIndex);
        DynamicObjectCollection subEntryRows = entryRow.getDynamicObjectCollection(statusProp.getParent().getName());
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(statusProp.getParent().getName());
        int[] subRowIndexs = entryGrid.getSelectRows();
        if (subEntryRows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u5904\u7406\u7684\u6570\u636e\u884c\u3002", (String)"RowStatusConvert_1", (String)BOSENTITYBUSINESS, (Object[])new Object[0]));
            return false;
        }
        if (subRowIndexs == null || subRowIndexs.length == 0) {
            this.getView().showTipNotification(this.getMessage());
            return false;
        }
        for (int subRowIndex : subRowIndexs) {
            DynamicObject subEntryRow = (DynamicObject)subEntryRows.get(subRowIndex);
            ListSelectedRow row = new ListSelectedRow(((IBillModel)this.getView().getModel()).getPKValue());
            row.setEntryEntityKey(statusProp.getParent().getParent().getName());
            row.setEntryPrimaryKeyValue(entryRow.getPkValue());
            row.setSubEntryEntityKey(statusProp.getParent().getName());
            row.setSubEntryPrimaryKeyValue(subEntryRow.getPkValue());
            rows.add((Object)row);
        }
        return true;
    }

    public String getMessage() {
        return ResManager.loadKDString((String)this.getDescription(), (String)ROWSTATUSCONVERT0, (String)BOSENTITYBUSINESS, (Object[])new Object[0]);
    }
}

