/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.operate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.data.ParameterHelper;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.DefaultEntityOperate;
import kd.bos.entity.operate.SaveValidatorCloseCallBack;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.entity.property.ModifierIdProp;
import kd.bos.entity.property.ModifyDateProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.form.FieldTip;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.fieldtip.DeleteRule;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.operate.NavigationCache;
import kd.bos.form.operate.OperateUtils;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.service.operation.OperationServiceImpl;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class Save
extends DefaultEntityOperate
implements IConfirmCallBack {
    private static final String SAVEOP = "saveop";
    private static final String BOS_ENTITY_BUSINESS = "bos-entity-business";
    private boolean addNew = false;

    private static String getPermForbidMessage(String permItem, String formId) {
        LocaleString formName = FormMetadataCache.getFormConfig((String)formId).getCaption();
        String permForbid = "";
        if ("47156aff000000ac".equals(permItem)) {
            permForbid = String.format(ResManager.loadKDString((String)"\u65e0\u201c%1$s\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"Save_15", (String)BOS_ENTITY_BUSINESS, (Object[])new Object[0]), formName);
        } else if ("4715a0df000000ac".equals(permItem)) {
            permForbid = String.format(ResManager.loadKDString((String)"\u65e0\u201c%1$s\u201d\u7684\u201c\u4fee\u6539\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"Save_16", (String)BOS_ENTITY_BUSINESS, (Object[])new Object[0]), formName);
        }
        return permForbid;
    }

    private static String getDataPermForbidMessage(String permItem, String formId) {
        LocaleString formName = FormMetadataCache.getFormConfig((String)formId).getCaption();
        String permForbid = "";
        String operateName = "";
        if ("47156aff000000ac".equals(permItem)) {
            operateName = ResManager.loadKDString((String)"\u65b0\u589e", (String)"Save_17", (String)BOS_ENTITY_BUSINESS, (Object[])new Object[0]);
        } else if ("4715a0df000000ac".equals(permItem)) {
            operateName = ResManager.loadKDString((String)"\u4fee\u6539", (String)"Save_18", (String)BOS_ENTITY_BUSINESS, (Object[])new Object[0]);
        }
        permForbid = String.format(ResManager.loadKDString((String)"\u5f88\u62b1\u6b49\u3002\u60a8\u6ca1\u6709[%1$s][%2$s]\u7684\u6570\u636e\u89c4\u5219\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"Save_19", (String)BOS_ENTITY_BUSINESS, (Object[])new Object[0]), operateName, formName);
        return permForbid;
    }

    @Override
    protected Set<String> getOperationFields() {
        Set<String> loadFieldKeys = super.getOperationFields();
        MainEntityType mainType = this.getView().getModel().getDataEntityType();
        if (mainType instanceof BillEntityType && StringUtils.isNotBlank((CharSequence)((BillEntityType)mainType).getBillNo())) {
            loadFieldKeys.add(((BillEntityType)mainType).getBillNo());
        }
        OperateOption ops = this.getOption();
        RefObject opValue = new RefObject();
        boolean addMuli = false;
        if (ops != null) {
            this.getOption().tryGetVariableValue("mulilangtext.emptyfill.enable", opValue);
            addMuli = Boolean.parseBoolean((String)opValue.getValue());
        }
        DataEntityPropertyCollection props = mainType.getProperties();
        List simpleProps = props.getSimpleProperties(true);
        for (ISimpleProperty simpleProperty : simpleProps) {
            Control ctl = this.getView().getControl(simpleProperty.getName());
            if (ctl == null || ctl.isInvisible()) continue;
            if (simpleProperty instanceof ModifierIdProp) {
                loadFieldKeys.add(((ModifierIdProp)simpleProperty).getModifierProp().getName());
            }
            if (simpleProperty instanceof ModifyDateProp) {
                loadFieldKeys.add(simpleProperty.getName());
            }
            if (!addMuli || !(simpleProperty instanceof MuliLangTextProp)) continue;
            loadFieldKeys.add(simpleProperty.getName());
        }
        List entryProps = props.getCollectionProperties(true);
        for (ICollectionProperty entryProp : entryProps) {
            this.addMulilangTextFieldKey(entryProp.getItemType(), loadFieldKeys, addMuli);
        }
        return loadFieldKeys;
    }

    private void addMulilangTextFieldKey(IDataEntityType dt, Set<String> loadFieldKeys, boolean addMuli) {
        List simpleProps = dt.getProperties().getSimpleProperties(true);
        for (ISimpleProperty prop : simpleProps) {
            Control ctl = this.getView().getControl(prop.getName());
            if (ctl == null || ctl.isInvisible()) continue;
            if (prop instanceof ModifierIdProp) {
                loadFieldKeys.add(((ModifierIdProp)prop).getModifierProp().getName());
            }
            if (prop instanceof ModifyDateProp) {
                loadFieldKeys.add(prop.getName());
            }
            if (!addMuli || !(prop instanceof MuliLangTextProp)) continue;
            loadFieldKeys.add(prop.getName());
        }
    }

    @Override
    protected boolean beforeInvokeOperation(OperationResult opResult) {
        if (this.isOpenIntentLocks() && !this.checkIntentExist(SAVEOP)) {
            return false;
        }
        if (this.hasAttachmentUploading()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9644\u4ef6\u4e0a\u4f20\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"Save_8", (String)BOS_ENTITY_BUSINESS, (Object[])new Object[0]));
            return false;
        }
        if (this.hasImgUploading() || this.hasImgListUploading()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u56fe\u7247\u4e0a\u4f20\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"Save_14", (String)BOS_ENTITY_BUSINESS, (Object[])new Object[0]));
            return false;
        }
        if (!this.checkMainOrg()) {
            return false;
        }
        boolean result = super.beforeInvokeOperation(opResult);
        if (result) {
            this.getView().getModel().clearNoDataRow();
        }
        return result;
    }

    @Override
    protected boolean needCheckDBDataVersion() {
        Boolean enable = this.getParameter().getOrDefault("checkFormDataVersion", false);
        return enable instanceof Boolean ? enable : Boolean.parseBoolean(((Object)enable).toString());
    }

    @Override
    protected void invokeNextOperation(OperationResult opResult) {
        DynamicObject opDyObj;
        String nextOp = "";
        if (!(this.getView() instanceof IListView) && (opDyObj = ParameterHelper.getUserOption((long)RequestContext.get().getCurrUserId(), (String)this.getEntityId())) != null) {
            List newOperate;
            boolean saveAndSubmit = (Boolean)opDyObj.get("saveandsubmit");
            Map allOperates = null;
            if (saveAndSubmit) {
                allOperates = OperateUtils.getAllOperate((String)this.getEntityId());
                List submitOperate = (List)allOperates.get("submit");
                if (submitOperate != null && submitOperate.size() == 1) {
                    nextOp = (String)submitOperate.get(0);
                } else {
                    saveAndSubmit = false;
                }
            }
            if (!saveAndSubmit && ((Boolean)opDyObj.get("saveandnew")).booleanValue() && (newOperate = (List)(allOperates = allOperates == null ? OperateUtils.getAllOperate((String)this.getEntityId()) : allOperates).get("new")) != null && newOperate.size() == 1) {
                nextOp = (String)newOperate.get(0);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)nextOp)) {
            Object sourceOperateType = this.getView().getFormShowParameter().getCustomParam("source_operate_type");
            if (sourceOperateType == null) {
                this.getView().getFormShowParameter().setCustomParam("source_operate_type", (Object)this.getType());
            }
            this.getView().invokeOperation(nextOp);
        } else {
            super.invokeNextOperation(opResult);
        }
        this.getView().getFormShowParameter().setCustomParam("source_operate_type", null);
    }

    private String getEntityTypeId(FormShowParameter showParameter) {
        String formId;
        String entityTypeId = null;
        entityTypeId = showParameter instanceof ListShowParameter ? (StringUtils.isBlank((CharSequence)(formId = ((ListShowParameter)showParameter).getBillFormId())) ? showParameter.getFormId() : FormMetadataCache.getFormConfig((String)formId).getEntityTypeId()) : (showParameter instanceof BillShowParameter || showParameter instanceof MobileFormShowParameter ? showParameter.getFormConfig().getEntityTypeId() : showParameter.getFormId());
        return entityTypeId;
    }

    @Override
    protected OperationResult callBillOperationService() {
        this.setTempAttachmentOption();
        this.setRemoveImageOption();
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        OperationResult opResult = new OperationResult();
        boolean bl = this.addNew = !dataEntity.getDataEntityState().getFromDatabase();
        if (this.addNew && !this.checkDuplicateSubmit()) {
            opResult.setSuccess(false);
            opResult.setMessage(ResManager.loadKDString((String)"\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4\u3002", (String)"Save_20", (String)BOS_ENTITY_BUSINESS, (Object[])new Object[0]));
            return opResult;
        }
        this.setModelTableOption();
        this.flexSave(dataEntity);
        OperationServiceImpl operationService = new OperationServiceImpl();
        try {
            opResult = operationService.localInvokeOperation(this.getOperateKey(), new DynamicObject[]{dataEntity}, this.getOption());
        }
        catch (Exception e) {
            if (this.addNew) {
                this.clearDuplicateSubmit();
            }
            throw e;
        }
        if (this.addNew && opResult != null && !opResult.isSuccess()) {
            this.clearDuplicateSubmit();
        }
        if (opResult != null && !opResult.getSuccessPkIds().isEmpty()) {
            this.clearAttsCache();
            this.updateAttachment();
            this.updateOperationFields(opResult);
            NavigationCache.addPKValue((IFormView)this.getView(), (Object)dataEntity.getPkValue());
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            if (showParameter instanceof BillShowParameter && ((BillShowParameter)showParameter).getBillStatus() == BillOperationStatus.ADDNEW) {
                this.addNew = true;
                showParameter.setStatus(OperationStatus.EDIT);
                ((BillShowParameter)showParameter).setBillStatus(BillOperationStatus.EDIT);
                this.getView().cacheFormShowParameter();
            }
            this.notifyListViewChanged();
            this.getView().getModel().setDataChanged(false);
        }
        return opResult;
    }

    protected void afterInvokeOperation(OperationResult opResult) {
        super.afterInvokeOperation(opResult);
        if (opResult != null && opResult.isSuccess() && this.getView() instanceof IBillView) {
            if (MutexHelper.isOpenIntentLocks()) {
                this.applyILockAfterOperate();
            } else if (this.addNew && this.getView().getFormShowParameter().getStatus() != OperationStatus.VIEW) {
                this.requestMutex("modify");
            }
        }
    }

    private boolean checkMainOrg() {
        if (!(this.getView() instanceof IBillView)) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)this.getView().getModel().getDataEntityType().getMainOrg())) {
            return true;
        }
        MainOrgProp orgProp = (MainOrgProp)this.getView().getModel().getProperty(this.getView().getModel().getDataEntityType().getMainOrg());
        if (orgProp == null) {
            return true;
        }
        if (this.getView().getModel().getDataEntity().getDataEntityState().getFromDatabase()) {
            return true;
        }
        Object orgValue = this.getView().getModel().getValue(orgProp.getName());
        if (orgValue == null) {
            FieldTip orgTip = new FieldTip();
            orgTip.setFieldKey(orgProp.getName());
            orgTip.setLevel(FieldTip.FieldTipsLevel.Info);
            orgTip.setSuccess(false);
            orgTip.setTipsType(FieldTip.FieldTipsTypes.others);
            orgTip.setTip(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165%s", (String)"Save_9", (String)BOS_ENTITY_BUSINESS, (Object[])new Object[0]), orgProp.getDisplayName().toString()));
            DeleteRule deleteRule = new DeleteRule();
            deleteRule.setAction("isChange");
            ArrayList<String> fields = new ArrayList<String>(1);
            fields.add(orgProp.getName());
            deleteRule.setFields(fields);
            orgTip.setDeleteRule(deleteRule);
            this.getView().showFieldTip(orgTip);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c%s\u201d\u3002", (String)"Save_10", (String)BOS_ENTITY_BUSINESS, (Object[])new Object[0]), orgProp.getDisplayName().toString()));
            return false;
        }
        return true;
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        if (StringUtils.equals((CharSequence)e.getCallBackId(), (CharSequence)SAVEOP)) {
            if (e.getResult() == MessageBoxResult.Yes) {
                this.getView().invokeOperation("refresh");
            }
        } else if (StringUtils.equals((CharSequence)e.getCallBackId(), (CharSequence)"savevalidator_refreshactionid")) {
            SaveValidatorCloseCallBack cb = new SaveValidatorCloseCallBack();
            HashMap<String, String> data = new HashMap<String, String>(1);
            data.put("opType", "refresh");
            ClosedCallBackEvent event = new ClosedCallBackEvent((Object)this.getView(), "savevalidator_refreshactionid", data);
            event.setView(this.getView());
            cb.closedCallBack(event);
        }
    }
}

