/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.rule;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.entity.rule.BRAction;
import kd.bos.entity.rule.BRExecuteContext;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.rule.FormRuleExecuteContext;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class ClearFormValidationAction
extends BRAction {
    private String controlKey;
    private Set<String> dependencyFields;

    public String getControlKey() {
        return this.controlKey;
    }

    public void setControlKey(String controlKey) {
        this.controlKey = controlKey;
    }

    public Set<String> getDependencyFields() {
        return this.dependencyFields;
    }

    public void setDependencyFields(Set<String> dependencyFields) {
        this.dependencyFields = dependencyFields;
    }

    public void setParameter(Map<String, Object> action) {
        this.controlKey = (String)action.get("controlKey");
        this.dependencyFields = (Set)action.get("dependencyFields");
    }

    public void execute(BRExecuteContext executeContext) {
        try (EntityTraceSpan span = EntityTracer.create((String)"ClearFormValidationAction", (String)"ClearFormValidationAction.execute");){
            if (executeContext instanceof FormRuleExecuteContext) {
                FormRuleExecuteContext formRuleExecuteContext = (FormRuleExecuteContext)executeContext;
                IFormView formView = formRuleExecuteContext.getView();
                String pageId = formView.getPageId();
                String controlKey = this.getControlKey();
                if (StringUtils.isBlank((String)controlKey)) {
                    controlKey = "";
                }
                if (span.isRealtime()) {
                    span.addLocaleTag("pageId", (Object)pageId);
                    span.addLocaleTag("controlKey", (Object)controlKey);
                }
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("pageId", pageId);
                map.put("ctrlKey", controlKey);
                IClientViewProxy clientViewProxy = (IClientViewProxy)formView.getService(IClientViewProxy.class);
                clientViewProxy.addAction("cleanFormValidata", map);
                this.setDependFieldsFireEvtUp(formView);
            }
        }
    }

    private void setDependFieldsFireEvtUp(IFormView formView) {
        if (!CollectionUtils.isEmpty(this.getDependencyFields())) {
            for (String depField : this.getDependencyFields()) {
                Control control = formView.getControl(depField);
                if (!(control instanceof FieldEdit)) continue;
                ((FieldEdit)control).setFireEvtUp(true);
            }
        }
    }
}

