/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.rule;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.rule.BRAction;
import kd.bos.entity.rule.BRExecuteContext;
import kd.bos.exception.KDBizException;

public class ClearValueAction
extends BRAction {
    private String expression;

    public void setParameter(Map<String, Object> param) {
        this.expression = (String)param.get("expression");
    }

    public void execute(BRExecuteContext executeContext) {
        if (executeContext.getDataEntities() == null || executeContext.getDataEntities().isEmpty()) {
            return;
        }
        for (String key : this.getNeedClearFields()) {
            this.clearFieldValue(key, executeContext);
        }
    }

    private void clearFieldValue(String key, BRExecuteContext executeContext) {
        IDataModel model = executeContext.getModel();
        DynamicObjectType entityType = ((RowDataEntity)executeContext.getDataEntities().get(0)).getDataEntity().getDynamicObjectType();
        IDataEntityProperty targetProp = model.getProperty(key);
        if (targetProp == null) {
            return;
        }
        if (!StringUtils.equals((CharSequence)targetProp.getParent().getName(), (CharSequence)entityType.getName())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7684\u5b9e\u4f53\u670d\u52a1\u89c4\u5219\u51fa\u9519\uff1a\u201c%2$s\u201d\u4e0d\u662f\u672c\u5b9e\u4f53\u4e0a\u7684\u5b57\u6bb5\uff0c\u4e0d\u80fd\u88ab\u6e05\u9664\u503c\u3002", (String)"ClearValueAction_0", (String)"bos-entity-business", (Object[])new Object[0]), entityType.getDisplayName().toString(), ((DynamicProperty)targetProp).getDisplayName().toString()));
        }
        for (RowDataEntity row : executeContext.getDataEntities()) {
            model.setValue(key, null, row.getRowIndex(), row.getParentRowIndex());
        }
    }

    private List<String> getNeedClearFields() {
        return Arrays.asList(this.expression.split(":"));
    }

    @SimplePropertyAttribute
    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String toString() {
        return this.expression;
    }
}

