/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.rule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.rule.BRAction;
import kd.bos.entity.rule.BRExecuteContext;
import kd.bos.entity.validate.IValidatorHanlder;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class TakeBasePropertyAction
extends BRAction {
    private List<Map<String, Object>> expression;
    private boolean onlyEmptyRow;

    public void setParameter(Map<String, Object> param) {
        this.expression = (List)param.get("expression");
        this.onlyEmptyRow = (Boolean)param.get("onlyEmptyRow");
    }

    @SimplePropertyAttribute
    public boolean getOnlyEmptyRow() {
        return this.onlyEmptyRow;
    }

    public void setOnlyEmptyRow(boolean onlyEmptyRow) {
        this.onlyEmptyRow = onlyEmptyRow;
    }

    @SimplePropertyAttribute
    public List<Map<String, Object>> getExpression() {
        return this.expression;
    }

    public void setExpression(List<Map<String, Object>> expression) {
        this.expression = expression;
    }

    public void execute(BRExecuteContext executeContext) {
        if (executeContext.getDataEntities() == null || executeContext.getDataEntities().isEmpty()) {
            return;
        }
        for (Map<String, Object> parameter : this.expression) {
            this.takeBaseRefPropValue(parameter, executeContext);
        }
    }

    private void takeBaseRefPropValue(Map<String, Object> parameter, BRExecuteContext executeContext) {
        block13: {
            IDataEntityProperty targetProp;
            String targetFieldKey;
            IDataEntityProperty srcProp;
            String srcRefProName;
            IDataModel model;
            block12: {
                model = executeContext.getModel();
                String srcFullPropName = (String)parameter.get("srcField");
                String[] arr = srcFullPropName.split("\\.");
                if (arr.length < 2) {
                    return;
                }
                String srcPropName = arr[0];
                srcRefProName = arr[1];
                srcProp = model.getProperty(srcPropName);
                if (srcProp == null) {
                    return;
                }
                targetFieldKey = (String)parameter.get("targetField");
                DynamicObjectType entityType = ((RowDataEntity)executeContext.getDataEntities().get(0)).getDataEntity().getDynamicObjectType();
                targetProp = model.getProperty(targetFieldKey);
                if (targetProp == null) {
                    return;
                }
                if (!StringUtils.equals((CharSequence)targetProp.getParent().getName(), (CharSequence)entityType.getName())) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7684\u5b9e\u4f53\u670d\u52a1\u89c4\u5219\u51fa\u9519\uff1a\u201c%2$s\u201d\u4e0d\u662f\u672c\u5b9e\u4f53\u4e0a\u7684\u5b57\u6bb5\uff0c\u4e0d\u80fd\u643a\u5e26\u57fa\u7840\u8d44\u6599\u5c5e\u6027\u503c\u8fc7\u53bb\u3002", (String)"TakeBasePropertyAction_0", (String)"bos-entity-business", (Object[])new Object[0]), entityType.getDisplayName().toString(), ((DynamicProperty)targetProp).getDisplayName().toString()));
                }
                if (!(srcProp instanceof BasedataProp)) break block12;
                IDataEntityProperty srcRefPro = (IDataEntityProperty)((BasedataProp)srcProp).getComplexType().getProperties().get((Object)srcRefProName);
                if (srcRefPro instanceof MulBasedataProp) {
                    srcFullPropName = srcPropName + "." + srcRefProName;
                }
                RowDataModel rowDataModel = new RowDataModel(entityType.getName(), model);
                if (targetProp instanceof BasedataProp && !(targetProp instanceof ItemClassProp) && !(targetProp instanceof FlexProp)) {
                    this.batchSetBDFldValue(rowDataModel, srcFullPropName, (BasedataProp)targetProp, executeContext);
                } else {
                    for (RowDataEntity row : executeContext.getDataEntities()) {
                        rowDataModel.setRowContext(row.getDataEntity());
                        if (!this.canTakeValue(rowDataModel, targetProp, this.getOnlyEmptyRow())) continue;
                        Object value = rowDataModel.getValue(srcFullPropName);
                        if (value instanceof DynamicObject) {
                            model.setValue(targetFieldKey, ((DynamicObject)value).getPkValue(), row.getRowIndex(), row.getParentRowIndex());
                            continue;
                        }
                        model.setValue(targetFieldKey, value, row.getRowIndex(), row.getParentRowIndex());
                    }
                }
                break block13;
            }
            if (!(srcProp instanceof MulBasedataProp)) break block13;
            RowDataModel rowDataModel = new RowDataModel(srcProp.getParent().getName(), model);
            ArrayList<Object> array = new ArrayList<Object>();
            for (RowDataEntity row : executeContext.getDataEntities()) {
                rowDataModel.setRowContext(row.getDataEntity());
                if (!this.canTakeValue(rowDataModel, targetProp, this.getOnlyEmptyRow())) continue;
                DynamicObjectCollection proValue = (DynamicObjectCollection)srcProp.getValueFast((Object)row.getDataEntity());
                int rowIndex = row.getRowIndex();
                if (proValue.isEmpty()) {
                    model.setValue(targetFieldKey, (Object)"", rowIndex, row.getParentRowIndex());
                    continue;
                }
                array.clear();
                IDataEntityProperty datapro = this.getBaseDataProp(proValue);
                for (DynamicObject dynamicObject : proValue) {
                    if (datapro == null) continue;
                    DynamicObject basedataObj = (DynamicObject)datapro.getValueFast((Object)dynamicObject);
                    BasedataEntityType basedataDT = (BasedataEntityType)((BasedataProp)datapro).getComplexType();
                    IDataEntityProperty sdatapro = basedataDT.findProperty(srcRefProName);
                    array.add(sdatapro.getValueFast((Object)basedataObj));
                }
                int startIndexOf = ((Object)array).toString().indexOf(91);
                int endIndexOf = ((Object)array).toString().indexOf(93);
                String value = ((Object)array).toString().substring(startIndexOf + 1, endIndexOf);
                model.setValue(targetFieldKey, (Object)value, rowIndex, row.getParentRowIndex());
            }
        }
    }

    private void batchSetBDFldValue(RowDataModel rowDataModel, String srcFullPropName, BasedataProp targetProp, BRExecuteContext executeContext) {
        IDataModel model = executeContext.getModel();
        RefEntityType targetBDType = (RefEntityType)targetProp.getComplexType();
        HashMap<RowDataEntity, Object> rowAndPkValue = new HashMap<RowDataEntity, Object>();
        for (RowDataEntity row : executeContext.getDataEntities()) {
            rowDataModel.setRowContext(row.getDataEntity());
            if (!this.canTakeValue(rowDataModel, (IDataEntityProperty)targetProp, this.getOnlyEmptyRow())) continue;
            Object value = rowDataModel.getValue(srcFullPropName);
            Object pkValue = null;
            pkValue = value instanceof DynamicObject ? ((DynamicObject)value).getPkValue() : value;
            if (targetProp.getValueComparator().compareValue(pkValue)) {
                model.setValue(targetProp.getName(), pkValue, row.getRowIndex(), row.getParentRowIndex());
                continue;
            }
            rowAndPkValue.put(row, targetProp.convertPKValueType((DynamicObjectType)targetBDType, pkValue));
        }
        if (rowAndPkValue.isEmpty()) {
            return;
        }
        Map bdObjs = BusinessDataServiceHelper.loadFromCache((Object[])rowAndPkValue.values().toArray(), (DynamicObjectType)targetBDType);
        for (Map.Entry rowItem : rowAndPkValue.entrySet()) {
            RowDataEntity row = (RowDataEntity)rowItem.getKey();
            DynamicObject bdObj = (DynamicObject)bdObjs.get(rowItem.getValue());
            model.setValue(targetProp.getName(), bdObj != null ? bdObj : rowItem.getValue(), row.getRowIndex(), row.getParentRowIndex());
        }
    }

    private IDataEntityProperty getBaseDataProp(DynamicObjectCollection mulObjs) {
        IDataEntityProperty basedataProp = null;
        for (IDataEntityProperty prop : mulObjs.getDynamicObjectType().getProperties()) {
            if (!(prop instanceof BasedataProp)) continue;
            basedataProp = prop;
            break;
        }
        return basedataProp;
    }

    private boolean canTakeValue(RowDataModel rowDataModel, IDataEntityProperty targetProp, boolean onlyEmptyRow) {
        if (!onlyEmptyRow) {
            return true;
        }
        if (!(targetProp instanceof IValidatorHanlder)) {
            return true;
        }
        Object oldValue = rowDataModel.getValue(targetProp.getName());
        if (oldValue instanceof DynamicObject) {
            oldValue = ((DynamicObject)oldValue).getPkValue();
        }
        return ((IValidatorHanlder)targetProp).getValueComparator().compareValue(oldValue);
    }

    public String toString() {
        return "" + this.expression;
    }
}

