/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.serviceImpl;

import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobDao;
import kd.bos.schedule.api.JobDispatchBatchResult;
import kd.bos.schedule.api.JobDispatcher;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.ObjectFactory;
import kd.bos.schedule.api.PlanInfo;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.server.JobDispatcherProxy;
import kd.bos.schedule.server.ScheduleService;
import kd.bos.schedule.zk.ActiveKeyValueStore;

public class JobDispatcherImpl
implements JobDispatcher {
    private static final Log log = LogFactory.getLog(JobDispatcherImpl.class);

    public String dispatch(JobInfo jobInfo) throws KDException {
        String taskId = String.valueOf(DB.genGlobalLongId());
        jobInfo.setTaskId(taskId);
        jobInfo.setTenantId(RequestContext.get().getTenantId());
        if (StringUtils.isBlank((CharSequence)jobInfo.getId())) {
            long jobId = DB.genLongId((String)"T_SCH_JOB");
            jobInfo.setId(String.valueOf(jobId));
        }
        log.info("Schedule***job-dispatcher-\u5fae\u670d\u52a1\u5206\u53d1\u6d88\u606f\uff1a" + jobInfo.getTaskId());
        JobDispatcherProxy jobDispatcher = new JobDispatcherProxy();
        jobDispatcher.dispatch(jobInfo);
        return taskId;
    }

    public String dispatch(String jobId) throws KDException {
        ObjectFactory of = ScheduleService.getInstance().getObjectFactory();
        JobDao jobDao = of.getJobDao();
        JobInfo jobInfo = jobDao.get(jobId);
        if (jobInfo.getId() == null) {
            return null;
        }
        return this.dispatch(jobInfo);
    }

    public void stopTask(String taskId) {
        JobDispatcherProxy proxy = new JobDispatcherProxy();
        proxy.stopTask(taskId);
    }

    public String createJob(JobInfo jobInfo) {
        JobDispatcherProxy proxy = new JobDispatcherProxy();
        return proxy.createJob(jobInfo);
    }

    public String createPlan(PlanInfo planInfo) {
        JobDispatcherProxy proxy = new JobDispatcherProxy();
        return proxy.createPlan(planInfo);
    }

    private ActiveKeyValueStore getZkStore() {
        return ActiveKeyValueStore.create();
    }

    public TaskInfo queryTask(String taskId) {
        JobDispatcherProxy proxy = new JobDispatcherProxy();
        TaskInfo taskInfo = proxy.queryTask(taskId);
        return taskInfo;
    }

    public int[] countNumOfExecute(String[] scheduleArray, Date endDate) {
        JobDispatcherProxy proxy = new JobDispatcherProxy();
        return proxy.countNumOfExecute(scheduleArray, endDate);
    }

    public List<ZonedDateTime[]> timelistOfExecute(String[] scheduleArray, Date endDate) {
        JobDispatcherProxy proxy = new JobDispatcherProxy();
        return proxy.timelistOfExecute(scheduleArray, endDate);
    }

    public ZonedDateTime[] nextExecuteTime(String[] scheduleArray) {
        JobDispatcherProxy proxy = new JobDispatcherProxy();
        return proxy.nextExecuteTime(scheduleArray);
    }

    public boolean deletePlan(String scheduleId) {
        JobDispatcherProxy proxy = new JobDispatcherProxy();
        return proxy.deletePlan(scheduleId);
    }

    public boolean deleteJob(String jobId) {
        JobDispatcherProxy proxy = new JobDispatcherProxy();
        return proxy.deleteJob(jobId);
    }

    public List<TaskInfo> queryTask(List<String> taskIds) {
        JobDispatcherProxy proxy = new JobDispatcherProxy();
        return proxy.queryTask(taskIds);
    }

    public void reScheduledTask(String taskId) {
        JobDispatcherProxy proxy = new JobDispatcherProxy();
        proxy.reScheduledTask(taskId);
    }

    public void resetReadyTask(String taskId) {
        JobDispatcherProxy proxy = new JobDispatcherProxy();
        proxy.resetReadyTask(taskId);
    }

    public JobDispatchBatchResult dispatchBatch(JobInfo[] jobArray) throws KDException {
        JobDispatcherProxy proxy = new JobDispatcherProxy();
        return proxy.dispatchBatch(jobArray);
    }
}

