/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.serviceImpl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.bundle.BosRes;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.endpoint.EndPointDispatchServiceHelper;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.ScheduleDao;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.message.rpc.RPCHelper;
import kd.bos.schedule.server.ScheduleService;
import kd.bos.schedule.zk.ActiveKeyValueStore;
import kd.bos.schedule.zk.ZkConfig;
import kd.bos.threads.ThreadPools;
import org.apache.zookeeper.CreateMode;

public class ScheduleManagerImpl
implements ScheduleManager {
    private static final Log log = LogFactory.getLog(ScheduleManagerImpl.class);
    private static String ScheduleServiceClassName = "kd.bos.schedule.server.ScheduleService";
    private static String ScheduleProcessChangedMethod = "scheduleProcessChanged";
    private static String JobProcessChangedMethod = "jobProcessChanged";
    private static String GrayChangedMethod = "grayChanged";

    private ActiveKeyValueStore getZkStore() {
        return ActiveKeyValueStore.create();
    }

    public void afterAddSchedule(String id) {
        this.sendScheudleChangedMessage("Add", id);
    }

    public void afterUpdateSchedule(String id) {
        this.sendScheudleChangedMessage("Update", id);
    }

    public void afterUpdateSchedule(String id, List<String> jobIds) {
        this.sendScheudleChangedMessage("Update", id, jobIds);
    }

    public void afterDeleteSchedule(String id) {
        List<String> jobIds = this.getJobIdsByScheduleId(id);
        if (jobIds == null) {
            this.sendScheudleChangedMessage("Delete", id);
        } else {
            this.sendScheudleChangedMessage("Delete", id, jobIds);
        }
    }

    private void sendScheudleChangedMessage(String flag, String scheduleId) {
        RequestContext rc = RequestContext.get();
        HashMap<String, String> msgMap = new HashMap<String, String>();
        msgMap.put("flag", flag);
        msgMap.put("scheduleId", scheduleId);
        msgMap.put("tenantId", rc.getTenantId());
        msgMap.put("accountId", rc.getAccountId());
        msgMap.put("userId", rc.getUserId());
        if (ZkConfig.isSupportZk()) {
            this.getZkStore().write(ZkConfig.getScheduleChangedMessagePath() + "/chg_", SerializationUtils.toJsonString(msgMap), (Object)CreateMode.PERSISTENT_SEQUENTIAL);
        } else {
            try {
                String masterRpcIp = RPCHelper.getMasterRpcIp();
                EndPointDispatchServiceHelper.invoke((String)masterRpcIp, (String)ScheduleServiceClassName, (String)ScheduleProcessChangedMethod, (Object[])new Object[]{SerializationUtils.toJsonString(msgMap)});
            }
            catch (KDException e) {
                this.handleRpcException(e);
            }
        }
    }

    private List<String> getJobIdsByScheduleId(String scheduleId) {
        if (ScheduleService.getInstance() == null) {
            return null;
        }
        ScheduleDao scheduleDao = ScheduleService.getInstance().getObjectFactory().getScheduleDao();
        return scheduleDao.getJobIdByScheduleId(scheduleId);
    }

    private void sendScheudleChangedMessage(String flag, String scheduleId, List<String> jobIds) {
        RequestContext rc = RequestContext.get();
        HashMap<String, String> msgMap = new HashMap<String, String>();
        msgMap.put("flag", flag);
        msgMap.put("scheduleId", scheduleId);
        msgMap.put("tenantId", rc.getTenantId());
        msgMap.put("accountId", rc.getAccountId());
        msgMap.put("userId", rc.getUserId());
        if (Objects.nonNull(jobIds)) {
            msgMap.put("jobIds", StringUtils.join((Object[])jobIds.toArray(), (String)","));
        }
        if (ZkConfig.isSupportZk()) {
            this.getZkStore().write(ZkConfig.getScheduleChangedMessagePath() + "/chg_", SerializationUtils.toJsonString(msgMap), (Object)CreateMode.PERSISTENT_SEQUENTIAL);
        } else {
            try {
                String masterRpcIp = RPCHelper.getMasterRpcIp();
                EndPointDispatchServiceHelper.invoke((String)masterRpcIp, (String)ScheduleServiceClassName, (String)ScheduleProcessChangedMethod, (Object[])new Object[]{SerializationUtils.toJsonString(msgMap)});
            }
            catch (KDException e) {
                this.handleRpcException(e);
            }
        }
    }

    private void sendJobChangedMessage(String flag, String jobId, boolean writeDb) {
        RequestContext rc = RequestContext.get();
        HashMap<String, String> msgMap = new HashMap<String, String>();
        msgMap.put("flag", flag);
        msgMap.put("jobId", jobId);
        msgMap.put("tenantId", rc.getTenantId());
        msgMap.put("accountId", rc.getAccountId());
        msgMap.put("userId", rc.getUserId());
        msgMap.put("writeDb", Boolean.toString(writeDb));
        List<String> ids = this.getScheduleIdByJob(jobId);
        msgMap.put("scheduleIds", SerializationUtils.toJsonString(ids));
        if (ZkConfig.isSupportZk()) {
            this.getZkStore().write(ZkConfig.getJobChangedMessagePath() + "/chg_", SerializationUtils.toJsonString(msgMap), (Object)CreateMode.PERSISTENT_SEQUENTIAL);
        } else {
            try {
                String masterRpcIp = RPCHelper.getMasterRpcIp();
                EndPointDispatchServiceHelper.invoke((String)masterRpcIp, (String)ScheduleServiceClassName, (String)JobProcessChangedMethod, (Object[])new Object[]{SerializationUtils.toJsonString(msgMap)});
            }
            catch (KDException e) {
                this.handleRpcException(e);
                return;
            }
        }
    }

    private void handleRpcException(KDException e) {
        if (!"DubboServiceLookup".equals(e.getErrorCode().getCode())) {
            throw e;
        }
        log.error("Schedule***ScheduleManager update schedule or job error", (Throwable)e);
    }

    private void sendJobChangedMessageForUpdate(String flag, List<String> jobIds) {
        RequestContext rc = RequestContext.get();
        HashMap<String, String> msgMap = new HashMap<String, String>();
        msgMap.put("flag", flag);
        if (!CollectionUtils.isEmpty(jobIds)) {
            msgMap.put("jobIds", SerializationUtils.toJsonString(jobIds));
        }
        msgMap.put("tenantId", rc.getTenantId());
        msgMap.put("accountId", rc.getAccountId());
        msgMap.put("userId", rc.getUserId());
        if (ZkConfig.isSupportZk()) {
            this.getZkStore().write(ZkConfig.getJobChangedMessagePath() + "/chgTrace_", SerializationUtils.toJsonString(msgMap), (Object)CreateMode.PERSISTENT_SEQUENTIAL);
        } else {
            try {
                String masterRpcIp = RPCHelper.getMasterRpcIp();
                EndPointDispatchServiceHelper.invoke((String)masterRpcIp, (String)ScheduleServiceClassName, (String)JobProcessChangedMethod, (Object[])new Object[]{SerializationUtils.toJsonString(msgMap)});
            }
            catch (KDException e) {
                this.handleRpcException(e);
            }
        }
    }

    private List<String> getScheduleIdByJob(String jobId) {
        List<String> scheduleIds = this.getScheduleIdByEntry(jobId);
        if (scheduleIds.size() > 0) {
            return scheduleIds;
        }
        String strSQL = "SELECT FID FROM T_SCH_SCHEDULE WHERE FJOBID= ? ";
        Object[] params = new SqlParameter[]{new SqlParameter(":FJOBID", 12, (Object)jobId)};
        return (List)DB.query((DBRoute)DBRoute.basedata, (String)strSQL, (Object[])params, rs -> {
            ArrayList<String> ids = new ArrayList<String>(10);
            while (rs.next()) {
                ids.add(rs.getString("fid"));
            }
            return ids;
        });
    }

    private List<String> getScheduleIdByEntry(String jobId) {
        String strSQL = "SELECT t1.FID FROM T_SCH_SCHEDULE t1 LEFT JOIN T_SCH_SCHEDULE_ENTRY t2 ON t1.FID = t2.FID WHERE t2.FJOBNUMBER = ? ";
        Object[] params = new SqlParameter[]{new SqlParameter(":FJOBNUMBER", 12, (Object)jobId)};
        return (List)DB.query((DBRoute)DBRoute.basedata, (String)strSQL, (Object[])params, rs -> {
            ArrayList<String> ids = new ArrayList<String>(10);
            while (rs.next()) {
                ids.add(rs.getString("fid"));
            }
            return ids;
        });
    }

    public void enableSchedule(String id) {
        this.sendScheudleChangedMessage("Enable", id);
    }

    public void disableSchedule(String id) {
        List<String> jobIds = this.getJobIdsByScheduleId(id);
        if (jobIds == null) {
            this.sendScheudleChangedMessage("Disable", id);
        } else {
            this.sendScheudleChangedMessage("Disable", id, jobIds);
        }
    }

    public void enableJob(String id) {
        this.enableJob(id, true);
    }

    public void disableJob(String jobId) {
        this.disableJob(jobId, true);
    }

    public void afterUpdateJob(String jobId) {
        this.sendJobChangedMessage("Update", jobId, false);
    }

    public void afterDeleteJob(String jobId) {
        this.sendJobChangedMessage("Delete", jobId, false);
    }

    private void disableJob(String jobId, boolean writeDb) {
        this.sendJobChangedMessage("Disable", jobId, writeDb);
    }

    private void enableJob(String jobId, boolean writeDb) {
        this.sendJobChangedMessage("Enable", jobId, writeDb);
    }

    public void grayDataChanged() {
        this.sendGrayChangedMessage();
    }

    private void sendGrayChangedMessage() {
        RequestContext rc = RequestContext.get();
        HashMap<String, String> msgMap = new HashMap<String, String>();
        msgMap.put("tenantId", rc.getTenantId());
        msgMap.put("accountId", rc.getAccountId());
        msgMap.put("userId", rc.getUserId());
        if (ZkConfig.isSupportZk()) {
            this.getZkStore().write(ZkConfig.getGrayChangedMessagePath() + "/chg_", SerializationUtils.toJsonString(msgMap), (Object)CreateMode.PERSISTENT_SEQUENTIAL);
        } else {
            try {
                String masterRpcIp = RPCHelper.getMasterRpcIp();
                EndPointDispatchServiceHelper.invoke((String)masterRpcIp, (String)ScheduleServiceClassName, (String)GrayChangedMethod, (Object[])new Object[]{SerializationUtils.toJsonString(msgMap)});
            }
            catch (KDException e) {
                this.handleRpcException(e);
            }
        }
    }

    public void batchUpdateJob(List<String> jobIds) {
        this.sendJobChangedMessageForUpdate("batchUpdateJob", jobIds);
    }

    public void refreshScheduleWheel() {
        RequestContext rc = RequestContext.get();
        String tenantId = rc.getTenantId();
        String accountId = rc.getAccountId();
        String userId = rc.getUserId();
        ThreadPools.executeOnce((String)"BOSSchedule-NotifyScheduleServerRefresh", () -> {
            try {
                HashMap<String, String> msgMap = new HashMap<String, String>();
                msgMap.put("flag", "Refresh");
                msgMap.put("scheduleId", "");
                msgMap.put("tenantId", tenantId);
                msgMap.put("accountId", accountId);
                msgMap.put("userId", userId);
                if (ZkConfig.isSupportZk()) {
                    this.getZkStore().write(ZkConfig.getScheduleChangedMessagePath() + "/chg_", SerializationUtils.toJsonString(msgMap), (Object)CreateMode.PERSISTENT_SEQUENTIAL);
                } else {
                    try {
                        String masterRpcIp = RPCHelper.getMasterRpcIp();
                        EndPointDispatchServiceHelper.invoke((String)masterRpcIp, (String)ScheduleServiceClassName, (String)ScheduleProcessChangedMethod, (Object[])new Object[]{SerializationUtils.toJsonString(msgMap)});
                    }
                    catch (KDException e) {
                        this.handleRpcException(e);
                    }
                }
                log.info("Schedule***" + BosRes.get((String)"mservice-schedule", (String)"ScheduleManagerImpl_0", (String)"\u53d1\u9001\u5237\u65b0\u65f6\u95f4\u8f6e\u901a\u77e5\u6210\u529f", (Object[])new Object[0]));
            }
            catch (Throwable t) {
                log.error("Schedule***" + BosRes.get((String)"mservice-schedule", (String)"ScheduleManagerImpl_1", (String)"\u53d1\u9001\u5237\u65b0\u65f6\u95f4\u8f6e\u901a\u77e5\u5931\u8d25", (Object[])new Object[0]), t);
            }
        });
    }

    public void scheduleProcessChanged(String message) {
    }

    public void jobProcessChanged(String message) {
    }
}

