/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.serviceImpl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bundle.BosRes;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.ExecutorServerInfo;
import kd.bos.schedule.api.SchCheckResult;
import kd.bos.schedule.api.ServerManager;
import kd.bos.schedule.redis.RedisConfig;
import kd.bos.schedule.redis.RedisStore;
import kd.bos.schedule.server.next.ServerObservableUtils;
import kd.bos.schedule.zk.ActiveKeyValueStore;
import kd.bos.schedule.zk.ZkConfig;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class ServerManagerImpl
implements ServerManager {
    private static Log log = LogFactory.getLog(ServerManagerImpl.class);
    private static final int SESSIONTIMEOUT = 5000;
    private static final String MQ_SERVER = "mq.server";

    public boolean schduleServerIsStarted() {
        String flag = this.getZkStore().read(ZkConfig.getMasterServerPath(), null);
        List childs = this.getZkStore().getChildren(ZkConfig.getMasterServerPath());
        return flag != null && (!"start".equals(flag) || childs.isEmpty());
    }

    public Map<String, Object> getMasterServerInfo() {
        HashMap<String, Object> masterInfoMap = new HashMap<String, Object>();
        if (ZkConfig.isSupportZk()) {
            Stat stat = (Stat)this.getZkStore().exists(ZkConfig.getMasterServerPath());
            masterInfoMap.put("isStarted", false);
            if (stat != null) {
                boolean isStarted;
                String data = this.getZkStore().read(ZkConfig.getMasterServerPath(), null);
                boolean bl = isStarted = data != null && !"start".equals(data);
                if (isStarted) {
                    masterInfoMap.put("isStarted", isStarted);
                    masterInfoMap.put("masterName", data);
                    masterInfoMap.put("startTime", new Date(stat.getMtime()));
                }
            }
        } else {
            Boolean stat = (Boolean)this.getZkStore().exists(RedisConfig.getMasterServerPath());
            masterInfoMap.put("isStarted", false);
            if (stat.booleanValue()) {
                boolean isStarted;
                String data = this.getZkStore().read(RedisConfig.getMasterServerPath(), null);
                String time = this.getZkStore().read(RedisConfig.getmasterServerBgTimePath(), null);
                boolean bl = isStarted = data != null && time != null;
                if (isStarted) {
                    masterInfoMap.put("isStarted", isStarted);
                    masterInfoMap.put("masterName", data);
                    masterInfoMap.put("startTime", new Date(Long.parseLong(time)));
                } else {
                    log.info("Schedule***server isStarted fail, data : {}, time \uff1a{}", (Object)data, (Object)time);
                }
            }
        }
        return masterInfoMap;
    }

    public List<ExecutorServerInfo> queryExecutorServerStatus() {
        if (ZkConfig.isSupportZk()) {
            List exeServerList = this.getZkStore().getChildren(ZkConfig.getExecutorServerPath());
            if (exeServerList == null || exeServerList.isEmpty()) {
                return null;
            }
            ArrayList<ExecutorServerInfo> serverInfoList = new ArrayList<ExecutorServerInfo>();
            for (String exeServerNode : exeServerList) {
                String dataStr;
                ExecutorServerInfo serverInfo;
                byte[] data = this.getZkStore().readByte(ZkConfig.getExecutorServerPath() + "/" + exeServerNode, null);
                if (data == null || data[0] == 1 || (serverInfo = (ExecutorServerInfo)SerializationUtils.fromJsonString((String)(dataStr = new String(data, ActiveKeyValueStore.CHARSET)), ExecutorServerInfo.class)) == null) continue;
                serverInfoList.add(serverInfo);
            }
            return serverInfoList;
        }
        Map serverMap = this.getZkStore().getChildrenData(ZkConfig.getExecutorServerPath(), null);
        if (serverMap == null || serverMap.isEmpty()) {
            return null;
        }
        ArrayList<ExecutorServerInfo> serverInfoList = new ArrayList<ExecutorServerInfo>();
        for (Map.Entry entry : serverMap.entrySet()) {
            ExecutorServerInfo serverInfo;
            String dataStr = (String)entry.getValue();
            if (StringUtils.isEmpty((CharSequence)dataStr) || (serverInfo = (ExecutorServerInfo)SerializationUtils.fromJsonString((String)dataStr, ExecutorServerInfo.class)) == null) continue;
            serverInfoList.add(serverInfo);
        }
        return serverInfoList;
    }

    private ActiveKeyValueStore getZkStore() {
        return ActiveKeyValueStore.create();
    }

    public boolean isScheduleServiceStarted() {
        List<String> masterNodes = new ArrayList();
        if (ZkConfig.isSupportZk()) {
            masterNodes = this.getZkStore().getChildren(ZkConfig.getMasterServerPath());
        } else {
            String masterServer = this.getZkStore().read(RedisConfig.getMasterServerPath(), null);
            if (StringUtils.isNotEmpty((CharSequence)masterServer)) {
                masterNodes.add(masterServer);
            }
        }
        List executeServers = this.getZkStore().getChildren(ZkConfig.getExecutorServerPath());
        return !executeServers.isEmpty() && !masterNodes.isEmpty();
    }

    public SchCheckResult checkZkConnected() {
        String url = ZkConfig.getHosts();
        try {
            if (StringUtils.isBlank((CharSequence)url)) {
                SchCheckResult.Status status = SchCheckResult.Status.ZKEXCEPTION;
                return SchCheckResult.create((Integer)status.getCode(), (String)(status.getStatus() + BosRes.get((String)"mservice-schedule", (String)"ServerManagerImpl_0", (String)"url\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u914d\u7f6eSchedule.zk.server\u3002", (Object[])new Object[0])));
            }
            ZooKeeper zooKeeper = new ZooKeeper(url, 5000, null);
            zooKeeper.exists("/", false);
            return SchCheckResult.success();
        }
        catch (Exception e) {
            log.error("schedule***error", (Throwable)e);
            SchCheckResult.Status status = SchCheckResult.Status.ZKEXCEPTION;
            return SchCheckResult.create((Integer)status.getCode(), (String)(status.getStatus() + e.getMessage()));
        }
    }

    public SchCheckResult checkMqConnected() {
        StringBuilder msg = new StringBuilder();
        try {
            if ("MQ".equalsIgnoreCase(ZkConfig.getMessageMode())) {
                if (SchCheckResult.success().getCode().equals(ServerObservableUtils.checkMqConnected().getCode())) {
                    return SchCheckResult.success();
                }
            } else {
                return SchCheckResult.success();
            }
            msg.append("connection is not Opened");
        }
        catch (Exception e) {
            msg.append(e.getMessage());
        }
        SchCheckResult.Status status = SchCheckResult.Status.MQEXCEPTION;
        return SchCheckResult.create((Integer)status.getCode(), (String)msg.append(status.getStatus()).toString());
    }

    public SchCheckResult checkExecutorService() {
        List<ExecutorServerInfo> esi = this.queryExecutorServerStatus();
        if (esi == null || esi.isEmpty()) {
            SchCheckResult.Status status = SchCheckResult.Status.EXECUTORSERVICEEXCEPTION;
            return SchCheckResult.create((Integer)status.getCode(), (String)(status.getStatus() + BosRes.get((String)"mservice-schedule", (String)"ServerManagerImpl_1", (String)"\u6ca1\u6709\u6ce8\u518c\u7684\u6267\u884c\u670d\u52a1\u5668", (Object[])new Object[0])));
        }
        return SchCheckResult.success();
    }

    public SchCheckResult checkScheduleService() {
        SchCheckResult mqConnected;
        StringBuilder builder = new StringBuilder();
        boolean schIsStarted = this.schduleServerIsStarted();
        if (schIsStarted) {
            return SchCheckResult.success();
        }
        SchCheckResult zkConnected = this.checkZkConnected();
        if (zkConnected.getCode() != 0) {
            builder.append(zkConnected.getMessage()).append(BosRes.get((String)"mservice-schedule", (String)"ServerManagerImpl_2", (String)"\u8bf7\u68c0\u67e5Schedule.zk.server\u7684\u5c5e\u6027\u914d\u7f6e\u662f\u5426\u6b63\u786e\uff0c\u4ee5\u53cazookeeper\u7684\u96c6\u7fa4\u670d\u52a1\u662f\u5426\u6b63\u5e38\u3002", (Object[])new Object[0]));
        }
        if ((mqConnected = this.checkMqConnected()).getCode() != 0) {
            builder.append(mqConnected.getMessage()).append(BosRes.get((String)"mservice-schedule", (String)"ServerManagerImpl_3", (String)"\u8bf7\u68c0\u67e5mq.server\u7684\u5c5e\u6027\u914d\u7f6e\u662f\u5426\u6b63\u786e\uff0c\u53carabbitMQ\u96c6\u7fa4\u670d\u52a1\u662f\u5426\u6b63\u5e38\u3002", (Object[])new Object[0]));
        }
        if (zkConnected.getCode() == 0 && mqConnected.getCode() == 0) {
            builder.append(BosRes.get((String)"mservice-schedule", (String)"ServerManagerImpl_4", (String)"zookeeper\u548crabbitMQ\u8fde\u63a5\u68c0\u67e5\u6b63\u5e38\u3002", (Object[])new Object[0]));
        }
        builder.append(BosRes.get((String)"mservice-schedule", (String)"ServerManagerImpl_5", (String)"\u8bf7\u68c0\u67e5Schedule.deployMode\u7684\u914d\u7f6e\uff0c\u9ed8\u8ba4\u662fNOLIMIT\u6a21\u5f0f\uff1a\u6267\u884c\u670d\u52a1\u548c\u8c03\u5ea6\u670d\u52a1\u90fd\u542f\u52a8\u3002\u5176\u4ed63\u4e2a\u914d\u7f6e\u5305\u62ec\uff0cSCHEDULE_NODE\uff1a\u53ea\u542f\u52a8\u8c03\u5ea6\u670d\u52a1\uff1bDISABLE\uff1a\u4e0d\u542f\u52a8\u8c03\u5ea6\u670d\u52a1\uff1bEXECUTE_NODE\uff1a\u53ea\u542f\u52a8\u6267\u884c\u670d\u52a1\u3002", (Object[])new Object[0])).append(BosRes.get((String)"mservice-schedule", (String)"ServerManagerImpl_6", (String)"\u8bf7\u68c0\u67e5Schedule.disableToWork\u7684\u914d\u7f6e\uff0c\u9ed8\u8ba4\u4e3afalse\uff08false\uff1a\u542f\u52a8\u8c03\u5ea6\u670d\u52a1\uff1btrue\uff1a\u7981\u7528\u8c03\u5ea6\u670d\u52a1\uff09\u3002", (Object[])new Object[0])).append(BosRes.get((String)"mservice-schedule", (String)"ServerManagerImpl_7", (String)"\u8bf7\u68c0\u67e5\u8be5\u8282\u70b9\u662f\u5426\u4e3a\u8f7b\u5206\u6790\u8282\u70b9\uff0c\u8f7b\u5206\u6790\u8282\u70b9\u9ed8\u8ba4\u4e0d\u542f\u7528\u8c03\u5ea6\u3002", (Object[])new Object[0]));
        SchCheckResult.Status status = SchCheckResult.Status.SCHEDULESERVCIEEXCEPTION;
        return SchCheckResult.create((Integer)status.getCode(), (String)builder.append(status.getStatus()).toString());
    }

    public SchCheckResult checkRedisConnected() {
        try {
            RedisStore redisStore = RedisStore.create();
            redisStore.write("checkRedisConnected", "true");
            redisStore.read("checkRedisConnected", null);
            return SchCheckResult.success();
        }
        catch (Exception e) {
            log.error("schedule***error", (Throwable)e);
            SchCheckResult.Status status = SchCheckResult.Status.REDISEXCEPTION;
            return SchCheckResult.create((Integer)status.getCode(), (String)(status.getStatus() + e.getMessage()));
        }
    }
}

